/* FILE diff.c */
     /* Differentiate, put in extra channel  */
#include "array.h"
#include "defs.h"
#include <stdlib.h>				/* atof()		*/
/* ******************************************************************** */

int DiffChannel = X7;
int	StepMs = 8;  /* msec */			/* Step for derivative	*/
						/* Used to be 16	*/

/* ******************************************************************** */
/* FUNCTION SetupDifferentiate */
void SetupDifferentiate(void) {
   char  ToChange[80];

   while (1) {
    fprintf(stderr," Diff >  To channel [1-%d]  : x%d\n",
   					MAX_CHANNELS-8, 1+DiffChannel-X1);
    fprintf(stderr,"         Step size (halved) :  %d ms\n", StepMs);

    inputs("         Change x or s? > ",ToChange);

    if (ToChange[1] == '#')
	fputs("\t\tNo, that's not what I meant!\n", stderr);

    switch (ToChange[0]) {
	 case NONE:
	    return;
	 case '?': case 'y':
	    fputs("      >  Help: Change step size with 's#'\n", stderr);
	    fputs("      >        Change destination with 'x#'\n", stderr);
	    break;
	 case 's':
	    if (ToChange[1] == NONE)
      	       inputs("         New step size  >  s",ToChange+1);
      	    StepMs = (float) atof(ToChange+1);
	    break;
	 case 'x':
	    if (ToChange[1] == NONE)
	       inputs("         New channel    >  x",ToChange+1);
	    DiffChannel = X1 + atoi(ToChange+1) - 1;
	    break;
	 }
     }
}
/* ******************************************************************** */

/* FUNCTION Differentiate */
int Differentiate(int X) {
   FRAME *from, *to, *end;
   int	  Step = StepMs;			/* Fast (register var)	*/
   float  Norm = 0.;				/* Normalizing constant	*/

if (ProofReg(X) == FAIL)
return(FAIL);

Norm = 2*Step/1000.0;				/* deg/ms->deg/s (float)*/

from  = Register[X].channel[CurrentChannel].frame + Step;
to    = Register[X].channel[DiffChannel].frame + Step - 1;
end   = Register[X].channel[DiffChannel].frame - Step
					       + Register[X].frame_count;
while (++from, ++to <= end)
   if ((from+Step)->n && (from-Step)->n) {
      to->sum  = (MEan(from+Step) - MEan(from-Step)) / Norm;
      to->sum2 = to->sum * to->sum;
      to->n    = 1;
   } else
      to->sum = to->sum2 = to->n = 0;

CurrentChannel = DiffChannel;
return(OK);
}
