/* FILE defs.h */
     /* Globals: NONE is only system dependent one */
     /* 	 See also array.h	 	   */

#include <math.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
/* ******************************************************************** */

#define MAX_EVENTS	200	/* Should be >= MAX_EVENTS of vortex	*/
/* ******************************************************************** */

#define NoData	    	-100000
#define FAIL	      	-9999
#define OK	       	9998	/* POSITIVE: (if >0) is true */
#define DEFAULT       	-9997
#define REJECT	      	-9996
#define CHANGE	   	-9995	/* Passed to filters: change parameters */
#define NO_CHANGE	-9994	/* Ditto */
#define NONE	       	'\0'	/* Returned by query when no response	*/

#define INVALID_REG	999
/* ******************************************************************** */

#define irint(a)  ((int)( (a)+.5 ))		/* MISSING FROM LIBRARY! */

/* "CurrentChannel" values used to select channel (see array.h & load.c)*/

#define MAX_CHANNELS	15			/* Has been as hi as 15	*/

#define MAX_RECORDED_CHANNELS 5			/* DERIVED SIGNALS:	*/
int 	CurrentChannel;


#define Set_CurrentChannel(i)	(CurrentChannel = i)
#define IsCurrentChannel(i)	(i == CurrentChannel)
#define TellCurrentChannel()	(CurrentChannel)
#define RecordedChannel(i)	( (i>MAX_CHANNELS) ? 0 :		\
		 		( (i>=MAX_RECORDED_CHANNELS) ?	1 :	\
		 		( (i<0) ?			0 :	\
		 	 	( (Header_dflag() & (1<<i)) ?   1 : 0  ))))
#define UNIT	0
#define SPIKE_1	0
#define OD_H	1
#define OD_V	2
#define ARM_H	3
#define ARM_V	4
#define ARM_H_WIDTH 5
#define ARM_V_WIDTH 6
#define OLD_MULTI	7	/* Not using now?	*/
#define X1	8
#define X2	9
#define X3	10
#define X4	11
#define X5	12
#define X6	13
#define X7	14
#define X8	15
#define X9	16
#define X10	17
#define SPIKE_2	18
#define SPIKE_3	19
#define SPIKE_4	20
#define ERROR	21

/* NON-BINDING SUGGESTIONS: */
#define H_VEL	   X1
#define V_VEL	   X2
#define HV_POS	   X3				/* Euclidean (H + V)	*/
#define HV_VEL	   X4				/* Euclidean (H + V)	*/
#define	HEAD_VEL   X5
/* ******************************************************************** */

#define Standard_Deviation(sum_, sum2_, n_)\
 ( (float)  sqrt(fabs((double) (sum2_ - (sum_ * sum_ / n_)) / (n_-1) )))

#define MIN(x,y)    (((x) < (y)) ?  (x) : (y))
#define MAX(x,y)    (((x) > (y)) ?  (x) : (y))
/* ******************************************************************** */

/* TERMINAL STATES */
#include "termdef.h"

int Status;					/* Status bits:		*/

#   define BATCH_MODE		(1<<0)		/*  Running a batch?	*/
#   define COMMAND_MODE		(1<<1)		/*    " a command file?	*/
#   define MACRO_MODE		(1<<2)		/*    " a macro?	*/
	/* MACRO MODE also used if we don't want to see intermediates	*/
/* ******************************************************************** */



/* ******************************************************************** */


#include "functions.h"
/* ******************************************************************** */

