/* FILE chg.c */
     /* Change various parameters, mostly (?) from graphing routines	*/
     /* FUNCTIONS:
      * MenuChg 	  Display changables and their values
      * ChangeParameter   Change a variable's value
      * SetParameter	  (#define in defs.h that calls ChangeParameter
      * ChangeColor	  Set color obtained with 'c'
      * ChangePaintColor  Set color obtained with '@c'
      */
/* ******************************************************************** */
#include <stdio.h>
#include <stdlib.h>						/* atof	*/
#include <ctype.h>
#include "defs.h"
#include "graph.h"
/* ******************************************************************** */

int	print_header,				/* Flags for graph	*/
	graph_events,
	graph_stddev,				/* If ==2, do stderr!	*/	
	graph_stddev_shade,			/* Shaded or lines?	*/
	graph_bold,				/* -1,0,1 (0,1 on nds)	*/
	graph_red, graph_green, graph_blue,
	time_tics, time_tics_offset;
/* ******************************************************************** */

/* FUNCTION MenuChg */
	 /* Present menu of things that can be changed			*/
void MenuChg(void) {
static char BB[] = "[1m"; 		/* Embolden	*/
static char UB[] = "[0m"; 		/* Disembolden	*/
#define PP(format,value) fprintf(stderr, format, BB, UB, value)
#define P2(format,v1,v2) fprintf(stderr, format, BB, UB, v1,v2)

static char *DataCode[] = {"u", "h", "v", "H", "V", "^H", "^V", "m",
	"x1", "x2", "x3", "x4", "x5", "x6", "x7", "x8", "x9" };
static char *DataName[] = {"Units", "Heye","Veye","Harm","Varm",
	"HarmWidth", "WarmWidth", "multiunit",
	"X1",  "X2",  "X3",  "X4", "X5",  "X6",  "X7",  "X8", "X9"};
static char *LineType[] = {"","Line","Long Dash","Disconnected","Dot-dash",
				"Dotted", "short-dashed"};
static char *Stdev[]    = { "Off", "SD", "SE", "SD/2", "SE/2",
				  "+SD", "+SE", "-SD", "-SE"};
static char *StdevShade[]    = { "Lines", "Shaded" };
static char *OnOff[]	= { "Off", "On" };
int i = -1;

PP(" %sW%sidth:      %5.1f ms\t\t", ScreenWidth()/Get_x_mult());
PP(" %sH%seight:     %5.1f d\n",    ScreenHeight()/Get_y_mult());
PP(" %sS%start at:   %5d ms\t\t",   -1 * Get_x_offset());
PP(" %sO%sffset:     %5.1f %%\n",   100*Get_y_offset()/ScreenHeight());

PP(" %sI%sdentify:   %s\t\t\t",     OnOff[print_header]);
P2(" %sD%seviation:  %s (%s)\n",    Stdev[graph_stddev], StdevShade[graph_stddev_shade]);
PP(" %sM%sarks:      %s\n",         OnOff[graph_events]);
P2(" %sL%sineType:   %d (%s)\t\t",  Set_LineType(NO_CHANGE),
					LineType[abs(Set_LineType(NO_CHANGE))]);
PP(" Line %sB%sreadth:%d\n",   	    graph_bold);
PP(" %sR%subout:     %s\t\t\t",     (Set_LineType(NO_CHANGE)<0) ? "Yes" : "No");
PP(" %sC%solor:      %d",    graph_red);
	fprintf(stderr," %d %d\n", graph_green, graph_blue);

P2(" %sT%sype data:  %s (%s)\t\t Valid: ", DataCode[CurrentChannel],
				          DataName[CurrentChannel]);
for (i=0; i<MAX_RECORDED_CHANNELS; i++)
   if (RecordedChannel(i))
      fprintf(stderr, "%s ", DataCode[i]);

fprintf(stderr, "x[1:%d]}\n",  MAX_CHANNELS-MAX_RECORDED_CHANNELS);
PP(" %sz%stime tics:  %d\t\t\t",    time_tics);
PP(" %sZ%soffset:  %d\n",    time_tics_offset);

}
/* ********************************************************************* */

/* FUNCTION ChangeParameter */
	 /* Execute changes. Some take optional argument (vs toggling)	*/
void ChangeParameter(char Parameter, char *Value) {

   if (Parameter != 'Z')
     if (isupper(Parameter))
       Parameter -= 'A' + 'a';

   if (Value[0] == NONE) {
      vtprint("No value.");
      return;
   } else if (atof(Value) == 0)
      switch (Parameter) {
         case 'w': case 'h': case 'g': case 'l':
            vtprint("Zero is not an allowed value!");
            return;
         }

   switch (Parameter) {
    case 'i': print_header = atoi(Value);
	      return;
    case 'm': graph_events = atoi(Value);
	      return;
    case 'r': Set_LineType((atoi(Value)<1) ?
		   abs(Set_LineType(NO_CHANGE)) : -abs(Set_LineType(NO_CHANGE)));
	      return;
    case 's': Set_x_offset((float)-(atof(Value)));
	      return;
    case 'h': Set_y_mult(ScreenHeight() / (float)atof(Value));
	      return;
    case 'o':  						/* Convert to %	*/
    	      Set_y_offset(ScreenHeight() * (float)atof(Value)/100);
	      return;
    case 'b': graph_bold = atoi(Value);
	      return;

    case 'z': time_tics = atoi(Value);
	      return;
    case 'Z': time_tics_offset = atoi(Value);
	      return;

    case 'c': switch(Value[0]) {
	case '0': graph_red = graph_green = graph_blue = 0;	break;
	case 'W':
	case '8': graph_red = graph_green = graph_blue = 8;	break;
	case 'A': case 'a':				/* Monochrome	*/
		  graph_red = graph_green = graph_blue = atoi(Value+1);	break;

	case 'R': graph_green = graph_blue = 0; graph_red = 8;	break;
	case 'G': graph_red = graph_blue = 0; graph_green = 8;	break;
	case 'B': graph_red = graph_green = 0; graph_blue = 8;	break;

	case 'r': case '1': graph_red   = atoi(Value+1);	break;
	case 'g': case '2': graph_green = atoi(Value+1);	break;
	case 'b': case '3': graph_blue  = atoi(Value+1);	break;

	case '?':
	default:
	   fprintf(stderr, "Enter 0 to color to black     (cc0  = black)\n");
	   fprintf(stderr, "Enter 1 or r to set red gun   (cc18 = on)\n");
	   fprintf(stderr, "Enter 2 or g to set green gun (cc20 = off)\n");
	   fprintf(stderr, "Enter 3 or b to set blue gun  (ccb4 = half)\n");
	   fprintf(stderr, "Enter a for all equal (grey)  (cca7 = light grey)\n");
	   fprintf(stderr, "Enter a for all equal (grey)  (cca1 = dark grey)\n");
	   return;
	}
	ChangeColor();
	return;
   
    case 'w': Set_x_mult(ScreenWidth()  / (float)atof(Value));
	      return;
    case 'l': Set_LineType(atoi(Value));
	      return;				/* Check line quality	*/
   
    case 'e':
    case 'd': switch (Value[0]) {
	         case '0': graph_stddev = 0; break;
	         case '1': graph_stddev = 1 + (Parameter=='e'); break;
	         case '2': graph_stddev = 3 + (Parameter=='e'); break;
	         case '+': graph_stddev = 5 + (Parameter=='e'); break;
	         case '-': graph_stddev = 7 + (Parameter=='e'); break;
		 case 's': graph_stddev_shade = 1; break;
		 case 'l': graph_stddev_shade = 0; break;
		 case '?':
      		   fprintf(stderr, "cd0 or ce0: plot only the mean\n");
      		   fprintf(stderr, "cd1 or ce1: add +/- SD/SE  (if < 15.)\n");
      		   fprintf(stderr, "cd+ or ce+: add  +1 SD/SE\n");
      		   fprintf(stderr, "cd- or ce-: add  -1 SD/SE\n");
      		   fprintf(stderr, "cds or ces: show as shading\n");
      		   fprintf(stderr, "cdl or cel: show as a line\n");
		   return;
	         default:  graph_stddev = atoi(Value);
	         }
	      return;
   
    case 't': {
	   int NewChannel;
   
	   switch (Value[0]) {
		   case 'u': case 'U':
			      if (Value[1] == 0 || Value[1] == '1') {
			         NewChannel = UNIT;
			         break;
	   			 }		/* Fall through	*/
		   	      NewChannel = SPIKE_2 -1 +(int)(Value[1])-(int)'1';
			      break; /* if Value=2, SPIKE_2 -1 + 1 = SPIKE_2 */

		   case 'h' : NewChannel = OD_H;  break;
		   case 'v' : NewChannel = OD_V;  break;
		   case 'H' : NewChannel = ARM_H;  break;
		   case 'V' : NewChannel = ARM_V;  break;
		   case '' : NewChannel = ARM_H_WIDTH;  break;
		   case '' : NewChannel = ARM_V_WIDTH;  break;
   
		   case 'X':
		   case 'x':	NewChannel = X1 + (int)(Value[1])-(int)'1';
				   if (NewChannel < MAX_CHANNELS)
				      break;
           			   fputs("Channel not recorded!\n", stderr);
				   return;

		   case 'm': case 'M':	
           			   fputs("Use u2 for old 'multi'\n", stderr);
				   return;
   
		   default: 	NewChannel = ERROR;
				   break;
		   }				/* END SWITCH (Value[0])*/
           if (NewChannel == ERROR) {
	      vtprint("Choose from: u[1-4] h v H V ^H ^V x[1-9]");
	      return;
	      }
	   if (RecordedChannel(NewChannel) == 0) {
	      vtprint("Channel not recorded!");
	      return;
	      }
	   CurrentChannel = NewChannel;
           return;				/* END CASE 't':	*/
  	   }   
   
    default:
	   fprintf(stderr, "Unknown parameter '%c' (%s)\n", Parameter, Value);
	   return;
    }
   }
/* ******************************************************************** */

/* FUNCTION ChangeColor */
	 /* After intervening change using direct call to color	*/
	 /* Will also restore to these values after Paint or other call
	    changes them */
void ChangeColor(void) {
	int r=2*graph_red, g=2*graph_green, b=2*graph_blue;

	if (r > 10)/* Greater than 5?  Make light colors lighter*/
	    r++;
	if (g > 10)
	    g++;
	if (b > 10)
	    b++;

	if (r>16)
	    r=16;
	if (g>16)
	    g=16;
	if (b>16)
	    b=16;

	color(r * 0xFFF, g * 0xFFF, b * 0xFFF);
	}
/* ******************************************************************** */

/* FUNCTION ChangePaintColor */
	 /* Map paint colors same as graph_red,etc	*/
void ChangePaintColor(int *PaintColors) {
	int r=2*PaintColors[0], g=2*PaintColors[1], b=2*PaintColors[2];

	if (r > 10)	/* Greater than 5?  Make light colors lighter	*/
	    r++;
	if (g > 10)
	    g++;
	if (b > 10)
	    b++;

	if (r>16)
	    r=16;
	if (g>16)
	    g=16;
	if (b>16)
	    b=16;

	color(r * 0xFFF, g * 0xFFF, b * 0xFFF);
	}
/* ******************************************************************** */
