/* FILE calc.c */
     /* Specialized calculations	*/

     /* FUNCTIONS:
	  FindIntercept		Returns time of intercept given 4 points
      */

#include "defs.h"				/* Misc constants	*/
#include "array.h"				/* Array declarations	*/
/* ********************************************************************	*/

/* FUNCTION FindIntercept */
	 /* Given two registers and a time, find intercept looking back
	    in time from that point (used by divergedata) */
int FindIntercept(int reg1, int reg2, int time) {
   #define SPAN	6			/* 2nd point: 1st point + SPAN	*/
   #define BACK	5			/* 1st point: time - BACK ms	*/

   float yA = AvgSomeData(reg1, time-2-BACK, time+2-BACK);	/* 1st point	*/
   float yC = AvgSomeData(reg2, time-2-BACK, time+2-BACK);	/*  (2nd reg)	*/

   float yB = AvgSomeData(reg1, SPAN+time-2-BACK, SPAN+time+2-BACK);
   float yD = AvgSomeData(reg2, SPAN+time-2-BACK, SPAN+time+2-BACK);

   return (  irint(time-BACK + (yC-yA)*SPAN/(yB-yA-yD+yC)) );
   }
/* ********************************************************************	*/
