/* FILE Auto.c */
     /* Handle automode: automatically calculate new values after each 'n'*/
     /* In general: automode instructions can be anything, even macros!
	You could add sorting, filtering, write to disk, averaging, etc.
	Caveate:  Be consistent: don't ask for accel but not veloc,
	unless veloc is calculated within accel instruction.
	Error checking is not automatic -- only there if you add it.
	*/
/* ********************************************************************	*/

#include "defs.h"

#define CONSTRUCTS 16

static int Channel[CONSTRUCTS] = { 1,2,3,4};
/* static int Channel[CONSTRUCTS] = { 0, 0, 0, 0};	 * No automode!	*/
static char *Construct[CONSTRUCTS] = {
	"OD horizontal eye velocity",
	"OD vertical   eye velocity",
	"OD horiz  eye acceleration",
	"OD vertic  eye acceleration"
	};
static int Prefilter_H = 1, Prefilter_V = 1;		/* Pre-filter	*/
static int ChannelTo = -1;
/* ********************************************************************	*/

/* FUNCTION Set_AutoMode */
	 /* Set up what will be calculated */
void Set_AutoMode(void) {
   int count;
   char answer[80];
   
   fputs("Default value is in brackets (Options are 0 or 1)\n", stderr);
   fprintf(stderr, "Pre-filter horizontal eye [%d (%s)]      >     ",
   		Prefilter_H, (Prefilter_H==0) ? "off" : " on");
   inputs("", answer);
   if (answer[0] != NONE)
      Prefilter_H = (answer[0]=='1' || answer[0]=='y');
   
   fprintf(stderr, "Pre-filter vertical   eye [%d (%s)]      >     ",
   		Prefilter_V, (Prefilter_V==0) ? "off" : " on");
   inputs("", answer);
   if (answer[0] != NONE)
      Prefilter_V = (answer[0]=='1' || answer[0]=='y');
   
   fprintf(stderr, "Leave channel at [%2d]  {Enter '?' for help} >     ", ChannelTo);
   inputs("", answer);		/* NOTE: ChannelTo == -1 => no change	*/
   if (answer[0] == '?') {
      fputs("\n Control the setting of CurrentChannel ('t' option of 'c' menu)\n", stderr);
      fputs("   return  Maintain current default [value]\n", stderr);
      fputs("   -1      No effect of Automode\n", stderr);
      fputs("   0:16    Set to channel # [defs.h]\n", stderr);
      fprintf(stderr, "\nSet channel to [%d]                    >   ", ChannelTo);
      inputs("", answer);
      }
   if (answer[0] != NONE)
      ChannelTo = atoi(answer);
   if (ChannelTo > 0)
      ChannelTo--;				/* Don't start at zero	*/
   
   fprintf(stderr, "\n Construct:               [x channel]   new x channel\n");
   fprintf(stderr, "\n  (return for default, -1 for quit, # for channel)\n");
   for (count=0; count<CONSTRUCTS; count++) {
       if (Construct[count] == NULL)
          break;
       fprintf(stderr,"%-28s [%2d]      >     ", Construct[count], Channel[count]);
       if (count==3) {				/* Not independently set*/
          fprintf(stderr, "%d\n", Channel[count]);	/* Same as verg	*/
          continue;
          }
       inputs("", answer);
       if (answer[0] == '0')
          Channel[count] = 0;
       else if (atoi(answer) < 0)				/* Escape	*/
          break;
       else if (answer[0] != NONE)
          Channel[count] = atoi(answer);
       }
   }
/* ********************************************************************	*/
   
/* FUNCTION Do_AutoMode */
	 /* Execute automode instructions */
void Do_AutoMode(void) {
   extern int DiffChannel;
   int SaveChannel = CurrentChannel;
   int SaveDiffChannel = DiffChannel;
   int count;
   
   if (Status & (BATCH_MODE|MACRO_MODE))
      return;
   
   if (Prefilter_H) {
      if (CurrentChannel==OD_H)
         Filter(0);
      } 
   if (Prefilter_V) {
      if (CurrentChannel==OD_V)
         Filter(0);
      } 
   
   for (count=0; count<CONSTRUCTS; count++)
      if (Channel[count] != 0)
        switch (count) {
           case 0:					/* OD_H vel	*/
   		if (!RecordedChannel(OD_H))
   		   break;
   		CurrentChannel = OD_H;
   		DiffChannel = X1;
   		Differentiate(0);
   		break;
           case 1:					/* OD_V veloc	*/
   		if (!RecordedChannel(OD_V))
   		   break;
   		CurrentChannel = OD_V;
   		DiffChannel = X2;
   		Differentiate(0);
   		break;
           case 2:					/* OD_H accel	*/
   		if (!RecordedChannel(X1))
   		   break;
   		CurrentChannel = Channel[0]+X1-1;
   		DiffChannel = X3;
   		Differentiate(0);
   		break;
           case 3:					/* OD_V accel	*/
   		if (!RecordedChannel(X2))
   		   break;
   		CurrentChannel = Channel[1]+X1-1;
   		DiffChannel = X4;
   		Differentiate(0);
   		break;
   	default:
   		break;
           }
   
   CurrentChannel = (ChannelTo==-1) ? SaveChannel : ChannelTo;
   DiffChannel    = SaveDiffChannel;
   }
/* ********************************************************************	*/
