/* FILE array.h */
	/* Definitions/declarations common to array.c and list.c	*/

#include <stdio.h>
#include <ctype.h>
#include "defs.h"				/* Channel definitions	*/
/* ******************************************************************** */

#define MAX_REGISTERS	135 /* Accumulator to store trials (162,106,55)	*/
#define MAX_FRAMES	27000	/* Data points per trial (8500,4200)	*/
#define MARGIN		3	/* Don't ever change this; happy at 3	*/
/* ******************************************************************** */

#define MEan(  F)	( ((F)->sum) / ((F)->n) )
#define SD(    F)	( (float) sqrt(fabs( (double)\
			((F)->sum2 - (F)->sum * MEan(F))) / ((F)->n - 1)))
#define SE(    F)	( SD(F) / (float) sqrt( (double) ((F)->n)) )

typedef struct {
	float	sum;				/* Sum of data		*/
	float	sum2;				/* Sum of squares	*/
	short	n;				/* Number data points	*/
	short   dummy;				/* sun3-4 compatability	*/
} FRAME;					/* One frame snapshot	*/
		/* NOTE: UNIT frame: sum = EncodeFreq(hz), n=sgn(hz)	*/

typedef struct {
	FRAME	 frame[MAX_FRAMES+MARGIN];	/* Multiple frames	*/
} CHANNEL;					/* Stream for 1 channel	*/

#define TAG_SIZE	30
#define MAX_STACK_NAME_CHARS	24
float ScratchPad[MAX_FRAMES+MARGIN];		/* Differentiate pad	*/

struct REGISTER {				/* Describes 1 trial	*/
 char	tag[TAG_SIZE+MARGIN];			/* Descriptor/title	*/
 int	frame_count;				/* Most frames in a reg	*/
 int	trial_count;				/* Trials in register	*/
 int	spikes[MAX_FRAMES+MARGIN];		/* Summed spikes/frame	*/
 CHANNEL channel[MAX_CHANNELS];
 short  stack[5 * (MAX_EVENTS+1)];		/* Keep copy of stack	*/
 char   stackname[MAX_STACK_NAME_CHARS];	/* Stack's name		*/
 int    stacknumber, classnumber;		/* Stack and class #	*/
 int	shift;					/* Amount shifted	*/
}  Register[MAX_REGISTERS];  			/* All the data		*/
/* ********************************************************************	*

Deffs of convenience (for discussing data):
	trial		One trial of data (all channels).
Structure types & variables of that type:
	REGISTER	Holds a trial or average of n trials. Data & title.
	Register[0]	Trials read from tape always go first to here.
	CHANNEL		Stucture holding single-channel data sequence
	channel[OD_H]	Holds entire sequence of OD_H data
	FRAME		Structure holding 1 instant of data from 1 channel
	spikes[]	# spikes occuring in each frame (summed over all trials)
 * ********************************************************************	*/
