/* FILE arm.c */
     /* SetupFindArmMove	User's parameter menu 			*/
     /* FindArmMove		Return start or finish			*/
/* ******************************************************************** */

#include "defs.h"				/* Misc constants	*/
#include "array.h"				/* Array declarations	*/
#include "sac.h"				/* ArmMoveData struct	*/

int NoArmMovesBeforeThis = 0; /* Indent before searching-FindSaccade() (ms)*/
int NoArmMovesAfterThis = 0;  /* Don't look all the way to the end (ms)	*/
int FindStartOfArmMove = 1;		/* Else find end of move	*/

static float ArmPosition(FRAME *at);
/* ********************************************************************	*/

/* FUNCTION SetupFindArmMove */
void SetupFindArmMove(void) {
char answer[80];

if ((Status & COMMAND_MODE) == 0) {
 PRINT_AGAIN:
   fprintf(stderr, " A    Begin search after %d ms\n", NoArmMovesBeforeThis);
   fprintf(stderr, " Z    Stop  search after %d ms\n", NoArmMovesAfterThis);
   fprintf(stderr, " S    Find START ? (vs END): %d\n", FindStartOfArmMove);
   }

while  (1) {
   inputs(" Find arm moves >  ", answer);
   if (answer[0] >= 'a' && answer[0] <= 'z')
       answer[0] += 'A' - 'a';			/* convert to upper case*/
   switch (answer[0]) {
       case 'A':    NoArmMovesBeforeThis = atoi(answer+1); break;
       case 'Z':    NoArmMovesAfterThis  = atoi(answer+1); break;
       case 'S':    FindStartOfArmMove  = atoi(answer+1); break;
       case '?':    goto PRINT_AGAIN;
       default: return;
       }
   }
}
/* ********************************************************************	*/
#define MOVE_CRITERION	3.	/* Find lift-off OR move of > ~ deg	*/
#define WITHIN		100	/*  within ~ ms of lift-off		*/

/* FUNCTION FindArmMove */
	 /* Places where arm moves at greater than 0.75 d or lifts up	*/
	 /* CANNOT HANDLE A PURE SLIDE, ie, MOVEMENT WITHOUT LIFT-OFF	*/
int FindArmMove(int reg) {
    FRAME *H = (Register[reg].channel[ARM_H].frame);
    FRAME *V;
    FRAME *END = H + Register[reg].frame_count;
    float StartH, StartV;
    int    i;

if (ProofReg(reg) == FAIL)
   return(FAIL);

if (NoArmMovesAfterThis)
   END = H + NoArmMovesAfterThis;

H += NoArmMovesBeforeThis;

while (H < END)					/* Find release		*/
   if (H->n == 0)					/* No touch?	*/
      break;
   else
       H += 50;						/* 50 ms steps	*/

if (H >= END)					/* Check for EOF	*/
   goto NO_LIFT_OFF;

H -= 50;
while (H < END)					/* Refine release	*/
   if (H->n == 0)					/* No touch?	*/
      break;
   else
       H += 4;						/* 4 ms steps	*/

H -= WITHIN; 					/* Check for move	*/
V = Register[reg].channel[ARM_V].frame +
      (H - Register[reg].channel[ARM_H].frame);

StartH = ArmPosition(H-100);		/* Get position 100 ms before	*/
StartV = ArmPosition(V-100);			/*  (uses 20 ms window)	*/

for (i=0; i<WITHIN; i+=2) {			/* Find within 2 ms	*/
    float h = ArmPosition(H + i);
    float v = ArmPosition(V + i);
    
    if (H->n == 0)				/* Not touching?	*/
       break;
    if (fabs(h - StartH) > MOVE_CRITERION ||
        fabs(v - StartV) > MOVE_CRITERION)
       break;
    }

H += i;
V += i;

if (FindStartOfArmMove)
   return(H - Register[reg].channel[ARM_H].frame);	/* ms		*/

/* else if find end of movement */
for (i=0; i<WITHIN; i++,H++)			/* Find lift-off	*/
   if (H->n == 0)
      break;

for (   ; H<END; H++)				/* Find touch-down	*/
    if (H->n != 0)
       break;

if (H >= END) {
   fprintf(stderr, "Couldn't find end of movement\n");
   return(FAIL);
   }

return(H - Register[reg].channel[ARM_H].frame);	/* ms		*/



NO_LIFT_OFF:					/* Arm never picks up	*/
{
 int Backup;

 H = Register[reg].channel[ARM_H].frame;	/* Reset position	*/
 H += NoArmMovesBeforeThis;

 V = Register[reg].channel[ARM_V].frame +
      (H - Register[reg].channel[ARM_H].frame);

 Backup = (NoArmMovesBeforeThis > 100) ? 100 : NoArmMovesBeforeThis - 5;
 StartH = ArmPosition(H-Backup);	/* Get position at start	*/
 StartV = ArmPosition(V-Backup);

 for (i=0; H+i<END; i+=2) {			/* Find within 2 ms	*/
    float h = ArmPosition(H + i);
    float v = ArmPosition(V + i);
    
    if (H->n == 0)				/* Not touching?	*/
       break;
    if (fabs(h - StartH) > MOVE_CRITERION ||
        fabs(v - StartV) > MOVE_CRITERION)
       break;
    }

 H += i;

 if (H >= END) {
    fprintf(stderr, "No arm movement\n");
    return(FAIL);
    }

 return(H - Register[reg].channel[ARM_H].frame);	/* ms		*/
 }
}
/* ********************************************************************	*/
/* FUNCTION ArmPosition */
	 /* Does not check for out of bounds or not touching! */
static float ArmPosition(FRAME *at) {
   int i;
   float sum = 0.;
   int n = 0;

   at -= 10;					/* Look at centered int	*/
   for (i=0; i<20; i++, at++)
      if (at->n > 0) {
         sum += at->sum / at->n;
	 n++;
	 }
   if (n>0)
      return(sum/n);
   return(FAIL);
   }
/* ********************************************************************	*/
