/* Copyright (C) 1989 Free Software Foundation, Inc.

   plot is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY.  No author or distributor accepts responsibility to
   anyone for the consequences of using it or for whether it serves any
   particular purpose or works at all, unless he says so in writing.
   Refer to the GNU General Public License for full details.

   Everyone is granted permission to copy, modify and redistribute
   plot, but only under the conditions described in the GNU General
   Public License.  A copy of this license is supposed to have been
   given to you along with libtek so you can know your rights and
   responsibilities.  It should be in a file named COPYING.  Among
   other things, the copyright notice and this notice must be preserved
   on all copies.  */

/* This file is the space routine, which is a standard part of the plot
   library.  It sets the lower left and upper right corners of the page.  The
   plot will be scaled so that these coners fit the largest renderable area on
   the page.  */

#include "plot.h"


static double scale = 1;
static int x_offset = 0;
static int y_offset = 0;
static int arg_x0 = 0;
static int arg_y0 = 0;
static int arg_x1 = 1024;
static int arg_y1 = 1024;


int x_scale (int x)		/* transform coordinates */
{
  return (x - x_offset) * scale;
}

int y_scale (int y)
{
  return xpl_window->height - (y - y_offset) * scale - 1;
}

#define min(a,b) ((a)<(b)?(a):(b))

int spaceX (int x0, int y0, int x1, int y1)
{
  if (x0 == 0 && y0 == 0 && x1 == 0 && y1 == 0)  {
    /* Internal call.  Window resized.  Recurse with old values. */
    spaceX (arg_x0, arg_y0, arg_x1, arg_y1);
  } else {
    /* Store values for resize. */
    arg_x0 = x0, arg_y0 = y0, arg_x1 = x1, arg_y1 = y1;

    x_offset = x0;
    y_offset = y0;
    scale = min( (double)(xpl_window->width-1) / (x1-x0), 
  		 (double)(xpl_window->height-1) / (y1-y0) );
  }
  return 0;
}
