#ifndef _xplot_h
#define _xplot_h

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>	/* Added 10-2012 */

#include <Xlib.h>
#include <Xutil.h>
#include <Xos.h>
#include <Xatom.h>

/*
#include "/usr/include/X11/Xlib.h"
#include "/usr/include/X11/Xutil.h"
#include "/usr/include/X11/Xos.h"
#include "/usr/include/X11/Xatom.h"
*/


/* The X plot library implementation allows multiple windows to be
 * maintained with graphics output switched between them using the
 * device() extension call.  The following structure holds information
 * about each window.
 */

typedef struct _XplWindow {
  Display *		dpy;
  Window		win;
  Pixmap		pix;
  GC			gc;

  int			closed;
  int			external_win;

  int			width;
  int			height;
  
  unsigned long		foreground;
  unsigned long		background;

  struct _XplWindow *	next;
} XplWindow;


extern XplWindow *	 xpl_window;
extern XplWindow *	 xpl_windows;

void   xpl_new_window     (Display *, Window, char *);
int    xpl_select_window  (XplWindow *);
void   xpl_unlink_window  (XplWindow *);
void   xpl_destroy_window (XplWindow *);
void   xpl_update();

/*
 * These buffers are used to collect lines and points so that they can
 * be drawn in a single call to XDrawLines or XDrawPoints.
 */

#define XPL_BUFFER_SIZE	100
extern XPoint	Xpl_line_buffer[XPL_BUFFER_SIZE];
extern XPoint   Xpl_point_buffer[XPL_BUFFER_SIZE];

void  Xbuffer_cont  (int x, int y);
void  Xbuffer_point (int x, int y);
void  Xbuffer_move  (int x, int y);
void  Xbuffer_flushpl ();

extern int		    current_x;
extern int		    current_y;

int    x_scale (int);
int    y_scale (int);

int deviceX	     (va_list *args);

int openplX          (void);
int closeplX         (void);
int flushplX         (void);
int spaceX           (int x0, int y0, int x1, int y1);
int colorX           (int red, int green, int blue);
int bkgndX           (int red, int green, int blue);
int linemodX         (char *s);
int linewidthX       (int);
int fillX            (int level);
int fontnameX        (char *s);
int fontsizeX        (int size);
int rotateX          (int w, int h, int angle);
int eraseX           (void);
int labelX           (char *s);
int alabelX          (int x_justify, int y_justify, char *s);
int arcX             (int xc, int yc, int x0, int y0, int x1, int y1);
int boxX             (int x0, int y0, int x1, int y1);
int circleX          (int x, int y, int r);
int contX            (int x, float y);
int dotX             (int x, int y, int dx, int n, char *pattern);
int pointX           (int x, int y);
int lineX            (int x0, int y0, int x1, int y1);
int moveX            (int x, float y);

#endif /* !_xplot_h */

