/* Copyright (C) 1989 Free Software Foundation, Inc.

   plot is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY.  No author or distributor accepts responsibility to
   anyone for the consequences of using it or for whether it serves any
   particular purpose or works at all, unless he says so in writing.
   Refer to the GNU General Public License for full details.

   Everyone is granted permission to copy, modify and redistribute
   plot, but only under the conditions described in the GNU General
   Public License.  A copy of this license is supposed to have been
   given to you along with libtek so you can know your rights and
   responsibilities.  It should be in a file named COPYING.  Among
   other things, the copyright notice and this notice must be preserved
   on all copies.  */

/* This file is the linemod routine, which is a standard part of the plot
   library.  It sets the line type according to the name contained in
   the string argument s */

#include "plot.h"

#define NO_OF_STYLES 6

struct {char *name; long line_style;} styles [NO_OF_STYLES + 1] = {
  {"solid", 		LineSolid},
  {"longdashed",	LineOnOffDash},
  {"disconnected",	LineOnOffDash},
  {"dotdashed",		LineOnOffDash},
  {"dotted",		LineOnOffDash},
  {"shortdashed", 	LineOnOffDash},
  {"default",		LineSolid},
};

int linemodX (char *s)
{
  XGCValues           	values;
  long                	value_mask = 0;
  int i;

  flushplX();

  for (i = 0; i < NO_OF_STYLES; i++) 
    if (strcmp (styles[i].name, s) == 0)
      break; 

  values.line_style = styles[i].line_style;
  value_mask |= GCLineStyle;
  XChangeGC (xpl_window->dpy, xpl_window->gc, value_mask, &values);

  return 0;
}
