/* Copyright (C) 1989 Free Software Foundation, Inc.

   plot is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY.  No author or distributor accepts responsibility to
   anyone for the consequences of using it or for whether it serves any
   particular purpose or works at all, unless he says so in writing.
   Refer to the GNU General Public License for full details.

   Everyone is granted permission to copy, modify and redistribute
   plot, but only under the conditions described in the GNU General
   Public License.  A copy of this license is supposed to have been
   given to you along with libtek so you can know your rights and
   responsibilities.  It should be in a file named COPYING.  Among
   other things, the copyright notice and this notice must be preserved
   on all copies.  */

/* FONTNAME takes a string argument S containing the name of the desired current
   font and sets the current font to that name.  If the string S is too long
   it complains and sets the current font to the default. */

#include "plot.h"

extern void setfont();
char *current_font = 0;

#define NO_OF_FONTS 13
struct {char *plot_name; char *x_name;} fonts[NO_OF_FONTS + 1] = {
  {"courier-bold", 		"courier-bold-r"},
  {"courier-boldoblique", 	"courier-bold-o"},
  {"courier-oblique", 		"courier-medium-o"},
  {"courier", 			"courier-medium-r"},
  {"helvetica-bold", 		"helvetica-bold-r"},
  {"helvetica-boldoblique", 	"helvetica-bold-o"},
  {"helvetica-oblique", 	"helvetica-medium-o"},
  {"helvetica", 		"helvetica-medium-r"},
  {"symbol", 			"symbol-medium-r"},
  {"times-bold", 		"times-bold-r"},
  {"times-bolditalic", 		"times-bold-i"},
  {"times-italic", 		"times-medium-i"},
  {"times-roman", 		"times-medium-r"},
  {"default",			"helvetica-medium-r"}
};
    
int
fontnameX (char *s)
{
  int i;
  for (i = 0; i < NO_OF_FONTS; i++) 
    if (strcmp (fonts[i].plot_name, s) == 0) 
      break;
  current_font = fonts[i].x_name;
  setfont();
  return 0;
}
