#include "plot.h"
#include "../plot.h"

/*
 * Global initialization of the function pointers.
 */

int (*openplP)          (void)				= openplX;
int (*closeplP)         (void)				= closeplX;  
int (*flushplP)		(void)				= flushplX;
int (*spaceP)           (int, int, int, int)		= spaceX;    
int (*colorP)           (int, int, int)			= colorX;    
int (*bkgndP)           (int, int, int)			= bkgndX;    
int (*linemodP)         (char *)			= linemodX;  
int (*linewidthP)       (int)				= linewidthX;
int (*fillP)            (int)				= fillX;     
int (*fontnameP)        (char *)			= fontnameX; 
int (*fontsizeP)        (int)				= fontsizeX; 
int (*rotateP)          (int, int, int)			= rotateX;   
int (*eraseP)           (void)				= eraseX;    
int (*labelP)           (char *)			= labelX;    
int (*alabelP)          (int, int, char *)		= alabelX;   
int (*arcP)             (int, int, int, int, int, int)	= arcX;      
int (*boxP)             (int, int, int, int)		= boxX;      
int (*circleP)          (int, int, int)			= circleX;   
int (*contP)            (int, float)			= contX;     
int (*dotP)             (int, int, int, int, char *)	= dotX;      
int (*pointP)           (int, int)			= pointX;    
int (*lineP)            (int, int, int, int)		= lineX;     
int (*moveP)            (int, float)			= moveX;     







#if (COMPILING_WITH_MULTI_VERSION)	/* Commented out 8-13-96 by LHS */
int deviceX (va_list *args)
{
  /* Read arguments */

  /* The first argument is one of the strings "new", "old" or "pre".
     This tells us what other arguments to expect */
  char *type = va_arg (*args, char *);

  /* "new" means open a new window.  The name of the window follows */

  if (strcmp (type, "new") == 0) {
    char *name  = va_arg(*args, char *);
    xpl_new_window (NULL, 0, name);
  }


  /* "pre" means to use a pre-existing window.  The display and window 
     pointers follow */
  
  if (strcmp (type, "pre") == 0) {
    Display *dpy = va_arg(*args, Display *);
    Window   win = va_arg(*args, Window);
    xpl_new_window (dpy, win, NULL);
  }


  /* "old" means look up the (following) index in the old window list */
  
  if (strcmp (type, "old") == 0) {
    int window_index = va_arg (*args, int);

    xpl_select_window ((XplWindow *) window_index);
  }

  /* Reassign the function pointers */
  
  openplP      = openplX;   
  closeplP     = closeplX; 
  flushplP     = flushplX;
  spaceP       = spaceX;    
  colorP       = colorX;    
  bkgndP       = bkgndX;    
  linemodP     = linemodX;  
  linewidthP   = linewidthX;
  fillP        = fillX;     
  fontnameP    = fontnameX; 
  fontsizeP    = fontsizeX; 
  rotateP      = rotateX;   
  eraseP       = eraseX;    
  labelP       = labelX;    
  alabelP      = alabelX;   
  arcP         = arcX;      
  boxP	       = boxX;      
  circleP      = circleX;   
  contP	       = contX;     
  dotP	       = dotX;      
  pointP       = pointX;    
  lineP	       = lineX;     
  moveP	       = moveX;     

  return (int) xpl_window;
}
#endif
