/* Copyright (C) 1989 Free Software Foundation, Inc.

   plot is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY.  No author or distributor accepts responsibility to
   anyone for the consequences of using it or for whether it serves any
   particular purpose or works at all, unless he says so in writing.
   Refer to the GNU General Public License for full details.

   Everyone is granted permission to copy, modify and redistribute
   plot, but only under the conditions described in the GNU General
   Public License.  A copy of this license is supposed to have been
   given to you along with libtek so you can know your rights and
   responsibilities.  It should be in a file named COPYING.  Among
   other things, the copyright notice and this notice must be preserved
   on all copies.  */

/* This file is the color routine, which is an extension to the plot
   library. It changes the color of the following drawing operations. */

#include "plot.h"


int colorX (int red, int green, int blue)
{
  XColor new_color;
  new_color.red = red;
  new_color.green = green;
  new_color.blue = blue;

  flushplX();

  if (XAllocColor (xpl_window->dpy, 
		   DefaultColormap (xpl_window->dpy, 
				    DefaultScreen(xpl_window->dpy)), 
		   &new_color)) {

    xpl_window->foreground = new_color.pixel;
    XSetForeground (xpl_window->dpy, xpl_window->gc, new_color.pixel);
    return 0;

  } else {

    fprintf (stderr, "ERROR: could not allocate color\n");
    return -1;

  }
}


int bkgndX (int red, int green, int blue)
{
  XColor new_color;
  new_color.red = red;
  new_color.green = green;
  new_color.blue = blue;

  if (XAllocColor (xpl_window->dpy, 
		   DefaultColormap (xpl_window->dpy, 
				    DefaultScreen(xpl_window->dpy)), 
		   &new_color)) {

    xpl_window->background = new_color.pixel;

    XSetWindowBackground (xpl_window->dpy, xpl_window->win, new_color.pixel);
    XSetBackground       (xpl_window->dpy, xpl_window->gc , new_color.pixel);
    
    return 0;

  } else {

    fprintf (stderr, "ERROR: could not allocate color\n");
    return -1;

  }
}

