/* Copyright (C) 1989 Free Software Foundation, Inc.

   plot is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY.  No author or distributor accepts responsibility to
   anyone for the consequences of using it or for whether it serves any
   particular purpose or works at all, unless he says so in writing.
   Refer to the GNU General Public License for full details.

   Everyone is granted permission to copy, modify and redistribute
   plot, but only under the conditions described in the GNU General
   Public License.  A copy of this license is supposed to have been
   given to you along with libtek so you can know your rights and
   responsibilities.  It should be in a file named COPYING.  Among
   other things, the copyright notice and this notice must be preserved
   on all copies.  */

/* This file is the closepl routine, which is a standard part of the plot
   library.  Normally it closes the plotting device.   */

/* In xplot it forks a child process to maintain the display window and
   then returns, allowing the parent to exit.  The child process can
   be dismissed by a mouse button click in the display window. */

#include "plot.h"
#include <unistd.h>
#include <time.h>

int closeplX ()
{
  /* Keep a pointer to the current window */
  XplWindow *closed = xpl_window;

  /* Flush all streams first.  Otherwise, stuff pending in the buffer
     will be duplicated in the child and written twice. */
  flushplX();

  /* Unlink it and change the current window */
  xpl_unlink_window (closed);
  xpl_window = xpl_windows;
  
  /* If we didn't make the window just clean up and leave */
  if (closed->external_win) {
    xpl_destroy_window(closed);
    return 0;
  }
  
  /* If we did, fork a child to keep the window around until 
     clicked on */

  if (fork()) {			/* this is the parent */

    return 0;

  } else {			/* this is the child */

    /* a timer to sleep to */
    struct timespec tm;
    tm.tv_sec  = 0;
    tm.tv_nsec = 10000000;	/* 10 milliseconds */
      

    /* reset the window list to contain only the closed child */
    xpl_windows = closed;
    xpl_windows->next = NULL;
    xpl_window  = xpl_windows;

    /* tell it to die on a button press */
    xpl_window->closed = 1;

    /* process events until that fatal button event */
    while (1) {
      nanosleep (&tm, NULL);
      xpl_update();
    }
    return 0;
  }
}

