/* Copyright (C) 1989 Free Software Foundation, Inc.

   plot is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY.  No author or distributor accepts responsibility to
   anyone for the consequences of using it or for whether it serves any
   particular purpose or works at all, unless he says so in writing.
   Refer to the GNU General Public License for full details.

   Everyone is granted permission to copy, modify and redistribute
   plot, but only under the conditions described in the GNU General
   Public License.  A copy of this license is supposed to have been
   given to you along with libtek so you can know your rights and
   responsibilities.  It should be in a file named COPYING.  Among
   other things, the copyright notice and this notice must be preserved
   on all copies.  */

/* This file is the circle routine, which is a standard part of the plot
   library. It draws a circle given the center x,y and the radius */

#include "plot.h"

extern short fill_control;

int circleX (int x_i, int y_i, int r_i)
{
  int x = x_scale (x_i);
  int y = y_scale (y_i);
  int r = x_scale (r_i) - x_scale (0);
  XDrawArc (xpl_window->dpy, xpl_window->win, xpl_window->gc, 
	    x - r, y - r, 2 * r, 2 * r, 0, 360*64 - 1);
  XDrawArc (xpl_window->dpy, xpl_window->pix, xpl_window->gc, 
	    x - r, y - r, 2 * r, 2 * r, 0, 360*64 - 1);
  xpl_update();
  return 0;
}
