/* Copyright (C) 1989 Free Software Foundation, Inc.

   plot is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY.  No author or distributor accepts responsibility to
   anyone for the consequences of using it or for whether it serves any
   particular purpose or works at all, unless he says so in writing.
   Refer to the GNU General Public License for full details.

   Everyone is granted permission to copy, modify and redistribute
   plot, but only under the conditions described in the GNU General
   Public License.  A copy of this license is supposed to have been
   given to you along with libtek so you can know your rights and
   responsibilities.  It should be in a file named COPYING.  Among
   other things, the copyright notice and this notice must be preserved
   on all copies.  */

/* This file is the arc routine, which is a standard part of the plot
   library.  It draws an arc with the center at xc,yc, the beginning at
   x0,y0 and the ending at x1,y1 */

#include "plot.h"
#include <math.h>

int
arcX (xc, yc, x0, y0, x1, y1)
     int xc, yc, x0, y0, x1, y1;
{
  int a0, b0, a1, b1;
  int a02, b02, a12, b12;
  double ar, br, ar2, br2;
  double theta0, theta1;

  moveX (xc, yc);
  xc = x_scale (xc);
  yc = y_scale (yc);
  x0 = x_scale (x0);
  y0 = y_scale (y0);
  x1 = x_scale (x1);
  y1 = y_scale (y1);

  a0 = x0 - xc;
  a02 = a0*a0;
  a1 = x1 - xc;
  a12 = a1*a1;
  b0 = y0 - yc;
  b02 = b0*b0;
  b1 = y1 - yc;
  b12 = b1*b1;
  if (b12 == b02) return 0;     /* punt rather than divide by zero.  */
  ar2 = (a02*b12 - a12*b02)/(b12 - b02);
  if (ar2 < 0) return 0;
  ar = sqrt (ar2);
  if (a12 == a02) return 0;
  br2 = (b02*a12 - b12*a02)/(a12 - a02);
  if (br2 < 0) return 0;
  br = sqrt (br2);
  if ((br==0)||(ar==0)) return 0;
  theta0 = -atan2 (b0/br, a0/ar);
  theta1 = -atan2 (b1/br, a1/ar);
  if (theta0 > theta1) theta1 += 2 * M_PI;
  if (theta0 < 0)
    {
      theta0 += 2 * M_PI;
      theta1 += 2 * M_PI;
    }
  XDrawArc (xpl_window->dpy, xpl_window->win, xpl_window->gc, 
	    (int) (xc - ar), (int) (yc - br), 
            (int)(2 * ar), (int) (2 * br), 
            (int) (64* theta0 * 180/M_PI), 
            (int) (64 * (theta1 - theta0) * 180/M_PI));
  XDrawArc (xpl_window->dpy, xpl_window->pix, xpl_window->gc, 
	    (int) (xc - ar), (int) (yc - br), 
            (int)(2 * ar), (int) (2 * br), 
            (int) (64* theta0 * 180/M_PI), 
            (int) (64 * (theta1 - theta0) * 180/M_PI));
  return 0;
}
