/* Copyright (C) 1989 Free Software Foundation, Inc.

   plot is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY.  No author or distributor accepts responsibility to
   anyone for the consequences of using it or for whether it serves any
   particular purpose or works at all, unless he says so in writing.
   Refer to the GNU General Public License for full details.

   Everyone is granted permission to copy, modify and redistribute
   plot, but only under the conditions described in the GNU General
   Public License.  A copy of this license is supposed to have been
   given to you along with libtek so you can know your rights and
   responsibilities.  It should be in a file named COPYING.  Among
   other things, the copyright notice and this notice must be preserved
   on all copies.  */

#include "plot.h"

/* ALABEL takes three arguments X_JUSTIFY, Y_JUSTIFY, and S and places
   the label S according to the x and y axis adjustments specified in
   X_JUSTIFY and Y_JUSTIFY respectively.  X_JUSTIFY is a character
   containing either l, c, or r for left, center or right justified with
   respect to the current x coordinate.  Y_JUSTIFY is a character
   containing either b, c, or t for placing the bottom center or top of
   the label even with the current y coordinate. S is a string containing
   the label. The current point is moved to follow the end of the text. */


/* current font struct */
extern XFontStruct *current_font_struct; /* from setfont.c */

int
alabelX(x_justify, y_justify, s)
     char x_justify, y_justify, *s;
{
  int alabel_width, alabel_height, alabel_decent;
  double x_char_offset, y_char_offset;

  int direction_return;
  int font_ascent_return, font_descent_return;
  XCharStruct overall_return;

  switch (x_justify) {		/* placement of label with respect
                                   to x coordinate */
  case 'l':			/* left justified */
    x_char_offset = 0.0;
    break;
  case 'c':			/* centered */
    x_char_offset = -0.5;
    break;
  case 'r':			/* right justified */
    x_char_offset = -1.0;
    break;
  }

  switch (y_justify) {		/* placement of label with respect
                                   to y coordinate */
  case 'b':                   /* bottom */
    y_char_offset = 0.0;
    break;
  case 'c':                   /* centered */
    y_char_offset = 0.5;
    break;
  case 't':                   /* top */
    y_char_offset = 1.0;
    break;
  }

  if (current_font_struct == NULL) {
    alabel_width = alabel_height = alabel_decent = 0;
  } else {
    alabel_width = XTextWidth (current_font_struct, s, strlen (s));
    XTextExtents (current_font_struct, s, strlen (s), &direction_return,
		  &font_ascent_return, &font_descent_return, &overall_return);
    alabel_height = font_ascent_return + font_descent_return;
    alabel_decent = font_descent_return;
  }
  
  /* `+ .5' encourages round off rather than truncate by (int) cast. */
  {
    int x, y;
    x = (int) (current_x + x_char_offset * alabel_width + .5);
    y = (int) (current_y + y_char_offset * alabel_height - alabel_decent + .5);
    XDrawString (xpl_window->dpy, xpl_window->win, xpl_window->gc, x, y, s, strlen (s));
    XDrawString (xpl_window->dpy, xpl_window->pix, xpl_window->gc, x, y, s, strlen (s));
  }
  xpl_update();
  return 0;
}


