#ifndef _multi_plot_h
#define _multi_plot_h

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Multiple Device Plot Library
 *
 * This is a plot(4) API compliant library that allows a single
 * program to switch between output devices.  It does so by use of a
 * single extension function device() (see below).
 */

#include "pl/plot.h"

/*
 * Output device control.  This is an extension to the plot() API.
 */

/* 
 * device (char *dev, ...)
 *
 * Choose the device to output to.  dev is one of the recognized
 * device strings.  Other arguments are device dependant.  
 *
 * RETURN VALUE:
 * -1: device string was not recognized or device failed to open correctly.  
 * 1:  device successfully opened (first access).
 * 0:  device successfully opened (later access).
 *
 * device() can be called numerous times during one program.  Each time a 
 * *new* device is opened openpl() must be called immediately after 
 * device() before any rendering.  If the device is then switched away and 
 * later returned to it will remember its state.
 */

int device (char *dev, ...);


/*
 * Plot library calls.
 */

/* The following defines are used within the code to access the appropriate
   rendering function.  They evaluate to the appropriate function pointer
   which has been set to point appropriately by device().  In the absence of 
   a call to device they point to the standard plot library functions.

   Some of these are extensions to the standard library.  These are marked.
 */

#define openpl 		(*openplP)
#define closepl		(*closeplP)
#define flushpl		(*flushplP) 		/* extension */
#define space		(*spaceP)        

#define erase		(*eraseP)

#define color		(*colorP)	 	/* extension */
#define bkgnd		(*bkgndP)		/* extension */
#define linemod		(*linemodP)		/* extension */
#define linewidth	(*linewidthP)		/* extension */
#define fill		(*fillP)		/* extension */
#define fontname	(*fontnameP)		/* extension */
#define fontsize	(*fontsizeP)		/* extension */
#define rotate		(*rotateP)		/* extension */

#define label		(*labelP)           
#define alabel		(*alabelP)	    	/* extension */
#define arc		(*arcP)           
#define box		(*boxP)             
#define circle		(*circleP)          
#define cont		(*contP)            
#define dot		(*dotP)             	/* extension */
#define point		(*pointP)		
#define line		(*lineP)            
#define move		(*moveP)            



extern int (*openplP)          (void);
extern int (*closeplP)         (void);
extern int (*flushplP)		(void);
extern int (*spaceP)           (int, int, int, int);
extern int (*colorP)           (int, int, int);
extern int (*bkgndP)           (int, int, int);
extern int (*linemodP)         (char *);
extern int (*linewidthP)       (int);
extern int (*fillP)            (int);
extern int (*fontnameP)        (char *);
extern int (*fontsizeP)        (int);
extern int (*rotateP)          (int, int, int);
extern int (*eraseP)           (void);
extern int (*labelP)           (char *);
extern int (*alabelP)          (int, int, char *);
extern int (*arcP)             (int, int, int, int, int, int);
extern int (*boxP)             (int, int, int, int);
extern int (*circleP)          (int, int, int);
extern int (*contP)            (int, float);
extern int (*dotP)             (int, int, int, int, char *);
extern int (*pointP)           (int, int);
extern int (*lineP)            (int, int, int, int);
extern int (*moveP)            (int, float);


#ifdef __cplusplus
}
#endif

#endif
/* !_multi_plot_h */
