/* plot2ps, a utility for converting Unix plot files into postscript.
   Copyright (C) 1989 Free Software Foundation, Inc.

Plot2ps is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY.  No author or distributor accepts responsibility to anyone for the
consequences of using it or for whether it serves any particular purpose or
works at all, unless he says so in writing.  Refer to the GNU General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute plot2ps, but
only under the conditions described in the GNU General Public License.  A copy
of this license is supposed to have been given to you along with plot2ps so
you can know your rights and responsibilities.  It should be in a file named
COPYING.  Among other things, the copyright notice and this notice must be
preserved on all copies.  */

/* This file is the space routine, which is a standard part of the plot
   library.  It sets the lower left and upper right corners of the page.  The
   plot will be scaled so that these coners fit the largest renderable area on
   the page.  */

#include "plot.h"

int landscape = 0;

int
spaceID (x0, y0, x1, y1)
     int x0, y0, x1, y1;
{
  double x_scale, y_scale;
#ifdef DEBUG
  fprintf (PSoutfile, "%% space: %d %d %d %d\n", x0, y0, x1, y1);
#endif
 
  /* if we are in landscape mode end that block */
  if (landscape) {
    fputs ("End %I eop\n", PSoutfile);
    landscape = 0;
  }

  /* if width is greater than length go to landscape mode */
  if ( (x1 - x0) > (y1 - y0) ) {
    fputs (" Begin %I Pict\n", PSoutfile);
    fputs (" %I b u\n %I cfg u\n %I cbg u\n %I f u\n %I p u\n %I t\n", 
	   PSoutfile);
    fprintf (PSoutfile, "[ 0 1 -1 0 %g 0] concat\n", x_pagesize);
    landscape = 1;
  }
  
  IDx_input_min = x0;
  IDy_input_min = y0;
  if (landscape) {
    x_scale = (x1-x0)/(y_pagesize - 2 * y_margin);
    y_scale = (y1-y0)/(x_pagesize - 2 * x_margin);
    if (x_scale > y_scale) {
      IDscaleup = x_scale;
      IDy_output_min = (x_pagesize - (y1-y0)/IDscaleup) / 2;
    } else {
      IDscaleup = y_scale;
      IDx_output_min = (y_pagesize - (x1-x0)/IDscaleup) / 2;
    }
  } else {
    x_scale = (x1-x0)/(x_pagesize - 2 * x_margin);
    y_scale = (y1-y0)/(y_pagesize - 2 * y_margin);
    if (x_scale > y_scale) {
      IDscaleup = x_scale;
      IDy_output_min = (y_pagesize - (y1-y0)/IDscaleup) / 2;
    } else {
      IDscaleup = y_scale;
      IDx_output_min = (x_pagesize - (x1-x0)/IDscaleup) / 2;
    }
  }
#ifdef DEBUG
  fprintf (PSoutfile, "%% scale: %g %g %g %g %g %g\n",
	  x_scale, y_scale, IDx_input_min, IDy_input_min,
	  IDx_output_min, IDy_output_min);
#endif
return 0;
}
