#ifndef _psplot_defines_
#define _psplot_defines_ 1

#include <stdarg.h>
#include <stdio.h>

int deviceID	     (va_list *args);

int openplID          (void);
int closeplID         (void);
int flushplID	      (void);
int spaceID           (int x0, int y0, int x1, int y1);
int colorID           (int red, int green, int blue);
int bkgndID           (int red, int green, int blue);
int linemodID         (char *s);
int linewidthID       (int);
int fillID            (int level);
int fontnameID        (char *s);
int fontsizeID        (int size);
int rotateID          (int w, int h, int angle);
int eraseID           (void);
int labelID           (char *s);
int alabelID          (int x_justify, int y_justify, char *s);
int arcID             (int xc, int yc, int x0, int y0, int x1, int y1);
int boxID             (int x0, int y0, int x1, int y1);
int circleID          (int x, int y, int r);
int contID            (int x, float y);
int dotID             (int x, int y, int dx, int n, char *pattern);
int pointID           (int x, int y);
int lineID            (int x0, int y0, int x1, int y1);
int moveID            (int x, float y);

/* Internal routines: */
int find_font	      (char *s);
int string_width      (char *s);
int draw_line	      (void);
void set_range	      (double x, double y);
void get_range	      (double *xmin, double *xmax, double *ymin, double *ymax);

/* Global variables which affect the output: */
extern double IDx_input_min; /* minimum input x coordinate */
extern double IDy_input_min; /* minimum input y coordinate */
extern double IDx_output_min; /* minimum output x coordinate */
extern double IDy_output_min; /* minimum output y coordinate */
extern double IDx_output_max; /* maximum output x coordinate */
extern double IDy_output_max; /* maximum output y coordinate */
extern double IDscaleup; /* input to output scaleing for both x and y */

extern int landscape;  /* 0 => drawing in portrait mode.
			  1 => drawing in landscape mode.
			  See space.c. */

extern int IDlast_x, IDLast_y; /* location of the last coordinates used */

/* Output file pointer. */
extern FILE *PSoutfile;

/* This is the default scaling in the postscript current transformation
   matrix (CTM) for the entire plot. This value is arbitrarily chosen
   for compatibility with idraw. See open.c. */
#define SCALING 0.8

/* The dimesions below determine the size of the page onto which the
   postscript from plot2ps will be drawn.  They are provided in scaled
   dots, such that they will be meaningful to the plot CTM.  See SCALING
   above. */
#define x_margin (0.85 * 72. / SCALING)
#define y_margin (1.1  * 72. / SCALING)
#define x_pagesize (8.5 * 72. / SCALING)
#define y_pagesize (11. * 72. / SCALING)


/* The scaling and rotation part of a postscript transformation matrix */
extern double text_transformation_matrix[4];

/* Note: define MAX_NO_OF_POINTS according to the number of
   points the postscript device can handle.  Experimentation has
   shown 150 to be reasonable. */

#define MAX_NO_OF_POINTS 250
extern int line_x[MAX_NO_OF_POINTS];
extern float line_y[MAX_NO_OF_POINTS];

/* We accumulate coordinates untill we either have enought points
   or the line is broken.  This counter tells us whether we have
   accumulated points and how many there are. */

extern int PointsInLine;

/* This bit vector represents the line style (eg. dashed) for
   idraw. We intitialize it to all ones which represents a solid
   line. */

extern long IDline_type_bit_vector;

/* This is a string that should conatain a postscript vector
   argument for the postscript setdash command.  This is allocted
   in the OPENPL function. */

extern char *line_type_setdash;

/* The current length of the above buffer */

extern int line_type_setdash_length;

/* LINE_TYPE_SETDASH_BITS is one greater than the length in number of bits in
   the dash pattern.  It can be computed as the sum of the integers contained
   in LINE_TYPE_SETDASH plus one.  If the string is empty, then the value should
   be zero. */

extern int IDline_type_setdash_bits;

/* Idraw puts the upper left corner of the tex at the current */

/* TEXT_ROTATION is the angle in degress counterclockwise from the
   horizontal for rotation of labels. */

extern int IDtext_rotation;

/* FONT_SIZE is the font size in printer's points (-f option). */

extern double IDfont_size;

/* FONT_SCALING takes into account the font scaling by idraw.  Version 2.4
   of idraw scales the whole drawing down by a factor of SCALING, we must
   scale the fonts back up by 1.25 so that a 14 point fonts appears as
   a 14 point font on the hardcopy. Version 2.5 of idraw does not seem
   to need this adjustment, but it is left here for compatibility. */

extern double font_scaling;

/* USER_HAS_PROLOGUE is a flag. If it is non-zero then the OPENPL routine
   should output the user specified prologue contained in the file specified
   in the string USERS_PROLOGUE */

extern int user_has_prologue;

/* USERS_PROLOGUE is a string containing the file name for any user specified
   postscript prologue.  This file is a substitute for the prologue contained
   in the file header.c. */

extern char *users_prologue;


struct font_info_struct {
  char *name;			/* the name the user specifies the font by */
  char *X_name;			/* the X windows font name */
  char *ps_name;		/* the postscript font name */
  int width[256];		/* the font width information */
};

#define NO_OF_FONTS 13

extern struct font_info_struct font_info[NO_OF_FONTS];


/* CURRENT_FONT is a string containing the name of the current font. */

extern char* IDcurrent_font;

/* DEFAULT_FONT is a string containing the name of the default font.
   This string should be a valid match for one of the font names. */

extern char* default_font;

/* FIND_FONT takes a string argument S containing a font name and returns the
   index of the font structure FONT_INFO corresponding to that name. If no match
   is found for the font name, an error message is printed and the index of the
   default font is returned. */

/* declared above: extern int find_font(); */


/* FGCOLOR_RED, FGCOLOR_GREEN and FGCOLOR_BLUE indicate the foreground
   color of all plot. For each the range of intensity is from 0 to 1 so
   that a value of (0,0,0) represents black and a value of (1,1,1)
   indicates white. */

extern double fgcolor_red, fgcolor_green, fgcolor_blue;

/* FILL_LEVEL is the intensity of the filler for closed paths.  Intensity
   ranges from 0 to 1. A value of 0 represents black and a value of 1 indicates
   white. */

extern double fill_level;


/* LINE_WIDTH is the interger value of width of lines drawn. */

extern int line_width;


#endif /* _libplot_defines_ */
