/* plot2ps, a utility for converting Unix plot files into postscript.
   Copyright (C) 1989 Free Software Foundation, Inc.

Plot2ps is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY.  No author or distributor accepts responsibility to anyone for the
consequences of using it or for whether it serves any particular purpose or
works at all, unless he says so in writing.  Refer to the GNU General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute plot2ps, but
only under the conditions described in the GNU General Public License.  A copy
of this license is supposed to have been given to you along with plot2ps so
you can know your rights and responsibilities.  It should be in a file named
COPYING.  Among other things, the copyright notice and this notice must be
preserved on all copies.  */

/* This file is the draw_line routine, which is used by the other plot library
   routines. Coordinates are accumulated in the arrays line_x and line_y.
   The number of points accumulated is stored in PointsInLine. When draw_line
   is called it outputs any accumulated points.  PointsInLine is set to one
   with the first point replaced by the last point of the previous line - so
   that the next line can be a continuation of the previous one. */

#include "plot.h"


/* plot (3) routines ___________________________________________ */

double IDx_input_min = 0.; /* minimum input x coordinate */
double IDy_input_min = 0.; /* minimum input y coordinate */

double IDx_output_min = x_margin; /* minimum output x coordinate */
double IDy_output_min = y_margin; /* minimum output y coordinate */
double IDx_output_max = x_pagesize - x_margin; /* maximum output x coordinate */
double IDy_output_max = y_pagesize - y_margin; /* maximum output y coordinate */

double IDscaleup = 10.; /* input to output scaling for both x and y */

int IDlast_x=0, IDLast_y = 0; /* location of the last coordinates used */

/* the scaling and rotation part of a postscript transformation matrix */
double text_transformation_matrix[4] =
{
  1., 0., 0., 1.
};

/* Note: define MAX_NO_OF_POINTS according to the number of
   points the postscript device can handle.  Experimentation has
   shown 150 to be reasonable */

#define MAX_NO_OF_POINTS 250
int line_x[MAX_NO_OF_POINTS];
float line_y[MAX_NO_OF_POINTS];

/* We accumulate coordinates untill we either have enought points
   or the line is broken.  The counter tells us whether we have
   accumulated points and how many */

int PointsInLine=0;

/* this bit vector represents the line style (eg. dashed) for
   idraw.  We intitialize it to all ones which represents a solid
   line. */
long IDline_type_bit_vector = 65535;

/* this is a string that should conatain a postscript vector
   argument for the postscript setdash command.  This is allocted
   in the open(3) function. */
char *line_type_setdash;

/* the current length of the above buffer */
int line_type_setdash_length;

/* one greater than the length in number of bits in the dash pattern.  */

int IDline_type_setdash_bits=0;

/* LINE_WIDTH is the interger value of width of lines drawn. */

int line_width = 0;


/* draw a line using all the accumulated points if there are any. */

int
draw_line ()
{
  if (PointsInLine > 1 )
    {
      int i;
      fputs ("Begin %I MLine\n", PSoutfile);
      fprintf (PSoutfile, "%%I b %d\n", IDline_type_bit_vector);
      fprintf (PSoutfile, "%d 0 0 [ %s ] %d SetB\n", line_width, 
	       line_type_setdash, IDline_type_setdash_bits);
      fprintf (PSoutfile, "%%I cfg Black\n%g %g %g SetCFg\n",
	      fgcolor_red, fgcolor_green, fgcolor_blue);
      fputs ("%I cbg White\n1 1 1 SetCBg\n", PSoutfile);
      if (fill_level == -1.)
	{
	  fprintf (PSoutfile, "%%I p\nnone SetP\n");
	}
      else
	{
	  fprintf (PSoutfile, "%%I p\n%g SetP\n", fill_level);
	}
      fprintf (PSoutfile, "%%I t\n[ %g 0 0 %g %g %g ] concat\n", 
	       1./IDscaleup, 1./IDscaleup, IDx_output_min, IDy_output_min);
      fprintf (PSoutfile, "%%I %d\n", PointsInLine);
      for (i=0; i<PointsInLine; i++)
	{
	  fprintf (PSoutfile, "%d %.3f\n", line_x[i], line_y[i]);
	  set_range ((line_x[i]+IDx_output_min)/IDscaleup, 
		     (line_y[i]+IDy_output_min)/IDscaleup);
	}
      fprintf (PSoutfile, "%d MLine\nEnd\n\n", PointsInLine);

      /* leave the last point as the first point of the next line */
      line_x[0] = line_x [PointsInLine - 1];
      line_y[0] = line_y [PointsInLine - 1];
      PointsInLine = 1;
    }
  return 0;
}
