/* plot2ps, a utility for converting Unix plot files into postscript.
   Copyright (C) 1989 Free Software Foundation, Inc.

Plot2ps is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY.  No author or distributor accepts responsibility to anyone for the
consequences of using it or for whether it serves any particular purpose or
works at all, unless he says so in writing.  Refer to the GNU General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute plot2ps, but
only under the conditions described in the GNU General Public License.  A copy
of this license is supposed to have been given to you along with plot2ps so
you can know your rights and responsibilities.  It should be in a file named
COPYING.  Among other things, the copyright notice and this notice must be
preserved on all copies.  */

/* This file is the cont routine, which is a standard part of the plot
   library. It continues a line from the last point drawn to the point specified
   by x and y. */

#include "plot.h"

int
contID (x, y)
     int x; float y;
{
#ifdef DEBUG
  fprintf (PSoutfile, "%% cont:%d %.3f\n", x, y);
#endif

  /* The x_ and y_ output min translation is achieved by the writing
     of the translation matrix in drawline().  To do it here doubles
     the effect. 
 
     m.
 */

  IDlast_x = (x - IDx_input_min); /*  + IDx_output_min;  */
  IDLast_y = (y - IDy_input_min); /*  + IDy_output_min;  */
  /* Allow the first point in the list to be duplicate.  This allows
     point() to work. 
     m.
   */
  if (PointsInLine > 1
      && (line_x[ PointsInLine-1] == IDlast_x)
      && (line_y[ PointsInLine-1] == IDLast_y))
    return 0;			/* slip redundant points */
  line_x[ PointsInLine] = IDlast_x;
  line_y[ PointsInLine] = IDLast_y;
  PointsInLine++;
  if (PointsInLine == MAX_NO_OF_POINTS)
    draw_line ();
  return 0;
}
