/* plot2ps, a utility for converting Unix plot files into postscript.
   Copyright (C) 1989 Free Software Foundation, Inc.

Plot2ps is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY.  No author or distributor accepts responsibility to anyone for the
consequences of using it or for whether it serves any particular purpose or
works at all, unless he says so in writing.  Refer to the GNU General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute plot2ps, but
only under the conditions described in the GNU General Public License.  A copy
of this license is supposed to have been given to you along with plot2ps so
you can know your rights and responsibilities.  It should be in a file named
COPYING.  Among other things, the copyright notice and this notice must be
preserved on all copies.  */

/* This file is the color routine, which is an extension to the plot
   library. It changes the color of the following drawing operations. */

#include "plot.h"

/* FGCOLOR_RED, FGCOLOR_GREEN and FGCOLOR_BLUE indicate the foreground
   color of all plot. For each the range of intensity is from 0 to 1 so
   that a value of (0,0,0) represents black and a value of (1,1,1)
   indicates white. */

double fgcolor_red=0., fgcolor_green=0., fgcolor_blue=0.;

int
colorID ( red, green, blue)
     int red, green, blue;
{
  /* we need to flush the drawline() buffer, else this change in color will 
     affect lines already drawn */
  draw_line();
  fgcolor_red = (double) red / 0xffff;
  fgcolor_green = (double) green / 0xffff;
  fgcolor_blue = (double) blue / 0xffff;
  return 0;
}


int
bkgndID (int r, int g, int b)
{
  return 0;
}
