/* plot2ps, a utility for converting Unix plot files into postscript.
   Copyright (C) 1989 Free Software Foundation, Inc.

Plot2ps is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY.  No author or distributor accepts responsibility to anyone for the
consequences of using it or for whether it serves any particular purpose or
works at all, unless he says so in writing.  Refer to the GNU General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute plot2ps, but
only under the conditions described in the GNU General Public License.  A copy
of this license is supposed to have been given to you along with plot2ps so
you can know your rights and responsibilities.  It should be in a file named
COPYING.  Among other things, the copyright notice and this notice must be
preserved on all copies.  */

/* This file is the circle routine, which is a standard part of the plot
   library. It draws a circle given the center x,y and the radius */

#include "plot.h"

int
circleID (x, y, r)
     int x, y, r;
{
  int radius;
  draw_line ();
  fputs ("Begin %I Elli\n", PSoutfile);
  fprintf (PSoutfile, "%%I b %d\n", IDline_type_bit_vector);
  fprintf (PSoutfile, "%d 0 0 [ %s ] %d SetB\n", line_width, line_type_setdash,
	  IDline_type_setdash_bits);
  fprintf (PSoutfile, "%%I cfg Black\n%g %g %g SetCFg\n",
	  fgcolor_red, fgcolor_green, fgcolor_blue);
  fputs ("%I cbg White\n1 1 1 SetCBg\n", PSoutfile);
  if (fill_level == -1.)
    {
      fprintf (PSoutfile, "%%I p\nnone SetP\n");
    }
  else
    {
      fprintf (PSoutfile, "%%I p\n%g SetP\n", fill_level);
    }
  fprintf (PSoutfile, "%%I t\n[ %g 0 0 %g %g %g ] concat\n", 
	   1./IDscaleup, 1./IDscaleup, IDx_output_min, IDy_output_min);
  /* The x_ and IDy_output_min translation is achieved by the writing
     of the translation matrix above.  To do it below would double
     the effect. 
 
     m.
 */
  IDlast_x = (x - IDx_input_min) /* + IDx_output_min */;
  IDLast_y = (y - IDy_input_min) /* + IDy_output_min */;
  radius = r;
  fprintf (PSoutfile, "%%I\n%d %d %d %d Elli\nEnd\n\n", 
	   IDlast_x, IDLast_y, radius, radius);
#ifdef DEBUG
  fprintf (PSoutfile, "%% circle: %d %d %d\n", x, y, r);
#endif
  return 0;
}
