/* FILE yuqingmac.c	*/
     /* Read a string of units in; normalize each to a single trial and
        then add to a main register */

#include "../defs.h"
#include "../array.h"       		/* Access registers directly	*/
#include "../_imports/deffs.h"
#include "../_imports/event.h"       	/* Stack instruction definitions*/
#include <stdlib.h>

#include "../sac.h"

#define EIGHT_DEGREE		0	/* [0 or 1]  8 deg or 4 deg?	*/
#define IN_ORDER		1	/* [1] Sort vs hard-wired regs?	*/

static int  FILTER		= 12;	/* (2) 0:no 2:9 4:25 12:46 Hz	*/
static int  DO_EYE_TRACES	= 1;	/* Filter, etc:  very slow	*/
static int  RECTIFY_ANALOG	= 0;	/* Show up systematic changes	*/
			/* i.e., drift that occurs before the 'go' cue	*/
static int  NORMALIZE		= 0;	/* Each unit gets equal weight	*/
static int  OFFSET		= 0;	/* Each unit starts at 0	*/

#define	ALIGN_ON_TARGET		1	/* Not actually used!		*/
#define	ALIGN_ON_SACCADE	0	/* On initial sac or reach	*/
#define	ALIGN_ON_REACH		0	/* On initial sac or reach	*/

#define PRINT_REGISTER_NAMES	0	/* Print it on screen		*/
#define WRITE_TO_DISK   	0

#define PLOT_AVERAGED_CELLS	0	/* As you go...			*/
#define PLOT_INDIVIDUALS	0

#define STACKS_TO_SORT		3
#define CLASSES_TO_SORT		16
#define TO_SORT			STACKS_TO_SORT * CLASSES_TO_SORT

#define	ALIGNMENT_TIME		2000

#define DELETE_MARGIN		0	/* For diverge_macro() only	*/

void yuqing_sort_macro();
static void Initialize_Stuff(void);
static void Write_to_Disk(void);
static void Tag_Registers(void);
static void Normalize_Registers(void);
static void Offset_Registers(void);
static void Avg_Registers(void);
static void Avg_Registers_for_units(void);
static void Clean_Registers();
static int  Find_TrialType(void);
static int  Find_Register(int stack, int class);

/* ******************************************************************** */

/* FUNCTION yuqing_sort_macro() */
	 /* Sort shifted trials */
void yuqing_sort_macro() {
   extern int DiffChannel;			/* diff.c		*/
			/* Odd: fails if use "extern int DiffChannel"	*/

if (MAX_REGISTERS <= 2*TO_SORT + 2) {
   fprintf(stderr, "MAX_REG is only %d; need %d\n", MAX_REGISTERS, 2*TO_SORT+3);
   fatal("Increase MAX_REGISTERS TO_SORT");
   }

Initialize_Stuff();

do {						/* Next trial or header	*/
     int TargetTime = StackExtract(TARGET_SAC_POLAR,1, TIME);

     if (Register[0].stacknumber == 105)	/* Identical stacks	*/
         Register[0].stacknumber = 104;
     if (Register[0].stacknumber == 107)	/* Identical stacks	*/
         Register[0].stacknumber = 106;
     if (Register[0].stacknumber == 95)		/* Identical stacks	*/
         Register[0].stacknumber = 94;
     if (Register[0].stacknumber == 97)		/* Identical stacks	*/
         Register[0].stacknumber = 96;
     if (Register[0].stacknumber == 85)		/* Identical stacks	*/
         Register[0].stacknumber = 84;
     if (Register[0].stacknumber == 87)		/* Identical stacks	*/
         Register[0].stacknumber = 86;

     switch (Register[0].stacknumber) {
	 case 104+2*EIGHT_DEGREE: /* [104],[106] 4,8 deg perturbed trials	*/
	 case 94+2*EIGHT_DEGREE:  /* [94],[96] 4,8 deg perturbed trials	*/
	 case 84+2*EIGHT_DEGREE:  /* [84],[86] 4,8 deg perturbed trials	*/
	 case 83-EIGHT_DEGREE:			/* Control trials	*/
	 case 81:
		 break;
	 default:
	         continue;
	 }


     if (DO_EYE_TRACES) {
	extern int UseFilter;
	int SaveFilter = UseFilter;

	UseFilter = 12;			/* Less than units (faster)	*/

        Set_CurrentChannel(OD_H);
        if (FILTER)
           Filter(0);
        DiffChannel = H_VEL;
        Differentiate(0);

        Set_CurrentChannel(OD_V);
        if (FILTER)
           Filter(0);
        DiffChannel = V_VEL;
        Differentiate(0);

	UseFilter = SaveFilter;

        if (RECTIFY_ANALOG) {
           Set_CurrentChannel(OD_H);
           ChannelDataTransfer(0, X3);	/* Copy to extra channel X3	*/
           Set_CurrentChannel(X3);
           OffsetData(0, 
               AvgSomeData(0, TargetTime-400, TargetTime));
           RectifyData(0);

           Set_CurrentChannel(OD_V);
           ChannelDataTransfer(0, X4);	/* Copy to extra channel X4	*/
           Set_CurrentChannel(X4);
           OffsetData(0, 
               AvgSomeData(0, TargetTime-400, TargetTime));
           RectifyData(0);

           Set_CurrentChannel(ARM_H);
           ChannelDataTransfer(0, X5);/* Copy to extra channel X5	*/
           Set_CurrentChannel(X5);
           OffsetData(0, 
               AvgSomeData(0, TargetTime-400, TargetTime));
           RectifyData(0);

           Set_CurrentChannel(ARM_V);
           ChannelDataTransfer(0, X6);/* Copy to extra channel X6	*/
           Set_CurrentChannel(X6);
           OffsetData(0, 
               AvgSomeData(0, TargetTime-400, TargetTime));
           RectifyData(0);
	   }
     }

     Set_CurrentChannel(UNIT);		/* Filter indis: SE is smooth	*/
     if (FILTER)
        Filter(0);

     if (ALIGN_ON_REACH) {		/* Saccade or arm movement	*/
	int Move;
	extern int NoArmMovesBeforeThis;

	NoArmMovesBeforeThis = TargetTime;
	Move = FindArmMove(0);

	 if (Move == FAIL) {
	    fprintf(stderr, "Could not find reach; skipping trial!\n");
	    continue;
	    }
	 ShiftReg(0, ALIGNMENT_TIME - Move);

       } else if (ALIGN_ON_SACCADE) {	/* Saccade or arm movement	*/
#	 define IGNORE_IT	320000
	 int Move;
	 extern int NoSacsBeforeThis;
	 /* extern int NoSacsAfterThis; */
	 int HorizMove=IGNORE_IT, VertMove=IGNORE_IT;
	 float HorizSize=0., VertSize=0.;

	 NoSacsBeforeThis = TargetTime;

     	 Set_CurrentChannel(OD_H);		/* Look in both chans	*/
	 if (FindSaccade(0) != FAIL) {
	      HorizMove = SaccadeData.begin;
   	      HorizSize = fabs(
	      	   AvgSomeData(0, SaccadeData.end, SaccadeData.end+30)-
   		   AvgSomeData(0, SaccadeData.begin-30, SaccadeData.begin));
	      }
     	 Set_CurrentChannel(OD_V);
	 if (FindSaccade(0) != FAIL) {
	      VertMove = SaccadeData.begin;
   	      VertSize = fabs(
	          AvgSomeData(0, SaccadeData.end, SaccadeData.end+30)-
   		  AvgSomeData(0, SaccadeData.begin-30, SaccadeData.begin));
	      }

	 if ((VertMove != FAIL && HorizMove != FAIL) &&
	       abs(HorizMove - VertMove) > 100) {  /* Two diff sacs?	*/
	      if (HorizSize > 3 * VertSize)	   /* Vert too small	*/
	          VertMove = IGNORE_IT;		   /* Disregard it	*/
	      if (VertSize > 3 * HorizSize) 	   /* Horiz too small	*/
	          HorizMove = IGNORE_IT;
	      }				/* Now take the earlier:	*/
	 Move = (HorizMove < VertMove) ? HorizMove : VertMove;
	 if (Move == IGNORE_IT)	/* Didn't find any?		*/
	       Move = FAIL;

	 if (Move == FAIL) {
	    fprintf(stderr, "Could not find saccade; skipping trial!\n");
	    continue;
	    }
	 ShiftReg(0, ALIGNMENT_TIME - Move);
      } else {			/* Put last target at ALIGNMENT_TIME ms	*/
        ShiftReg(0, ALIGNMENT_TIME-TargetTime);
         }

     /* FOR GETTING OUTPUT DURING RUNNING OF MACRO: */
     if (PLOT_INDIVIDUALS) {
        ChangeParameter('h', "30");
        ChangeParameter('w', "750");
        ChangeParameter('s', "2000");	/* ALIGNMENT_TIME	*/
        ChangeParameter('o', "30");
	ChangeParameter('b', "2");
	if (Register[0].classnumber==2 || Register[0].classnumber==10) {
          ChangeParameter('t', "h");
	  switch (Register[0].stacknumber) {
	     case 81:  
          	ChangeParameter('c', "B");
	  	break;
	     case 83:
          	ChangeParameter('c', "R");
	  	break;
	     default:  goto SKIP;
	     }
	  GraphData(0);
	  SKIP:;
	  }
        }

     AvgReg(0, Find_TrialType());		/* Determine type	*/

} while (Read_trial() != FAIL);			/* Next header		*/

Tag_Registers();
if (NORMALIZE)
   Normalize_Registers();
if (OFFSET)
   Offset_Registers();
Avg_Registers();

/* FOR GETTING OUTPUT DURING RUNNING OF MACRO: */
if (PLOT_AVERAGED_CELLS) {
        ChangeParameter('h', "30");
        ChangeParameter('w', "750");
        ChangeParameter('s', "2000");	/* ALIGNMENT_TIME	*/
        ChangeParameter('o', "30");
	ChangeParameter('b', "2");

        ChangeParameter('t', "h");

        ChangeParameter('c', "B");
        GraphData(Find_Register(81,2));
        ChangeParameter('c', "R");
        GraphData(Find_Register(83,2));
        GraphData(Find_Register(83,10));
        }

Clean_Registers();

if (WRITE_TO_DISK)
    Write_to_Disk();
}
/* ******************************************************************** */

/* FUNCTION Initialize_Stuff */
         /* Init */
static void Initialize_Stuff(void) {
   extern  int StepMs;				/* Differentiation stuff*/
   extern  int UseFilter;

   StepMs = 30;					/* Set up differentiator*/
   UseFilter = FILTER;
   }
/* ******************************************************************** */
/* ******************************************************************** */
/* ******************************************************************** */

/* FUNCTION Write_to_Disk */
	 /* Write to disk */
static void Write_to_Disk(void) {
   int i;

   for (i=TO_SORT+1; i<=TO_SORT*2; i++)
      if (ContentReg(i) > 0)
         RawFile(i);				/* Disk copies	*/
   }
/* ******************************************************************** */

/* FUNCTION Normalize_Registers */
	 /* Make'm look like 1 trial */
static void Normalize_Registers(void) {
	int i;
        for (i=1; i<=TO_SORT; i++)
	    NormalizeReg(i);
	}
/* ******************************************************************** */

/* FUNCTION Offset_Registers */
	 /* Offset so activity at 0 to 200 ms before align is at zero */
static void Offset_Registers(void) {
	int i;
        for (i=1; i<=TO_SORT; i++)
          if (Register[i].trial_count)			/* Not empty?	*/
	    OffsetData(i, AvgSomeData(i, ALIGNMENT_TIME-200, ALIGNMENT_TIME));
	}
/* ******************************************************************** */

#if IN_ORDER
/* FUNCTION mAx */
static int mAx(int *a, int *b) { return(*a>*b); }
#endif
/* ******************************************************************** */

/* FUNCTION Avg_Registers */
static void Avg_Registers(void) {
   int class[CLASSES_TO_SORT];
   int stack[STACKS_TO_SORT];
   int MaxClasses = 0;
   int MaxStacks = 0;
   int i,j;
#if IN_ORDER
   int FixFlag = 0;
#endif

   for (i=1; i<=TO_SORT; i++) {			/* For each trial type	*/
      if (Register[i].frame_count==0)		/* Unused register?	*/
         continue;				/* Skip it		*/

      for (j=0; j<MaxClasses; j++)		/* Look thru classes	*/
         if (class[j] == Register[i].classnumber)  /* Found this one?	*/
	    break;
      if (j==MaxClasses && Register[i].classnumber!=0)	/* Found new one*/
         class[MaxClasses++] = Register[i].classnumber;	/* Store as next*/

      for (j=0; j<MaxStacks; j++)		/* Look thru stacks	*/
         if (stack[j] == Register[i].stacknumber)  /* Found this one?	*/
	    break;
      if (j==MaxStacks && Register[i].stacknumber!=0)	/* Found new one*/
         stack[MaxStacks++] = Register[i].stacknumber;	/* Store as next*/
      }

   if (MaxClasses * MaxStacks > TO_SORT) {
      fprintf(stderr, "%d classes, %d stacks\n", MaxClasses, MaxStacks);
      fatal("TO_SORT is too small!");
      }

#if IN_ORDER
   if (MaxClasses < 16) {		/* A cheat for missing classes	*/
      fprintf(stderr, "Forcing max classes to 16\n");
      if (MaxClasses != 14)
         fprintf(stderr, "Stop!  Do not use! (%d classes)\n", MaxClasses);
      FixFlag = 1;
      }

   qsort(class, MaxClasses, sizeof(int), (void *) mAx);
   qsort(stack, MaxStacks, sizeof(int), (void *) mAx);

   for (i=0; i<MaxStacks; i++)
      for (j=0; j<MaxClasses; j++) {
         AvgReg(Find_Register(stack[i], class[j]),
	 	TO_SORT + i*MaxClasses + j+1);
	 }

   if (FixFlag) {	/* Horrible hack for missing class 4 (&12) */
      for (i=90; i>86; i--)
         CopyReg(i, i+6);
      for (i=86; i>79; i--)
         CopyReg(i, i+5);
      for (i=79; i>72; i--)
         CopyReg(i, i+4);
      for (i=72; i>65; i--)
         CopyReg(i, i+3);
      for (i=65; i>62; i--)
         CopyReg(i, i+2);
      for (i=55; i>51; i--)
         CopyReg(i, i+1);
      RemoveReg(84);
      RemoveReg(76);
      RemoveReg(68);
      RemoveReg(63);
      RemoveReg(64);
      RemoveReg(52);
      }
#else
   if (MaxStacks > 3 || MaxClasses > 16) {
      fprintf(stderr, "%d classes, %d stacks\n", MaxClasses, MaxStacks);
      fatal("Need <= 3 stacks and <= 16 classes!");
      }

   for (i=0; i<MaxStacks; i++)
      for (j=0; j<MaxClasses; j++) {
         AvgReg(Find_Register(stack[i], class[j]),
	 	TO_SORT + i*3 + class[j]+1);
	 }

#endif
   }
/* ******************************************************************** */

/* FUNCTION Clean_Registers */
static void Clean_Registers() {
	int i;

	for (i=0; i<=TO_SORT; i++)
	    RemoveReg(i);
	}
/* ******************************************************************** */

/* FUNCTION Tag_Registers */
static void Tag_Registers(void) {
   	char newname[80];
	int i;

	for (i=0; i<MAX_REGISTERS; i++)
	     if (Register[i].trial_count > 0) {
	        sprintf(newname, "%d.%d %s",
		   Register[i].stacknumber,
		   Register[i].classnumber,
		   Register[i].stackname);
	        MacroTagReg(i, newname);
	        if (PRINT_REGISTER_NAMES)
	           fprintf(stderr, "  %d: %d.%d %s\n", i,
		      Register[i].stacknumber,
		      Register[i].classnumber,
		      Register[i].stackname);
	        }
	}
/* ******************************************************************** */

/* FUNCTION Find_Register */
	 /* Find register with given stack, class */
static int Find_Register(int stack, int class) {
	int i;

	for (i=1; i<=TO_SORT; i++)
            if (stack == Register[i].stacknumber
	    				&& class==Register[i].classnumber)
	       return(i);
	return(99);			/* Not found or out of room	*/
	}
/* ******************************************************************** */

/* FUNCTION Find_TrialType */
	 /* Return index of this trial in Class[]	*/
static int  Find_TrialType(void) {
    int i;
    int stack = Register[0].stacknumber;
    int class = Register[0].classnumber;

    for (i=1; i<=TO_SORT; i++) {
       if (Register[i].trial_count <= 0)		/* Empty?	*/
	  return(i);					/*  Use it	*/
        else						/* Else: match?	*/
        if (stack == Register[i].stacknumber && class==Register[i].classnumber)
	  return(i); 
       }
    return(99);
    }
/* ********************************************************************	*/
/* ********************************************************************	*/
/* ********************************************************************	*/

/* FUNCTION yuqing_sort_unit_macro() */
	 /* Sort shifted trials */
void yuqing_sort_unit_macro() {
   extern int DiffChannel;			/* diff.c		*/
			/* Odd: fails if use "extern int DiffChannel"	*/

if (MAX_REGISTERS <= 2*TO_SORT + 2) {
   fprintf(stderr, "MAX_REG is only %d; need %d\n", MAX_REGISTERS, 2*TO_SORT+3);
   fatal("Increase MAX_REGISTERS TO_SORT");
   }

Initialize_Stuff();

do {						/* Next trial or header	*/
     int TargetTime = StackExtract(TARGET_SAC_POLAR,1, TIME);

     switch (Register[0].stacknumber) {
	 case 83:				/* Control trials	*/
	 case 89:				/* Perturbed trials	*/
		 break;
	 default:
	         continue;
	 }

     if (Register[0].stacknumber == 89) {	/* Multiple shifts?	*/
        int occur = 0;
	
	while (1) {
	   int delay_actual = StackExtract(DELAY, ++occur, TWO);
	   int delay_step = StackExtract(DELAY, occur, THREE);
		
	   if (delay_actual == FAIL)	/* 1 shift OR more than 2 shifts*/
              break;			/* Leave in 89	*/
	   
	   if (delay_actual == 0)
              break;			/* Smallest shift; leave in 89	*/

	   if (delay_actual == delay_step) {  /* Longest shift; to 90	*/
	      ++Register[0].stacknumber;
	      break;
	      }
	   }
        }


     if (DO_EYE_TRACES) {
	extern int UseFilter;
	int SaveFilter = UseFilter;

	UseFilter = 12;			/* Less than units (faster)	*/

        Set_CurrentChannel(OD_H);
        if (FILTER)
           Filter(0);
        DiffChannel = H_VEL;
        Differentiate(0);

        Set_CurrentChannel(OD_V);
        if (FILTER)
           Filter(0);
        DiffChannel = V_VEL;
        Differentiate(0);

	UseFilter = SaveFilter;

        if (RECTIFY_ANALOG) {
           Set_CurrentChannel(OD_H);
           ChannelDataTransfer(0, X3);	/* Copy to extra channel X3	*/
           Set_CurrentChannel(X3);
           OffsetData(0, 
               AvgSomeData(0, TargetTime-400, TargetTime));
           RectifyData(0);

           Set_CurrentChannel(OD_V);
           ChannelDataTransfer(0, X4);	/* Copy to extra channel X4	*/
           Set_CurrentChannel(X4);
           OffsetData(0, 
               AvgSomeData(0, TargetTime-400, TargetTime));
           RectifyData(0);

           Set_CurrentChannel(ARM_H);
           ChannelDataTransfer(0, X5);/* Copy to extra channel X5	*/
           Set_CurrentChannel(X5);
           OffsetData(0, 
               AvgSomeData(0, TargetTime-400, TargetTime));
           RectifyData(0);

           Set_CurrentChannel(ARM_V);
           ChannelDataTransfer(0, X6);/* Copy to extra channel X6	*/
           Set_CurrentChannel(X6);
           OffsetData(0, 
               AvgSomeData(0, TargetTime-400, TargetTime));
           RectifyData(0);
	   }
     }

     Set_CurrentChannel(UNIT);		/* Filter indis: SE is smooth	*/
     if (FILTER)
        Filter(0);

     if (ALIGN_ON_REACH) {		/* Saccade or arm movement	*/
	int Move;
	extern int NoArmMovesBeforeThis;

	NoArmMovesBeforeThis = TargetTime;
	Move = FindArmMove(0);

	 if (Move == FAIL) {
	    fprintf(stderr, "Could not find reach; skipping trial!\n");
	    continue;
	    }
	 ShiftReg(0, ALIGNMENT_TIME - Move);

       } else if (ALIGN_ON_SACCADE) {	/* Saccade or arm movement	*/
#	 define IGNORE_IT	320000
	 int Move;
	 extern int NoSacsBeforeThis;
	 /* extern int NoSacsAfterThis; */
	 int HorizMove=IGNORE_IT, VertMove=IGNORE_IT;
	 float HorizSize=0., VertSize=0.;

	 NoSacsBeforeThis = TargetTime;

     	 Set_CurrentChannel(OD_H);		/* Look in both chans	*/
	 if (FindSaccade(0) != FAIL) {
	      HorizMove = SaccadeData.begin;
   	      HorizSize = fabs(
	      	   AvgSomeData(0, SaccadeData.end, SaccadeData.end+30)-
   		   AvgSomeData(0, SaccadeData.begin-30, SaccadeData.begin));
	      }
     	 Set_CurrentChannel(OD_V);
	 if (FindSaccade(0) != FAIL) {
	      VertMove = SaccadeData.begin;
   	      VertSize = fabs(
	          AvgSomeData(0, SaccadeData.end, SaccadeData.end+30)-
   		  AvgSomeData(0, SaccadeData.begin-30, SaccadeData.begin));
	      }

	 if ((VertMove != FAIL && HorizMove != FAIL) &&
	       abs(HorizMove - VertMove) > 100) {  /* Two diff sacs?	*/
	      if (HorizSize > 3 * VertSize)	   /* Vert too small	*/
	          VertMove = IGNORE_IT;		   /* Disregard it	*/
	      if (VertSize > 3 * HorizSize) 	   /* Horiz too small	*/
	          HorizMove = IGNORE_IT;
	      }				/* Now take the earlier:	*/
	 Move = (HorizMove < VertMove) ? HorizMove : VertMove;
	 if (Move == IGNORE_IT)	/* Didn't find any?		*/
	       Move = FAIL;

	 if (Move == FAIL) {
	    fprintf(stderr, "Could not find saccade; skipping trial!\n");
	    continue;
	    }
	 ShiftReg(0, ALIGNMENT_TIME - Move);
      } else {			/* Put last target at ALIGNMENT_TIME ms	*/
        ShiftReg(0, ALIGNMENT_TIME-TargetTime);
         }

     AvgReg(0, Find_TrialType());		/* Determine type	*/

} while (Read_trial() != FAIL);			/* Next header		*/

Tag_Registers();
if (NORMALIZE)
   Normalize_Registers();
if (OFFSET)
   Offset_Registers();
Avg_Registers_for_units();

/* FOR GETTING OUTPUT DURING RUNNING OF MACRO: */
if (PLOT_AVERAGED_CELLS) {
        ChangeParameter('h', "30");
        ChangeParameter('w', "750");
        ChangeParameter('s', "2000");	/* ALIGNMENT_TIME	*/
        ChangeParameter('o', "30");
	ChangeParameter('b', "2");

        ChangeParameter('t', "h");

        ChangeParameter('c', "B");
        GraphData(Find_Register(81,2));
        ChangeParameter('c', "R");
        GraphData(Find_Register(83,2));
        GraphData(Find_Register(83,10));
        }

Clean_Registers();

if (WRITE_TO_DISK)
    Write_to_Disk();
}
/* ********************************************************************	*/
/* ******************************************************************** */

/* FUNCTION Avg_Registers_for_units */
   /* STACKS 83, 89 and 90 (90 is 89 with larger delay) */
   /* Classes - up to 16 possible */
static void Avg_Registers_for_units(void) {
   int i;

   for (i=1; i<=TO_SORT; i++) {			/* For each trial type	*/
      int stack = Register[i].stacknumber;

      if (Register[i].frame_count==0)		/* Unused register?	*/
         continue;				/* Skip it		*/

      AvgReg(i,
      	TO_SORT +				/* Base			*/
        CLASSES_TO_SORT * ((stack==83) ? 0 :	/* stack order:83,89,90	*/
	      		 ((stack==89) ? 1 : 2)) +
	Register[i].classnumber);		/* order by class, 1:16	*/
      }
   }
/* ******************************************************************** */
