/* FILE vestibmac.c	*/
     /* Read a string of units in; normalize each to a single trial and
        then add to a main register */
    /* WARNING: Not keeping the 10 deg horizontal trials */

#include "../defs.h"
#include "../array.h"       		/* Access registers directly	*/
#include "../_imports/deffs.h"
#include "../_imports/event.h"       	/* Stack instruction definitions*/
#include <stdlib.h>

/* OLD VERSION OF THIS MACRO !  USE  'Vestibmac.c' INSTEAD ! */

#define ALIGN_ON_TARGET_ON	0	/* Pick one or the other	*/
#define ALIGN_ON_TARGET_OFF	0
#define ALIGN_ON_END_ROTATION	1	/* End of movement(smpurs,rotate)*/


#define NORMALIZE_TRIAL_COUNT	1	/* Each unit gets equal weight	*/
#define NORMALIZE_RATE		1	/* Each unit gets equal weight	*/
#define OFFSET			0	/* Each unit starts at 0	*/

#define PRINT_REGISTER_NAMES	0	/* Print it on screen		*/
#define WRITE_TO_DISK   	0

#define PLOT_INDIVIDUALS	0	/* Plots of indi cell data	*/
#define PLOT_SINGLES		0	/* Plots of indi trial data	*/

#define HEAVIEST_FILTER		1	/* Overrides 'heavy'		*/
#define HEAVY_FILTER		1	/* Heavy (2-4 Hz) or light (46)	*/
#define DO_EYE_TRACES		1	/* Filter, etc:  very slow	*/

#define TO_SORT			18

static void Initialize_Stuff(void);
static void Write_to_Disk(void);
static void Tag_Registers(void);
static void Normalize_Registers(int Target_At);
static void Offset_Registers(void);
static void Avg_Registers(void);
static void Subtract_Registers(void);
static void Clean_Registers(void);
static int  Find_TrialType(void);
static int  Find_Register(int stack, int class);

/* ******************************************************************** */

/* FUNCTION vestib_sort_macro() */
	 /* Sort trials */
void vestib_sort_macro() {
   extern int DiffChannel;			/* diff.c		*/
   static int ToldUs = 0;
   int Target_At;				/*Time target appears at*/

if (ALIGN_ON_TARGET_ON + ALIGN_ON_TARGET_OFF + ALIGN_ON_END_ROTATION > 1)
   fatal("Choose just one alignment method");
if (ALIGN_ON_TARGET_ON + ALIGN_ON_TARGET_OFF + ALIGN_ON_END_ROTATION == 0)
   fatal("Choose an alignment method");
if (ToldUs++ == 0)
 fprintf(stderr, "Align on %s\n",			/* Tell us	*/
  (ALIGN_ON_TARGET_ON)  ? "target on" : (
  (ALIGN_ON_TARGET_OFF) ? "target off": (
  (ALIGN_ON_END_ROTATION) ? "stop rotation": "??")));

if (MAX_REGISTERS <= 2*TO_SORT + 2) {
   fprintf(stderr, "MAX_REG is only %d; need %d\n", MAX_REGISTERS, 2*TO_SORT+3);
   fatal("Increase MAX_REGISTERS or decrease TO_SORT");
   }

Initialize_Stuff();

if (PLOT_SINGLES) {
 ChangeParameter('w', "3000");
 ChangeParameter('s', "500");
 }

do {						/* Next trial or header	*/
     Register[0].stacknumber = (Register[0].stacknumber % 100);

#   ifdef DO_EYE_TRACES
     Set_CurrentChannel(OD_H);
     Filter(0);
     DiffChannel = H_VEL;
     Differentiate(0);

     Set_CurrentChannel(OD_V);
     Filter(0);
     DiffChannel = V_VEL;
     Differentiate(0);
#   endif

     Set_CurrentChannel(UNIT);		/* Filter indis: SE is smooth	*/
     Filter(0);

     {
     int occur = 0;

     while (StackExtract(TARGET_RE_1, ++occur, ONE) != 3) /* Target 3?	*/
        if (occur > 100)
           fatal("Can't find target 3 RE_1");
     Target_At = StackExtract(TARGET_RE_1,occur,TIME);

     occur = 0;

#    if ALIGN_ON_TARGET_ON
      ShiftReg(0, 1000 - Target_At);
#    elif ALIGN_ON_TARGET_OFF
      int time_off, time_blank;
      while (StackExtract(TARGET_OFF, ++occur, ONE) != 1) /* Target 1?	*/
         if (occur > 100)
	    break;
      time_off = StackExtract(TARGET_OFF, occur, TIME);
      occur = 0;
      while (StackExtract(TARGET_BLANK, ++occur, ONE) != 1) /* Targ 1	*/
         if (occur > 100)
	    break;
      time_blank = StackExtract(TARGET_BLANK, occur, TIME);
	
      if (time_off == -9999 && time_blank == -9999)
         fatal("Can't find target blank/off");

      if ((time_off==FAIL) ||		/* Only a 'blank' exists	*/
          (time_blank != -9999 &&	/* Both exist, and		*/
	      time_blank<time_off))	/* blank occurs BEFORE off:	*/
	time_off = time_blank;		/* Then use blank time		*/
					/* Else use off time		*/
      ShiftReg(0, 3000 - time_off);

#    elif ALIGN_ON_END_ROTATION
      {
      int end_movement;

      while (StackExtract(CHAIR_AT, ++occur, TIME) != FAIL) ;
      if (occur == 1 || occur > 100) {
         occur = 0;			/* Try looking for pursuit	*/
         while (StackExtract(TARGET_PURSUIT, ++occur, TIME) != FAIL) ;
         if (occur == 1 || occur > 100)
	    fatal("Can't find rotation or pursuit (or too many)");
         end_movement = StackExtract(TARGET_PURSUIT,occur-1,TIME);
      } else {
         end_movement = StackExtract(CHAIR_AT,occur-1,TIME);
	 }

      ShiftReg(0, 2500 - end_movement);
      }
#    endif
     }

      if (PLOT_SINGLES) {
        if (Register[0].stacknumber == 72) {
 	 ChangeParameter('o', "0");
 	 ChangeParameter('h', "100");
 	 ChangeParameter('w', "1000");
 	 ChangeParameter('s', "0");
 	 ChangeParameter('t', "u");
 	 ChangeParameter('c', "G");
         GraphData(0);
	 }
	}

     AvgReg(0, Find_TrialType());		/* Determine type	*/
} while (Read_trial() != FAIL);			/* Next header		*/

Tag_Registers();
if (NORMALIZE_TRIAL_COUNT || NORMALIZE_RATE)
   Normalize_Registers(Target_At);
if (OFFSET)
   Offset_Registers();
Avg_Registers();
Subtract_Registers();				/* Do differences	*/

/* FOR GETTING OUTPUT DURING RUNNING OF MACRO: */
if (PLOT_INDIVIDUALS) {
 char Text[80];
 /* system("sleep 2"); */
 GraphErase();
 ChangeParameter('o', "5");
 ChangeParameter('h', "200");
 ChangeParameter('w', "3000");
 ChangeParameter('s', "0");
 ChangeParameter('t', "u");

 ChangeParameter('c', "G");
 GraphData(Find_Register(22,3));
 ChangeParameter('c', "R");
 GraphData(Find_Register(23,3));
 ChangeParameter('c', "b8");
 GraphData(Find_Register(32,3));
 ChangeParameter('c', "B");
 GraphData(Find_Register(33,3));

 ChangeParameter('l', "5");
 ChangeParameter('c', "G");
 GraphData(Find_Register(22,7));
 ChangeParameter('c', "R");
 GraphData(Find_Register(23,7));
 ChangeParameter('c', "b8");
 GraphData(Find_Register(32,7));
 ChangeParameter('c', "B");
 GraphData(Find_Register(33,7));

 sprintf(Text, "@t 400 0 %d.%d",
	Register[0].classnumber,
	Register[0].stacknumber);
 Paint(Text);
 }

Clean_Registers();

if (WRITE_TO_DISK)
    Write_to_Disk();
}
/* ******************************************************************** */

/* FUNCTION Initialize_Stuff */
         /* Init */
static void Initialize_Stuff(void) {
   extern  int StepMs;				/* Differentiation stuff*/
   extern  int UseFilter;

   StepMs = 30;					/* Set up differentiator*/
   UseFilter = (HEAVY_FILTER) ? 2 : 12;		/* Heavy or light?	*/
   if (HEAVIEST_FILTER)
      UseFilter = 1;
   }					/* 2:9 Hz; 4:~25    12:46Hz	*/
/* ******************************************************************** */
/* ******************************************************************** */
/* ******************************************************************** */

/* FUNCTION Write_to_Disk */
	 /* Write to disk */
static void Write_to_Disk(void) {
   int i;

   for (i=TO_SORT+1; i<=TO_SORT*2; i++)
      if (ContentReg(i) > 0)
         RawFile(i);				/* Disk copies	*/
   }
/* ******************************************************************** */

/* FUNCTION Normalize_Registers */
	 /* Make'm look like 1 trial, and/or set max height = 100 Hz */
static void Normalize_Registers(int Target_At) {
	int i;

	if (NORMALIZE_TRIAL_COUNT)
           for (i=1; i<=TO_SORT; i++)
	      NormalizeReg(i);

	if (NORMALIZE_RATE) {
	   float max_peak = -9999.;
	   int peak_at;

 	   ChangeParameter('t', "u");		/* Change to units	*/

           for (i=1; i<=TO_SORT; i++) {
	      peak_at = FindPeakOfData(i,
	        Target_At + Register[i].shift,	/* Target presentation	*/
		Target_At + Register[i].shift + 500,	/* 500 ms later	*/
		1);					/* Positive peak*/
	      if (AvgSomeData(i,peak_at-10, peak_at+10) > max_peak)
	         max_peak = AvgSomeData(i,peak_at-10, peak_at+10);
	      }
	   if (max_peak < 0.)
	      fatal("vestib macro: couldn't find a peak value");
	   {
	   extern float multiplier;		/* From data.c		*/
 	   multiplier = 100/max_peak;		/* Scale peak to 100	*/
	   }

           for (i=1; i<=TO_SORT; i++)
	      MultiplyData(i);
	   }
	}
/* ******************************************************************** */

/* FUNCTION Offset_Registers */
	 /* Offset so activity at 400-600 ms is at zero */
static void Offset_Registers(void) {
	int i;
        for (i=1; i<=TO_SORT; i++)
          if (Register[i].trial_count)			/* Not empty?	*/
	    OffsetData(i, AvgSomeData(i, 700, 1000));
	}
/* ******************************************************************** */

/* FUNCTION Avg_Registers */
static void Avg_Registers(void) {
   AvgReg(Find_Register(70,3), TO_SORT + 1);	/* Get the up & rights	*/
   AvgReg(Find_Register(71,3), TO_SORT + 2);
   AvgReg(Find_Register(72,3), TO_SORT + 3);
   AvgReg(Find_Register(73,3), TO_SORT + 4);

   AvgReg(Find_Register(80,3), TO_SORT + 5);
   AvgReg(Find_Register(81,3), TO_SORT + 6);
   AvgReg(Find_Register(82,3), TO_SORT + 7);
   AvgReg(Find_Register(83,3), TO_SORT + 8);

   AvgReg(Find_Register(70,7), TO_SORT + 1);	/* Use down+right, too */
   AvgReg(Find_Register(71,7), TO_SORT + 2);	/* (Combine w/ up+right*/
   AvgReg(Find_Register(72,7), TO_SORT + 3);
   AvgReg(Find_Register(73,7), TO_SORT + 4);

   AvgReg(Find_Register(80,7), TO_SORT + 5);
   AvgReg(Find_Register(81,7), TO_SORT + 6);
   AvgReg(Find_Register(82,7), TO_SORT + 7);
   AvgReg(Find_Register(83,7), TO_SORT + 8);

   AvgReg(Find_Register(76,7), TO_SORT + 3);	/* Get horizontals	*/
   AvgReg(Find_Register(77,7), TO_SORT + 4);	/* Combine w/ diagonals	*/
   AvgReg(Find_Register(86,7), TO_SORT + 7);
   AvgReg(Find_Register(87,7), TO_SORT + 8);

						/* NOW DO PURSUITS */
   AvgReg(Find_Register(20,3), TO_SORT + 9);	/* Get the up & rights	*/
   AvgReg(Find_Register(21,3), TO_SORT + 10);
   AvgReg(Find_Register(22,3), TO_SORT + 11);
   AvgReg(Find_Register(23,3), TO_SORT + 12);

   AvgReg(Find_Register(30,3), TO_SORT + 13);
   AvgReg(Find_Register(31,3), TO_SORT + 14);
   AvgReg(Find_Register(32,3), TO_SORT + 15);
   AvgReg(Find_Register(33,3), TO_SORT + 16);

   AvgReg(Find_Register(20,7), TO_SORT + 9);	/* Use down+right, too */
   AvgReg(Find_Register(21,7), TO_SORT + 10);	/* (Combine w/ up+right*/
   AvgReg(Find_Register(22,7), TO_SORT + 11);
   AvgReg(Find_Register(23,7), TO_SORT + 12);

   AvgReg(Find_Register(30,7), TO_SORT + 13);
   AvgReg(Find_Register(31,7), TO_SORT + 14);
   AvgReg(Find_Register(32,7), TO_SORT + 15);
   AvgReg(Find_Register(33,7), TO_SORT + 16);

   AvgReg(Find_Register(26,7), TO_SORT + 11);	/* Get horizontals	*/
   AvgReg(Find_Register(27,7), TO_SORT + 12);	/* Combine w/ diagonals	*/
   AvgReg(Find_Register(36,7), TO_SORT + 15);
   AvgReg(Find_Register(37,7), TO_SORT + 16);
   }
/* ******************************************************************** */

/* FUNCTION Subtract_Registers */
static void Subtract_Registers() {
   
   if (Find_Register(70,3) != 99) {
      CopyReg( Find_Register(70,3), 0);		/* 70.3 into reg 0	*/
      SubtractReg(0, Find_Register(71,3));	/* 0 = 70.3 - 71.3	*/
      AvgReg(0, TO_SORT + 25);
      MacroTagReg(TO_SORT + 25, "Diff 70.3 - 71.3");

      CopyReg( Find_Register(80,3), 0);		/* 80.3 into reg 0	*/
      SubtractReg(0, Find_Register(81,3));	/* 0 = 80.3 - 81.3	*/
      AvgReg(0, TO_SORT + 27);
      MacroTagReg(TO_SORT + 27, "Diff 80.3 - 81.3");
      }

   if (Find_Register(72,3) != 99) {
      CopyReg( Find_Register(72,3), 0);		/* 72.3 into reg 0	*/
      SubtractReg(0, Find_Register(73,3));	/* 0 = 72.3 - 73.3	*/
      AvgReg(0, TO_SORT + 26);
      MacroTagReg(TO_SORT + 26, "Diff 72.3 - 73.3");
      
      CopyReg( Find_Register(82,3), 0);		/* 82.3 into reg 0	*/
      SubtractReg(0, Find_Register(83,3));	/* 0 = 82.3 - 83.3	*/
      AvgReg(0, TO_SORT + 28);
      MacroTagReg(TO_SORT + 28, "Diff 82.3 - 83.3");
      }

   if (Find_Register(76,7) != 99) {
      CopyReg( Find_Register(76,7), 0);         /* 76.7 into reg 0      */
      SubtractReg(0, Find_Register(77,7));      /* 0 = 76.7 - 77.7      */
      AvgReg(0, TO_SORT + 26);
      MacroTagReg(TO_SORT + 26, "Diff 76.7 - 77.7");

      CopyReg( Find_Register(86,7), 0);         /* 86.7 into reg 0      */
      SubtractReg(0, Find_Register(87,7));      /* 0 = 86.7 - 87.7      */
      AvgReg(0, TO_SORT + 28);  
      MacroTagReg(TO_SORT + 28, "Diff 86.7 - 87.7");
      }

   if (Find_Register(70,7) != 99) {
      CopyReg( Find_Register(70,7), 0);		/* 70.7 into reg 0	*/
      SubtractReg(0, Find_Register(71,7));	/* 0 = 70.7 - 71.7	*/
      AvgReg(0, TO_SORT + 25);

      CopyReg( Find_Register(80,7), 0);		/* 80.7 into reg 0	*/
      SubtractReg(0, Find_Register(81,7));	/* 0 = 80.7 - 81.7	*/
      AvgReg(0, TO_SORT + 27);
      }

   if (Find_Register(72,7) != 99) {
      CopyReg( Find_Register(72,7), 0);		/* 72.7 into reg 0	*/
      SubtractReg(0, Find_Register(73,7));	/* 0 = 72.7 - 73.7	*/
      AvgReg(0, TO_SORT + 26);

      CopyReg( Find_Register(82,7), 0);		/* 82.7 into reg 0	*/
      SubtractReg(0, Find_Register(83,7));	/* 0 = 82.7 - 83.7	*/
      AvgReg(0, TO_SORT + 28);
      }


   
   if (Find_Register(20,3) != 99) {
      CopyReg( Find_Register(20,3), 0);		/* 20.3 into reg 0	*/
      SubtractReg(0, Find_Register(21,3));	/* 0 = 20.3 - 21.3	*/
      AvgReg(0, TO_SORT + 29);

      CopyReg( Find_Register(30,3), 0);		/* 30.3 into reg 0	*/
      SubtractReg(0, Find_Register(31,3));	/* 0 = 30.3 - 31.3	*/
      AvgReg(0, TO_SORT + 31);
      }

   if (Find_Register(22,3) != 99) {
      CopyReg( Find_Register(22,3), 0);		/* 22.3 into reg 0	*/
      SubtractReg(0, Find_Register(23,3));	/* 0 = 22.3 - 23.3	*/
      AvgReg(0, TO_SORT + 30);

      CopyReg( Find_Register(32,3), 0);		/* 32.3 into reg 0	*/
      SubtractReg(0, Find_Register(33,3));	/* 0 = 32.3 - 33.3	*/
      AvgReg(0, TO_SORT + 32);
      }

   if (Find_Register(26,7) != 99) {
      CopyReg( Find_Register(26,7), 0);         /* 26.7 into reg 0      */
      SubtractReg(0, Find_Register(27,7));      /* 0 = 26.7 - 27.7      */
      AvgReg(0, TO_SORT + 30);

      CopyReg( Find_Register(36,7), 0);         /* 36.7 into reg 0      */
      SubtractReg(0, Find_Register(37,7));      /* 0 = 36.7 - 37.7      */
      AvgReg(0, TO_SORT + 32);
      }

   if (Find_Register(20,7) != 99) {
      CopyReg( Find_Register(20,7), 0);		/* 20.7 into reg 0	*/
      SubtractReg(0, Find_Register(21,7));	/* 0 = 20.7 - 21.7	*/
      AvgReg(0, TO_SORT + 29);

      CopyReg( Find_Register(30,7), 0);		/* 30.7 into reg 0	*/
      SubtractReg(0, Find_Register(31,7));	/* 0 = 30.7 - 31.7	*/
      AvgReg(0, TO_SORT + 31);
      }

   if (Find_Register(22,7) != 99) {
      CopyReg( Find_Register(22,7), 0);		/* 22.7 into reg 0	*/
      SubtractReg(0, Find_Register(23,7));	/* 0 = 22.7 - 23.7	*/
      AvgReg(0, TO_SORT + 30);

      CopyReg( Find_Register(32,7), 0);		/* 32.7 into reg 0	*/
      SubtractReg(0, Find_Register(33,7));	/* 0 = 32.7 - 33.7	*/
      AvgReg(0, TO_SORT + 32);
      }
   }
/* ******************************************************************** */

/* FUNCTION Clean_Registers */
static void Clean_Registers() {
	int i;

	for (i=0; i<=TO_SORT; i++)
	    RemoveReg(i);
	}
/* ******************************************************************** */

/* FUNCTION Tag_Registers */
static void Tag_Registers(void) {
   	char newname[80];
	int i;

	for (i=0; i<MAX_REGISTERS; i++)
	     if (Register[i].trial_count > 0) {
	        sprintf(newname, "%d.%d %s",
		   Register[i].stacknumber,
		   Register[i].classnumber,
		   Register[i].stackname);
		
	        MacroTagReg(i, newname);
	        }
	if (PRINT_REGISTER_NAMES)
	   ListReg();
	}
/* ******************************************************************** */

/* FUNCTION Find_Register */
	 /* Find register with given stack, class */
static int Find_Register(int stack, int class) {
	int i;

	for (i=1; i<=TO_SORT; i++)
            if (stack == Register[i].stacknumber
	    				&& class==Register[i].classnumber)
	       return(i);
	return(99);			/* Not found or out of room	*/
	}
/* ******************************************************************** */

/* FUNCTION Find_TrialType */
	 /* Return index of this trial in Class[]	*/
static int  Find_TrialType(void) {
    int i;
    int stack = Register[0].stacknumber;
    int class = Register[0].classnumber;

    for (i=1; i<=TO_SORT; i++) {
       if (Register[i].trial_count <= 0)		/* Empty?	*/
	  return(i);					/*  Use it	*/
        else						/* Else: match?	*/
        if (stack == Register[i].stacknumber && class==Register[i].classnumber)
	  return(i); 
       }
    return(99);
    }
/* ********************************************************************	*/
