/* FILE stimsort.c	*/
     /* Sort trials in current file */

#include "../defs.h"
#include "../array.h"       		/* Access registers directly	*/
#include "../_imports/deffs.h"
#include "../_imports/event.h"       	/* Stack instruction definitions*/


#define FILTER			1	/* Heavy (9 Hz) or light (46 Hz)*/
#define PRINT_REGISTER_NAMES	0
#define SQUASH_CLASS		1	/* Ignore class?		*/
#define CONTROL_STACK		99	/* 0: do naught >0: mv to reg 1	*/
#define WRITE_DATA		0

static void Initialize_Stuff(void);
static void Write_to_Disk(void);
static void Tag_Registers(void);
static int  Find_TrialClass(void);

/* ******************************************************************** */

/* FUNCTION StimulationSort() */
	 /* Sort shifted trials */
void StimulationSort(int Type) {
   extern int DiffChannel;			/* diff.c		*/
			/* Odd: fails if use "extern int DiffChannel"	*/

Initialize_Stuff();

do {						/* Next trial or header	*/
   Set_CurrentChannel(OD_H);
   Filter(0);
   DiffChannel = H_VEL;
   Differentiate(0);

   Set_CurrentChannel(OD_V);
   Filter(0);
   DiffChannel = V_VEL;
   Differentiate(0);

   if (FILTER) {
      Set_CurrentChannel(UNIT);		/* Filter indis: SE is smooth	*/
      Filter(0);
      }

   if (SQUASH_CLASS)
      Register[0].classnumber = 1;

   if (Type==1)
      ShiftReg(0, -StackExtract(TAPE_ON, 1, TIME));
							
   if (Type==2) {
      int occur = 5;			/* Sort on last acquire		*/

      while (StackExtract(ACQUIRE, occur, TIME) == FAIL)
         occur--;
      ShiftReg(0, 4000-StackExtract(ACQUIRE, occur, TIME));
      }

   AvgReg(0, Find_TrialClass());		/* Determine type	*/

} while (Read_trial() != FAIL);			/* Next header		*/

if (CONTROL_STACK) {
   if (Register[2].stacknumber == CONTROL_STACK) {
       CopyReg(1, 40);
       CopyReg(2, 1);
       CopyReg(40, 2);
       }
   if (Register[3].stacknumber == CONTROL_STACK) {
       CopyReg(1, 40);
       CopyReg(3, 1);
       CopyReg(40, 3);
       }
   if (Register[2].stacknumber == 96) {			/* Late stim?	*/
       CopyReg(3, 40);
       CopyReg(2, 3);
       CopyReg(40, 2);
       }
    RemoveReg(40);
   }

Tag_Registers();

if (WRITE_DATA)
   Write_to_Disk();
}
/* ******************************************************************** */

/* FUNCTION Initialize_Stuff */
         /* Init */
static void Initialize_Stuff(void) {
   extern  int StepMs;				/* Differentiation stuff*/
   extern  int UseFilter;

   StepMs = 30;					/* Set up differentiator*/
   UseFilter = (FILTER) ? 2 : 12;		/* Heavy or light?	*/
   }
/* ******************************************************************** */
/* ******************************************************************** */
/* ******************************************************************** */

/* FUNCTION Write_to_Disk */
	 /* Write to disk */
static void Write_to_Disk(void) {
   int i = 0;

   while (ContentReg(++i) > 0)
         RawFile(i);				/* Disk copies	*/
   }
/* ******************************************************************** */

/* FUNCTION Tag_Registers */
static void Tag_Registers(void) {
   	char newname[80];
        int i = 0;

        while (ContentReg(++i) > 0) {
	   sprintf(newname, "%d.%d %s",
		   Register[i].stacknumber,
		   Register[i].classnumber,
		   Register[i].stackname);
	   MacroTagReg(i, newname);
	   if (PRINT_REGISTER_NAMES)
	      fprintf(stderr, "  %d: %d.%d %s\n", i,
		      Register[i].stacknumber,
		      Register[i].classnumber,
		      Register[i].stackname);
	   }
	}
/* ******************************************************************** */

/* FUNCTION Find_TrialClass */
	 /* Return index of this trial in Class[]	*/
static int  Find_TrialClass(void) {
    int i;
    int stack = Register[0].stacknumber;
    int class = Register[0].classnumber;

    for (i=1; i<MAX_REGISTERS; i++) {
       if (Register[i].trial_count <= 0)		/* Empty?	*/
	  return(i);					/*  Use it	*/
        else						/* Else: match?	*/
        if (   (stack == Register[i].stacknumber)
            && (class == Register[i].classnumber))
	  return(i); 
       }
    return(99);
    }
/* ********************************************************************	*/
