/* FILE sort.c	*/
     /* Sort trials in current file */

#include "../defs.h"
#include "../array.h"       		/* Access registers directly	*/
#include "../_imports/deffs.h"
#include "../_imports/event.h"       	/* Stack instruction definitions*/


#define FILTER			1	/* Heavy (9 Hz) or light (46 Hz)*/
#define PRINT_REGISTER_NAMES	0

#define ALIGNMENT_TIME		2000
#define ALIGN_ON_TARGET		1	/* TARGET_RE_1 */
#define ALIGN_ON_REACH		0
#define ALIGN_ON_SACCADE	0
#define LAST			99

#define MAX_REGS		50	/* Careful about changing this!	*/

static void Initialize_Stuff(void);
static void Write_to_Disk(void);
static void Tag_Registers(void);
static int  Find_TrialClass(void);
static int  Find_Register(int stack, int class);
static void Sort_Some_Registers();

/* ******************************************************************** */

/* FUNCTION sort_macro() */
	 /* Sort shifted trials */
void sort_macro(void) {
   extern int DiffChannel;			/* diff.c		*/

Initialize_Stuff();

do {						/* Next trial or header	*/
   int TargetTime = StackExtract(TARGET_ON+2000,(int)'$',TIME);
   	/* TARGET_ON + 2000 == ANY TARGET; '$' == last occurrence */

   Set_CurrentChannel(OD_H);
   Filter(0);
   DiffChannel = H_VEL;
   Differentiate(0);

   Set_CurrentChannel(OD_V);
   Filter(0);
   DiffChannel = V_VEL;
   Differentiate(0);

   if (FILTER) {
      Set_CurrentChannel(UNIT);		/* Filter indis: SE is smooth	*/
      Filter(0);
      }

   if (ALIGN_ON_TARGET) {
        int Move = StackExtract(TARGET_RE_1, 1, TIME);
	if(Move == FAIL) {
	  fprintf(stderr, "Could not find reach; skipping trial!\n");
	  continue;
	  }
	ShiftReg(0,ALIGNMENT_TIME - Move);
    } else if (ALIGN_ON_REACH) {		/* Saccade or arm movement	*/
	int Move;
	extern int NoArmMovesBeforeThis;

	NoArmMovesBeforeThis = TargetTime;
	Move = FindArmMove(0);

	if(Move == FAIL) {
	  fprintf(stderr, "Could not find reach; skipping trial!\n");
	  continue;
	  }
	ShiftReg(0,ALIGNMENT_TIME - Move);

     } else if (ALIGN_ON_SACCADE) {	/* Saccade or arm movement	*/
#	define IGNORE_IT	320000
#	include "../sac.h"
	int Move;
	extern int NoSacsBeforeThis;
	/*extern int NoSacsAfterThis; */
	int HorizMove=IGNORE_IT, VertMove=IGNORE_IT;
	float HorizSize=0., VertSize=0.;

	NoSacsBeforeThis = TargetTime;

   	 Set_CurrentChannel(OD_H);		/* Look in both chans	*/
	if(FindSaccade(0) != FAIL) {
	    HorizMove = SaccadeData.begin;
 	      HorizSize = fabs(
	    	   AvgSomeData(0, SaccadeData.end, SaccadeData.end+30)-
 		   AvgSomeData(0, SaccadeData.begin-30, SaccadeData.begin));
	    }
   	 Set_CurrentChannel(OD_V);
	if(FindSaccade(0) != FAIL) {
	    VertMove = SaccadeData.begin;
 	      VertSize = fabs(
	        AvgSomeData(0, SaccadeData.end, SaccadeData.end+30)-
 		  AvgSomeData(0, SaccadeData.begin-30, SaccadeData.begin));
	    }

	if((VertMove != FAIL && HorizMove != FAIL) &&
	     abs(HorizMove - VertMove) > 100) {  /* Two diff sacs?	*/
	    if (HorizSize > 3 * VertSize)	   /* Vert too small	*/
	        VertMove = IGNORE_IT;		   /* Disregard it	*/
	    if (VertSize > 3 * HorizSize) 	   /* Horiz too small	*/
	        HorizMove = IGNORE_IT;
	    }				/* Now take the earlier:	*/
	Move= (HorizMove < VertMove) ? HorizMove : VertMove;
	if(Move == IGNORE_IT)	/* Didn't find any?		*/
	     Move = FAIL;

	if(Move == FAIL) {
	  fprintf(stderr, "Could not find saccade; skipping trial!\n");
	  continue;
	  }
	ShiftReg(0,ALIGNMENT_TIME - Move);
    } else {			/* Put last target at ALIGNMENT_TIME ms	*/
      ShiftReg(0, ALIGNMENT_TIME-TargetTime);
       }
							
   AvgReg(0, Find_TrialClass());		/* Determine type	*/

} while (Read_trial() != FAIL);			/* Next header		*/

Tag_Registers();
Sort_Some_Registers();
Write_to_Disk();
}
/* ******************************************************************** */

/* FUNCTION Initialize_Stuff */
         /* Init */
static void Initialize_Stuff(void) {
   extern  int StepMs;				/* Differentiation stuff*/
   extern  int UseFilter;

   StepMs = 1;					/* Set up differentiator*/
   UseFilter = (FILTER) ? 2 : 12;		/* Heavy or light?	*/
   }
/* ******************************************************************** */
/* ******************************************************************** */
/* ******************************************************************** */

/* FUNCTION Write_to_Disk */
	 /* Write to disk */
static void Write_to_Disk(void) {
   int i = 0;

   while (ContentReg(++i) > 0)
         RawFile(i);				/* Disk copies	*/
   }
/* ******************************************************************** */

/* FUNCTION Tag_Registers */
static void Tag_Registers(void) {
   	char newname[80];
        int i = 0;

        while (ContentReg(++i) > 0) {
	   sprintf(newname, "%d.%d %s",
		   Register[i].stacknumber,
		   Register[i].classnumber,
		   Register[i].stackname);
	   MacroTagReg(i, newname);
	   if (PRINT_REGISTER_NAMES)
	      fprintf(stderr, "  %d: %d.%d %s\n", i,
		      Register[i].stacknumber,
		      Register[i].classnumber,
		      Register[i].stackname);
	   }
	}
/* ******************************************************************** */

/* FUNCTION Find_TrialClass */
	 /* Return index of this trial in Class[]	*/
static int  Find_TrialClass(void) {
    int i;
    int stack = Register[0].stacknumber;
    int class = Register[0].classnumber;

    for (i=1; i<MAX_REGISTERS; i++) {
       if (Register[i].trial_count <= 0)		/* Empty?	*/
	  return(i);					/*  Use it	*/
        else						/* Else: match?	*/
        if (   (stack == Register[i].stacknumber)
            && (class == Register[i].classnumber))
	  return(i); 
       }
    return(99);
    }
/* ********************************************************************	*/

/* FUNCTION Find_Register */
         /* Find register with given stack, class */
static int Find_Register(int stack, int class) {
       int i;
for (i=1; i<=MAX_REGS; i++)
   if (Register[i].trial_count)
      if (stack == Register[i].stacknumber && class==Register[i].classnumber)
          return(i);

return(INVALID_REG);           			/* Not found or out of room     */
}
/* ******************************************************************** */

/* FUNCION Sort_Some_Registers */
	 /* Sort some registers that we specify */
static void Sort_Some_Registers() {

   AvgReg(Find_Register(226,3), 51);
   AvgReg(Find_Register(227,3), 52);
   AvgReg(Find_Register(236,3), 53);
   AvgReg(Find_Register(237,3), 54);

   AvgReg(Find_Register(226,7), 51);
   AvgReg(Find_Register(227,7), 52);
   AvgReg(Find_Register(236,7), 53);
   AvgReg(Find_Register(237,7), 54);

   return;
   }
/* ******************************************************************** */
