/* FILE rsvp1sort.c	*/
     /* Sort trials in current file */

#include "../defs.h"
#include "../array.h"       		/* Access registers directly	*/
#include "../_imports/deffs.h"
#include "../_imports/event.h"       	/* Stack instruction definitions*/


#define FILTER			0	/* Heavy (9 Hz) or light (46 Hz)*/
#define PRINT_REGISTER_NAMES	0
#define ALIGNMENT_TIME		2000
#define TYPES_TO_SORT		4
#define ALIGN_EVENT2		REWARD_OPTIONAL_BUTTON_AND
/* #define ALIGN_EVENT2		TARGET_BITMAP */

static void Initialize_Stuff(void);
static void Tag_Registers(void);
static int  Find_Register(int stack, int class);
static void Sort_Registers(void);

/* ******************************************************************** */

/* FUNCTION rsvp1_sort_macro() */
	 /* Sort shifted trials */
void rsvp1_sort_macro(void) {
   extern int DiffChannel;			/* diff.c		*/

Initialize_Stuff();

do {						/* Next trial or header	*/
   /* int Delay = StackExtract(DELAY, 1, TWO);			*/

   /* int Angle = atan2( StackExtract(TARGET_ON, 1, THREE),	*/
   /* 		         StackExtract(TARGET_ON, 1, TWO);	*/

   Set_CurrentChannel(OD_H);
   Filter(0);
   DiffChannel = H_VEL;
   Differentiate(0);

   Set_CurrentChannel(OD_V);
   Filter(0);
   DiffChannel = V_VEL;
   Differentiate(0);

   if (FILTER) {
      Set_CurrentChannel(UNIT);		/* Filter indis: SE is smooth	*/
      Filter(0);
      }

   ShiftReg(0, ALIGNMENT_TIME- StackExtract(TARGET_ON, 1, TIME));

   /* #define CHUNK	500			*/
   /* Delay = (int) (Delay / CHUNK) * CHUNK;	*/
							
   AvgReg(0, Find_Register( Register[0].stacknumber, Register[0].classnumber));

} while (Read_trial() != FAIL);			/* Next header		*/

Tag_Registers();
Sort_Registers();
}
/* ******************************************************************** */

/* FUNCTION rsvp2_sort_macro() */
	 /* Sort shifted trials */
void rsvp2_sort_macro(void) {
   extern int DiffChannel;			/* diff.c		*/

Initialize_Stuff();

do {						/* Next trial or header	*/
   Set_CurrentChannel(OD_H);
   Filter(0);
   DiffChannel = H_VEL;
   Differentiate(0);

   Set_CurrentChannel(OD_V);
   Filter(0);
   DiffChannel = V_VEL;
   Differentiate(0);

   if (FILTER) {
      Set_CurrentChannel(UNIT);		/* Filter indis: SE is smooth	*/
      Filter(0);
      }

   ShiftReg(0, ALIGNMENT_TIME- StackExtract(ALIGN_EVENT2, 1, TIME));

   AvgReg(0, Find_Register( Register[0].stacknumber, Register[0].classnumber));

} while (Read_trial() != FAIL);			/* Next header		*/

Tag_Registers();
Sort_Registers();
}
/* ******************************************************************** */

/* FUNCTION Initialize_Stuff */
         /* Init */
static void Initialize_Stuff(void) {
   extern  int StepMs;				/* Differentiation stuff*/
   extern  int UseFilter;

   StepMs = 1;					/* Set up differentiator*/
   UseFilter = (FILTER) ? 2 : 12;		/* Heavy or light?	*/
   }
/* ******************************************************************** */
/* ******************************************************************** */
/* ******************************************************************** */

/* FUNCTION Tag_Registers */
static void Tag_Registers(void) {
   	char newname[80];
        int i = 0;

        while (ContentReg(++i) > 0) {
	   sprintf(newname, "%d.%d %s",
		   Register[i].stacknumber,
		   Register[i].classnumber,
		   Register[i].stackname);
	   MacroTagReg(i, newname);
	   if (PRINT_REGISTER_NAMES)
	      fprintf(stderr, "  %d: %d.%d %s\n", i,
		      Register[i].stacknumber,
		      Register[i].classnumber,
		      Register[i].stackname);
	   }
	}
/* ******************************************************************** */

/* FUNCTION Find_Register */
	 /* Find register with given stack, class */
static int Find_Register(int stack, int class) {
	int i;

	for (i=1; i<=TYPES_TO_SORT; i++)
            if ((stack == Register[i].stacknumber
	    				&& class==Register[i].classnumber)
	      || Register[i].frame_count==0)	/* Unused register?	*/
		return(i);
	fprintf(stderr, "Overflow!\n");
	return(-1);	/* Should cause an error */
	}
/* ******************************************************************** */

/* FUNCTION mAx */
static int mAx(int *a, int *b) { return(*a>*b); }
/* ******************************************************************** */
/* FUNCTION Sort_Registers */
static void Sort_Registers(void) {
   int stackclass[TYPES_TO_SORT];
   int MaxTypes = 0;
   int class[TYPES_TO_SORT];
   int stack[TYPES_TO_SORT];
   int i,j;

   for (i=1; i<=TYPES_TO_SORT; i++) {		/* For each trial type	*/
      if (Register[i].frame_count==0)		/* Unused register?	*/
         continue;				/* Skip it		*/

      for (j=0; j<MaxTypes; j++)
         if ((class[j] == Register[i].classnumber) &
             (stack[j] == Register[i].stacknumber)) /* Found this one?	*/
	    break;
      if (j==MaxTypes) {
         class[MaxTypes] = Register[i].classnumber;	/* Store as next*/
         stack[MaxTypes] = Register[i].stacknumber;	/* Store as next*/
         stackclass[MaxTypes] = stack[MaxTypes] * 100 + class[MaxTypes];
	 MaxTypes++;
         }
      }

   qsort(stackclass, MaxTypes, sizeof(int), (void *) mAx);

   ListReg();
   for (i=0; i<MaxTypes; i++) {
       int next = Find_Register((int)(stackclass[i]/100), stackclass[i] % 100);
       RawFile(next);
       AvgReg(next, MaxTypes + 2 + i);
       }
   for (i=0; i<=MaxTypes; i++)
       RemoveReg(i);
   }
/* ******************************************************************** */
