/* FILE printmac.c	*/
     /* write out a register's data (spikes, H and V)	*/
 
#include "../defs.h"
#include "../array.h"       		/* Access registers directly	*/
#include "../sac.h"
#include "../_imports/deffs.h"
#include "../_imports/event.h"       	/* Stack instruction definitions*/
#include "../_imports/head.h"       	/* Monk name, unit & run numbers*/
#include <stdlib.h>

/* ******************************************************************** */

/* FUNCTION PrintRegister_macro() */
	 /* Print out the data */
void PrintRegister_macro(int reg) {
      char OutputName[80];
      FILE *File;

      sprintf(OutputName, "t_%c_%d.%d_%d",
		       h.id.monk[0], h.id.unit, h.id.run, reg);
      File = fopen(OutputName, "w");
      UseStack(reg);

      fprintf(File, "stack %d class %d reg %d\n",
	Register[reg].stacknumber, Register[reg].classnumber, reg);
      TextFile(reg, File, 2);
      fclose(File);
      }
/* ******************************************************************** */
