/* FILE namemac.c	*/
     /* Name registers according to stack, class and stack name	*/

#include "../defs.h"
#include "../array.h"       		/* Access registers directly	*/
#include "../_imports/deffs.h"
#include "../_imports/event.h"       	/* Stack instruction definitions*/
#include <stdlib.h>

/* ******************************************************************** */

/* FUNCTION name_macro() */
	 /* Name according to stack, class & stack name */
	 /*  PROMPTS FOR WHICH STACKS */
void name_macro(void) {
	int from, to;
   	char newname[80];

	fprintf(stderr, "Name registers starting from: ");
	if (scanf("%d", &from) != 1)
	   return;
	fprintf(stderr, "               ending at:     ");
	if (scanf("%d", &to) != 1)
	   return;

	if (to == 99 || from == 99)
	   return;

	from--;
	while (++from <= to)
	   if (Register[from].trial_count > 0) {
	        sprintf(newname, "%d.%d %s",
		   Register[from].stacknumber,
		   Register[from].classnumber,
		   Register[from].stackname);
	        MacroTagReg(from, newname);
	        }
	}
/* ********************************************************************	*/
