/* FILE kubaneksort.c	*/
     /* Sort trials in current file */

#include "../defs.h"
#include "../array.h"       		/* Access registers directly	*/
#include "../_imports/deffs.h"
#include "../_imports/event.h"       	/* Stack instruction definitions*/


#define PRINT_REGISTER_NAMES	0

#define ALIGNMENT_TIME		2000
#define ALIGN_ON_TARGET		0	/* Default both 0: on move	*/
#define ALIGN_ON_GO_CUE		0

#define MAX_REGS		50

static void Tag_Registers(void);
static int  TrialClass(int stack, int class);
static int  Map_Register(int reg);
static void Normalize_Registers(void);

/* ******************************************************************** */

/* FUNCTION kubanek_sort_macro() */
	 /* Sort shifted trials */
void kubanek_sort_macro(int pref, int null) {
   extern int DiffChannel;			/* diff.c		*/
   extern  int StepMs;				/* Differentiation stuff*/
   extern  int UseFilter;

StepMs = 1;					/* Set up differentiator*/

do {						/* Next trial or header	*/
   int TargetTime = StackExtract(TARGET_ON+2000, 2, TIME); /*+2K:any targ*/

   switch (Register[0].stacknumber) {
      case  66:		/* Memory arm */
      case  65:		/* Memory eye */
	      if (Register[0].classnumber == pref)
                 Register[0].classnumber = 20;
	      else if (Register[0].classnumber == null)
                 Register[0].classnumber = 21;
	      else 
		 continue;
	      break;
      case 165:		/* Decide eye */
      case 166:		/* Decide arm */
              Register[0].classnumber =
		      	20 + (StackExtract(RUNTIME_MACRO, 1, TWO) % 2);
	      break;
      default:
	      continue;
      }
							
   UseFilter = 64;				/* 2, 8, 12, etc	*/
   Set_CurrentChannel(OD_H);
   Filter(0);
   DiffChannel = H_VEL;
   Differentiate(0);

   Set_CurrentChannel(OD_V);
   Filter(0);
   DiffChannel = V_VEL;
   Differentiate(0);

   Set_CurrentChannel(UNIT);		/* Filter indis: SE is smooth	*/
   UseFilter = 16;				/* 2, 8, 12, etc	*/
   Filter(0);

   if (ALIGN_ON_TARGET) {
      ShiftReg(0,ALIGNMENT_TIME - TargetTime);
    } else if (ALIGN_ON_GO_CUE) {	/* Saccade or arm movement	*/
      int Go = StackExtract(TARGET_REDRAW, (int) '$', TIME);
      if (Go == FAIL) {
	 fprintf(stderr, "Could not find go cue; skipping trial!\n");
	 continue;
	 }
      ShiftReg(0,ALIGNMENT_TIME - Go);
    } else {
      int Go = StackExtract(TARGET_REDRAW, (int) '$', TIME);
      int Move;
      if (Register[0].stacknumber % 100 == 66) {	/* Reach trial	*/
	 extern int NoArmMovesBeforeThis;
	 NoArmMovesBeforeThis = Go;
	 Move = FindArmMove(0);
       } else {                               		/* Saccade	*/
#        include "../sac.h"
#        define TOO_LATE      320000
	 extern int NoSacsBeforeThis;
	 extern int FindSmallSac;
         int HorizMove=TOO_LATE, VertMove=TOO_LATE;
         float HorizSize=0., VertSize=0.;

         NoSacsBeforeThis = Go;
         FindSmallSac = 1;

         Set_CurrentChannel(OD_H);            /* Look in both chans   */
         if (FindSaccade(0) != FAIL) {
	     HorizMove = SaccadeData.begin;
	     HorizSize = fabs(
		AvgSomeData(0, SaccadeData.end, SaccadeData.end+30)-
		AvgSomeData(0, SaccadeData.begin-30, SaccadeData.begin));
             }
         Set_CurrentChannel(OD_V);
         if (FindSaccade(0) != FAIL) {
	     VertMove = SaccadeData.begin;
	     VertSize = fabs(
	        AvgSomeData(0, SaccadeData.end, SaccadeData.end+30)-
		AvgSomeData(0, SaccadeData.begin-30, SaccadeData.begin));
             }

         if ((VertMove != FAIL && HorizMove != FAIL) &&
		abs(HorizMove - VertMove) > 100) {  /* Two diff sacs?    */
	     if (HorizSize > 3 * VertSize)        /* Vert too small    */
		 VertMove = TOO_LATE;             /* Disregard it      */
	     if (VertSize > 3 * HorizSize)        /* Horiz too small   */
		 HorizMove = TOO_LATE;
	     }                         /* Now take the earlier:        */
         Move = (HorizMove < VertMove) ? HorizMove : VertMove;
         if (Move == TOO_LATE)        /* Didn't find any?             */
	     Move = FAIL;
         }      
      if (Move == FAIL) {
	 fprintf(stderr, "Could not find movemment; skipping trial!\n");
	 continue;
	 }
      ShiftReg(0, ALIGNMENT_TIME - Move);
      Set_CurrentChannel(UNIT);      	 
      }

   AvgReg(0, Map_Register(0));			/* Determine type	*/
   if (Register[0].stacknumber==165 || Register[0].stacknumber==166) {
       Register[0].classnumber = 23;		/* Both pref & null	*/
       AvgReg(0, Map_Register(0));		/* Save a '+' copy	*/
       }

} while (Read_trial() != FAIL);			/* Next header		*/
}
/* ******************************************************************** */

/* FUNCTION end_kubanek_sort_macro() */
	 /* Finish off sorting trials */
void end_kubanek_sort_macro() {
 int i, j, k;
 int Stacks[] = { 65,66,165,166 };
 int Classes[] = { 20, 21, 22 };
 char newname[80];

 Normalize_Registers();
 Tag_Registers();

 for (j=0; j<4; j++) {			/* Make class 22 (pref-null)	*/
   int st = Stacks[j];
   i = TrialClass(st,22);
   CopyReg(    TrialClass(st,20), i);
   SubtractReg(i, TrialClass(st,21));
   Register[i].classnumber = 22;
   sprintf(newname, "%d.%d %d-%d",
		   Register[i].stacknumber,
		   Register[i].classnumber,
		   TrialClass(st,20), TrialClass(st,21));
   MacroTagReg(i, newname);
   }
					/* Make stack ?67 (eye-arm)	*/
 for (j=65; j<200; j+=100)			/* Stacks 65 and 165	*/
  for (k=20; k<23; k+=1) {			/* Classes 20 to 22	*/
   i = TrialClass(j+2,k);
   CopyReg(    TrialClass(j,k), i);	/* eye - arm, for each class	*/
   SubtractReg(i, TrialClass(j+1,k));
   Register[i].stacknumber = j+2;
   sprintf(newname, "%d.%d %d-%d",
		   Register[i].stacknumber,
		   Register[i].classnumber,
		   TrialClass(j,k), TrialClass(j+1,k));
   MacroTagReg(i, newname);
   }

 for (k=0; k<3; k++) {
   int cl = Classes[k];
   for (j=0; j<2; j++) {
     int st = Stacks[j];
     i = TrialClass(200+st,cl);

     CopyReg(    TrialClass(    st,cl), i);
     SubtractReg(i, TrialClass(100+st,cl));
     Register[i].stacknumber = 200+st;
     sprintf(newname, "%d.%d %d-%d",
		   Register[i].stacknumber,
		   Register[i].classnumber,
		   TrialClass(st,cl), TrialClass(100+st,cl));
     MacroTagReg(i, newname);
     }
   }

 for (i=1; i<MAX_REGS; i++)
   if (ContentReg(i) > 0)
    AvgReg(i, Map_Register(i)+50);
}
/* ******************************************************************** */
/* ******************************************************************** */
/* ******************************************************************** */

/* FUNCTION Tag_Registers */
static void Tag_Registers(void) {
   	char newname[80];
        int i = 0;

	for (i=1; i<MAX_REGS; i++)
         if (ContentReg(i) > 0) {
	   sprintf(newname, "%d.%d %s",
		   Register[i].stacknumber,
		   Register[i].classnumber,
		   Register[i].stackname);
	   MacroTagReg(i, newname);
	   if (PRINT_REGISTER_NAMES)
	      fprintf(stderr, "  %d: %d.%d %s\n", i,
		      Register[i].stacknumber,
		      Register[i].classnumber,
		      Register[i].stackname);
	   }
	}
/* ******************************************************************** */

/* FUNCTION Map_Register */
         /* Find register with given stack, class */
static int Map_Register(int reg) {
   return(TrialClass(Register[reg].stacknumber, Register[reg].classnumber));
   }

/* ******************************************************************** */

/* FUNCTION TrialClass */
         /* Map stack, class to a register */
static int TrialClass(int stack, int class) {
if (stack== 65 && class==20) return(1);
if (stack== 65 && class==21) return(2);
if (stack== 65 && class==22) return(3);		/* Diff */

if (stack== 66 && class==20) return(4);
if (stack== 66 && class==21) return(5);
if (stack== 66 && class==22) return(6);		/* Diff */

if (stack== 67 && class==20) return(7);		/* Diff, arm-eye pref */
if (stack== 67 && class==21) return(8);		/* Diff, arm-eye null */
if (stack== 67 && class==22) return(9);		/* Double diff */


if (stack==165 && class==20) return(11);
if (stack==165 && class==21) return(12);
if (stack==165 && class==22) return(13);

if (stack==166 && class==20) return(14);
if (stack==166 && class==21) return(15);
if (stack==166 && class==22) return(16);

if (stack==167 && class==20) return(17);	/* Diff, arm-eye pref	*/
if (stack==167 && class==21) return(18);	/* Diff, arm-eye null	*/
if (stack==167 && class==22) return(19);	/* Double diff		*/

if (stack==265 && class==20) return(21);	/* mem-decide, eye pref	*/
if (stack==265 && class==21) return(22);	/*                 null	*/
if (stack==265 && class==22) return(23);        /*   double diff	*/

if (stack==266 && class==20) return(24);	/* mem-decide, arm pref	*/
if (stack==266 && class==21) return(25);
if (stack==266 && class==22) return(26);

if (stack==267 && class==20) return(27);	/* Doubles, arm-eye pref*/
if (stack==267 && class==21) return(28);	/* Doubles, arm-eye null*/
if (stack==267 && class==22) return(29);	/* Triple diff 		*/

if (stack==165 && class==23) return(30);
if (stack==166 && class==23) return(31);

fprintf(stderr, "DIAG: %d.%d not found\n", stack, class);
return(INVALID_REG);           		/* Not found or out of room     */
}
/* ******************************************************************** */

/* FUNCTION Normalize_Registers */
         /* Make'm look like 1 trial */
static void Normalize_Registers(void) {
	int i;
	for (i=1; i<MAX_REGS; i++)
	    NormalizeReg(i);
	}
/* ******************************************************************** */
