/* FILE jeffmac.c	*/
     /* Read a string of units in; normalize each to a single trial and
        then add to a main register */

#include "../defs.h"
#include "../array.h"       		/* Access registers directly	*/
#include "../_imports/deffs.h"
#include "../_imports/event.h"       	/* Stack instruction definitions*/
#include <stdlib.h>

static int  ALIGN_ON_FIRST =0;	/* Align on 1st or 2nd stimulus?	*/
static int  ALIGN_ON_MOTOR =0;	/* Align on motor?  Disregard 'ON_FIRST'*/

static int  DO_200s	=0;	/* Select: Cue-Target stacks		*/
static int  DO_210s	=0;	/* 	   Target-cue			*/
static int  DO_220s	=0;	/* 	   Cued memory			*/
static int  DO_230s	=1;	/* 	   Spatial memory		*/

static int  COLLAPSE_ACROSS_STACKS = 0;	/* 200s,210s,220s into 1 each	*/

static int  COLLAPSE_ACROSS_CLASSES= 0;	/* All classes into a single one*/
static int  USE_ONLY_TWO_CLASSES   = 0;	/* Must pass best class to macro*/
static int  USE_ONLY_ONE_CLASS     = 0;	/* Must pass best class to macro*/

static int  FILTER		= 302;	/* (8 Hz) 1,2,4,8,16,32 Hz	*/
					/* Used to be 302		*/
#define     EXTRA_FILTER	1	/* Rm edge glitches on units	*/
static int  DIFF_FILTER		= 320;	/* (16) Extra for diff traces	*/
					/* Used to be 320		*/
static int  DO_EYE_TRACES	= 1;	/* Filter, etc:  very slow	*/
static int  RECTIFY_ANALOG	= 0;	/* Show up systematic changes	*/
			/* i.e., drift that occurs before the 'go' cue	*/

static int  NORMALIZE		= 1;	/* Each unit gets equal weight	*/
static int  OFFSET		= 0;	/* Each unit starts at 0	*/
static int  ARM_MINUS_EYE       = 0;	/* Do cell-by-cell subtraction	*/
static int  IN_MINUS_OUT        = 0;	/* Ditto (210's, 1st intvl ONLY?*/
static int  DOUBLE_SUBTRACT     = 0;	/* When do we do this??		*/

#define  ONLY_EYE_AND_ARM_CELLS	     0	/* Skip cells w/o combined data	*/
#define  ARM_AND_EYE_MINUS_ARM	     0	/* Do cell-by-cell subtraction	*/

#define  PRINT_REGISTER_NAMES	0	/* Print it on screen		*/
#define  WRITE_TO_DISK   	0
#define  PLOT_AVERAGED_CELLS	0	/* As you go...			*/
static int  STACKS_TO_SORT	= 3;	/* 200,202,204 or 210,212,214	*/
static int  CLASSES_TO_SORT	= 8;	/* Pref, null	*/

#define PLOT_INDIVIDUALS	0

#define TO_SORT			(STACKS_TO_SORT * CLASSES_TO_SORT)

#define	ALIGNMENT_TIME		2600	/* Used to be 600		*/

#define DELETE_MARGIN		0	/* For diverge_macro() only	*/

void jeff_sort_macro(int direction);
static void Initialize_Stuff(void);
static void Write_to_Disk(void);
static void Tag_Registers(void);
static void Normalize_Registers(void);
static void Offset_Registers(void);
static void Avg_Registers(void);
static void Clean_Registers();
static int  Find_TrialType(void);
static int  Find_Register(int stack, int class);

static int DivergenceMacro = 0;

/* ******************************************************************** */

/* FUNCTION jeff_initialize_macro() */
	 /* Initialize the macro */
void jeff_initialize_macro(int value) {
	switch (value%100) {

		case 1:				/* CUE-target trials */
		   ALIGN_ON_FIRST		= 1;
		   DO_200s			= 1;
		   DO_210s			= 0;
		   COLLAPSE_ACROSS_STACKS	= 0;
		   USE_ONLY_TWO_CLASSES		= 0;
		   COLLAPSE_ACROSS_CLASSES	= 1;

		   DO_220s = DO_230s		= 0;
		   USE_ONLY_ONE_CLASS		= 0;
		   ARM_MINUS_EYE		= 1;
		   IN_MINUS_OUT			= 0;
		   OFFSET			= 0;
		   DO_EYE_TRACES		= 1;
		   RECTIFY_ANALOG		= 1;
		   break;
		case 2:				/* TARGET-cue trials */
		   ALIGN_ON_FIRST		= 1;
		   DO_200s			= 0;
		   DO_210s			= 1;
		   COLLAPSE_ACROSS_STACKS	= 1;
		   USE_ONLY_TWO_CLASSES		= 1;
		   COLLAPSE_ACROSS_CLASSES	= 0;

		   ARM_MINUS_EYE		= 0; 
		   IN_MINUS_OUT			= 1;
		   DO_220s = DO_230s		= 0;
		   USE_ONLY_ONE_CLASS		= 0;
		   OFFSET			= 0;
		   DO_EYE_TRACES		= 1;
		   RECTIFY_ANALOG		= 1;
		   break;

		case 3:				/* cue-TARGET trials */
		   ALIGN_ON_FIRST		= 0;
		   DO_200s			= 1;
		   DO_210s			= 0;
		   COLLAPSE_ACROSS_STACKS	= 0;
		   USE_ONLY_TWO_CLASSES		= 1;
		   COLLAPSE_ACROSS_CLASSES	= 0;

		   ARM_MINUS_EYE		= 1;
		   IN_MINUS_OUT			= 0;
		   DO_220s = DO_230s		= 0;
		   USE_ONLY_ONE_CLASS		= 0;
		   OFFSET			= 0;
		   DO_EYE_TRACES		= 1;
		   RECTIFY_ANALOG		= 1;
		   break;

		case 4:				/* target-CUE trials */
		   ALIGN_ON_FIRST		= 0;
		   DO_200s			= 0;
		   DO_210s			= 1;
		   COLLAPSE_ACROSS_STACKS	= 0;
		   USE_ONLY_TWO_CLASSES		= 1;
		   COLLAPSE_ACROSS_CLASSES	= 0;

		   ARM_MINUS_EYE		= 1;
		   IN_MINUS_OUT			= 1;
		   DO_220s = DO_230s		= 0;
		   USE_ONLY_ONE_CLASS		= 0;
		   OFFSET			= 0;
		   DO_EYE_TRACES		= 1;
		   RECTIFY_ANALOG		= 1;
		   break;

		case 5:				/* Spatial memory */
		case 15:
		case 25:
		   ALIGN_ON_FIRST		= 0;
		   DO_200s			= 0;
		   DO_210s			= 0;
		   DO_220s 			= 0;
		   DO_230s			= 1;
		   COLLAPSE_ACROSS_STACKS	= 0;
		   USE_ONLY_TWO_CLASSES		= 1;
		   COLLAPSE_ACROSS_CLASSES	= 0;

		   ARM_MINUS_EYE	= (value%100== 5 || value%100==25);
		   IN_MINUS_OUT		= (value%100==15 || value%100==25);
		   USE_ONLY_ONE_CLASS		= 0;
		   OFFSET			= 0;
		   DO_EYE_TRACES		= 1;
		   RECTIFY_ANALOG		= 1;
		   break;

		case 6:				/* Cued memory */
		   ALIGN_ON_FIRST		= 1;
		   DO_200s			= 0;
		   DO_210s			= 0;
		   DO_220s 			= 1;
		   DO_230s			= 0;
		   COLLAPSE_ACROSS_STACKS	= 0;
		   USE_ONLY_TWO_CLASSES		= 1;
		   COLLAPSE_ACROSS_CLASSES	= 0;

		   ARM_MINUS_EYE		= 1;
		   IN_MINUS_OUT			= 0;
		   USE_ONLY_ONE_CLASS		= 0;
		   OFFSET			= 0;
		   DO_EYE_TRACES		= 1;
		   RECTIFY_ANALOG		= 1;
		   break;

		case 90:
		   ALIGN_ON_MOTOR = 0;		/* The default	*/
		   break;
		case 91:
		   ALIGN_ON_MOTOR = 1;
		   break;

		default: 
		   fprintf(stderr, "jeffmac: Unknown init (%d)\n", value);
	}

  NORMALIZE			= value < 1000;
  }
/* ******************************************************************** */


/* FUNCTION jeff_divergence_macro() */
	 /* Return eye-arm divergence times */
void jeff_divergence_macro(int direction) {
	DivergenceMacro = 1;
	jeff_sort_macro(direction);
	DivergenceMacro = 0;
	}
/* ******************************************************************** */

/* FUNCTION jeff_sort_macro() */
	 /* Sort shifted trials */
void jeff_sort_macro(int direction) {
   extern int DiffChannel;			/* diff.c		*/
   int i;
			/* Odd: fails if use "extern int DiffChannel"	*/

if (ONLY_EYE_AND_ARM_CELLS && ARM_AND_EYE_MINUS_ARM) {
   STACKS_TO_SORT  = 4;		/* Diff uses 2 extra, not using EYE (-1)*/
   CLASSES_TO_SORT = 6;		/* Keep product same (TO_SORT)	*/
   }

if (IN_MINUS_OUT && DO_230s) {
   STACKS_TO_SORT  = 6;		/* Diff uses 2 extra, so need 5		*/
   CLASSES_TO_SORT = 4;		/* Keep product same (TO_SORT)	*/
   }

if (ARM_MINUS_EYE) {
 if (COLLAPSE_ACROSS_CLASSES || USE_ONLY_TWO_CLASSES || USE_ONLY_ONE_CLASS) {
   STACKS_TO_SORT  = 6;		/* Diff uses 2 extra, so need 5		*/
   CLASSES_TO_SORT = 4;		/* Keep product same (TO_SORT)	*/
  } else
   fprintf(stderr, "Not enough slots to do 5 stacks plus up to 8 classes\n");
 }

if (MAX_REGISTERS <= 2*TO_SORT + 2) {
   fprintf(stderr, "MAX_REG is only %d; need %d\n", MAX_REGISTERS, 2*TO_SORT+3);
   fatal("Increase MAX_REGISTERS or decrease STACKS/CLASSES_TO_SORT");
   }

Initialize_Stuff();

if (DivergenceMacro)
   for (i=0; i<TO_SORT; i++)
      RemoveReg(TO_SORT + i);

do {						/* Next trial or header	*/
     int FirstTargetTime, SecondTargetTime,	/* Target on occurences	*/
	 PolarTargetTime;			/* (could also be a targ*/

     switch (Register[0].stacknumber) {		/* Check for odd stacks	*/
        case 200: case 202: case 204:
	    if (DO_200s == 0)			/* Skip 200's?		*/
	       continue;
	    break;

        case 210: case 212: case 214:
	    if (DO_210s == 0)			/* Skip 210's?		*/
	       continue;
            break;

        case 220: case 222: case 224:
	    if (DO_220s == 0)			/* Skip 220's?		*/
	       continue;
            break;

        case 230: case 232: case 234:
	    if (DO_230s == 0)			/* Skip 230's?		*/
	       continue;
            break;

	default:				/* Skip unknown stack	*/
	    continue;
        }

      if (USE_ONLY_TWO_CLASSES || USE_ONLY_ONE_CLASS) {
         if (direction == 0)			/* Didn't tell us which	*/
	    fatal("Direction not specified: jeff_sort_macro");

	 if (Register[0].classnumber == direction)
	     Register[0].classnumber = 10;	/* Best direction	*/

	 if (USE_ONLY_TWO_CLASSES) {
	     int opp = direction + 4;
	     if (opp > 8)
	         opp -= 8;
	     if (Register[0].classnumber == opp)
	         Register[0].classnumber = 11;	/* Null direction	*/
	     }
	 if (Register[0].classnumber < 10)	/* Neither best nor null*/
	    continue;
	 }

     if (COLLAPSE_ACROSS_STACKS) {
        if (Register[0].stacknumber < 210)
	    Register[0].stacknumber = 201;
	else if (Register[0].stacknumber < 220)
	    Register[0].stacknumber = 211;
	else if (Register[0].stacknumber < 230)
	    Register[0].stacknumber = 221;
	else if (Register[0].stacknumber < 240)
	    Register[0].stacknumber = 231;
        else
	    fatal("Unclassifiable stack number: jeff_sort_macro");
	}
     if (COLLAPSE_ACROSS_CLASSES)
        Register[0].classnumber = 10;		/* Make all the same	*/

     {					/* Find last two targets	*/
     int occur = 0;

     while (++occur < 10)
        if (StackExtract(TARGET_ON, occur, ONE) == FAIL) /* Non-exist?	*/
           break;			/* Find one past last target	*/
     if (occur >= 10)
        fatal("Can't find last target");

     FirstTargetTime = StackExtract(TARGET_ON,occur-2, TIME);/* 2nd to last*/
     SecondTargetTime= StackExtract(TARGET_ON,occur-1, TIME);/* Last target*/
     PolarTargetTime = StackExtract(TARGET_ON_POLAR, 1, TIME);

     if (PolarTargetTime != FAIL) {
        if (PolarTargetTime > SecondTargetTime) {
           FirstTargetTime  = SecondTargetTime;
	   SecondTargetTime = PolarTargetTime;
 	 } else if (PolarTargetTime > FirstTargetTime)
           FirstTargetTime  = PolarTargetTime;
	}

     if (DO_230s) {		/* Spatial mem is a bit of an exception!*/
	FirstTargetTime = SecondTargetTime;	/* 1st targ is fixation!*/
        }			/* (has only 2 instead of usu 3 targs)	*/
     }


     if (DO_EYE_TRACES) {
	extern int UseFilter;
	int SaveFilter = UseFilter;

	UseFilter = 32;			/* Less than units (faster)	*/

        Set_CurrentChannel(OD_H);
        if (FILTER)
           Filter(0);
        DiffChannel = H_VEL;
        Differentiate(0);

        Set_CurrentChannel(OD_V);
        if (FILTER)
           Filter(0);
        DiffChannel = V_VEL;
        Differentiate(0);

	UseFilter = SaveFilter;

        if (RECTIFY_ANALOG) {
           Set_CurrentChannel(OD_H);
           ChannelDataTransfer(0, X3);	/* Copy to extra channel X3	*/
           Set_CurrentChannel(X3);
           OffsetData(0, 
               AvgSomeData(0, FirstTargetTime-400, FirstTargetTime));
           RectifyData(0);

           Set_CurrentChannel(OD_V);
           ChannelDataTransfer(0, X4);	/* Copy to extra channel X4	*/
           Set_CurrentChannel(X4);
           OffsetData(0, 
               AvgSomeData(0, FirstTargetTime-400, FirstTargetTime));
           RectifyData(0);

           Set_CurrentChannel(ARM_H);
           ChannelDataTransfer(0, X5);/* Copy to extra channel X5	*/
           Set_CurrentChannel(X5);
           OffsetData(0, 
               AvgSomeData(0, FirstTargetTime-400, FirstTargetTime));
           RectifyData(0);

           Set_CurrentChannel(ARM_V);
           ChannelDataTransfer(0, X6);/* Copy to extra channel X6	*/
           Set_CurrentChannel(X6);
           OffsetData(0, 
               AvgSomeData(0, FirstTargetTime-400, FirstTargetTime));
           RectifyData(0);
	   }
     }


     Set_CurrentChannel(UNIT);		/* Filter indis: SE is smooth	*/
     if (EXTRA_FILTER) {		/* Remove glitches on edges	*/
        extern  int UseFilter;		/*  - run shorter filters 1st	*/
	int save = UseFilter;		/* No longer have orig filts! 	*/

	UseFilter = 32;
	Filter(0);
	UseFilter = 64;
	Filter(0);
	UseFilter = save;
	}
     if (FILTER)
        Filter(0);

     if (ALIGN_ON_MOTOR) {		/* Saccade or arm movement	*/
	int Move;

	if (Register[0].stacknumber % 10 == 0) {	/* Arm trials	*/
	   extern int NoArmMovesBeforeThis;
	   NoArmMovesBeforeThis = SecondTargetTime;
	   Move = FindArmMove(0);
	 } else {				/* Eye + arm+eye trials	*/
#	   include "../sac.h"
#	   define IGNORE_IT	320000
	   extern int NoSacsBeforeThis;
	   extern int NoSacsAfterThis;
	   int HorizMove=IGNORE_IT, VertMove=IGNORE_IT;
	   float HorizSize=0., VertSize=0.;

	   NoSacsBeforeThis = SecondTargetTime;

	   if (DO_230s) {		/* Mem trials are special	*/
	      int AcquireCount = 1;
	      int AcquireTime, EarlierTime;

	      while (StackExtract(ACQUIRE, AcquireCount, TIME) != FAIL)
	         AcquireCount++;		/* Count acquires	*/	

	      AcquireTime = StackExtract(ACQUIRE, AcquireCount, TIME);

		/* Problem: can't find where the delay period ends
		   because we changed the stack many times (fix off, fix
		   blank, fix shrink).  Instead, look for the earliest
		   of a cluster of late acquires. */
	      for (;;) {	/* Find last of the final acquires	*/
	          EarlierTime = StackExtract(ACQUIRE, --AcquireCount, TIME);
	          if (AcquireTime - EarlierTime > 400)
	             break;	/* MUCH earlier - must be pre-delay!	*/
		  if (AcquireCount > 20)
		     fatal("jeffmac: acquire loop is bad!\n");
	          AcquireTime = EarlierTime;	/* Earlier is ~=: use it*/
	          }
	      
	      NoSacsBeforeThis = AcquireTime - 400; /* Ought to be - 100*/
	      NoSacsAfterThis  = AcquireTime + 200; /* Ought to be + 0	*/
	      }

     	   Set_CurrentChannel(OD_H);		/* Look in both chans	*/
	   if (FindSaccade(0) != FAIL) {
	      HorizMove = SaccadeData.begin;
   	      HorizSize = fabs(
	      	   AvgSomeData(0, SaccadeData.end, SaccadeData.end+30)-
   		   AvgSomeData(0, SaccadeData.begin-30, SaccadeData.begin));
	      }
     	   Set_CurrentChannel(OD_V);
	   if (FindSaccade(0) != FAIL) {
	      VertMove = SaccadeData.begin;
   	      VertSize = fabs(
	          AvgSomeData(0, SaccadeData.end, SaccadeData.end+30)-
   		  AvgSomeData(0, SaccadeData.begin-30, SaccadeData.begin));
	      }

	   if ((VertMove != FAIL && HorizMove != FAIL) &&
	       abs(HorizMove - VertMove) > 100) {  /* Two diff sacs?	*/
	      if (HorizSize > 3 * VertSize)	   /* Vert too small	*/
	          VertMove = IGNORE_IT;		   /* Disregard it	*/
	      if (VertSize > 3 * HorizSize) 	   /* Horiz too small	*/
	          HorizMove = IGNORE_IT;
	      }				/* Now take the earlier:	*/
	   Move = (HorizMove < VertMove) ? HorizMove : VertMove;
	   if (Move == IGNORE_IT)	/* Didn't find any?		*/
	       Move = FAIL;
	   }	  
	 if (Move == FAIL) {
	    fprintf(stderr, "Could not find saccade; skipping trial!\n");
	    continue;
	    }
	 ShiftReg(0, ALIGNMENT_TIME - Move);
     } else if (ALIGN_ON_FIRST == 1) {	/* Align on one of last 2 targs	*/
        if (DO_200s || DO_210s)
           DeleteAllData(0,		/* Clear data after 2nd target	*/
	    SecondTargetTime+50,
     	    StackExtract(TAPE_OFF,1,TIME));
        if (StackExtract(TAPE_OFF,1,TIME) == FAIL) {
	    fatal("Quitting!\n");
	    }
        ShiftReg(0, ALIGNMENT_TIME-FirstTargetTime);
      } else			/* Put last target at ALIGNMENT_TIME ms	*/
        ShiftReg(0, ALIGNMENT_TIME-SecondTargetTime);

     /* FOR GETTING OUTPUT DURING RUNNING OF MACRO: */
     if (PLOT_INDIVIDUALS) {
        static int count = 0;
        ChangeParameter('h', "140");
        ChangeParameter('w', "3000");
        ChangeParameter('s', "0");	/* ALIGNMENT_TIME	*/
        ChangeParameter('o', "67");
	ChangeParameter('b', "2");
	if (Register[0].stacknumber==232 && Register[0].classnumber==10) {
  	  extern void GraphLine(int i, int j);
   	  extern  int UseFilter;
	  int save = UseFilter;
	  UseFilter = 2;
	  if (count++ > 10) break;
          GraphLine(2600, 0);
          ChangeParameter('c', "R");
          ChangeParameter('t', "h");
	  Filter(0);
	  Filter(0);
	  GraphData(0);
          ChangeParameter('o', "33");
          ChangeParameter('c', "G");
          ChangeParameter('t', "v");
	  Filter(0);
	  Filter(0);
	  GraphData(0);
	  UseFilter = save;
	  }
        }

     AvgReg(0, Find_TrialType());		/* Determine type	*/

} while (Read_trial() != FAIL);			/* Next header		*/

if (DIFF_FILTER) {
   extern  int UseFilter;
   UseFilter = DIFF_FILTER;	/* Heavy filtering of difference traces	*/
   }


if (IN_MINUS_OUT) {
   int EyeStack = (DO_200s) ? 202 :
                  (DO_210s) ? 212 :
		  (DO_220s) ? 222 : 232;
   int ArmStack = (DO_200s) ? 200 :
                  (DO_210s) ? 210 :
		  (DO_220s) ? 220 : 230;

   for (i=1; i<=TO_SORT; i++)				/* Find empty	*/
      if (ContentReg(i) <= 0)
         break;
   if (i > TO_SORT - 2)			/* Need 2 empty slots	*/
      fatal("Need two extra registers for differences (A+E - A) [2]");
   if (DO_210s && ALIGN_ON_FIRST) {
      CopyReg(Find_Register(211,10), i);		/* First empty	*/
      SubtractReg(i, Find_Register(211,11));		/* In - out	*/
      Register[i].stacknumber = 300;			/* Diff stack	*/
      if (DIFF_FILTER)
         Filter(i);
    } else {
      CopyReg(Find_Register(EyeStack, 10), i);		/* First empty	*/
      SubtractReg(i, Find_Register(EyeStack,11));	/* In - out,eye	*/
      strcpy(Register[i].stackname, "In-out, eye");
      Register[i].stacknumber = 300;			/* Diff stack	*/
      Register[i].classnumber = 10;			/* Diff stack	*/
      if (DIFF_FILTER)
         Filter(i);

      i++;
      CopyReg(Find_Register(ArmStack, 10), i);		/* First empty	*/
      SubtractReg(i, Find_Register(ArmStack,11));	/* In - out,arm	*/
      strcpy(Register[i].stackname, "In-out, arm");
      Register[i].stacknumber = 300;			/* Diff stack	*/
      Register[i].classnumber = 11;			/* Diff stack	*/
      if (DIFF_FILTER)
         Filter(i);
      }
   }


if (ARM_MINUS_EYE) {
   int EyeStack = (DO_200s) ? 202 :
                  (DO_210s) ? 212 :
		  (DO_220s) ? 222 : 232;
   int ArmStack = (DO_200s) ? 200 :
                  (DO_210s) ? 210 :
		  (DO_220s) ? 220 : 230;

   for (i=1; i<=TO_SORT; i++)		/* For each trial type	*/
      if (ContentReg(i) <= 0)
         break;
   if (i > TO_SORT - 2)				/* Need 2 empty slots	*/
      fatal("Need two extra registers for differences (E - A) [1]");
   CopyReg(Find_Register(EyeStack, 10), i);		/* First empty	*/
   SubtractReg(i,   Find_Register(ArmStack,10));	/* E - A, pref	*/
   if (DIFF_FILTER)
      Filter(i);
   Register[i].stacknumber = 400;			/* Diff stack	*/
   Register[i].classnumber = 10;
   strcpy(Register[i].stackname, "Eye-arm, in");
   if (COLLAPSE_ACROSS_CLASSES==0 && USE_ONLY_ONE_CLASS==0) {
      i++;						/* Next empty	*/
      CopyReg(Find_Register(EyeStack, 11), i);		/* Null direct	*/
      SubtractReg(i, Find_Register(ArmStack,11));	/* E - A, null	*/
      Register[i].stacknumber = 400;			/* Diff stack	*/
      Register[i].classnumber = 11;
      strcpy(Register[i].stackname, "Eye-arm, out");
      if (DIFF_FILTER)
         Filter(i);
      }
   if (DOUBLE_SUBTRACT) {		/* Not sure when we use this	*/
      SubtractReg(i, i-1);
      strcpy(Register[i].stackname, "In-out AND arm-eye");
      }
   }


if (ONLY_EYE_AND_ARM_CELLS) {
   int NoCombinedTrials = 1;
   for (i=1; i<=TO_SORT; i++)			/* For each trial type	*/
    if (ContentReg(i) > 0)	/* (Empty regs may have stack numbers!)	*/
      if (Register[i].stacknumber%10 == 4) {
         NoCombinedTrials = 0;
         break;
	 }
   if (NoCombinedTrials) {
      Clean_Registers();
      return;					/* Skip remainder	*/
      }

   if (ARM_AND_EYE_MINUS_ARM) {
      int ArmEyeStack = (DO_200s) ? 204 :
			 (DO_210s)? 214 :
			 (DO_220s)? 224 : 234;
      int ArmStack =    (DO_200s) ? 200 :
			 (DO_210s)? 210 : 
			 (DO_220s)? 220 : 230;
      for (i=1; i<=TO_SORT; i++)		/* For each trial type	*/
         if (ContentReg(i) <= 0)
	    break;
      if (i > TO_SORT - 2)			/* Need 2 empty slots	*/
	 fatal("Need two extra registers for differences (A+E - A) [3]");
      CopyReg(Find_Register(ArmEyeStack, 10), i);	/* First empty	*/
      SubtractReg(i,   Find_Register(ArmStack,10));	/* A+E - A, pref*/
      if (DIFF_FILTER)
         Filter(i);
      Register[i].stacknumber += 1;			/* Diff stack	*/
      if (COLLAPSE_ACROSS_CLASSES == 0) {
         i++;						/* Next empty	*/
         CopyReg(Find_Register(ArmEyeStack, 11), i);	/* Null direct	*/
         SubtractReg(i, Find_Register(ArmStack,11));	/* A+E - A, null*/
         Register[i].stacknumber += 1;			/* Diff stack	*/
         if (DIFF_FILTER)
            Filter(i);
	 }
      }
   }

Tag_Registers();
if (NORMALIZE)
   Normalize_Registers();
if (OFFSET)
   Offset_Registers();
Avg_Registers();

/* FOR GETTING OUTPUT DURING RUNNING OF MACRO: */
if (PLOT_AVERAGED_CELLS) {
  extern void GraphLine(int i, int j);
   system("sleep 4");		/* Pause, then clear screen?	*/
   fprintf(stderr, "Unit %d has 'preferred' (direction %d) & null values of:\n",
	     					Header_Unit(), direction);
   fprintf(stderr, "    (pre:   %.1f   %.1f)\n",
   	     		AvgSomeData(Find_Register(211,10), 2300,2600),
       	     		AvgSomeData(Find_Register(211,11), 2300,2600));
   fprintf(stderr, "     post:  %.1f   %.1f\n",
   	     		AvgSomeData(Find_Register(211,10), 2700,2850),
       	     		AvgSomeData(Find_Register(211,11), 2700,2850));
   fprintf(stderr, "     post+: %.1f   %.1f\n",
   	     		AvgSomeData(Find_Register(211,10), 2800,3200),
       	     		AvgSomeData(Find_Register(211,11), 2800,3200));
   GraphErase();
   ChangeParameter('b', "3");
   ChangeParameter('o', "0");
   ChangeParameter('h', "80");
   ChangeParameter('w', "2000");
   ChangeParameter('s', "2100");
   ChangeParameter('t', "u");
   ChangeParameter('c', "R");
   GraphData(Find_Register(211,10));
   ChangeParameter('c', "G");
   GraphData(Find_Register(211,11));
   GraphLine(2600, 0);
   GraphLine(3700, 0);
   fflush(stdout);
   }
Clean_Registers();

if (WRITE_TO_DISK)
    Write_to_Disk();

if (DivergenceMacro) {
   DeleteData(25, 0,  ALIGNMENT_TIME - DELETE_MARGIN);
   DeleteData(26, 0,  ALIGNMENT_TIME - DELETE_MARGIN);
   fprintf(stderr, "%d\n", DivergeData(TO_SORT+1, TO_SORT+2));   
   }
}
/* ******************************************************************** */

/* FUNCTION Initialize_Stuff */
         /* Init */
static void Initialize_Stuff(void) {
   extern  int StepMs;				/* Differentiation stuff*/
   extern  int UseFilter;

   StepMs = 30;					/* Set up differentiator*/
   UseFilter = FILTER;
   }
/* ******************************************************************** */
/* ******************************************************************** */
/* ******************************************************************** */

/* FUNCTION Write_to_Disk */
	 /* Write to disk */
static void Write_to_Disk(void) {
   int i;

   for (i=TO_SORT+1; i<=TO_SORT*2; i++)
      if (ContentReg(i) > 0)
         RawFile(i);				/* Disk copies	*/
   }
/* ******************************************************************** */

/* FUNCTION Normalize_Registers */
	 /* Make'm look like 1 trial */
static void Normalize_Registers(void) {
	int i;
        for (i=1; i<=TO_SORT; i++)
	    NormalizeReg(i);
	}
/* ******************************************************************** */

/* FUNCTION Offset_Registers */
	 /* Offset so activity at 0 to 200 ms before align is at zero */
static void Offset_Registers(void) {
	int i;
        for (i=1; i<=TO_SORT; i++)
          if (Register[i].trial_count)			/* Not empty?	*/
	    OffsetData(i, AvgSomeData(i, ALIGNMENT_TIME-200, ALIGNMENT_TIME));
	}
/* ******************************************************************** */

/* FUNCTION mAx */ static int mAx(int *a, int *b) { return(*a>*b); }
/* ******************************************************************** */

/* FUNCTION Avg_Registers */
static void Avg_Registers(void) {
   int class[CLASSES_TO_SORT];
   int stack[STACKS_TO_SORT];
   int MaxClasses = 0;
   int MaxStacks = 0;
   int i,j;

   for (i=1; i<=TO_SORT; i++) {			/* For each trial type	*/
      if (Register[i].frame_count==0)		/* Unused register?	*/
         continue;				/* Skip it		*/

      for (j=0; j<MaxClasses; j++)		/* Look thru classes	*/
         if (class[j] == Register[i].classnumber)  /* Found this one?	*/
	    break;
      if (j==MaxClasses && Register[i].classnumber!=0)	/* Found new one*/
         class[MaxClasses++] = Register[i].classnumber;	/* Store as next*/

      for (j=0; j<MaxStacks; j++)		/* Look thru stacks	*/
         if (stack[j] == Register[i].stacknumber)  /* Found this one?	*/
	    break;
      if (j==MaxStacks && Register[i].stacknumber!=0)	/* Found new one*/
         stack[MaxStacks++] = Register[i].stacknumber;	/* Store as next*/
      }

   {
   /* Should be an eye+arm class, too; if not, will screw up the order */
   int CheckForStack = ((stack[0] / 10) * 10) + 4;	/* Arm+eye ??4 */
   for (i=0; i<MaxStacks; i++)
      if (stack[i] == CheckForStack)
         break;						/* Found it?	*/
   if (i >= MaxStacks)					/* No:		*/
      stack[MaxStacks++] = CheckForStack;		/*  Add it in	*/
   }

   if (MaxClasses > CLASSES_TO_SORT)
      fatal("CLASSES_TO_SORT is too small!");
   if (MaxStacks > STACKS_TO_SORT)
      fatal("STACKS_TO_SORT is too small!");

   qsort(class, MaxClasses, sizeof(int), (void *) mAx);
   qsort(stack, MaxStacks, sizeof(int), (void *) mAx);

   for (i=0; i<MaxStacks; i++)
      for (j=0; j<MaxClasses; j++) {
         AvgReg(Find_Register(stack[i], class[j]),
	 	TO_SORT + i*MaxClasses + j+1);
	 }
   }
/* ******************************************************************** */

/* FUNCTION Clean_Registers */
static void Clean_Registers() {
	int i;

	for (i=0; i<=TO_SORT; i++)
	    RemoveReg(i);
	}
/* ******************************************************************** */

/* FUNCTION Tag_Registers */
static void Tag_Registers(void) {
   	char newname[80];
	int i;

	for (i=0; i<MAX_REGISTERS; i++)
	     if (Register[i].trial_count > 0) {
	        sprintf(newname, "%d.%d %s",
		   Register[i].stacknumber,
		   Register[i].classnumber,
   	           (DO_210s && ALIGN_ON_FIRST) ? "all" : Register[i].stackname);
	        MacroTagReg(i, newname);
	        if (PRINT_REGISTER_NAMES)
	           fprintf(stderr, "  %d: %d.%d %s\n", i,
		      Register[i].stacknumber,
		      Register[i].classnumber,
		      Register[i].stackname);
	        }
	}
/* ******************************************************************** */

/* FUNCTION Find_Register */
	 /* Find register with given stack, class */
static int Find_Register(int stack, int class) {
	int i;

	for (i=1; i<=TO_SORT; i++)
            if (stack == Register[i].stacknumber
	    				&& class==Register[i].classnumber)
	       return(i);
	return(99);			/* Not found or out of room	*/
	}
/* ******************************************************************** */

/* FUNCTION Find_TrialType */
	 /* Return index of this trial in Class[]	*/
static int  Find_TrialType(void) {
    int i;
    int stack = Register[0].stacknumber;
    int class = Register[0].classnumber;

    for (i=1; i<=TO_SORT; i++) {
       if (Register[i].trial_count <= 0)		/* Empty?	*/
	  return(i);					/*  Use it	*/
        else						/* Else: match?	*/
        if (stack == Register[i].stacknumber && class==Register[i].classnumber)
	  return(i); 
       }
    return(99);
    }
/* ********************************************************************	*/
