/* FILE harrysort.c	*/
     /* Sort trials in current file */

#include "../defs.h"
#include "../array.h"       		/* Access registers directly	*/
#include "../_imports/deffs.h"
#include "../_imports/event.h"       	/* Stack instruction definitions*/
 
#define SEE_ERRORS	0		/* Special case			*/

#define SPECIAL		0		/* For getting pop tuning	*/
					/* Will look +/- this distance	*/
#if (SEE_ERRORS == 0)
#  define PREF_WIDTH	22.5		/* 11.25 22.5 [5 for Rel.Ghost/Shift]*/
#  define NULL_WIDTH	90		/* 22.5 90 [95 for Rel.Ghost/Shift]*/
#else
	/*  For plots of failed trials, open up to get more trials:	*/
#  define PREF_WIDTH	45.   		/* [45]				*/
#  define NULL_WIDTH	60.   		/* [60.0]			*/
#endif

static int NORMALIZE_RATE =	0;	/* Puts max firing rate == 100	*/
static int NORMALIZE_TRIALS =	1;	/* Normalize to 1 trial?	*/
static float DIRECTION_BIN_SIZE = 45.;	/* Should be: 180 % SIZE == 0	*/
	/* For continuous, uses bins of half this to either side!	*/
	/* Same convention for ROUND_BIN_LOCATIONS, so may want to halve*/

static int ALIGN_TIME =		5000;
static int ALIGN_ON_TARGET =	1;	/* 0:go cue  2: saccade 3:reward*/
static int SORT_BY_TARGET =	1;	/* 0:Sac;2:PrevTarg;-1:Class;etc*/
static int WARN_LOW_N =		0;	/* 0 or warn if trials < ~	*/
static int SKIP_LOW_N =		0;	/* 0 or skip if trials < ~	*/
static int JUST_ONE_STACK =	0;	/* 0 or else stack # 		*/
		/* Affects current if SORT_BY_TARGET is 0|1, else prev	*/
static int CURRENT_STACK = 	0;	/* Only use trials with this	*/
static int PREV_STACK = 	0;	/* Only use trials with this	*/
static int INTERVAL_START =	6000;	/* Must include align time!	*/
static int INTERVAL_END =	7000;
static int PLOT_INDIVIDUALS =	0;	/* Plot the individual files?	*/
static int ROUND_BIN_LOCATIONS=	0;	/* If binned targs,round 'away'!*/
static int TRUNCATE =		0;	/* From truncate to end		*/
static char AREA = 		'A';	/* Select:Any,FEF,DLPFC,Border	*/
static int MIN_OFF =		0;	/* Select by offtime		*/
static int MAX_OFF =		0;	/* Select by offtime		*/

#define DO_EYES 		SEE_ERRORS	/* Slows us down	*/
#define VERBOSE			1		/* -1,0,1		*/
#define SHOW_EACH_VALUE		0		/* One line per cell	*/
/* ******************************************************************** */

/* NOT A PARAMETER -- SET SORT_BY_TARGET TO THIS VALUE FOR SORT BY CLASS*/
#define BY_CLASS	-1	/* Do not change to a positive number!	*/
/* ******************************************************************** */
static double sum = 0.;
static double sum2 = 0.;
static int    sumN = 0;

/* FUNCTION set_Harry_sort_macro() */
void set_Harry_sort_macro(char *cmdline) {  
     char name[255] = "";
     char value_string[20];
     float value;

     sscanf(cmdline, "%s %s", name, value_string);
     value = atof(value_string);

     if (strcmp(name, "NormalizeRate") == 0) {
	 NORMALIZE_RATE = (value != 0);
	 fprintf(stderr, "Normalize rate = %d\n", NORMALIZE_RATE);
     } else if (strcmp(name, "NormalizeTrials") == 0) {
	 NORMALIZE_TRIALS = value;  /* (value != 0); */
	 fprintf(stderr, "Normalize trials = %d\n", NORMALIZE_TRIALS);
     } else if (strcmp(name, "IntervalStart") == 0) {
	 INTERVAL_START = value;
	 fprintf(stderr, "Interval start = %d\n", INTERVAL_START);
     } else if (strcmp(name, "IntervalEnd") == 0) {
	 INTERVAL_END = value;
	 fprintf(stderr, "Interval end = %d\n", INTERVAL_END);
     } else if (strcmp(name, "WarnLowN") == 0) {
	 WARN_LOW_N = value;
	 fprintf(stderr, "Warn low N = %d\n", WARN_LOW_N);
     } else if (strcmp(name, "SkipLowN") == 0) {
	 SKIP_LOW_N = value;
	 fprintf(stderr, "Skip low N = %d\n", SKIP_LOW_N);
     } else if (strcmp(name, "JustOneStack") == 0) {
	 JUST_ONE_STACK = value;
	 fprintf(stderr, "Just one stack = %d\n", JUST_ONE_STACK);
     } else if (strcmp(name, "CurrentStack") == 0) {
	 CURRENT_STACK = value;
	 fprintf(stderr, "Current Stack one stack = %d\n", CURRENT_STACK);
     } else if (strcmp(name, "PrevStack") == 0) {
	 PREV_STACK = value;
	 fprintf(stderr, "Prev Stack = %d\n", PREV_STACK);
     } else if (strcmp(name, "SortByTarget") == 0) {
	 SORT_BY_TARGET = value;
	 fprintf(stderr, "Sort by target = %d\n", SORT_BY_TARGET);
     } else if (strcmp(name, "DirectionBinSize") == 0) {
	 DIRECTION_BIN_SIZE = value;
	 fprintf(stderr, "Direction Bin Size = %.2f\n", DIRECTION_BIN_SIZE);
     } else if (strcmp(name, "AlignTime") == 0) {
	 ALIGN_TIME = value;
	 fprintf(stderr, "Align time = %d\n", ALIGN_TIME);
     } else if (strcmp(name, "AlignOnTarget") == 0) {
	 ALIGN_ON_TARGET = value;
	 fprintf(stderr, "Align on target = %d\n", ALIGN_ON_TARGET);
     } else if (strcmp(name, "PlotIndividuals") == 0) {
	 PLOT_INDIVIDUALS = value;
	 fprintf(stderr, "Plot individual traces = %d\n", PLOT_INDIVIDUALS);
     } else if (strcmp(name, "RoundBinLocations") == 0) {
	 ROUND_BIN_LOCATIONS = value;
	 fprintf(stderr, "Round Bin Locations = %d\n", ROUND_BIN_LOCATIONS);
     } else if (strcmp(name, "Truncate") == 0) {
	 TRUNCATE = value;
	 fprintf(stderr, "Truncate = %d\n", TRUNCATE);
     } else if (strcmp(name, "MinOffTime") == 0) {
	 MIN_OFF = value;
	 fprintf(stderr, "Min off time = %d\n", MIN_OFF);
     } else if (strcmp(name, "MaxOffTime") == 0) {
	 MAX_OFF = value;
	 fprintf(stderr, "Max off time = %d\n", MAX_OFF);
     } else if (strcmp(name, "Area") == 0) {
	 AREA = value_string[0];
	 fprintf(stderr, "Area = %c\n", AREA);
     } else
	 fprintf(stderr, "WARNING: unknown parameter (set_Harry_Sort_Macro)\n");

     if (NORMALIZE_RATE && (ALIGN_ON_TARGET==0))
	 fatal("Must rewrite 'normalize_rate' to work with go cue alignment");
     }
/* ******************************************************************** */

/* FUNCTION end_Harry_sort_macro() */
void end_Harry_sort_macro() {  
       fprintf(stderr, "Mean = %.2f (%d to %d ms",
		sum/sumN, INTERVAL_START, INTERVAL_END);
       if (sumN > 1)
          fprintf(stderr, ", sd=%.2f, se=%.3f p=%.3f n=%d",
		sqrt(fabs(sum2 - sum*sum/sumN)/(sumN-1)),
		sqrt(fabs(sum2 - sum*sum/sumN)/(sumN-1)) / sqrt(sumN),
		Ttest_short(sum/sumN, sumN, 
		     sqrt(fabs(sum2 - sum*sum/sumN)/(sumN-1)) / sqrt(sumN),
		     0.,0.,0,
		     2),
		sumN);
       fprintf(stderr, ")\n");
       }
/* ******************************************************************** */

/* FUNCTION Harry_sort_macro() */
	 /* Sort shifted trials */
void Harry_sort_macro(int unit, int pref, int off_time, 
		      int from, int to, char area) {
#  if DO_EYES
   extern int DiffChannel;			/* diff.c		*/
#  endif
   extern  int StepMs;				/* Differentiation stuff*/
   extern  int UseFilter;
   int i;
   int flag = 0;
   double SaveAngle = 0;
   int Save_trial = -9999;
   int Save_stack = -9999;
   int null = 0;				/* Compute null direction*/
   double PrefAngle = 0;

if (AREA != 'A')
   if (AREA != area)
       return;
if (MIN_OFF != 0)
   if (off_time < MIN_OFF)
      return;
if (MAX_OFF != 0)
   if (off_time > MAX_OFF)
      return;

Set_CurrentChannel(UNIT);
if (unit != 0) {			/* Move 2nd chan into 1st chan	*/
   Set_CurrentChannel(SPIKE_2);	
   ChannelDataTransfer(0, UNIT);
   }

if (pref == -1) {				/* Find it yourself!	*/
   double Rates[16];
   double Rates2[16];
   int    Trials[16];
   double MaxRate = 0;
   int spikes[16][80];
   double sum_h=0., sum_v=0.;

   if (SORT_BY_TARGET==BY_CLASS)
      fatal("Finding pref direction not coded for sort BY_CLASS!\n");

   for (i=0; i<16; i++) { 
       int j;
       Rates[i] = Rates2[i] = 0.; 
       Trials[i] = 0;
       for (j=0; j<80; j++)
	   spikes[i][j] = 0;
       }

   do {
       int TargetTime = StackExtract(TARGET_RE_1_POLAR, 1, TIME);
       double Fixate_H = StackExtract(TARGET_ON, 1, TWO) / 10.;
       double Fixate_V = StackExtract(TARGET_ON, 1, THREE) / 10.;
       double Target_H = StackExtract(TARGET_RE_1_POLAR, 1, TWO) / 10.;
       double Target_V = StackExtract(TARGET_RE_1_POLAR, 1, THREE) / 10.;
       double TargetAngle;
       double rate;
       int this_bin;

       if (TargetTime == FAIL) {
           TargetTime = StackExtract(TARGET_ON_POLAR, 1, TIME);
           Target_H = StackExtract(TARGET_ON_POLAR, 1, TWO) / 10.;
           Target_V = StackExtract(TARGET_ON_POLAR, 1, THREE) / 10.;
	   }
       if (TargetTime == FAIL) {
           TargetTime = StackExtract(TARGET_RE_2_POLAR, 1, TIME);
           Target_H = StackExtract(TARGET_RE_2_POLAR, 1, TWO) / 10.;
           Target_V = StackExtract(TARGET_RE_2_POLAR, 1, THREE) / 10.;
	   }
       if (TargetTime == FAIL) {
           TargetTime = StackExtract(TARGET_RE_1, 1, TIME);
           Target_H = StackExtract(TARGET_RE_1, 1, TWO) / 10.;
           Target_V = StackExtract(TARGET_RE_1, 1, THREE) / 10.;
	   }
       if (TargetTime == FAIL) {
           TargetTime = StackExtract(TARGET_ON, 2, TIME);
           Target_H = StackExtract(TARGET_ON, 2, TWO) / 10.;
           Target_V = StackExtract(TARGET_ON, 2, THREE) / 10.;
	   }
       if (TargetTime == FAIL || Fixate_H == FAIL) {
	   fprintf(stderr, "Not finding the right events!\n");
   	   return;
   	   }

       rate = AvgSomeData(0, TargetTime+400, TargetTime+800);

       sum_h += (Target_H-Fixate_H) * rate;
       sum_v += (Target_V-Fixate_V) * rate;

       TargetAngle = 
	     atan2(Target_V-Fixate_V, Target_H-Fixate_H) * (360/2/3.14);
       if (TargetAngle < 0.)
	   TargetAngle += 360.;

       this_bin = (int)round(TargetAngle / DIRECTION_BIN_SIZE);

       spikes[this_bin][Trials[this_bin]] = (int)round(rate*100); /* x 100 */
       		/* t test wants integers; multiply by 100 to keep signif */
       Rates [this_bin] += rate;
       Rates2[this_bin] += rate * rate;
       Trials[this_bin]++;
     } while (Read_trial() != FAIL);		/* Next header		*/

   for (i=0; i<16; i++)
       if ((Trials[i] > 0) && ((Rates[i]/Trials[i]) > MaxRate)) {
          MaxRate = Rates[i]/Trials[i];
	  pref = i;
          }
   PrefAngle = atan2(sum_v, sum_h) * (360/2/3.14);
   ReRead_file();

   if (DIRECTION_BIN_SIZE == 45) {
       null = (pref + 4) % 8;


       int null_plus_one = (pref+5) % 8;
       int null_minus_one = (pref+3) % 8;

       for (i=0; i<Trials[null_plus_one]; i++)
           spikes[null][Trials[null] + i] = spikes[null_plus_one][i];
       Trials[null] += Trials[null_plus_one];
       Rates [null] += Rates [null_plus_one];
       Rates2[null] += Rates2[null_plus_one];

       for (i=0; i<Trials[null_minus_one]; i++)
           spikes[null][Trials[null] + i] = spikes[null_minus_one][i];
       Trials[null] += Trials[null_minus_one];
       Rates [null] += Rates [null_minus_one];
       Rates2[null] += Rates2[null_minus_one];

       int pref_plus_one  = (8+pref+1) % 8;	/* Added 8 2020-10-09 LHS */
       int pref_minus_one = (8+pref-1) % 8;
       for (i=0; i<Trials[pref_plus_one]; i++)
           spikes[pref][Trials[pref] + i] = spikes[pref_plus_one][i];
       Trials[pref] += Trials[pref_plus_one];
       Rates [pref] += Rates [pref_plus_one];
       Rates2[pref] += Rates2[pref_plus_one];
       for (i=0; i<Trials[pref_minus_one]; i++)
           spikes[pref][Trials[pref] + i] = spikes[pref_minus_one][i];
       Trials[pref] += Trials[pref_minus_one];
       Rates [pref] += Rates [pref_minus_one];
       Rates2[pref] += Rates2[pref_minus_one];
       }
     else
       {
       fprintf(stderr, "Check if this is a 22.5 deg bin size\n");
       null = (pref + 8) % 16;
       }

    if (VERBOSE > 0)
     fprintf(stderr, "Pref = %.1f (%.1f) deg, mem = %.1f sp/s (n=%d,%d)\n", 
    	   PrefAngle,
    	   pref*DIRECTION_BIN_SIZE,
    	   MaxRate - Rates[null]/Trials[null],
         Trials[pref], Trials[null]);

   if (Trials[pref] < 3 || Trials[null] < 3 ||
       (Ttest(			/* Good (large, signif) mem activity	*/
	&(spikes[pref][0]), Trials[pref], 
	&(spikes[null][0]), Trials[null], 
	2) > .10) ||
        (MaxRate - Rates[null]/Trials[null] < 0.001)) {
      if (VERBOSE > -1)
       fprintf(stderr, "Skip unit (poor memory) (pval is %.3f)\n", 
        Ttest( &(spikes[pref][0]), Trials[pref], 
	       &(spikes[null][0]), Trials[null], 2));
      return;
      }

   pref = pref * DIRECTION_BIN_SIZE;
   if (pref > 180)
       pref -= 360;
  } else {					/* End of find pref/null*/
   PrefAngle = pref;				/* 2020-10-09 LHS	*/
   if (VERBOSE > 0)
      fprintf(stderr, "Pref = %d deg\n", pref);
   }

StepMs = 1;					/* Set up differentiator*/

if ((ALIGN_ON_TARGET == 0) && (JUST_ONE_STACK == 0))
   fprintf(stderr, "Warning: bad policy to mix stacks when aligned on go\n");
if (180/DIRECTION_BIN_SIZE > 18)
   fprintf(stderr, "FIX CODE TO HANDLE SMALL BINS - IGNORE RESULTS!\n");
if (ContentReg(19+29) < 1)			/* Do just once		*/
   fprintf(stderr, "Bin size = %.1f deg    Normalization %s\n",
		(float)DIRECTION_BIN_SIZE, (NORMALIZE_RATE) ? "on" : "off");

if (PLOT_INDIVIDUALS) {
   extern void GraphLine(int i, int j);
   char value[80];
   sprintf(value, "%d", ALIGN_TIME-1000);
   ChangeParameter('h', "80");
   ChangeParameter('o', "0");
   ChangeParameter('w', "15000");
   ChangeParameter('s', value);
   ChangeParameter('b', "4");
   ChangeParameter('c', "R");
   ChangeParameter('t', "u");
   GraphLine(ALIGN_TIME, 0);
   }


do {						/* Next trial or header	*/
   int TargetTime = StackExtract(TARGET_RE_1_POLAR, 1, TIME);
   int UnBlankTime = StackExtract(TARGET_BLANK, 3, TIME);	/* unblank */
   int BlankTime = StackExtract(TARGET_BLANK, 2, TIME);		/* blank   */
   int RewardTime = StackExtract(REWARD, 1, TIME);
   double Fixate_H = StackExtract(TARGET_ON, 1, TWO) / 10.;
   double Fixate_V = StackExtract(TARGET_ON, 1, THREE) / 10.;
   double Target_H = StackExtract(TARGET_RE_1_POLAR, 1, TWO) / 10.;
   double Target_V = StackExtract(TARGET_RE_1_POLAR, 1, THREE) / 10.;
   double CurrentRePref = -9999;
   double PrevAngle = -9999;
   double DeltaAngle = -9999;
   double away;		/* How far from pref direction in BIN_SIZE units*/
   int SortFlag = 0;

   if (SORT_BY_TARGET <= 1 && JUST_ONE_STACK)	/* Includes sort by class */
      if (Register[0].stacknumber != JUST_ONE_STACK)
         continue;

#ifdef COMBINE_61_and_65
   if (Register[0].stacknumber == 65) {
       Register[0].stacknumber = 61;
       fprintf(stderr, "converting 65 to 61\n");
       }
   if (Register[0].stacknumber != 61)
       fprintf(stderr, "\t\t\t\t\t\t%d\n", Register[0].stacknumber);
#endif

   if ((CURRENT_STACK > 0) && (Register[0].stacknumber != CURRENT_STACK))
      continue;
   if ((CURRENT_STACK < 0) &&
	  ((Register[0].stacknumber % 100) != -CURRENT_STACK))
      continue;

   if (TargetTime == FAIL) {
       TargetTime = StackExtract(TARGET_ON_POLAR, 1, TIME);
       Target_H = StackExtract(TARGET_ON_POLAR, 1, TWO) / 10.;
       Target_V = StackExtract(TARGET_ON_POLAR, 1, THREE) / 10.;
       }
   if (TargetTime == FAIL) {
       TargetTime = StackExtract(TARGET_RE_2_POLAR, 1, TIME);
       Target_H = StackExtract(TARGET_RE_2_POLAR, 1, TWO) / 10.;
       Target_V = StackExtract(TARGET_RE_2_POLAR, 1, THREE) / 10.;
       }
   if (TargetTime == FAIL) {
       TargetTime = StackExtract(TARGET_RE_1, 1, TIME);
       Target_H = StackExtract(TARGET_RE_1, 1, TWO) / 10.;
       Target_V = StackExtract(TARGET_RE_1, 1, THREE) / 10.;
       }
   if (TargetTime == FAIL) {
       TargetTime = StackExtract(TARGET_ON, 2, TIME);
       Target_H = StackExtract(TARGET_ON, 2, TWO) / 10.;
       Target_V = StackExtract(TARGET_ON, 2, THREE) / 10.;
       }
  
   {				/* Do we not blank the fixation point?	*/
   int k;
   for (k=1; k<12; k++)				/* Do we shrink it?	*/
       if ((StackExtract(TARGET_SIZE,k,TIME) > 0) && 	/* OLD DATA!	*/
	   (abs(StackExtract(TARGET_SIZE, k, TWO)) < 3))
	  break;
   if (k < 12) {
      BlankTime = StackExtract(TARGET_SIZE, k, TIME);	/* Shrink time	*/
      if (StackExtract(TARGET_REDRAW, 1, TIME) > BlankTime)
         BlankTime = StackExtract(TARGET_REDRAW, 1, TIME);
       else if (StackExtract(TARGET_REDRAW, 2, TIME) > BlankTime)
         BlankTime = StackExtract(TARGET_REDRAW, 2, TIME);
    } else
    if (UnBlankTime == FAIL) {			/* Do we turn it off?	*/
       UnBlankTime = BlankTime;
       BlankTime = StackExtract(TARGET_OFF, 1, TIME);/* other stacks	*/
       flag = 1;
       }
   }

   if (SORT_BY_TARGET > 1) {		/* Sort by PREVIOUS re: pref	*/
      PrevAngle = SaveAngle;		/* Hold on to this for cases 3-6*/
      DeltaAngle = PrevAngle - pref; 	/* How far is prev from pref?	*/
      if (DeltaAngle >   180) DeltaAngle -= 360;/* & unwrap,since - pref*/
      if (DeltaAngle <= -180) DeltaAngle += 360;
      SaveAngle = atan2(Target_V-Fixate_V, Target_H-Fixate_H) * (360/2/3.14);

      if ((Header_Trial() - Save_trial) != 1) {	/* If Save_trial==-9999	*/
         Save_trial = Header_Trial();		/*  or an error		*/
         continue;
         }
      Save_trial = Header_Trial();
      }

   if (SORT_BY_TARGET > 2) {		/* Look at current re: pref	*/
      CurrentRePref = SaveAngle - pref;	/* Subtraction, so must unwrap	*/
      if (CurrentRePref >   180) CurrentRePref -= 360;
      if (CurrentRePref <= -180) CurrentRePref += 360;
      }

   switch (SORT_BY_TARGET) {
	case 0: {
	   double x,y;
           if (flag==0 && (StackExtract(TARGET_BLANK, 3, THREE) != 0))
              fprintf(stderr, "Check alignment for saccade endpoint!\n");
           Set_CurrentChannel(OD_H);
           x = AvgSomeData(0, UnBlankTime - 50, UnBlankTime + 50) - Fixate_H;
           Set_CurrentChannel(OD_V);
           y = AvgSomeData(0, UnBlankTime - 50, UnBlankTime + 50) - Fixate_V;
           Set_CurrentChannel(UNIT);

           if ((fabs(x - (Target_H-Fixate_H)) > 10) || 
               (fabs(y - (Target_V-Fixate_H)) > 10))
              fprintf(stderr, "Error > 10 deg (?)\n");

	   DeltaAngle = atan2(y,x) * 360/2/3.14159 - pref;
           if (DeltaAngle >   180) DeltaAngle -= 360;/* & unwrap,since - pref*/
           if (DeltaAngle <= -180) DeltaAngle += 360;
	   }
	   break;

	case BY_CLASS: /* -1 */
	   break;

	case 1:
	    /* 
            DeltaAngle = 
	     atan2(Target_V-Fixate_V, Target_H-Fixate_H) * (360/2/3.14) - pref;
	     */
            DeltaAngle =  /* Used to use a rounded verion; here is true angle:*/
	     atan2(Target_V-Fixate_V, Target_H-Fixate_H) * (360/2/3.14) - PrefAngle;
            if (DeltaAngle >   180) DeltaAngle -= 360;/* & unwrap,since - pref*/
            if (DeltaAngle <= -180) DeltaAngle += 360;
	    break;

	case 3:		/* Skip if current near pref	*/
	    		/* This lets us include more trials in the null */
	    		/* so we lose way less cells due to no data as */
	    		/* compared to case 12, whcih enforces P-C is large */
	    		/* for the 'null' instead of only the 'preferred' */
	    if (fabs(CurrentRePref) <= 90)
	       continue;
	    break;
	case 4:				/* Skip if current NOT near pref*/
	    if (fabs(CurrentRePref) >  90)
	       continue;
	    break;

	case 5: { /* Skip current close to pref & previous on same side	*/
		  /* Skip current close to pref & previous on OPP side	*/
	    float c_range1,c_range2,p_range1,p_range2,p_range3,p_range4;
	    c_range1 = 0;  /* [20,0] Smallest current target		*/
	    c_range2 = 50; /* [70,50] Largest  current target		*/
	    p_range1 = 0;  /* [20,0] Smallest prev target for pref direction */
	    p_range2 = 30; /* [50,30] Largest  prev target for pref direction */
	    p_range3 = 150;/* [50,150] Smallest prev target for nul direction */
	    p_range4 = 185;/* [115,185] Largest prev target for nul direction */	    
	    				/* DeltaAngle is PreviousRePref	*/
	    if ((CurrentRePref > c_range1 && CurrentRePref < c_range2 && 
	            DeltaAngle < -p_range1 && DeltaAngle > -p_range2)
		|| (CurrentRePref < -c_range1 && CurrentRePref > -c_range2 && 
	            DeltaAngle > p_range1 && DeltaAngle < p_range2))
	      SortFlag = 1;
	    else if ((CurrentRePref > c_range1 && CurrentRePref < c_range2 && 
	            DeltaAngle > p_range3 && DeltaAngle < p_range4)
		|| (CurrentRePref < -c_range1 && CurrentRePref > -c_range2 && 
	            DeltaAngle < -p_range3 && DeltaAngle > -p_range4))
	      SortFlag = 2;
	    else
		continue;
	    }
	    break;
	case 6:      /* X axis */                /* Y axis */
	    if ((fabs(CurrentRePref+135) < 5) && (fabs(DeltaAngle-0) < 5))
	       SortFlag = 1;				/* RED		*/
	     else if ((fabs(CurrentRePref+135)<5) && (fabs(DeltaAngle-45) < 5))
	       SortFlag = 2;				/* GREEN	*/
	     else
		continue;
	    break;
	case 7: /* Same as 5 but for data that only has pref and null*/
	    	/* RED(#48):Pref->Pref GREEN(#49):Null->Pref (Prev->Current)*/
	    if ((fabs(CurrentRePref) >= 0 && fabs(CurrentRePref) <= 30 && 
	            fabs(DeltaAngle) >= 0 && fabs(DeltaAngle) <= 30))
	      SortFlag = 1;
	    else if ((fabs(CurrentRePref) >= 0 && fabs(CurrentRePref) <= 30 && 
	            fabs(DeltaAngle) >= 150 && fabs(DeltaAngle) <= 180))
	      SortFlag = 2;
	    else
		continue;
	    break;
	case 8: /* Same as 7 but uses different limits	*/
	    if (fabs(CurrentRePref) <= 50 && 
		fabs(DeltaAngle)    <= 50)
	      SortFlag = 1;
	    else 
	    if (fabs(CurrentRePref) <= 50 && 
	        fabs(DeltaAngle)    >= (180-90))
	      SortFlag = 2;
	    else
		continue;
	    break;
	case 9: /* Same as 7 but uses PREF and NULL to set limits	*/
	    if (fabs(CurrentRePref) <= PREF_WIDTH && 
		fabs(DeltaAngle)    <= PREF_WIDTH)
	      SortFlag = 1;
	    else 
	    if (fabs(CurrentRePref) <= PREF_WIDTH && 
	        fabs(DeltaAngle)    >= (180-NULL_WIDTH))
	      SortFlag = 2;
	    else
		continue;
	    break;

	case 10: {	/* To measure shift, split into trials with current */
	    		/* near preferred, and previous not too far away    */
		    	/* Positive firing rate difference is neurons moving*/
			/* toward previous target, and therefore population */
			/* moving away*/
	    float
	    prev_from_current = 90, /* prev no farther than x from current  */
	    c_range1 = 20,	/* Smallest current re: pref	*/
	    c_range2 = 70;	/* Farthest current re: pref	*/
	    			/* DeltaAngle is PreviousRePref	*/
	    float PminusC = DeltaAngle - CurrentRePref;
	    if (PminusC >   180) PminusC -= 360;
	    if (PminusC <= -180) PminusC += 360;

	    if ((CurrentRePref > c_range1 && CurrentRePref < c_range2 && 
	         PminusC > 0 && PminusC < prev_from_current)
		|| (CurrentRePref < -c_range1 && CurrentRePref > -c_range2 && 
	            PminusC < 0 && PminusC > -prev_from_current))
	      SortFlag = 1;  
	    else if ((CurrentRePref < -c_range1 && CurrentRePref > -c_range2 && 
	         PminusC > 0 && PminusC < prev_from_current)
		|| (CurrentRePref > c_range1 && CurrentRePref < c_range2 && 
	            PminusC < 0 && PminusC > -prev_from_current))
	      SortFlag = 2;
	    else
		continue;
	    }
	    break;
	
	case 11: {	/* To measure shift of main bump, but in ghost trials */
			/* See 10 */
	    float
	    prev_from_current = 90, /* prev no farther than x from current */
	    c_range1 = 20,	/* Smallest current re: pref	*/
	    c_range2 = 70;	/* Farthest current re: pref	*/
	    			/* DeltaAngle is PreviousRePref	*/
	    float PminusC = DeltaAngle - CurrentRePref;
	    if (PminusC >   180) PminusC -= 360;
	    if (PminusC <= -180) PminusC += 360;

	    if ((CurrentRePref > c_range1 && CurrentRePref < c_range2 && 
	         PminusC > prev_from_current)
		|| (CurrentRePref < -c_range1 && CurrentRePref > -c_range2 && 
	            PminusC < -prev_from_current))
	      SortFlag = 1;  
	    else if ((CurrentRePref < -c_range1 && CurrentRePref > -c_range2 && 
	         PminusC > prev_from_current)
		|| (CurrentRePref > c_range1 && CurrentRePref < c_range2 && 
	            PminusC < -prev_from_current))
	      SortFlag = 2;
	    else
		continue;
	    }
	    break;
	case 12: {	/* Ghost Over Time - Alternate method to case 3 */
	    float
	    prev_from_current = 70,
	    p_range1 = 20,
	    p_range2 = 95;
	    float PminusC = DeltaAngle - CurrentRePref;
	    if (PminusC >   180) PminusC -= 360;
	    if (PminusC <= -180) PminusC += 360;

	    if ((fabs(DeltaAngle) < p_range1 && 
	         fabs(PminusC) > prev_from_current && fabs(CurrentRePref) > 90))
	      SortFlag = 1;  
	    else if ((fabs(DeltaAngle) > p_range2 && 
	         fabs(PminusC) > prev_from_current && fabs(CurrentRePref) > 90))
	      SortFlag = 2;
	    else
		continue;
	    }
	    break;
	case 13: {	/* Look at conditions that should have NO shift or ghost
			   but might still have a change in firing rate */
	    float range1 = 30,
		  range2 = 145;
	    if ((fabs(CurrentRePref) <= range1 && fabs(DeltaAngle) <= range1))
	      SortFlag = 1;
	    else if ((fabs(CurrentRePref) <= range1 && fabs(DeltaAngle) >= range2))
	      SortFlag = 2;
	    else
		continue;
		
	    }
	    break;
        }
   	


    if (SORT_BY_TARGET > 1 && JUST_ONE_STACK) {
       if (Save_stack != JUST_ONE_STACK) {	/* PREVIOUS stack!	*/
          Save_stack = Register[0].stacknumber;	/* Save for next time	*/
          continue;				/* Exclude these!	*/
	  }
       }
   if (PREV_STACK && 
	 ((Save_stack != PREV_STACK) &&
	 (PREV_STACK < 0 &&
	    ((Save_stack % 100) != -PREV_STACK)))) {
       Save_stack = Register[0].stacknumber;	/* Save for next time	*/
       continue;
       }
    Save_stack = Register[0].stacknumber;	/* Save for next time	*/
    if (Header_Trial() >= from && Header_Trial() <= to)
       continue;				/* Exclude these!	*/

#  if DO_EYES
   UseFilter = 8;				/* 2, 8, 12, etc	*/
   Set_CurrentChannel(OD_H);
   Filter(0);
   RectifyData(0);
   DiffChannel = H_VEL;
   Differentiate(0);

   Set_CurrentChannel(OD_V);
   Filter(0);
   RectifyData(0);
   DiffChannel = V_VEL;
   Differentiate(0);

   Set_CurrentChannel(X3);      /* Posit amplitude into X3, veloc -> X4 */
   ComputeAmplitudesData(0);

   Set_CurrentChannel(UNIT);
#  endif

#  ifdef WE_NOW_DO_THIS_TRANSFER_ABOVE
   if (unit != 0) {			/* Move 2nd chan into 1st chan	*/
      Set_CurrentChannel(SPIKE_2);	/* Changed on 04-02-2015	*/
      ChannelDataTransfer(0, UNIT);
      }
#  endif
   if (PLOT_INDIVIDUALS)		/* Before you filter,		*/
      AvgReg(0, 60);			/* Collect all the trials	*/
   Set_CurrentChannel(UNIT);		/* Filter indis: SE is smooth	*/

   UseFilter = (PLOT_INDIVIDUALS)? 251 : /* 250,500,1,2,4,8,16,32,64	*/
   // 64;
   // 16;
   //  8;			/* Was this LHS */
   // 4;
   // 2;
     1;			/* DEFAULT */
   // 500;
   // 250;

   if (ALIGN_ON_TARGET == 3)		/* 1st reward			*/
      UseFilter = 8;

   /* UseFilter = 8; /* DIAG */

#if SEE_ERRORS
   UseFilter = 500;
   Filter(0);				 /* Double filter!		*/
#endif

   Filter(0);

   if (ALIGN_ON_TARGET == 1) {
      DeleteData(0,				/* Rm data after go cue	*/
		 BlankTime,
		 Register[0].frame_count + 1000);  /* +1000: Insurance?	*/
      ShiftReg(0,ALIGN_TIME - TargetTime);
    } else if (ALIGN_ON_TARGET == 0) {		/* Align on go-cue	*/
      if (TargetTime == FAIL || BlankTime == FAIL)
         continue;
      DeleteData(0, 0, TargetTime+500);   /* Sac align:rm early data	*/
      ShiftReg(0,ALIGN_TIME - BlankTime);
    } else if (ALIGN_ON_TARGET == 3) {		/* On 1st reward	*/
      if (TargetTime == FAIL || BlankTime == FAIL) {	/* Should never	*/
	 fprintf(stderr, "No target or blank!");
         continue;
         }
      if (RewardTime > (BlankTime-1000))
	 continue;
      DeleteData(0,				/* Rm data after go cue	*/
		 BlankTime,
		 Register[0].frame_count + 1000);  /* +1000: Insurance?	*/
      DeleteData(0, 0, TargetTime);   		/* Rm visual response	*/
      ShiftReg(0, ALIGN_TIME - RewardTime);
    } else if (ALIGN_ON_TARGET == 2) {		/* On saccade		*/
      int at, at_h, at_v;
      float size_h = -9999, size_v = -9999;
      extern int NoSacsBeforeThis;
      extern int NoSacsAfterThis;
      extern int SuppressNoSaccadeMessage;
      extern int FindSmallSac;
#	include "../sac.h"
      
      NoSacsBeforeThis = BlankTime + 100;
      NoSacsAfterThis  = BlankTime + 500;
      FindSmallSac = 1;

      ChangeParameter('t', "h");	/* Horizontal eye position	*/
      UseFilter = 2;
      Filter(0);
      SuppressNoSaccadeMessage = 1;
      FindSaccade(0);
      at_h = SaccadeData.peak;
      if (at_h != FAIL)
         size_h = AvgSomeData(0, SaccadeData.end+50, SaccadeData.end+250) -
                  AvgSomeData(0, SaccadeData.begin-250, SaccadeData.begin-50);

      ChangeParameter('t', "v");	/* Vertical eye position	*/
      Filter(0);
      FindSaccade(0);
      at_v = SaccadeData.peak;
      if (at_v != FAIL)
         size_v = AvgSomeData(0, SaccadeData.end+50, SaccadeData.end+250) -
                  AvgSomeData(0, SaccadeData.begin-250, SaccadeData.begin-50);
      SuppressNoSaccadeMessage = 0;

      if (at_h == FAIL && at_v == FAIL) {
	 fprintf(stderr, "Cannot find a saccade -- skipping.\n");
	 continue;
	 }

      if (at_h == FAIL)
          at = at_v;
      else if (at_v == FAIL)
          at = at_h;
      else if (size_h > size_v)
         at = at_h;
      else
         at = at_v;

      ShiftReg(0, ALIGN_TIME - at);
      }
   
   if (SortFlag) {
      AvgReg(0, 18+SortFlag);
      continue;
      }

   /* Compute how far the target (or sac end) is from the pref	*/

   if (SORT_BY_TARGET == BY_CLASS) {
      if (Register[0].classnumber == null)
         AvgReg(0, 20);
      if (Register[0].classnumber == pref)
         AvgReg(0, 19);

      away = abs(pref - Register[0].classnumber);	/* Overwritng	*/
      if (away > 8)
          away = 16 - away;			/* Handle wrapping	*/
    } else {
      away = fabs(DeltaAngle);			/* How many deg away?	*/

      if (ROUND_BIN_LOCATIONS) {
          away /= (DIRECTION_BIN_SIZE/2.);
          away = round(away) * (DIRECTION_BIN_SIZE/2.);
          }

      if (180-away <= NULL_WIDTH)
         AvgReg(0, 20);

      if (away <= PREF_WIDTH)
         AvgReg(0, 19);

      away = away / (DIRECTION_BIN_SIZE/2.);	/* How many steps away?	*/

      if (away > 18)
         fatal("Argh!  Ran out of space.  Move everything over!\n");      
      }


   if (PLOT_INDIVIDUALS) {
    if (away < 1) {
      extern  int UseFilter;
      int save = UseFilter;
      /* UseFilter = 1; */
      /* Filter(0); */
      /* Filter(0); */
      UseFilter = save;
      ChangeParameter('c', "R");		/* Default: purple	*/
      ChangeParameter('c', "b8");
      switch (Register[0].stacknumber) {
	  case 111: ChangeParameter('c', "B"); break;	/* blue for 5 s	*/
	  case 112: ChangeParameter('c', "G"); break;	/* green for 5 s*/
	  case 115: ChangeParameter('c', "R"); break;	/* red for 5 s	*/
	  }
      GraphData(0);
      }
    }

   Register[0].stacknumber = (int)floor(away);
   AvgReg(0, (int)floor(away+1));

} while (Read_trial() != FAIL);			/* Next header		*/

if ((ContentReg(19) == 0) ||
    ( StatsSomeData(19,INTERVAL_START,INTERVAL_END,"N") < 1.)) {
   if (VERBOSE > -1)
    fprintf(stderr, "No preferred direction data; skipping this unit\n");
   return;
   }
if ((ContentReg(20) == 0) ||
    (StatsSomeData(20,INTERVAL_START,INTERVAL_END,"N") < 1.)) {
   if (VERBOSE > -1)
    fprintf(stderr, "No null direction data; skipping this unit!\n");
   return;
   }


if ((SORT_BY_TARGET < 5) && (SORT_BY_TARGET != BY_CLASS)) {
 for (i=1; i<(360/DIRECTION_BIN_SIZE+2); i++) {	/* Go thru all the bins	*/
   if (SKIP_LOW_N)
     if (ContentReg(i) < SKIP_LOW_N) {
         fprintf(stderr, "Skipping cell (only %d trials in bin %d)\n",
		      ContentReg(i), i);
	 return;
         }
   if (WARN_LOW_N)
     if (ContentReg(i) < WARN_LOW_N) {
         fprintf(stderr, "Warning: only %d trials in bin %d\n",
		      ContentReg(i), i);
      }
   }
 }

if (NORMALIZE_RATE) {
   float peak = -9999.;
   float anti =  9999.;
   int peak_reg = -1;
   int anti_reg = -1;

   Set_CurrentChannel(UNIT);

   for (i=1; i<=20; i++) {		/* Find +/- peaks (-at2 -i0:500)*/
       float Avg = AvgSomeData(i, ALIGN_TIME+500, ALIGN_TIME+1500);
       if (ContentReg(i) == 0)
	  continue;

       if (Avg > peak) {
	   peak = Avg;
	   peak_reg = i;
           }
       else if (Avg <= anti) {
	   anti = Avg;
	   anti_reg = i;
           }
       }
    {
    extern float multiplier;			/* From data.c		*/
    multiplier = 100/peak;			/* Scale peak to 100	*/
    }						/* Or 100/(peak-anti)?	*/
   if (peak < 0.)
      fatal("Memory mac: couldn't find peak value! CORRECT STACKS?");
   if (anti > 1000.)
      fatal("Memory mac: couldn't find negative peak value! CORRECT STACKS?");
   fprintf(stderr, "s%d.%d:  Peak - anti is %.2f (%.2f,%.2f)\n", 
		      	Header_Unit(), Header_Run(), peak-anti, peak, anti);
   if (peak_reg != 1)
      fprintf(stderr, "s%d.%d:  Peak class is %d, not %d\n", 
		      	Header_Unit(), Header_Run(),
			Register[peak_reg].classnumber,
			Register[1].classnumber);
   if (ContentReg(1) < 4)
      fprintf(stderr, "s%d.%d:  Peak has only %d trials\n", 
		      	Header_Unit(), Header_Run(), ContentReg(1));
   if (anti_reg != 20)
      fprintf(stderr, "s%d.%d:  Lowest class is %d, not %d\n", 
		      	Header_Unit(), Header_Run(),
			Register[anti_reg].classnumber,
			Register[10].classnumber);
   if (ContentReg(20) < 4)
      fprintf(stderr, "s%d.%d:  Null has only %d trials\n", 
		      	Header_Unit(), Header_Run(), ContentReg(10));
   }



for (i=1; i<=20; i++) {
    if (TRUNCATE==1)
       if (off_time != 0)
          DeleteUnitData(i, ALIGN_TIME+off_time, Register[i].frame_count + 1);
    if (TRUNCATE==-1)
       if (off_time != 0)
          DeleteUnitData(i, 0, ALIGN_TIME+off_time+500);
    if (NORMALIZE_TRIALS==1)
       NormalizeReg(i);				/* To one trial		*/
    if (NORMALIZE_RATE)
       MultiplyData(i);				/* Scale height		*/
    AvgReg(i, 29+i);
    if (ContentReg(i+29) > 0) {
       char newname[80];
       sprintf(newname, "%d %.3s",
		   Register[i+29].stacknumber,
		   Register[i+29].stackname);
       MacroTagReg(i+29, newname);
       }
    }
CopyReg(19, 52);
CopyReg(20, 53);
if (NORMALIZE_TRIALS==0) {		/* If not norm'd, do it now!	*/
   NormalizeReg(52);			/* May be unequal # of trials	*/
   NormalizeReg(53);
   }
SubtractReg(52, 53);

{
double result = AvgSomeData(52, INTERVAL_START, INTERVAL_END);
sum += result;
sum2 += result*result;
sumN++;
if (SHOW_EACH_VALUE)
  fprintf(stderr, "Single: %d.%d   %d %d %d   %.2f\n", 
	Header_Unit(), 
	Header_Run(), 
	*(Header_Monk())-'a'+1,
	*(Header_Monk()+1)-'a'+1, 
	*(Header_Monk()+2)-'a'+1, 
	result);
}
#if (SPECIAL)
fprintf(stderr, "%d: %.2f %.2f  ",
		sumN,
		AvgSomeData(19,INTERVAL_START,INTERVAL_END),
		AvgSomeData(20,INTERVAL_START,INTERVAL_END));
for (i=1; i<9; i++)
   fprintf(stderr,  "%.1f ",
		AvgSomeData(i,INTERVAL_START,INTERVAL_END));

fprintf(stderr, "      %.0f %.0f\n", 
		StatsSomeData(1, INTERVAL_START, INTERVAL_START+100, "N"),
		StatsSomeData(8, INTERVAL_START, INTERVAL_START+100, "N"));
#endif

AvgReg(52, 50);
Set_CurrentChannel(UNIT);
MacroTagReg(50, "difference");
for (i=1; i<=20; i++)
    RemoveReg(i);
RemoveReg(52);
RemoveReg(53);
}
/* ******************************************************************** */
/* ******************************************************************** */
