/* FILE harrysimple.c	*/
     /* Sort trials in current file */

#include "../defs.h"
#include "../array.h"       		/* Access registers directly	*/
#include "../_imports/deffs.h"
#include "../_imports/event.h"       	/* Stack instruction definitions*/
 
#define  FULL_SORT		0
static float DIRECTION_BIN_SIZE = 45.;	/* Should be: 180 % SIZE == 0	*/
	/* For continuous, uses bins of half this to either side!	*/

static int ALIGN_TIME =		5000;
static int ALIGN_ON_TARGET =	1;	/* 0:go cue  2: saccade		*/
static int JUST_ONE_STACK =	0;	/* 0 or else stack # 		*/
static double PREF_WIDTH =	22.5;	/* [22.5]			*/
static double NULL_WIDTH =	50;	/* [50]				*/
static int    FILTER =		8;	/* [8]				*/

#define DO_EYES 		0	/* Slows us down	*/
#define VERBOSE			1	/* -1,0,1		*/
/* ******************************************************************** */

/* FUNCTION set_Harry_simple_macro() */
void set_Harry_simple_macro(char *cmdline) {  
     char name[255] = "";
     char value_string[20];
     float value;

     sscanf(cmdline, "%s %s", name, value_string);
     value = atof(value_string);

     if (strcmp(name, "JustOneStack") == 0) {
	 JUST_ONE_STACK = value;
	 if (value)
	    fprintf(stderr, "Just one stack = %d\n", JUST_ONE_STACK);
     } else if (strcmp(name, "DirectionBinSize") == 0) {
	 DIRECTION_BIN_SIZE = value;
	 fprintf(stderr, "Direction Bin Size = %.2f\n", DIRECTION_BIN_SIZE);
     } else if (strcmp(name, "PrefWidth") == 0) {
	 PREF_WIDTH = value;
	 fprintf(stderr, "Pref bin width = %.2f deg\n", PREF_WIDTH);
     } else if (strcmp(name, "NullWidth") == 0) {
	 NULL_WIDTH = value;
	 fprintf(stderr, "Null bin width = %.2f deg\n", NULL_WIDTH);
     } else if (strcmp(name, "AlignTime") == 0) {
	 ALIGN_TIME = value;
	 fprintf(stderr, "Align time = %d\n", ALIGN_TIME);
     } else if (strcmp(name, "AlignOnTarget") == 0) {
	 ALIGN_ON_TARGET = value;
	 fprintf(stderr, "Align time = %d\n", ALIGN_ON_TARGET);
     } else if (strcmp(name, "UseFilter") == 0) {
	 FILTER = value;
	 fprintf(stderr, "Filter = %d\n", FILTER);
     } else
	 fprintf(stderr, "WARNING: unknown parameter (%s)\n", name);

     }
/* ******************************************************************** */

/* FUNCTION Harry_simple_macro() */
	 /* Sort shifted trials */
void Harry_simple_macro(int unit, int pref)  {
#  if DO_EYES
   extern int DiffChannel;			/* diff.c		*/
#  endif
   extern  int StepMs;				/* Differentiation stuff*/
   extern  int UseFilter;
   int i;
   double PrefAngle = 0.;


Set_CurrentChannel(UNIT);

if (pref == -1) {				/* Find it yourself!	*/
   double sum_h=0., sum_v=0.;

   do {
       int TargetTime = StackExtract(TARGET_RE_1_POLAR, 1, TIME);
       double Fixate_H = StackExtract(TARGET_ON, 1, TWO) / 10.;
       double Fixate_V = StackExtract(TARGET_ON, 1, THREE) / 10.;
       double Target_H = StackExtract(TARGET_RE_1_POLAR, 1, TWO) / 10.;
       double Target_V = StackExtract(TARGET_RE_1_POLAR, 1, THREE) / 10.;
       double rate;

       if (TargetTime == FAIL) {
           TargetTime = StackExtract(TARGET_ON_POLAR, 1, TIME);
           Target_H = StackExtract(TARGET_ON_POLAR, 1, TWO) / 10.;
           Target_V = StackExtract(TARGET_ON_POLAR, 1, THREE) / 10.;
	   }
       if (TargetTime == FAIL) {
           TargetTime = StackExtract(TARGET_RE_2_POLAR, 1, TIME);
           Target_H = StackExtract(TARGET_RE_2_POLAR, 1, TWO) / 10.;
           Target_V = StackExtract(TARGET_RE_2_POLAR, 1, THREE) / 10.;
	   }
       if (TargetTime == FAIL) {
           TargetTime = StackExtract(TARGET_RE_1, 1, TIME);
           Target_H = StackExtract(TARGET_RE_1, 1, TWO) / 10.;
           Target_V = StackExtract(TARGET_RE_1, 1, THREE) / 10.;
	   }
       if (TargetTime == FAIL) {
           TargetTime = StackExtract(TARGET_ON, 2, TIME);
           Target_H = StackExtract(TARGET_ON, 2, TWO) / 10.;
           Target_V = StackExtract(TARGET_ON, 2, THREE) / 10.;
	   }
       if (TargetTime == FAIL || Fixate_H == FAIL) {
	   fprintf(stderr, "Not finding the right events!\n");
   	   return;
   	   }

       rate = AvgSomeData(0, TargetTime+400, TargetTime+800);

       sum_h += (Target_H-Fixate_H) * rate;
       sum_v += (Target_V-Fixate_V) * rate;

     } while (Read_trial() != FAIL);		/* Next header		*/

   PrefAngle = atan2(sum_v, sum_h) * (360/2/3.14);
   if (PrefAngle > 180)
       PrefAngle -= 360;
   ReRead_file();

   fprintf(stderr, "Pref = %.1f deg\n\n", PrefAngle);
 } else
   PrefAngle = pref;
  	   /* End of find pref/null*/


StepMs = 1;					/* Set up differentiator*/

if ((ALIGN_ON_TARGET == 0) && (JUST_ONE_STACK == 0))
   fprintf(stderr, "Warning: bad policy to mix stacks when aligned on go\n");
if (FULL_SORT)
   if (180/DIRECTION_BIN_SIZE > 18)
      fprintf(stderr, "FIX CODE TO HANDLE SMALL BINS - IGNORE RESULTS!\n");
if (FULL_SORT)
   if (ContentReg(19+29) < 1)			/* Do just once		*/
      fprintf(stderr, "Bin size = %.1f deg\n", (float)DIRECTION_BIN_SIZE);


do {						/* Next trial or header	*/
   int TargetTime = StackExtract(TARGET_RE_1_POLAR, 1, TIME);
   int UnBlankTime = StackExtract(TARGET_BLANK, 3, TIME);	/* unblank */
   int BlankTime = StackExtract(TARGET_BLANK, 2, TIME);		/* blank   */
   double Fixate_H = StackExtract(TARGET_ON, 1, TWO) / 10.;
   double Fixate_V = StackExtract(TARGET_ON, 1, THREE) / 10.;
   double Target_H = StackExtract(TARGET_RE_1_POLAR, 1, TWO) / 10.;
   double Target_V = StackExtract(TARGET_RE_1_POLAR, 1, THREE) / 10.;
   double DeltaAngle = -9999;
   double DeltaBins;	/* How far from pref direction in BIN_SIZE units*/

   if (JUST_ONE_STACK)
      if (Register[0].stacknumber != JUST_ONE_STACK)
         continue;

#ifdef COMBINE_61_and_65
   if (Register[0].stacknumber == 65) {
       Register[0].stacknumber = 61;
       fprintf(stderr, "converting 65 to 61\n");
       }
   if (Register[0].stacknumber != 61)
       fprintf(stderr, "\t\t\t\t\t\t%d\n", Register[0].stacknumber);
#endif

   if (TargetTime == FAIL) {
       TargetTime = StackExtract(TARGET_ON_POLAR, 1, TIME);
       Target_H = StackExtract(TARGET_ON_POLAR, 1, TWO) / 10.;
       Target_V = StackExtract(TARGET_ON_POLAR, 1, THREE) / 10.;
       }
   if (TargetTime == FAIL) {
       TargetTime = StackExtract(TARGET_RE_2_POLAR, 1, TIME);
       Target_H = StackExtract(TARGET_RE_2_POLAR, 1, TWO) / 10.;
       Target_V = StackExtract(TARGET_RE_2_POLAR, 1, THREE) / 10.;
       }
   if (TargetTime == FAIL) {
       TargetTime = StackExtract(TARGET_RE_1, 1, TIME);
       Target_H = StackExtract(TARGET_RE_1, 1, TWO) / 10.;
       Target_V = StackExtract(TARGET_RE_1, 1, THREE) / 10.;
       }
   if (TargetTime == FAIL) {
       TargetTime = StackExtract(TARGET_ON, 2, TIME);
       Target_H = StackExtract(TARGET_ON, 2, TWO) / 10.;
       Target_V = StackExtract(TARGET_ON, 2, THREE) / 10.;
       }
  
   {				/* Do we not blank the fixation point?	*/
   int k;
   for (k=1; k<12; k++)				/* Do we shrink it?	*/
       if ((StackExtract(TARGET_SIZE,k,TIME) > 0) && 	/* OLD DATA!	*/
	   (abs(StackExtract(TARGET_SIZE, k, TWO)) < 3))
	  break;
   if (k < 12) {
      BlankTime = StackExtract(TARGET_SIZE, k, TIME);	/* Shrink time	*/
      if (StackExtract(TARGET_REDRAW, 1, TIME) > BlankTime)
         BlankTime = StackExtract(TARGET_REDRAW, 1, TIME);
       else if (StackExtract(TARGET_REDRAW, 2, TIME) > BlankTime)
         BlankTime = StackExtract(TARGET_REDRAW, 2, TIME);
    } else
    if (UnBlankTime == FAIL) {			/* Do we turn it off?	*/
       UnBlankTime = BlankTime;
       BlankTime = StackExtract(TARGET_OFF, 1, TIME);/* other stacks	*/
       fprintf(stderr, "Ugh - I think we used to skip these\n");
       }
   }

    DeltaAngle =
        atan2(Target_V-Fixate_V, Target_H-Fixate_H) * (360/2/3.14) - PrefAngle;
    if (DeltaAngle >   180) DeltaAngle -= 360;/* & unwrap,since - pref*/
    if (DeltaAngle <= -180) DeltaAngle += 360;

#  if DO_EYES
   UseFilter = 8;				/* 2, 8, 12, etc	*/
   Set_CurrentChannel(OD_H);
   UseFilter = 8;
   Filter(0);
   RectifyData(0);
   DiffChannel = H_VEL;
   Differentiate(0);

   Set_CurrentChannel(OD_V);
   Filter(0);
   RectifyData(0);
   DiffChannel = V_VEL;
   Differentiate(0);

   Set_CurrentChannel(X3);      /* Posit amplitude into X3, veloc -> X4 */
   ComputeAmplitudesData(0);

   Set_CurrentChannel(UNIT);
#  endif

   if (unit != 0) {			/* Move 2nd chan into 1st chan	*/
      Set_CurrentChannel(SPIKE_2);	/* Changed on 04-02-2015	*/
      ChannelDataTransfer(0, UNIT);
      }
   Set_CurrentChannel(UNIT);		/* Filter indis: SE is smooth	*/

   UseFilter = FILTER; /* 250,500,1,2,4,8,16,32,64	*/
   Filter(0);
   					/* Do BEFORE filtering?		*/
   if (ALIGN_ON_TARGET == 1) {
      DeleteData(0,				/* Rm data after go cue	*/
		 BlankTime,
		 Register[0].frame_count + 1000);  /* +1000: Insurance?	*/
      ShiftReg(0,ALIGN_TIME - TargetTime);
    } else if (ALIGN_ON_TARGET == 0) {
      if (TargetTime == FAIL || BlankTime == FAIL)
         continue;
      DeleteData(0, 0, TargetTime+500);   /* Sac align:rm early data	*/
      ShiftReg(0,ALIGN_TIME - BlankTime);
    } else {
      int at, at_h, at_v;
      float size_h = -9999, size_v = -9999;
      extern int NoSacsBeforeThis;
      extern int NoSacsAfterThis;
      extern int SuppressNoSaccadeMessage;
      extern int FindSmallSac;
#	include "../sac.h"
      
      NoSacsBeforeThis = BlankTime + 100;
      NoSacsAfterThis  = BlankTime + 500;
      FindSmallSac = 1;

      ChangeParameter('t', "h");	/* Horizontal eye position	*/
      UseFilter = 2;
      Filter(0);
      SuppressNoSaccadeMessage = 1;
      FindSaccade(0);
      at_h = SaccadeData.peak;
      if (at_h != FAIL)
         size_h = AvgSomeData(0, SaccadeData.end+50, SaccadeData.end+250) -
                  AvgSomeData(0, SaccadeData.begin-250, SaccadeData.begin-50);

      ChangeParameter('t', "v");	/* Vertical eye position	*/
      Filter(0);
      FindSaccade(0);
      at_v = SaccadeData.peak;
      if (at_v != FAIL)
         size_v = AvgSomeData(0, SaccadeData.end+50, SaccadeData.end+250) -
                  AvgSomeData(0, SaccadeData.begin-250, SaccadeData.begin-50);
      SuppressNoSaccadeMessage = 0;

      if (at_h == FAIL && at_v == FAIL) {
	 fprintf(stderr, "Cannot find a saccade -- skipping.\n");
	 continue;
	 }

      if (at_h == FAIL)
          at = at_v;
      else if (at_v == FAIL)
          at = at_h;
      else if (size_h > size_v)
         at = at_h;
      else
         at = at_v;

      ShiftReg(0, ALIGN_TIME - at);
      }
   
   /* Compute how far the target (or sac end) is from the pref	*/

   if (180-fabs(DeltaAngle) <= NULL_WIDTH)
      AvgReg(0, 20);
   if (fabs(DeltaAngle) <= PREF_WIDTH)
      AvgReg(0, 19);

   if (FULL_SORT) {
      DeltaBins = 
	   fabs(DeltaAngle)/(DIRECTION_BIN_SIZE/2.);/* How many bins away?*/

      if (DeltaBins > 18)
         fatal("Argh!  Ran out of space.  Move everything over!\n");      

      Register[0].stacknumber = (int)floor(DeltaBins);
      AvgReg(0, (int)floor(DeltaBins+1));
      }

} while (Read_trial() != FAIL);			/* Next header		*/

for (i=1; i<=18; i++) {
    if (ContentReg(i) > 0) {
       char newname[80];
       sprintf(newname, "%d %.3s",
		   Register[i].stacknumber,
		   Register[i].stackname);
       MacroTagReg(i, newname);
       }
    }
MacroTagReg(19, "Pref");
MacroTagReg(20, "Null");
CopyReg(19, 52);
CopyReg(20, 53);
SubtractReg(52, 53);

AvgReg(52, 50);
Set_CurrentChannel(UNIT);
MacroTagReg(50, "difference");
RemoveReg(52);
RemoveReg(53);
RemoveReg(0);
}
/* ******************************************************************** */
/* ******************************************************************** */
