/* FILE harry2sort.c	*/
     /* Sort trials in current file */

#include "../defs.h"
#include "../array.h"       		/* Access registers directly	*/
#include "../_imports/deffs.h"
#include "../_imports/event.h"       	/* Stack instruction definitions*/
 
#  define PREF_WIDTH	22.5		/* 11.25 [5 for Rel.Ghost/Shift]*/
#  define NULL_WIDTH	 50		/* 22.5 [95 for Rel.Ghost/Shift]*/

static int NORMALIZE_TRIALS =	1;	/* Normalize to 1 trial?	*/
static float DIRECTION_BIN_SIZE = 45.;	/* Should be: 180 % SIZE == 0	*/
	/* For continuous, uses bins of half this to either side!	*/
	/* Same convention for ROUND_BIN_LOCATIONS, so may want to halve*/

static int ALIGN_TIME =		5000;
static int SORT_BY_TARGET =	1;	/* 1:Targ 0:Sac -1:Class	*/
#define BY_CLASS		-1	/* (more readable		*/
#define BY_SAC			0	/* (more readable		*/
static int SKIP_LOW_N =		0;	/* 0 or skip if trials < ~	*/
static int PLOT_INDIVIDUALS =	0;	/* Plot the individual files?	*/
static int ROUND_BIN_LOCATIONS=	0;	/* If binned targs,round 'away'!*/
static char AREA = 		'A';	/* Select:Any,FEF,DLPFC,Border	*/

#define DO_EYES 		0		/* Slows us down	*/
#define VERBOSE			1		/* -1,0,1		*/
/* ******************************************************************** */
static double sum = 0.;
static double sum2 = 0.;
static int    sumN = 0;

/* FUNCTION set_Harry_sort_macro() */
void set_Harry_sort_macro(char *cmdline) {  
     char name[255] = "";
     char value_string[20];
     float value;

     sscanf(cmdline, "%s %s", name, value_string);
     value = atof(value_string);

     if (strcmp(name, "NormalizeTrials") == 0) {
	 NORMALIZE_TRIALS = value;  /* (value != 0); */
	 fprintf(stderr, "Normalize trials = %d\n", NORMALIZE_TRIALS);
     } else if (strcmp(name, "SkipLowN") == 0) {
	 SKIP_LOW_N = value;
	 fprintf(stderr, "Skip low N = %d\n", SKIP_LOW_N);
     } else if (strcmp(name, "SortByTarget") == 0) {
	 SORT_BY_TARGET = value;
	 fprintf(stderr, "Sort by target = %d\n", SORT_BY_TARGET);
     } else if (strcmp(name, "DirectionBinSize") == 0) {
	 DIRECTION_BIN_SIZE = value;
	 fprintf(stderr, "Direction Bin Size = %.2f\n", DIRECTION_BIN_SIZE);
     } else if (strcmp(name, "AlignTime") == 0) {
	 ALIGN_TIME = value;
	 fprintf(stderr, "Align time = %d\n", ALIGN_TIME);
     } else if (strcmp(name, "PlotIndividuals") == 0) {
	 PLOT_INDIVIDUALS = value;
	 fprintf(stderr, "Plot individual traces = %d\n", PLOT_INDIVIDUALS);
     } else if (strcmp(name, "RoundBinLocations") == 0) {
	 ROUND_BIN_LOCATIONS = value;
	 fprintf(stderr, "Round Bin Locations = %d\n", ROUND_BIN_LOCATIONS);
     } else if (strcmp(name, "Area") == 0) {
	 AREA = value_string[0];
	 fprintf(stderr, "Area = %c\n", AREA);
     } else
	 fprintf(stderr, "WARNING: unknown parameter (set_Harry_Sort_Macro)\n");
     }
/* ******************************************************************** */

/* FUNCTION end_Harry_sort_macro() */
void end_Harry_sort_macro() {  
       }
/* ******************************************************************** */

/* FUNCTION Harry_sort_macro() */
	 /* Sort shifted trials */
void Harry_sort_macro(int unit, int pref, char area) {
#  if DO_EYES
   extern int DiffChannel;			/* diff.c		*/
#  endif
   extern  int StepMs;				/* Differentiation stuff*/
   extern  int UseFilter;
   int i;
   int flag = 0;				/* Go cue: blank or off?*/
   double SaveAngle = 0;
   int Save_trial = -9999;

if (AREA != 'A')
   if (AREA != area)
       return;

Set_CurrentChannel(UNIT);

if (pref == -1) {				/* Find it yourself!	*/
   double Rates[16];
   double Rates2[16];
   int    Trials[16];
   double MaxRate = 0;
   int spikes[16][80];

   if (SORT_BY_TARGET==BY_CLASS)
      fatal("Macro call asks to find pref direction but code says BY_CLASS!\n");

   for (i=0; i<16; i++) { 
       int j;
       Rates[i] = Rates2[i] = 0.; 
       Trials[i] = 0;
       for (j=0; j<80; j++)
	   spikes[i][j] = 0;
       }

   do {
       int TargetTime = StackExtract(TARGET_RE_1_POLAR, 1, TIME);
       double Fixate_H = StackExtract(TARGET_ON, 1, TWO) / 10.;
       double Fixate_V = StackExtract(TARGET_ON, 1, THREE) / 10.;
       double Target_H = StackExtract(TARGET_RE_1_POLAR, 1, TWO) / 10.;
       double Target_V = StackExtract(TARGET_RE_1_POLAR, 1, THREE) / 10.;
       double TargetAngle;
       double rate;
       int this_bin;
       int null = 0;				/* Compute null direction*/

       if (TargetTime == FAIL) {
           TargetTime = StackExtract(TARGET_ON_POLAR, 1, TIME);
           Target_H = StackExtract(TARGET_ON_POLAR, 1, TWO) / 10.;
           Target_V = StackExtract(TARGET_ON_POLAR, 1, THREE) / 10.;
	   }
       if (TargetTime == FAIL) {
           TargetTime = StackExtract(TARGET_RE_2_POLAR, 1, TIME);
           Target_H = StackExtract(TARGET_RE_2_POLAR, 1, TWO) / 10.;
           Target_V = StackExtract(TARGET_RE_2_POLAR, 1, THREE) / 10.;
	   }
       if (TargetTime == FAIL) {
           TargetTime = StackExtract(TARGET_RE_1, 1, TIME);
           Target_H = StackExtract(TARGET_RE_1, 1, TWO) / 10.;
           Target_V = StackExtract(TARGET_RE_1, 1, THREE) / 10.;
	   }
       if (TargetTime == FAIL) {
           TargetTime = StackExtract(TARGET_ON, 2, TIME);
           Target_H = StackExtract(TARGET_ON, 2, TWO) / 10.;
           Target_V = StackExtract(TARGET_ON, 2, THREE) / 10.;
	   }
       if (TargetTime == FAIL || Fixate_H == FAIL) {
	   fprintf(stderr, "Not finding the right events!\n");
   	   return;
   	   }
       TargetAngle = 
	     atan2(Target_V-Fixate_V, Target_H-Fixate_H) * (360/2/3.14);
       if (TargetAngle < 0.)
	   TargetAngle += 360.;

       rate = AvgSomeData(0, TargetTime+400, TargetTime+800);
       this_bin = (int)round(TargetAngle / DIRECTION_BIN_SIZE);

       spikes[this_bin][Trials[this_bin]] = (int)round(rate*100); /* x 100 */
       		/* t test wants integers; multiply by 100 to keep signif */
       Rates [this_bin] += rate;
       Rates2[this_bin] += rate * rate;
       Trials[this_bin]++;
     } while (Read_trial() != FAIL);		/* Next header		*/

   for (i=0; i<16; i++)
       if ((Trials[i] > 0) && ((Rates[i]/Trials[i]) > MaxRate)) {
          MaxRate = Rates[i]/Trials[i];
	  pref = i;
          }
   ReRead_file();

   if (DIRECTION_BIN_SIZE == 45) {
       null = (pref + 4) % 8;

       int null_plus_one = (pref+5) % 8;
       int null_minus_one = (pref+3) % 8;

       for (i=0; i<Trials[null_plus_one]; i++)
           spikes[null][Trials[null] + i] = spikes[null_plus_one][i];
       Trials[null] += Trials[null_plus_one];
       Rates [null] += Rates [null_plus_one];
       Rates2[null] += Rates2[null_plus_one];

       for (i=0; i<Trials[null_minus_one]; i++)
           spikes[null][Trials[null] + i] = spikes[null_minus_one][i];
       Trials[null] += Trials[null_minus_one];
       Rates [null] += Rates [null_minus_one];
       Rates2[null] += Rates2[null_minus_one];

       int pref_plus_one  = (pref+1) % 8;
       int pref_minus_one = (pref-1) % 8;
       for (i=0; i<Trials[pref_plus_one]; i++)
           spikes[pref][Trials[pref] + i] = spikes[pref_plus_one][i];
       Trials[pref] += Trials[pref_plus_one];
       Rates [pref] += Rates [pref_plus_one];
       Rates2[pref] += Rates2[pref_plus_one];
       for (i=0; i<Trials[pref_minus_one]; i++)
           spikes[pref][Trials[pref] + i] = spikes[pref_minus_one][i];
       Trials[pref] += Trials[pref_minus_one];
       Rates [pref] += Rates [pref_minus_one];
       Rates2[pref] += Rates2[pref_minus_one];
       }
     else {
       fprintf(stderr, "Check if this is a 22.5 deg bin size\n");
       null = (pref + 8) % 16;
       }

   if (VERBOSE > 0)
    fprintf(stderr, "Pref = %.1f deg, mem = %.1f sp/s (n=%d,%d)\n", 
	   pref*DIRECTION_BIN_SIZE,
	   MaxRate - Rates[null]/Trials[null],
	   Trials[pref], Trials[null]);

   if (Trials[pref] < 3 || Trials[null] < 3 ||
       (Ttest(			/* Good (large, signif) mem activity	*/
	&(spikes[pref][0]), Trials[pref], 
	&(spikes[null][0]), Trials[null], 
	2) > .10) ||
        (MaxRate - Rates[null]/Trials[null] < 5.)) {
      if (VERBOSE > -1)
       fprintf(stderr, "Skip unit (poor memory)\n");
      return;
      }

   pref = pref * DIRECTION_BIN_SIZE;
   if (pref > 180)
       pref -= 360;
   }						/* End of find pref/null*/


StepMs = 1;					/* Set up differentiator*/

if (180/DIRECTION_BIN_SIZE > 18)
   fprintf(stderr, "FIX CODE TO HANDLE SMALL BINS - IGNORE RESULTS!\n");
if (ContentReg(19+29) < 1)			/* Do just once		*/
   fprintf(stderr, "Bin size = %.1f deg\n", (float)DIRECTION_BIN_SIZE);

if (PLOT_INDIVIDUALS) {
   extern void GraphLine(int i, int j);
   char value[80];
   sprintf(value, "%d", ALIGN_TIME-1000);
   ChangeParameter('h', "80");
   ChangeParameter('o', "0");
   ChangeParameter('w', "15000");
   ChangeParameter('s', value);
   ChangeParameter('b', "4");
   ChangeParameter('c', "R");
   ChangeParameter('t', "u");
   GraphLine(ALIGN_TIME, 0);
   }


do {						/* Next trial or header	*/
   int TargetTime = StackExtract(TARGET_RE_1_POLAR, 1, TIME);
   int UnBlankTime = StackExtract(TARGET_BLANK, 3, TIME);	/* unblank */
   int BlankTime = StackExtract(TARGET_BLANK, 2, TIME);		/* blank   */
   double Fixate_H = StackExtract(TARGET_ON, 1, TWO) / 10.;
   double Fixate_V = StackExtract(TARGET_ON, 1, THREE) / 10.;
   double Target_H = StackExtract(TARGET_RE_1_POLAR, 1, TWO) / 10.;
   double Target_V = StackExtract(TARGET_RE_1_POLAR, 1, THREE) / 10.;
   double away;		/* How far from pref direction in BIN_SIZE units*/

   if (TargetTime == FAIL) {
       TargetTime = StackExtract(TARGET_ON_POLAR, 1, TIME);
       Target_H   = StackExtract(TARGET_ON_POLAR, 1, TWO) / 10.;
       Target_V   = StackExtract(TARGET_ON_POLAR, 1, THREE) / 10.;
       }
   if (TargetTime == FAIL) {
       TargetTime = StackExtract(TARGET_RE_2_POLAR, 1, TIME);
       Target_H   = StackExtract(TARGET_RE_2_POLAR, 1, TWO) / 10.;
       Target_V   = StackExtract(TARGET_RE_2_POLAR, 1, THREE) / 10.;
       }
   if (TargetTime == FAIL) {
       TargetTime = StackExtract(TARGET_RE_1, 1, TIME);
       Target_H   = StackExtract(TARGET_RE_1, 1, TWO) / 10.;
       Target_V   = StackExtract(TARGET_RE_1, 1, THREE) / 10.;
       }
   if (TargetTime == FAIL) {
       TargetTime = StackExtract(TARGET_ON, 2, TIME);
       Target_H   = StackExtract(TARGET_ON, 2, TWO) / 10.;
       Target_V   = StackExtract(TARGET_ON, 2, THREE) / 10.;
       }
  
   {				/* Do we not blank the fixation point?	*/
   int k;
   for (k=1; k<12; k++)				/* Do we shrink it?	*/
       if ((StackExtract(TARGET_SIZE,k,TIME) > 0) && 	/* OLD DATA!	*/
	   (abs(StackExtract(TARGET_SIZE, k, TWO)) < 3))
	  break;
   if (k < 12) {
      BlankTime = StackExtract(TARGET_SIZE, k, TIME);	/* Shrink time	*/
      if (StackExtract(TARGET_REDRAW, 1, TIME) > BlankTime)
         BlankTime = StackExtract(TARGET_REDRAW, 1, TIME);
       else if (StackExtract(TARGET_REDRAW, 2, TIME) > BlankTime)
         BlankTime = StackExtract(TARGET_REDRAW, 2, TIME);
    } else
    if (UnBlankTime == FAIL) {			/* Do we turn it off?	*/
       UnBlankTime = BlankTime;
       BlankTime = StackExtract(TARGET_OFF, 1, TIME);/* other stacks	*/
       flag = 1;
       }
   }

   switch (SORT_BY_TARGET) {
	case BY_SAC: {			/* 0: Sort by where the eyes go	*/
	   double x,y;
           if (flag==0 && (StackExtract(TARGET_BLANK, 3, THREE) != 0))
              fprintf(stderr, "Check alignment for saccade endpoint!\n");
           Set_CurrentChannel(OD_H);
           x = AvgSomeData(0, UnBlankTime - 50, UnBlankTime + 50) - Fixate_H;
           Set_CurrentChannel(OD_V);
           y = AvgSomeData(0, UnBlankTime - 50, UnBlankTime + 50) - Fixate_V;
           Set_CurrentChannel(UNIT);

           if ((fabs(x - (Target_H-Fixate_H)) > 10) || 
               (fabs(y - (Target_V-Fixate_H)) > 10))
              fprintf(stderr, "Error > 10 deg (?)\n");

	   DeltaAngle = atan2(y,x) * 360/2/3.14159 - pref;
           if (DeltaAngle >   180) DeltaAngle -= 360;/* & unwrap,since - pref*/
           if (DeltaAngle <= -180) DeltaAngle += 360;
	   }
	   break;

	case BY_CLASS:			/* -1: Sort by class number	*/
	   break;

	case 1:				/* Sort by where the target is	*/
            DeltaAngle = 
	     atan2(Target_V-Fixate_V, Target_H-Fixate_H) * (360/2/3.14) - pref;
            if (DeltaAngle >   180) DeltaAngle -= 360;/* & unwrap,since - pref*/
            if (DeltaAngle <= -180) DeltaAngle += 360;
	    break;
        }
   	

#  if DO_EYES
   UseFilter = 8;				/* 2, 8, 12, etc	*/
   Set_CurrentChannel(OD_H);
   UseFilter = 8;
   Filter(0);
   RectifyData(0);
   DiffChannel = H_VEL;
   Differentiate(0);

   Set_CurrentChannel(OD_V);
   Filter(0);
   RectifyData(0);
   DiffChannel = V_VEL;
   Differentiate(0);

   Set_CurrentChannel(X3);      /* Posit amplitude into X3, veloc -> X4 */
   ComputeAmplitudesData(0);

   Set_CurrentChannel(UNIT);
#  endif

   if (unit != 0) {			/* Move 2nd chan into 1st chan	*/
      Set_CurrentChannel(SPIKE_2);	/* Changed on 04-02-2015	*/
      ChannelDataTransfer(0, UNIT);
      }
   if (PLOT_INDIVIDUALS)		/* Before you filter,		*/
      AvgReg(0, 60);			/* Collect all the trials	*/
   Set_CurrentChannel(UNIT);		/* Filter indis: SE is smooth	*/

   UseFilter = (PLOT_INDIVIDUALS)? 251 : 1; /* 250,500,1,2,4,8,16,32,64	*/

   Filter(0);				/* Delete FIRST, then filter?	*/
   DeleteData(0,BlankTime,Register[0].frame_count+1000);
   ShiftReg(0,ALIGN_TIME - TargetTime);	/* Removed all data past go cue	*/
   
   /* Compute how far the target (or sac end) is from the pref	*/

   if (SORT_BY_TARGET == BY_CLASS) {
      if (Register[0].classnumber == null)
         AvgReg(0, 20);
      if (Register[0].classnumber == pref)
         AvgReg(0, 19);

      away = abs(pref - Register[0].classnumber);	/* Overwritng	*/
      if (away > 8)
          away = 16 - away;			/* Handle wrapping	*/
    } else {		/* Sort by target position or final eye position*/
      away = fabs(DeltaAngle);			/* How many deg away?	*/

      if (ROUND_BIN_LOCATIONS) {
          away /= (DIRECTION_BIN_SIZE/2.);
          away = round(away) * (DIRECTION_BIN_SIZE/2.);
          }

      if (180-away <= NULL_WIDTH)
         AvgReg(0, 20);

      if (away <= PREF_WIDTH)
         AvgReg(0, 19);

      away = away / (DIRECTION_BIN_SIZE/2.);	/* How many steps away?	*/

      if (away > 18)
         fatal("Argh!  Ran out of space.  Move everything over!\n");      
      }


   if (PLOT_INDIVIDUALS) {
    if (away < 1) {
      extern  int UseFilter;
      int save = UseFilter;
      /* UseFilter = 1; */
      /* Filter(0); */
      /* Filter(0); */
      UseFilter = save;
      ChangeParameter('c', "R");		/* Default: purple	*/
      ChangeParameter('c', "b8");
      switch (Register[0].stacknumber) {
	  case 111: ChangeParameter('c', "B"); break;	/* blue for 5 s	*/
	  case 112: ChangeParameter('c', "G"); break;	/* green for 5 s*/
	  case 115: ChangeParameter('c', "R"); break;	/* red for 5 s	*/
	  }
      GraphData(0);
      }
    }

   Register[0].stacknumber = (int)floor(away);
   AvgReg(0, (int)floor(away+1));

} while (Read_trial() != FAIL);			/* Next header		*/

if (ContentReg(19) <= SKIP_LOW_N) {
   fprintf(stderr, "Too few preferred direction trials; skipping unit\n");
   return;
   }


for (i=1; i<=20; i++) {
    if (NORMALIZE_TRIALS==1)
       NormalizeReg(i);				/* To one trial		*/
    AvgReg(i, 29+i);
    /* sprintf(newname, "%d.%d %.3s",		* If want to look at indi*
		   Register[i].stacknumber,
		   Register[i].classnumber,
		   Register[i].stackname);
     */
    if (ContentReg(i+29) > 0) {
       char newname[80];
       sprintf(newname, "%d %.3s",
		   Register[i+29].stacknumber,
		   Register[i+29].stackname);
       MacroTagReg(i+29, newname);
       }
    }
CopyReg(19, 52);
CopyReg(20, 53);
if (NORMALIZE_TRIALS==0) {		/* If not norm'd, do it now!	*/
   NormalizeReg(52);			/* May be unequal # of trials	*/
   NormalizeReg(53);
   }
SubtractReg(52, 53);

AvgReg(52, 50);
Set_CurrentChannel(UNIT);
MacroTagReg(50, "difference");
for (i=1; i<=20; i++)
    RemoveReg(i);
RemoveReg(52);
RemoveReg(53);
}
/* ******************************************************************** */
/* ******************************************************************** */
