/* FILE gainfield.c	*/
     /* Sort trials in current file for gain field experiments */

#include "../defs.h"
#include "../array.h"       		/* Access registers directly	*/
#include "../_imports/deffs.h"
#include "../_imports/event.h"       	/* Stack instruction definitions*/

#define P_CRITERION		(0.05/8)	/* Else skip the unit	*/

#define UNIT_FILTER			8	/* [2] 			*/
#define EYE_FILTER			8	/* [8] 			*/
	/* 2 (9 Hz)  4(~24 Hz)   8 (~40 Hz)  12 (~46 Hz) */
#define PRINT_REGISTER_NAMES	0

#define ALIGNMENT_TIME		  3000
static int ALIGN_ON_TARGET      = 1;
static int ALIGN_ON_REACH_START	= 0;
static int ALIGN_ON_REACH_END   = 0;
static int AFTER_OPPOSITE_ONLY  = 0;

static int AVOID_PREF_DIR  = 0;

#define PLOT_INDIVIDUALS	0	/* Useful for debugging	*/
#define PLOT_AVERAGES		0	/* Useful for debugging	*/
#define RECTIFY_VELOC		0
#define RECTIFY_POSIT		0	/* Also offsets	*/
#define VERBOSE			0
#define CLASSES			3
#define TO_SORT			(8*CLASSES)
#define mBase(x)		(Base[x]/N[x])

static void Tag_Registers(void);

/* ******************************************************************** */
/* FUNCTION gainfield_initialize_macro() */
	 /* Set up the alignment for the macro */
void gainfield_initialize_macro(int code) {

   if (code <= 3 && code >= 1)
      ALIGN_ON_TARGET = ALIGN_ON_REACH_START = ALIGN_ON_REACH_END = 0;

   /* Set what you want */
   switch (code) {
      case 1:   ALIGN_ON_TARGET = 1;      break;
      case 2:   ALIGN_ON_REACH_START = 1; break;
      case 3:   ALIGN_ON_REACH_END   = 1; break;
      case 11:  AFTER_OPPOSITE_ONLY  = 1;
	        ALIGN_ON_TARGET      = 1; break;
      case 100: AVOID_PREF_DIR       = 1; break;
      default: fatal("Unknown initializer!");
      }
   }
/* ******************************************************************** */

/* FUNCTION gainfield_macro() */
	 /* Sort shifted trials */
void gainfield_macro(int PrefDir) {
   extern int DiffChannel;			/* diff.c		*/
   extern  int UseFilter;
   extern  int StepMs;				/* Differentiation stuff*/
   float Base[8];
   float Base2[8];
   int N[8];
   int peak = 0, null;
   int i;
   int skips = 0;				/* Skip slow/fast trials*/
   int skip3or4 = 0;				/*    Of class 3 or 4	*/
   int previous = 0;

   StepMs = 1;					/* Set up differentiator*/

   for (i=0; i<8; i++)
       N[i] = Base[i] = Base2[i] = 0.;

   if (AVOID_PREF_DIR && (PrefDir == 500)) {	/* Unknown pref direction*/
      fprintf(stderr, "Skip unit -- unknown pref direction\n");
      return;					/* Don't include it!	*/
      }

do {						/* Next trial or header	*/
   int TargetTime = StackExtract(TARGET_ON+2000, 3, TIME);
   int ArriveTime = StackExtract(ACQUIRE, 3, TIME);

   if (Register[0].classnumber == 4)
       Register[0].classnumber = 3;	/* Merge class 4 with 3		*/

   if (AFTER_OPPOSITE_ONLY & (previous != 3)) {
      previous = Register[0].classnumber;
      continue;
      }
   previous = Register[0].classnumber;

   if (Register[0].classnumber == 5)	/* Skip class 5 (out & back)	*/
      continue; 

   /* Check for (and skip) too-early or too-late saccades; tally them	*/
   if ((ArriveTime-TargetTime) > 750 || (ArriveTime-TargetTime) < 300) { 
      skips++;
      if (Register[0].classnumber == 3)
          skip3or4++;
      if (VERBOSE)
         fprintf(stderr, "Skip (total time = %d)\n", ArriveTime-TargetTime);
      continue;
      }

   UseFilter = EYE_FILTER;
   Set_CurrentChannel(OD_H);
   Filter(0);
   DiffChannel = H_VEL;
   Differentiate(0);

   Set_CurrentChannel(OD_V);
   Filter(0);
   DiffChannel = V_VEL;
   Differentiate(0);

   UseFilter = UNIT_FILTER;
   Set_CurrentChannel(UNIT);		/* Set to Chan 0 in all cases	*/
   if (UseFilter)
      Filter(0);

   DeleteAllData(0, 0, TargetTime - 800);		/* Rwd at -900	*/
   DeleteAllData(0, ArriveTime + 1000, 6000);
	/* Stack 95, thru 2013-04-01, had an inadvertent new target at	*/
  	/* 1 s past acquire, which the monk could anticipate		*/
   if (Register[0].stacknumber==95)
      DeleteAllData(0, ArriveTime + 700, ArriveTime+2000);

   {			/* For each stack (0:7) cumulate baseline firing*/
   int base = AvgSomeData(0, TargetTime - 500, TargetTime-150);
   Base[Register[0].stacknumber-90] += base;
   Base2[Register[0].stacknumber-90] += base*base;
   N[Register[0].stacknumber-90]++;
   }

   if (ALIGN_ON_TARGET) {
       ShiftReg(0, ALIGNMENT_TIME - TargetTime);
    } else if (ALIGN_ON_REACH_END) {			/* end of reach	*/
       ShiftReg(0, ALIGNMENT_TIME - ArriveTime);
    } else if (ALIGN_ON_REACH_START) {		/* start of reach	*/
       extern int NoArmMovesBeforeThis, NoArmMovesAfterThis;
       int MoveTime;

       NoArmMovesBeforeThis = TargetTime;
       NoArmMovesAfterThis  = ArriveTime+100;

       MoveTime = FindArmMove(0);
       if (MoveTime == FAIL) {
	  fprintf(stderr, "Skipping: Cannot find arm movement\n");
	  continue;
	} else
          ShiftReg(0, ALIGNMENT_TIME - MoveTime);
       }
							
   if (RECTIFY_VELOC) {
       Set_CurrentChannel(H_VEL);
       RectifyData(0);
       Set_CurrentChannel(V_VEL);
       RectifyData(0);
       }
   if (RECTIFY_POSIT) {
       Set_CurrentChannel(OD_H);
       RectifyData(0);
       Set_CurrentChannel(OD_V);
       RectifyData(0);
       }
   /* FOR GETTING OUTPUT DURING RUNNING OF MACRO: */
   if (PLOT_INDIVIDUALS) {
	extern void GraphLine(int i, int j);
	if (Register[0].stacknumber != 31)
	   goto SKIP;
	switch (Register[0].classnumber) {
	   case 10:  ChangeParameter('c', "B"); break;
	   default:  goto SKIP;
	   }
	ChangeParameter('h', "80");
	ChangeParameter('s', "2000");   /* just less than ALIGNMENT_TIME */
	ChangeParameter('w', "1500");
	ChangeParameter('b', "2");
	ChangeParameter('o', "75");
	ChangeParameter('t', "h");	/* h, x1	*/
	GraphData(0);
	ChangeParameter('o', "25");
	ChangeParameter('t', "v");	/* v, x2	*/
	GraphData(0);
	GraphLine(3000, 0);
	SKIP:;
        }

   AvgReg(0, (Register[0].stacknumber-90)*CLASSES + Register[0].classnumber);
} while (Read_trial() != FAIL);			/* Next header		*/


fprintf(stderr, "Skip %d trials (%d)\n", skips, skip3or4);

for (i=0; i<8; i++) {
    if (mBase(i) > mBase(peak))
       peak = i;
    if (VERBOSE)
       fprintf(stderr, "%d: %.2f (%d) [peak=%.2f]\n",
		       		i,mBase(i),peak,mBase(peak));
    }
null = peak + 4;
if (null > 7) 
    null -= 8;

if (VERBOSE)
   fprintf(stderr, "Gain field is %.2f (%d %d)\n",
		  	mBase(peak)-mBase(null), peak, null);


if (AVOID_PREF_DIR) {
   int prefdir = round((double)PrefDir)/45;

   switch (prefdir) {
       case 2: case 3: case 4: case 5:
	    if (abs(prefdir - peak) != 2)
	       goto BAD;
	    goto OKAY;
      case 0: 
	    if (peak != 2 && peak != 6)
	       goto BAD;
	    goto OKAY;
      case 1: 
	    if (peak != 3 && peak != 7)
	       goto BAD;
	    goto OKAY;
      case 6: 
	    if (peak != 0 && peak != 4)
	       goto BAD;
	    goto OKAY;
      case 7: 
	    if (peak != 1 && peak != 5)
	       goto BAD;
	    goto OKAY;
      }
   BAD:
     fprintf(stderr, "Skip unit -- not orthog (%d vs %d; %d vs %d)\n", PrefDir, peak*45, prefdir, peak);
     for (i=1; i<=TO_SORT; i++)
      RemoveReg(i);
     return;					/* Don't include it!	*/

   OKAY:
     ;
   }

#ifdef FIDDLE_AROUND
#define Wrap(x)   ((x + 180 + 360) % 360) - 180	/* Return -180 to +180	*/

while (AVOID_PREF_DIR && (abs(Wrap(PrefDir - peak*45)) <= LIMIT)) {
   /* Pref direction, in deg, is PrefDir; gain field is peak*45 */
   int deviation = Wrap(PrefDir - peak*45);

   if ((deviation <= LIMIT) && (deviation >= 0))
       --peak;				/* Rotate away 45 deg	*/
    else if ((deviation >= -LIMIT) && (deviation <= 0))
       ++peak;				/* Rotate 45 deg	*/
   if (peak > 7)
       peak -= 8;
   if (peak < 0)
       peak += 8;

   null = peak + 4;
   if (null > 7) 
       null -= 8;
   fprintf(stderr, "Peak to avoid pref dir is %.2f (%d %d) (deviate=%d)\n",
	mBase(peak)-mBase(null), peak, null, PrefDir-peak*45);
   }
#endif

if ((Ttest_short(
	mBase(peak), N[peak],			/* 2-sided t-test	*/
	Standard_Deviation(Base[peak], Base2[peak], N[peak]) / sqrt(N[peak]),
        mBase(null), N[null],
	Standard_Deviation(Base[null], Base2[null], N[null]) / sqrt(N[null]),
	2) >= P_CRITERION) ||
    (mBase(peak) < mBase(null))) {
   if (VERBOSE)
      fprintf(stderr, "    [%.2f %.2f %d vs %.2f %.2f %d]  ",
	Base[peak],Base2[peak],N[peak],
	Base[null],Base2[null],N[null]);
   fprintf(stderr, 
	"  Skip unit (%.2f vs %.2f P=%.3f\n",
	mBase(peak), mBase(null), 
        Ttest_short( mBase(peak), N[peak],
	   Standard_Deviation(Base[peak], Base2[peak], N[peak]) / sqrt(N[peak]),
           mBase(null), N[null],
	   Standard_Deviation(Base[null], Base2[null], N[null]) / sqrt(N[null]),
	   2));
   for (i=1; i<=TO_SORT; i++)
      RemoveReg(i);
   return;					/* Don't include it!	*/
   }

if (PLOT_AVERAGES) {
	extern void GraphLine(int i, int j);
   GraphErase();
   ChangeParameter('h', "100");
   ChangeParameter('s', "1700");   /* just less than ALIGNMENT_TIME */
   ChangeParameter('w', "2500");
   ChangeParameter('b', "4");
   ChangeParameter('o', "0");
   GraphLine(3000,0);
   ChangeParameter('c', "R");
   GraphData(peak*CLASSES+3);
   ChangeParameter('c', "B");
   GraphData(null*CLASSES+3);
   GraphShutDown();                     	/* Open a new page      */
   GraphSetUp();
   }

/* All the prefs */
RemoveReg(0);
AvgReg(peak*CLASSES+1, 0);
AvgReg(peak*CLASSES+2, 0);
AvgReg(peak*CLASSES+3, 0);
NormalizeReg(0);
AvgReg(0, 2*TO_SORT+1);
strcpy(Register[2*TO_SORT+1].stackname, "Baseline peak");
RemoveReg(0);

/* All the nulls */
AvgReg(null*CLASSES+1, 0);
AvgReg(null*CLASSES+2, 0);
AvgReg(null*CLASSES+3, 0);
NormalizeReg(0);
AvgReg(0, 2*TO_SORT+2);
strcpy(Register[2*TO_SORT+2].stackname, "Baseline null");
RemoveReg(0);

/* Fixed positions so can look at eye/hand positions: */
AvgReg(19, 2*TO_SORT+3);
AvgReg(20, 2*TO_SORT+4);
AvgReg(21, 2*TO_SORT+5);
AvgReg(7, 2*TO_SORT+6);
AvgReg(8, 2*TO_SORT+7);
AvgReg(9, 2*TO_SORT+8);
for (i=3; i<9; i++)
   strcpy(Register[2*TO_SORT+i].stackname, "eye/arm position");

peak++;						/* 0:7 to 1:8 mapping	*/
for (i=1; i<=TO_SORT; i++) {
    int rank = 1 + (i-1)/CLASSES;
    int add  =     (i-1)%CLASSES;
    NormalizeReg(i);
    AvgReg(i, TO_SORT + 1 + CLASSES*(rank-peak + ((rank<peak) ? 8 : 0)) + add);
    RemoveReg(i);
    }
Tag_Registers();
}
/* ******************************************************************** */
/* ******************************************************************** */
/* ******************************************************************** */

/* FUNCTION Tag_Registers */
static void Tag_Registers(void) {
   	char newname[80];
        int i = 0;

	for (i=1+TO_SORT; i<=9+2*TO_SORT; i++)
          if  (ContentReg(i) > 0) {
	   sprintf(newname, "%2d.%d %s",
		   Register[i].stacknumber,
		   Register[i].classnumber,
		   Register[i].stackname);
	   MacroTagReg(i, newname);
	   }
	}
/* ******************************************************************** */
