/* FILE do_mac.c */
     /* Execute a macro */
#include "../defs.h"
#include <ctype.h>					/* isdigit()	*/

extern void jeff_sort_macro(int i);
extern void jeff_initialize_macro(int i);
extern void jeff_divergence_macro(int i);
extern void jeff_initialize_macro(int i);
extern void jeff_divergence_macro(int i);

extern void steve_sort_macro(int i);
extern void steve_reference_sort_macro(int i);
extern void steve_initialize_macro(int i);
extern void steve_reference_initialize_macro(int i);
extern void steve_divergence_macro(int i);

extern void kubanek_sort_macro(int i, int j);
extern void end_kubanek_sort_macro();

extern void gainfield_macro(int PrefDir);
extern void gainfield_initialize_macro(int i);

extern void  set_Harry_sort_macro(char *);
extern void Harry_sort_macro(int channel, int pref, int truncate, 
			     int from, int to, char area);
extern void  end_Harry_sort_macro();

extern void  set_Harry_simple_macro(char *);
extern void Harry_simple_macro(int channel, int pref);

extern void reward_sort_macro(void);

extern void sort_macro(void);

extern void cuesort_macro(void);
extern void cunguosort_macro(int i);
extern void cunguosort_initialize_macro(int i);
extern void StimulationSort(int i);
extern void StimulationSort(int i);
extern void Vestib_sort_macro(void);
extern void vestib_sort_macro(void);
extern void Frames_sort_macro(void);
extern void Memory_sort_macro(int i);
extern void rsvp1_sort_macro(void);
extern void rsvp2_sort_macro(void);
extern void name_macro(void);
extern void yuqing_sort_macro();
extern void yuqing_sort_unit_macro();

extern void PrintRegister_macro(int reg);

/* FUNCTION DoMacro */
         /* Execute a macro (either in batch mode or interactively)	*/
void DoMacro(char *CmdLine) {

 switch(CmdLine[0]) {
  case '?':
    fputs("Macro menu:\n\
  g   sort      Gain field data (dynamic)\n\
  j(J)sort      For Jeff's eye/arm data, 2-99 (intialize)\n\
  t(T)sort      For Steve's R,L arm/eye data (initialize)\n\
  k(K)sort      For Steve's reference frame data (initialize)\n\
  d:  sort	For Jeff's eye/arm data, divergence times 12-99\n\
  s:  sort	Generic\n\
  S:  sort	Stimulation data sorting: Align on tape on\n\
  r:  sort	Sort rsvp1 data (align on target on)\n\
  ^R:  sort	Sort rsvp2 data (align on response or targ on)\n\
  c:  cue sort	Sort cueing experiments\n\
  A:  sort	Stimulation data sorting: align on acquire\n\
  b:  sort      Reward data\n\
  e:  sort      Newer reward data macro\n\
  h:  sort      Sort for Harry's memory data\n\
  ^h:  sort      Initialize Harry's memory data sorter\n\
  H:  sort      End of Harry's memory data (report stuff)\n\
  i:  simple sort   Version of Harry's\n\
  I:  simple sort   Initialize simple sort\n\
  f:  frames    Sort and align frames data; write ascii files\n\
  v:  sort      For frame of reff (vestib+purs) data, class 3, 4-99\n\
  V:  sort      For frame of reff (vestib+purs) data, classes 2-4 7-99\n\
  M:  sort	Memory data sorting (Rob?)\n\
  m:  sort	Memory data sorting (Adam)\n\
  n:  name	Name stacks by stack.class title, 2-99\n\
  y:  sort	For Yuqing's exps, align & sort reaches - BEHAVIOR\n\
  u:  sort	For Yuqing's exps, align & sort reaches - UNITS\n\
  C:  sort	For Cunguo's exps, align & sort reaches - UNITS\n\
  ^C:  sort	  Initalize\n\
  p:  printreg  Print out a register's data\n\
", stderr);
	        inputs( ">   Your order: ",CmdLine);	   /* Read as string */
		DoMacro(CmdLine);			   /* Recursive      */
		return;

  /* g:  sort      For Gijsbert's switch data, 5-00\n\ */

  case 'e': {
 	int i;
	for (i=1; i<30; i++)	/* For 2nd argument (after space)*/
     	   if (CmdLine[i] == ' ')
	      break;
	kubanek_sort_macro(atoi(CmdLine+1), atoi(CmdLine+i+1));
	break;
	}
  case 'E':	end_kubanek_sort_macro();	break;

  case 'g':     gainfield_macro(atoi(CmdLine+1));		break;
  case '':    gainfield_initialize_macro(atoi(CmdLine+1));	break;

  case '': set_Harry_sort_macro(CmdLine+1);
	     break;

  case 'h': {
	int args[5];
	char area = 'A';			/* Any Fef Dlpfc Between*/
	int matched2 = 			/* channel, pref, truncate, area*/
	   sscanf(CmdLine+1, "%d %d %d %c", args,args+1,args+2,(char *)args+3);
			/* Generates warning! -- added cast (1/2018 LHS)*/
	int matched = 			/* channel,pref,truncate,from,to*/
	   sscanf(CmdLine+1, "%d %d %d %d %d",args,args+1,args+2,args+3,args+4);
	if (matched2 > matched) {	/* Specified area, not from/to	*/
	   area = args[3];
	   args[3] = args[4] = 0;
         } else				/* else: Area not specified	*/
	     if (matched == 4)	/* 'to' not specified - go to last trial*/
	   args[4] = 100000;				/* Set "to"!	*/
	else if (matched < 4)
	   args[3] = args[4] = 0;
	else if (matched == 5)
	   area = args[4];
	else if (matched != 5) {
	   fprintf(stderr, "Matched only %d arguments", matched);
	   fatal("Missing argument?");
	   }
	   
	Harry_sort_macro(args[0], args[1], args[2], args[3], args[4], area);
	break;
	}
  case 'H':	end_Harry_sort_macro();		break;

  case 'i': {
 	int i;
	for (i=3; i<30; i++)	/* For 2nd argument (after space)*/
     	   if (CmdLine[i] == ' ')
	      break;
	Harry_simple_macro(atoi(CmdLine+2), atoi(CmdLine+i+1));
	break;
	}
  case 'I': set_Harry_simple_macro(CmdLine+1);
	     break;

  case 'p':     PrintRegister_macro(atoi(CmdLine+1));	break;

  case 'j':	jeff_sort_macro(atoi(CmdLine+1));	break;
  case 'J':	jeff_initialize_macro(atoi(CmdLine+1));	break;
  case 'd':	jeff_divergence_macro(atoi(CmdLine+1));	break;
  case 't':     steve_sort_macro(atoi(CmdLine+1));       break;
  case 'T':     steve_initialize_macro(atoi(CmdLine+1)); break;
  case 'k':     steve_reference_sort_macro(atoi(CmdLine+1));       break;
  case 'K':     steve_reference_initialize_macro(atoi(CmdLine+1)); break;
  case 'b':     reward_sort_macro();			break;
  case 's':     sort_macro();				break;
  case 'S':     StimulationSort(1);			break;
  case 'A':     StimulationSort(2);			break;
  case 'r':	rsvp1_sort_macro();			break;
  case '':	rsvp2_sort_macro();			break;
  case 'c':     cuesort_macro();			break;
  case 'f':     Frames_sort_macro();			break;
  case 'v':	vestib_sort_macro();			break;
  case 'V':	Vestib_sort_macro();			break;
  case 'M':	Memory_sort_macro(atoi(CmdLine+1));	break;
  case 'n':	name_macro();				break;
  case 'y':	yuqing_sort_macro();			break;
  case 'u':	yuqing_sort_unit_macro();		break;
  case 'C':	cunguosort_macro(atoi(CmdLine+1));	break;
  case '':	cunguosort_initialize_macro(atoi(CmdLine+1));	break;
  default :	return;
  }
  return;
}
