/* FILE cunguosort.c	*/
     /* Sort trials in current file for cunguo's experiments */

#include "../defs.h"
#include "../array.h"       		/* Access registers directly	*/
#include "../_imports/deffs.h"
#include "../_imports/event.h"       	/* Stack instruction definitions*/
#include "../_imports/head.h"       	/* Unit number			*/


#define UNIT_FILTER		8		/* [4] [8]		*/
#define EYE_FILTER		32		/* [8] 			*/
#define PRINT_REGISTER_NAMES	0
#define DEBUG			0		/* 0, 1, 2		*/
#define SUBTRACT_BASE		0		/* [0] [31]		*/
#define NORMALIZE_BY_BASE	0		/* [0] [1] (only if SUB)*/
#define SIMPLE_SACCADE_SORT	0		/* [0] type 64 (0100)	*/
	/* If 0, then sort 64 is complex - not 'sort by sac direction', *
	 * but 'sort by sac direction conditioned by arm direction'.    *
	 * So if have in-in, in-out and out-in trials, use only in-in	*
	 * versus in-out; only use out-in if you have out-out		*/

#define ALIGNMENT_TIME		  3000   	/* [3000] 		*/
static int ALIGN_ON_TARGET      = 1;
static int ALIGN_ON_SACCADE     = 0;
static int ALIGN_ON_REACH_START	= 0;
static int ALIGN_ON_REACH_END   = 0;
static int ALIGN_ON_GO_CUE      = 0;
static int ALIGN_ON_CONTRA_REACH_START	= 0;	/* Ipsi for ipsi stack */
static int ALIGN_ON_IPSI_REACH_START	= 0;	/* Contra for contra stack*/
static int AVERAGE_TWO_UNIMANUALS = 0;		/* Collapse stacks 62 & 63*/
#define SACCADE_ALIGN_TYPE	peak		/* "peak", "begin", "end" */
						/* Had been 'begin'	*/

static int UnitChannel		= SPIKE_1;
static int Hemisphere		= 0;		/* 0 is default: LEFT	*/

# define JUST_ONE_HEMISPHERE	0	/* [0] -1 is left, 1 is right	*/
# define JUST_CONTRA_RF		0	/* [0] Cells with contra/ipsi RF*/
# define CROSSED_ONLY		0	/* X'd/unX'd reaches		*/
					/*  Sac: to contra/ipsi side	*/
					/*  Together:assign by left arm */
/* JUST_CONTRA_RF & CROSSED_ONLY interact: Contra & X'd gives pref'd	*/
/* for all but contra-arm & apart; Contra & UnX'd the opposite		*/

# define JUST_ONE_CLASS		0	/* [0] For doing saccades (1-8)	*/

#define SHOW_REGISTERS		0	/* Useful for debugging	*/
#define PLOT_INDIVIDUALS	0	/* Useful for debugging	*/
#define PLOT_AVERAGE		0	/* 2:multi fancy  3:single fancy*/
#define COMPUTE_MEANS		2	/* Give stats (2 types, 1 & 2)	*/
static int SORT_BY_SACCADE =	0;	/* Value is minimum #	*/
static int SORT_COUNT      =    0;
static int SORT_TYPE 	   =	16;	/* 10's place: sort on	*/
static int PRINT_BY_SACCADE   = 0;	/* Print out sorted trials	*/

#define RECTIFY_VELOC		1
#define RECTIFY_POSIT		1	/* Also offsets	*/

#define TO_SORT			31

static int Stacks[] = {31, 32, 40, 41, 42, 43, 44, 48, 50, 0};  /* 0==end */
/* TO_SORT must be at least twice the number of stacks + 2 */
/* Stack 47 is converted to stack 48 */


static void Initialize_Stuff(void);
static void Rm_Registers(void);
static void Subtract_Registers(void);
static void Tag_Registers(void);
static void Sort_Registers(void);
static void Normalize_Registers(void);
static int  Find_StackClass(int stack, int class);

/* ******************************************************************** */
/* FUNCTION cunguosort_initialize_macro() */
	 /* Set up the alignment for the macro */
void cunguosort_initialize_macro(int code) {
   /* Clear them all */
   if (code > 10 && code < 18)
       ALIGN_ON_TARGET = ALIGN_ON_SACCADE = ALIGN_ON_REACH_START =
       ALIGN_ON_CONTRA_REACH_START = ALIGN_ON_IPSI_REACH_START =
       ALIGN_ON_REACH_END = ALIGN_ON_GO_CUE = 0;

   /* Set what you want */
   switch (code) {
      case 11: ALIGN_ON_TARGET = 1; break;
      case 12: ALIGN_ON_GO_CUE = 1; break;
      case 13: ALIGN_ON_SACCADE = 1; break;
      case 14: ALIGN_ON_REACH_START = 1; break;
      case 15: ALIGN_ON_REACH_END = 1; break;
      case 16: ALIGN_ON_CONTRA_REACH_START = 1; break;
      case 17: ALIGN_ON_IPSI_REACH_START = 1; break;

      case 0:  UnitChannel = SPIKE_1;		/* code for chan 0	*/
	       Hemisphere = 0;
	       break;
      case 8:  UnitChannel = SPIKE_1;		/* zen/14-12-06/s1220.2	*/
	       Hemisphere = 1;			/* SPECIAL CASE !!	*/
	       break;

      case 1:  UnitChannel = SPIKE_2; 		/* code for chan 1	*/
	       Hemisphere = 1;
	       break;
      case 2:  UnitChannel = SPIKE_3;		/* code for chan 2	*/
	       Hemisphere = 0;
	       break;
      case 3:  UnitChannel = SPIKE_4; 		/* code for chan 3	*/
	       Hemisphere = 1;
	       break;

      case 20:  UnitChannel = SPIKE_1;		/* code for chan 0	*/
	       Hemisphere = 0;
	       break;
      case 21:  UnitChannel = SPIKE_2; 		/* code for chan 1	*/
	       Hemisphere = 0;
	       break;
      case 22:  UnitChannel = SPIKE_3;		/* code for chan 2	*/
	       Hemisphere = 1;
	       break;
      case 23:  UnitChannel = SPIKE_4; 		/* code for chan 3	*/
	       Hemisphere = 1;
	       break;


      case 9:  AVERAGE_TWO_UNIMANUALS = 1;
         break;


      default: 
	   if ((code >= 999) && (code < 3000)) {
	      if ((PRINT_BY_SACCADE = (code > 2000)))	/* Assign & test*/
	         code -= 1000;
	      if ((SORT_BY_SACCADE = (code > 1000)))	/* Assign & test*/
	         code -= 1000;				/* 999:turn off	*/
   	      SORT_TYPE = code / 10;		/* 10's place: sort on	*/
   	      SORT_COUNT= code % 10;		/* 1's place: min trials*/
              fprintf(stderr, "Sort by sac, type %d min %d trials\n", 
			   SORT_TYPE, SORT_COUNT);
	      return;
	    } else
	      fatal("Unknown initializer!");
      }
   if (code > 10 && code < 18)
      fprintf(stderr, "Align on %d (targ:%d)\n", code, ALIGN_ON_TARGET);
   }
/* ******************************************************************** */

/* FUNCTION cunguosort_macro() */
	 /* Sort shifted trials */
void cunguosort_macro(int direction) {
   extern int DiffChannel;			/* diff.c		*/
   extern  int UseFilter;
   FILE *ByterSplitOut = NULL;
   int  DelayIntervalLength = 0;

Initialize_Stuff();

	/* Only trials with targets in the contra (ipsi) hemifield	*/
# if (JUST_CONTRA_RF==1)
if (((Hemisphere == 1) &&  ((direction <=3) || (direction>=7))) ||
    ((Hemisphere == 0) &&  ((direction >=3) && (direction<=7))))
   return;			/* Contra fields, NOT including vertical*/
# elif (JUST_CONTRA_RF==-1)
if (((Hemisphere == 0) &&  ((direction <=3) || (direction>=7))) ||
    ((Hemisphere == 1) &&  ((direction >=3) && (direction<=7))))
   return;			/* Ipsi fields, NOT including vertical	*/
# endif

if (direction == 0) {			/* No preferred direction	*/
   fprintf(stderr, "No preferred direction!\n");
   return;
   }

/* # define JUST_ONE_HEMISPHERE	0	* 0: std(L)	1: non-std(R)	*/
# if (JUST_ONE_HEMISPHERE)
if (((Hemisphere)? 1 : -1) != JUST_ONE_HEMISPHERE)
   return;
# endif

if (PRINT_BY_SACCADE) {
    ByterSplitOut = fopen("ByterSplitOutput.temp", "w");
    fprintf(ByterSplitOut, "unit  run    trial  code\n");
    }

if (PLOT_AVERAGE == 2) {
   GraphShutDown();			/* Open a new page	*/
   GraphSetUp();
   }

if (ALIGN_ON_SACCADE) {
   extern int SuppressNoSaccadeMessage;
   SuppressNoSaccadeMessage = 1;
   }

Set_ExcludedSpikesFlag(1);		/* Show per cell, not per trial	*/

do {						/* Next trial or header	*/
   int TargetTime = StackExtract(TARGET_ON, 
	(strcmp(Header_Monk(), "tyr")==0 &&	/* Was originally there	*/
	 (Header_Year() < 2016) &&
	 (Register[0].stacknumber < 61))	/* Added 3-31-2015	*/
       	 ? 3: 2,
	    	TIME);
   int TapeOff = StackExtract(TAPE_OFF, 1, TIME);
   int GoCue;
   int i = 1;

   while (StackExtract(TARGET_BLANK, i, ONE) != 1)
       i++;
   GoCue = StackExtract(TARGET_BLANK, i, TIME);

   if (GoCue < 250)
       GoCue = StackExtract(TARGET_BLANK, ++i, TIME);
   if (GoCue < 250)
       fatal("Fix getting the go cue!");

   if (DelayIntervalLength == 0)		/* Set this just once	*/
       DelayIntervalLength = GoCue - TargetTime;

   switch (Register[0].stacknumber) {
      case 47: /* Convert 47 to 48 */		/* Older stack version	*/
	Register[0].classnumber = 1 + ((Register[0].classnumber + 3) % 8);
	Register[0].stacknumber = 48;		/* Flip class number	*/
	break;
      case 82: case 92: /* Memory version	*/
      case 62: /* Convert 62 to 50 (eye only) */		/* Zen	*/
	Register[0].stacknumber = 50; break;	   /* Merge with Tyrol	*/
      case 83: case 93: /* Memory version	*/
      case 63: /* Convert 63 to 31 (L and eye) */		/* Zen	*/
	Register[0].stacknumber = 31; break;
      case 84: case 94: /* Memory version	*/
      case 64: /* Convert 64 to 32 (R and eye) */		/* Zen	*/
	Register[0].stacknumber = 32; break;
      case 85: case 95: /* Memory version	*/
      case 65: /* Convert 65 to 40 (1 T,R+L+e) */		/* Zen	*/
	Register[0].stacknumber = 40; break;
      case 86: case 96: /* Memory version	*/
      case 66: /* Convert 66 to 48 (2 T,R+L+e) */		/* Zen	*/
	Register[0].stacknumber = 48; break;

      /* FREE CHOICE 2-SACCADE TASK, 2017 */
      case 40: /* Experimental condition: 2-target free choice	*/
      case 41: /* Duplicate stack				*/
	if (Header_Year() > 2016)   /* Do not change Cunguo's (old) 40's*/
	   Register[0].stacknumber = 48;	/* If new, re-assign #	*/
	break;
      case 43: /* Control condition: 1-target 'choice'	*/
	if (Header_Year() > 2016)
	   Register[0].stacknumber = 50;	/* If new, re-assign #	*/
	break;
      }

   {		/* Only crossed movements or saccades to contra field	*/
#  if (CROSSED_ONLY)
      # define Class  		 Register[0].classnumber
      # define Stack  		 Register[0].stacknumber
      # define HemisphereRight  (Hemisphere == 1)

      int      TargetRight =    (Class > 7) || (Class < 3);

      fprintf(stderr, "DIAG: The logic (in the sections below) is not right\n");
      if ((Class == 3) || (Class == 7))
         continue;				/* Skip all verticals	*/
#  endif

#  if (CROSSED_ONLY == 1)
      if (Stack == 50)				/* Saccades		*/
         if (HemisphereRight == TargetRight)	/* Same side -- skip	*/
	    continue;

      if (Stack == 31 || Stack==40)		/* Left hand reach	*/
         if (!TargetRight)			/*  UnX'd reach?	*/
	    continue;				/*   Skip		*/
      if (Stack == 32 || Stack == 48)		/* Right hand reach	*/
         if (TargetRight)			/*  UnX'd reach?	*/
	    continue;				/*   Skip		*/

#  elif (CROSSED_ONLY == -1)
      if (Stack == 50)				/* Saccade or both stack*/
         if (HemisphereRight != TargetRight)	/* Opp side -- skip	*/
	    continue;

      if (Stack == 31 || Stack==40)		/* Left hand reach	*/
         if (TargetRight)			/*  X'd reach?	*/
	    continue;				/*   Skip		*/
      if (Stack == 32 || Stack == 48)		/* Right hand reach	*/
         if (!TargetRight)			/*  X'd reach?	*/
	    continue;				/*   Skip		*/
#  endif

#  if (CROSSED_ONLY)
#     undef Class
#     undef Stack
#     undef HemisphereRight
#  endif
   }

#  if (JUST_ONE_CLASS)
   if (Register[0].classnumber != JUST_ONE_CLASS)
       continue;
#  endif

   if (Hemisphere == 1) {			/* Non-std hemisphere(R)*/
      if (Register[0].stacknumber == 31)	/* Swap effective side	*/
          Register[0].stacknumber =  32;
      else if (Register[0].stacknumber == 32)
          Register[0].stacknumber =  31;
      if (Register[0].stacknumber == 48)	/* Swap classes!	*/
	  Register[0].classnumber = 1 + ((Register[0].classnumber + 3) % 8);
        /* class gives location in space (e.g, 1 is right, 5 is left) towards
	 * which the RIGHT arm moves.  With std hemisphere (L), that's the 
	 * contra arm.  If class 1 is PD, then we plot stack all class 1
	 * data as a solid line (for all stacks).  
	 * If record on left, stack 66 [48], class 1 means right (contra)
	 * arm went into the RF - solid line.
	 * If record on rght, stack 66 [48], class 1 means right (IPSI)
	 * arm went into the RF - should be dotted line!!
	 * To fix this, do a diagnoal swap!
	 */
      }


   if (AVERAGE_TWO_UNIMANUALS) {
      if (Register[0].stacknumber == 31)
	  Register[0].stacknumber = 32;
      }

   for (i=0; Stacks[i] > 0; i++)
       if (Register[0].stacknumber == Stacks[i])
	  break;
   if (Stacks[i] <= 0)
	  continue;

#  if (JUST_ONE_CLASS == 0)
   if (Register[0].classnumber == direction)
       Register[0].classnumber = 10;
   else {
       int opp = direction + 4;
       if (opp > 8)
	  opp -= 8;
       if (Register[0].classnumber == opp)
           Register[0].classnumber = 11;
       }
   if (Register[0].classnumber < 10)
      continue;
#  endif
#  if (JUST_ONE_CLASS)
   Register[0].classnumber = 10;
#  endif

   UseFilter = UNIT_FILTER;
   if (UnitChannel != UNIT) {		/* Use channel 1 of units	*/
      Set_CurrentChannel(UnitChannel);	/* Select desired channel	*/
      ChannelDataTransfer(0, UNIT);	/* Transfer units to chan 0	*/
      }
   Set_CurrentChannel(UNIT);		/* Set to Chan 0 in all cases	*/
   if (UseFilter)
      Filter(0);

   UseFilter = EYE_FILTER;
   Set_CurrentChannel(OD_H);
   Filter(0);
   DiffChannel = H_VEL;
   Differentiate(0);

   Set_CurrentChannel(OD_V);
   Filter(0);
   DiffChannel = V_VEL;
   Differentiate(0);

   if (RECTIFY_POSIT) {			/* Always set early posit to 0?	*/
      Set_CurrentChannel(OD_H);
      OffsetData(0,AvgSomeData(0,TargetTime-500,TargetTime+100));
      Set_CurrentChannel(OD_V);
      OffsetData(0,AvgSomeData(0,TargetTime-500,TargetTime+100));
      }

   Set_CurrentChannel(HV_POS);	/* Posit amplitude into X3, veloc -> X4	*/
   ComputeProjectedAmplitudesData(0, -(direction-1)*45);

   if (SORT_BY_SACCADE && Register[0].stacknumber == 48) {
      float StartPosition, SacDirection;
      int time;

      /* Find time based on amplitude	*/
      Set_CurrentChannel(X3);			/* Position amplitude	*/
      StartPosition = AvgSomeData(0, GoCue-1000, GoCue);
      for (time=GoCue; time < (TapeOff-50); time+=50)
	  if (fabs(AvgSomeData(0, time, time+50) - StartPosition/2) > 8.)
	     break;		/* -Start/2: De-emph the start posit	*/
      SacDirection = AvgSomeData(0, time, time+50);
      /* DIAG: the maximum RT allowed is an adjustable parameter!	*/
      /* DIAG: as is distance from start point that defines a saccade	*/

      /* More than the max RT, or if the trial ends w/o a saccade:	*/
      if (time-GoCue > 750 || SacDirection == FAIL ||	/* Adjust time!	*/
                fabs(SacDirection - StartPosition/2) <= 8.) {
	  if (DEBUG)
	     fprintf(stderr, "Late so skipping (%d)\n", time-GoCue);
	  continue;				/* Late: skip this one	*/
          }
      SacDirection -= StartPosition/2;	/* Vector, but de-emph the start*/

       			/* Electrode on left, so right arm is pref	*/
       			/* Class 10: pref arm in preferred direction	*/
      if (SORT_TYPE == 040) {			/* Sort only on arms	*/
	 Register[0].classnumber += 100;	/* All are 110 and 111	*/
#     if (SIMPLE_SACCADE_SORT)
       } else if (SORT_TYPE == 0100) {		/* Sort only on eyes	*/
       Register[0].classnumber = ((SacDirection > 0.) ? 110:111);
#     endif
       } else
         Register[0].classnumber += ((SacDirection > 0.) ? 100 : 200);

/*	 01   SacPrefArmPref   110
	 02   SacNullArmPref   210
	 04   SacPrefArmNull   111
	010  SacNullArmNull    211 	*/
/*           SORT_TYPE  020:   Include all trials */
/*           SORT_TYPE  040:   Sort only by arm (pref/null) */
/*           SORT_TYPE 0100:   Sort only by eye (pref/null) */

      if (PRINT_BY_SACCADE)		/* Include / exclude a subset	*/
	 if (
	     ((SORT_TYPE== 040) && (Register[0].classnumber >  100)) ||
	     ((SORT_TYPE==0100) && (Register[0].classnumber >  100)) ||
	     ((SORT_TYPE &  01) && (Register[0].classnumber == 110)) ||
	     ((SORT_TYPE &  02) && (Register[0].classnumber == 210)) ||
	     ((SORT_TYPE &  04) && (Register[0].classnumber == 111)) ||
	     ((SORT_TYPE & 010) && (Register[0].classnumber == 211)))
            fprintf(ByterSplitOut, "%d %d  %d %d\n",
	  	Header_Unit(), Header_Run(), 
		TrialNumber_file(), Register[0].classnumber);
      }

     if (ALIGN_ON_SACCADE) {
#	include "../sac.h"
	extern int NoSacsBeforeThis;
	extern int NoSacsAfterThis;
	int Move = FAIL;

	{  /* Set ROUGH boundaries to find the outgoing saccade */
	   /* Without this, may align on the RETURN saccade!	*/
	int time;

	{ float StartPosition = 0.;
   	  Set_CurrentChannel(X3);
	  StartPosition = AvgSomeData(0, GoCue-1000, GoCue);
	  for (time=GoCue; time < TapeOff; time+=50)
	    if (fabs(AvgSomeData(0, time, time+50) - StartPosition) > 5.)
		break;
	  }
	NoSacsAfterThis = 50 + time;
	NoSacsBeforeThis = GoCue - 50;

	if (FindSaccade(0) != FAIL)
	    Move = SaccadeData.SACCADE_ALIGN_TYPE; /* Align on peak vel	*/
 	 else while ((Move==FAIL) && (NoSacsAfterThis < 300 + time)) {
	    NoSacsAfterThis += 50;		/* Keep trying wider ...*/
	    NoSacsBeforeThis -= 25;
	    if (FindSaccade(0) != FAIL)
	       Move = SaccadeData.SACCADE_ALIGN_TYPE;	/* Peak vel?	*/
	    }
	}

	if (Move == FAIL) {
	   fprintf(stderr, "%d.%d: Could not find saccade; skipping trial!\n",
		Register[0].stacknumber, Register[0].classnumber);
	   continue;
	   }
	if (DEBUG==2)
	  fprintf(stderr, "move = %d ms\n", Move-GoCue);

	ShiftReg(0,ALIGNMENT_TIME-Move);
    } else if (ALIGN_ON_GO_CUE) {			/* Cue to move	*/
       ShiftReg(0, ALIGNMENT_TIME - GoCue);
    } else if (ALIGN_ON_REACH_END) {			/* end of reach	*/
       int i;
       if (Register[0].stacknumber == 50)		/* Sac stack	*/
	  continue;					/* Just skip!!	*/
       for (i=1; i<6; i++)
	   if (StackExtract(BUTTON_ACQUIRE_OR, i, TIME) > GoCue)
	      break;
       if (i < 6) {				/* Found one		*/
        ShiftReg(0, ALIGNMENT_TIME - StackExtract(BUTTON_ACQUIRE_OR, i, TIME));
       } else {					/* Did not find one	*/
        for (i=1; i<6; i++)
	   if (StackExtract(BUTTON_ACQUIRE_AND, i, TIME) > GoCue)
	      break;
        ShiftReg(0, ALIGNMENT_TIME - StackExtract(BUTTON_ACQUIRE_AND, i, TIME));
	}
    } else if (ALIGN_ON_REACH_START ||
               ALIGN_ON_CONTRA_REACH_START ||
               ALIGN_ON_IPSI_REACH_START
		    ) {				/* start of reach	*/
       extern int ButtonTime(int i), ButtonValue(int i), Header_ButtonCount();
       int DeltaButton = 0;
       int FirstButtonPastCue = 0;
       int i;

       if (Register[0].stacknumber == 50)		/* Sac stack	*/
	  continue;					/* Just skip!!	*/
       for (i=0; i<Header_ButtonCount(); i++) {
	   if (ButtonTime(i) > GoCue)
	      break;	/* Find first button press event after 'go' cue	*/
           }
       if (i >= Header_ButtonCount())
	  fatal("Could not find a button after the go cue!");

       FirstButtonPastCue = i;
       for (  ; i<Header_ButtonCount(); i++) {
	   if (i-FirstButtonPastCue > 3)
	     fatal("Cannot find an appropriate buton");
           /* Event should be release of start buttons (1 or 4 or 1+4)	*/
           DeltaButton = ButtonValue(i-1) - ButtonValue(i);
	   if ((Register[0].stacknumber == 31 && DeltaButton == 1) ||
	       (Register[0].stacknumber == 32 && DeltaButton == 4) ||
               (ALIGN_ON_REACH_START && (DeltaButton & 05)) ||
               (ALIGN_ON_CONTRA_REACH_START && (DeltaButton & 01)) ||
               (ALIGN_ON_IPSI_REACH_START   && (DeltaButton & 04)))
             break;
	   else if (DEBUG)
		fprintf(stderr, "skip button at %d ms : %d\n",
		  		ButtonTime(i)-GoCue, DeltaButton);
          }
       if (DEBUG)
	  fprintf(stderr, "use button at %d ms : %d (stack %d)\n",
  		ButtonTime(i), DeltaButton, Register[0].stacknumber);
       ShiftReg(0, ALIGNMENT_TIME-ButtonTime(i));
    } else if (ALIGN_ON_TARGET) {    /* Put target at ALIGNMENT_TIME ms	*/
       DeleteAllData(0, GoCue+50, 15000); 	/* Rm 50ms post-cue & on*/
       ShiftReg(0, ALIGNMENT_TIME-TargetTime);
    } else {			/* Did not specify alignment or odd value */
       fatal("Odd alignment instruction");
       }

   if (RECTIFY_VELOC && !SORT_BY_SACCADE) {
        Set_CurrentChannel(H_VEL);
        RectifyData(0);
        Set_CurrentChannel(V_VEL);
        RectifyData(0);
        }
   if (RECTIFY_POSIT && !SORT_BY_SACCADE) {
        Set_CurrentChannel(OD_H);
        RectifyData(0);
        Set_CurrentChannel(OD_V);
        RectifyData(0);
        }

   /* FOR GETTING OUTPUT DURING RUNNING OF MACRO: */
   if (PLOT_INDIVIDUALS) {
	extern void GraphLine(int i, int j);
	if (Register[0].stacknumber != 48)
	   goto DO_NOT_PLOT;
	switch (Register[0].classnumber) {
	   case 110:  ChangeParameter('c', "B"); break;
	   case 210:  ChangeParameter('c', "G"); break;
	   default:  goto DO_NOT_PLOT;
	   }
	ChangeParameter('h', "80");
	ChangeParameter('s', "2000");   /* just less than ALIGNMENT_TIME */
	ChangeParameter('w', "1500");
	ChangeParameter('b', "2");
	ChangeParameter('o', "75");
	ChangeParameter('t', "h");	/* h, x1	*/
	GraphData(0);
	ChangeParameter('o', "25");
	ChangeParameter('t', "v");	/* v, x2	*/
	GraphData(0);
	GraphLine(3000, 0);
	DO_NOT_PLOT:;
        }

   AvgReg(0, Find_StackClass(0,0));		/* Determine type	*/
} while (Read_trial() != FAIL);			/* Next header		*/

Print_ExcludedSpikesCount();		/* Show per cell, not per trial	*/

if (SORT_BY_SACCADE) {
   if (PRINT_BY_SACCADE)
      fclose(ByterSplitOut);

   if (SORT_TYPE == 020) {		/* Take everything	*/
      ;
#  if (SIMPLE_SACCADE_SORT)
    } else if ((SORT_TYPE==040) || (SORT_TYPE==0100)) {
#  else
    } else if (SORT_TYPE==040) {
#  endif
      if ((Register[Find_StackClass(48,110)].trial_count >= SORT_COUNT) &&
	  (Register[Find_StackClass(48,111)].trial_count >= SORT_COUNT)) {
         fprintf(stderr, "OK\n");
       } else
	  goto SKIP;
#  if (SIMPLE_SACCADE_SORT == 0)
    } else if (SORT_TYPE==0100) {
      if ((Register[Find_StackClass(48,110)].trial_count >= SORT_COUNT) &&
	  (Register[Find_StackClass(48,111)].trial_count >= SORT_COUNT) &&
	  (Register[Find_StackClass(48,210)].trial_count >= SORT_COUNT) &&
	  (Register[Find_StackClass(48,211)].trial_count >= SORT_COUNT)) {
	 /* Use both arm-in and arm-out trials -- merge them */
	 AvgReg(Find_StackClass(48,111), Find_StackClass(48,110));
	 AvgReg(Find_StackClass(48,211), Find_StackClass(48,210));
	 /* Rename the extra, unused, arm-out registers */
	 /*  (Removing messes up Find_StackClass(). Find_StackClass()	*
	  *  stops looking once it finds an empty slot!			*/
	 Register[Find_StackClass(48,111)].classnumber = 999;
	 Register[Find_StackClass(48,211)].classnumber = 999;
	 /* Rename the merged registers you'll use to '110' and '111' */
	 Register[Find_StackClass(48,210)].classnumber = 111;
         fprintf(stderr, "OK\n");
       } else 
      if ((Register[Find_StackClass(48,110)].trial_count >= SORT_COUNT) &&
	  (Register[Find_StackClass(48,210)].trial_count >= SORT_COUNT)) {
	 /* Use just arm-in trials (110 and 210) */
	 /* Rename the unused, arm-out registers */
	 Register[Find_StackClass(48,111)].classnumber = 999;
	 Register[Find_StackClass(48,211)].classnumber = 999;
	 /* Rename the arm-in registers you'll use to '110' and '111' */
	 Register[Find_StackClass(48,210)].classnumber = 111;
         fprintf(stderr, "OK\n");
       } else 
      if ((Register[Find_StackClass(48,111)].trial_count >= SORT_COUNT) &&
	  (Register[Find_StackClass(48,211)].trial_count >= SORT_COUNT)) {
	 /* Use just arm-out trials (210 and 211) */
	 /* Rename the unused, arm-in registers */
	 Register[Find_StackClass(48,110)].classnumber = 999;
	 Register[Find_StackClass(48,210)].classnumber = 999;
	 /* Rename the arm-out registers you'll use to '110' and '111' */
	 Register[Find_StackClass(48,111)].classnumber = 110;
	 Register[Find_StackClass(48,211)].classnumber = 111;
         fprintf(stderr, "OK\n");
       } else
	  goto SKIP;
#  endif
    } else if (
      (!(SORT_TYPE & 01)		/* sac P and arm pref (110)	*/
	|| (Register[Find_StackClass(48,110)].trial_count >= SORT_COUNT)) &&
      (!(SORT_TYPE & 02)		/* sac N and arm pref (210)	*/
	|| (Register[Find_StackClass(48,210)].trial_count >= SORT_COUNT)) &&
      (!(SORT_TYPE & 04)		/* sac P when arm null (111)	*/
	|| (Register[Find_StackClass(48,111)].trial_count >= SORT_COUNT)) &&
      (!(SORT_TYPE & 010)		/* sac N when arm null (211)	*/
	|| (Register[Find_StackClass(48,211)].trial_count >= SORT_COUNT))) {
      fprintf(stderr, "OK\n");

    } else {					/* Skip this cell	*/
      SKIP:
      if (PRINT_BY_SACCADE)			/* Just an empty file	*/
         system("touch ByterSplitOutput; rm -f ByterSplitOutput.temp");
      fprintf(stderr, "Skip\n");
      Rm_Registers();					/* Clean up	*/
      return;
      }
    if (PRINT_BY_SACCADE)
       system(
  "cat ByterSplitOutput.temp >> ByterSplitOutput; rm -f ByterSplitOutput.temp");
   }
/* if (!SORT_BY_SACCADE)   DIAG: LHS 3-23-2017 */
   Subtract_Registers();

if (COMPUTE_MEANS == 1) {
   int Reg1 = Find_StackClass(40,10);	/* RL, 1 target (in avg, reg 35) */
   int Reg2 = Find_StackClass(48,10);	/* RL, 2 targets(in avg, reg 45) */
#  define offset_from  (ALIGNMENT_TIME + 100)  /* Note: using indi, not avg*/
#  define offset_to    (ALIGNMENT_TIME + 200)
#  define offset_from2 (ALIGNMENT_TIME + -50)
#  define offset_to2   (ALIGNMENT_TIME +  20)
   ChangeParameter('t', "u");
   fprintf(stderr,"\n  %5.2f %5.2f %2.0f  %5.2f %5.2f %2.0f  %5.2f %5.2f %2.0f  %5.2f %5.2f %2.0f\n",
	AvgSomeData(  Reg1,offset_from,offset_to),
	StatsSomeData(Reg1,offset_from,offset_to, "SE"),
	StatsSomeData(Reg1,offset_from,offset_to, "N"),
	AvgSomeData(  Reg1,offset_from2,offset_to2),
	StatsSomeData(Reg1,offset_from2,offset_to2, "SE"),
	StatsSomeData(Reg1,offset_from2,offset_to2, "N"),
	AvgSomeData(  Reg2,offset_from,offset_to),
	StatsSomeData(Reg2,offset_from,offset_to, "SE"),
	StatsSomeData(Reg2,offset_from,offset_to, "N"),
	AvgSomeData(  Reg2,offset_from2,offset_to2),
	StatsSomeData(Reg2,offset_from2,offset_to2, "SE"),
	StatsSomeData(Reg2,offset_from2,offset_to2, "N"));
  } else if (COMPUTE_MEANS == 2) {
   int ii;
   static int which[6] = {50,31,32,40,48,48};

			/* Note: showing each indi CELL, not cell avg	*/
   int from_time = ALIGNMENT_TIME;
   int to_time   = ALIGNMENT_TIME;
   FILE *File = fopen("Unit.means", "a");

   if (ALIGN_ON_TARGET) {
      from_time += 500;
      to_time   += 1250;
      if (to_time > ALIGNMENT_TIME + DelayIntervalLength + 50)
         fprintf(stderr, "Averaging data past the delay period! See macro!\n");
    } else if (ALIGN_ON_SACCADE) {
      from_time += 50;
      to_time   += 150;
    } else if (ALIGN_ON_GO_CUE) {
      from_time += -500;
      to_time   +=  0;
    } else		/* Placeholder; already tested this case!	*/
     if (ALIGN_ON_TARGET) {	/* Use for units with short delays	*/
      if (to_time > ALIGNMENT_TIME + DelayIntervalLength + 50)
          to_time = ALIGNMENT_TIME + DelayIntervalLength + 50 - 2;
      if (from_time > ALIGNMENT_TIME + DelayIntervalLength) {
          fprintf(stderr, "'From time' is %d, Delay interval is %d\n",
			  from_time, DelayIntervalLength);
          fatal("Should never happen!\n");
          }
      }

   Set_CurrentChannel(UNIT);		/* Set to Chan 0 in all cases	*/
   fprintf(File, "\n%d %d.%d\n", UnitChannel,h.id.unit, h.id.run); 
   for (ii=0; ii<6; ii++) {
      int class = 10;
      int qq;
      
      if (ii==4)
	 class += 100;
      if (ii==5)
	 class += 200;

      for (qq=0; qq<2; qq++) {
         int reg = Find_StackClass(which[ii], class+qq); /* class 10&11 */
	 int nn = Register[reg].trial_count;
         fprintf(File,"%3d %3d     ", which[ii], class+qq);
         if (nn == 0)
	    fprintf(File, "     0      0   0\n");
          else
            fprintf(File,"%6.2f %6.2f %2d\n",
	      AvgSomeData(reg, from_time,to_time),
	         (nn==1)? 0:
	      StatsSomeData(reg, from_time,to_time, "SE"),
	      nn);
	 }
      }
   fclose(File);
  } else if (COMPUTE_MEANS == 3) {
   int ii;
   static int which[5] = {50,31,32,40,48};

   fprintf(stderr, "Should subtract baseline ...\n");
   fprintf(stderr, "\n");    
   ChangeParameter('t', "u");
   for (ii=0; ii<5; ii++)
      fprintf(stderr,"  %d:  %5.2f %5.2f   %5.2f %5.2f\n",
	ii,
	AvgSomeData(  Find_StackClass(which[ii],10), 3650, 4150),
	StatsSomeData(Find_StackClass(which[ii],10), 3650, 4150, "SE"),
	AvgSomeData(  Find_StackClass(which[ii],11), 3650, 4150),
	StatsSomeData(Find_StackClass(which[ii],11), 3650, 4150, "SE"));
   fprintf(stderr, "\n");    
   }



if (PLOT_AVERAGE) {
   extern void GraphLine(int i, int j);
   if (PLOT_AVERAGE == 2) {
      extern void GraphLine(int i, int j);
      Set_CurrentChannel(UNIT);		/* Set to Chan 0 in all cases	*/
      UseFilter = UNIT_FILTER;
      Filter(Find_StackClass(31,10));
      Filter(Find_StackClass(32,10));
      Filter(Find_StackClass(40,10)); 
      Filter(Find_StackClass(48,10)); 
      Filter(Find_StackClass(31,11));
      Filter(Find_StackClass(32,11));
      Filter(Find_StackClass(40,11)); 
      Filter(Find_StackClass(48,11)); 	
      /* DeleteData(Find_StackClass(40,10), 4250, 7000); */
      }
   ChangeParameter('s', "2500");
   ChangeParameter('w', "3000");
   ChangeParameter('h', "80");
   ChangeParameter('t', "u");
   ChangeParameter('o', "0");
   if (PLOT_AVERAGE > 1) {
      ChangeParameter('w', "1555");
      ChangeParameter('s', "2700");
      ChangeParameter('h', "90");	/* For CI, 120; IC: 60 */
      }

   ChangeParameter('c', "A");
   ChangeParameter('b', "30");
   GraphLine(3000,0);
   GraphLine(4250,0);
   if (0) {
      ChangeParameter('e', "1");		/* Errors on	*/
      ChangeParameter('e', "s");		/* Ribbon	*/
      }
   ChangeParameter('c', "B");
   GraphData(Find_StackClass(40,10));	 /* Both, together (blue) */
   ChangeParameter('c', "B");
   ChangeParameter('c', "r8");
   GraphData(Find_StackClass(48,10));	 /* Both, apart (purple) */
   GraphData(Find_StackClass(48,110));	 /* Both, apart (purple) */
   if (1 || PLOT_AVERAGE == 1) {	/* Override: always do it!	*/
      ChangeParameter('c', "G");
      GraphData(Find_StackClass(31,10));	/* Left (green)		*/
      ChangeParameter('c', "R");
      GraphData(Find_StackClass(32,10));	/* Right (red)		*/
      ChangeParameter('c', "A");		/* or cca0 ?		*/
      GraphData(Find_StackClass(50,10));	 /* Saccade (black)	*/
      }

   ChangeParameter('l', "2");
   ChangeParameter('c', "B");
   GraphData(Find_StackClass(40,11));	 /* Both, together (blue) */
   ChangeParameter('c', "B");
   ChangeParameter('c', "r8");
   GraphData(Find_StackClass(48,11));	  /* Both, apart (purple) */
   GraphData(Find_StackClass(48,111));	  /* Both, apart (purple) */
   if (1 || PLOT_AVERAGE == 1) {	/* Override: always do it!	*/
      ChangeParameter('c', "G");
      GraphData(Find_StackClass(31,11));	/* Left (green)		*/
      ChangeParameter('c', "R");
      GraphData(Find_StackClass(32,11));	/* Right (red)	*/
      ChangeParameter('c', "A");		/* or cca0 ? */
      GraphData(Find_StackClass(50,11)); 	/* Saccade (black)	*/
      }
   }
#if (JUST_ONE_CLASS == 0)
Normalize_Registers();
#endif
Sort_Registers();
Tag_Registers();
Rm_Registers();
if (SHOW_REGISTERS)
   ListReg();
}
/* ******************************************************************** */

/* FUNCTION Initialize_Stuff */
         /* Init */
static void Initialize_Stuff(void) {
   extern  int StepMs;				/* Differentiation stuff*/

   StepMs = 1;					/* Set up differentiator*/
   }
/* ******************************************************************** */
/* ******************************************************************** */
/* ******************************************************************** */

/* FUNCTION Subtract_Registers */
	 /* Get pref minus nulls */
static void Subtract_Registers(void) {
	int i;					/* First open register	*/

   for (i=1; i<TO_SORT; i++)
     if  (ContentReg(i) <= 0)
	break;

   if (i > TO_SORT-2)
      fatal("TO_SORT too small!");

   int j;
   for (j=0; Stacks[j] > 0; j++) {
     if (SORT_BY_SACCADE) {
      if (Register[Find_StackClass(Stacks[j],110)].trial_count) {
         CopyReg(Find_StackClass(Stacks[j],110), i);
         SubtractReg(i, Find_StackClass(Stacks[j],111));/* In - out	*/
         Register[i].stacknumber = Stacks[j];
	 Register[i].classnumber = 112;			/* Diff stack	*/
         i++;
         }
      if (Register[Find_StackClass(Stacks[j],210)].trial_count) {
         CopyReg(Find_StackClass(Stacks[j],210), i);
         SubtractReg(i, Find_StackClass(Stacks[j],211));/* In - out	*/
         Register[i].stacknumber = Stacks[j];
	 Register[i].classnumber = 212;			/* Diff stack	*/
         i++;
         }
     } else {
      if (Register[Find_StackClass(Stacks[j],10)].trial_count) {
         CopyReg(Find_StackClass(Stacks[j],10), i);
         SubtractReg(i, Find_StackClass(Stacks[j],11));	/* In - out	*/
         Register[i].stacknumber = Stacks[j];
	 Register[i].classnumber = 12; 			/* Diff stack	*/
         i++;
         }
     }
    }

   int k;
   if (SUBTRACT_BASE) {
      for (j=0; Stacks[j] > 0; j++)
	  for (k=10; k<12; k++) {
	      if ((k==11) & (Stacks[j] == SUBTRACT_BASE))
	         continue;
              SubtractReg(				/* to -= minus	*/
	           Find_StackClass(Stacks[j],k),		/* to	*/
	           Find_StackClass(SUBTRACT_BASE,11));		/* minus*/
	      }
      SubtractReg( Find_StackClass(48,110),			/* to	*/
	           Find_StackClass(SUBTRACT_BASE,11));		/* minus*/
      SubtractReg( Find_StackClass(48,111),			/* to	*/
	           Find_StackClass(SUBTRACT_BASE,11));		/* minus*/
      SubtractReg( Find_StackClass(48,210),			/* to	*/
	           Find_StackClass(SUBTRACT_BASE,11));		/* minus*/
      SubtractReg( Find_StackClass(48,211),			/* to	*/
	           Find_StackClass(SUBTRACT_BASE,11));		/* minus*/
 
      SubtractReg( Find_StackClass(SUBTRACT_BASE,11),  /* Save for last	*/
	           Find_StackClass(SUBTRACT_BASE,11));

      Set_CurrentChannel(UNIT);
      if (NORMALIZE_BY_BASE) {
	 extern float multiplier;
	 multiplier = 40. / AvgSomeData( Find_StackClass(SUBTRACT_BASE,10),
				      ALIGNMENT_TIME+150, ALIGNMENT_TIME+600);
	 /* if (multiplier > 5.) multiplier = .5;	* DIAG */
	 fprintf(stderr, "DIAG: %.1f\n", multiplier);
         for (j=0; Stacks[j] > 0; j++)
	     for (k=10; k<12; k++) {
		NormalizeReg(Find_StackClass(Stacks[j],k));
      		Set_CurrentChannel(UNIT);
	        MultiplyData(Find_StackClass(Stacks[j],k));
	        }
         }
      }
   }
/* ******************************************************************** */

/* FUNCTION Rm_Registers */
	 /* Remove unsorted stuff */
static void Rm_Registers(void) {
   int i = 0;

   for (i=0; i<TO_SORT; i++)
      RemoveReg(i);
   }
/* ******************************************************************** */

/* FUNCTION Normalize_Registers */
         /* Make'm look like 1 trial */
static void Normalize_Registers(void) {
   int i;
   for (i=1; i<TO_SORT; i++)
      NormalizeReg(i);
   }
/* ******************************************************************** */

/* FUNCTION Sort_Registers */
	 /* Note: If SORT_BY_SACCADE, don't include the subtracted regs	*/
static void Sort_Registers(void) {
   int to = TO_SORT;
   int i;

   for (i=0; Stacks[i] > 0; i++) {
       AvgReg(Find_StackClass(Stacks[i],10), to++);
       AvgReg(Find_StackClass(Stacks[i],11), to++);
       }

   if (SORT_BY_SACCADE) {
      AvgReg(Find_StackClass(48,110), to++);	/* Reg 49, I think	*/
      AvgReg(Find_StackClass(48,111), to++);	/* Reg 50		*/
      AvgReg(Find_StackClass(48,210), to++);	/* Reg 51		*/
      AvgReg(Find_StackClass(48,211), to++);	/* Reg 52		*/
      if (Register[Find_StackClass(48,112)].trial_count)
         AvgReg(Find_StackClass(48,112), 2*TO_SORT+i);
    } else {
      for (i=0; Stacks[i] > 0; i++)
         if (Register[Find_StackClass(Stacks[i],12)].trial_count)
               AvgReg(Find_StackClass(Stacks[i],12), 2*TO_SORT+i);
      }
   }
/* ******************************************************************** */

/* FUNCTION Tag_Registers */
static void Tag_Registers(void) {
   	char newname[80];
        int i = 0;

	for (i=0; i<3*TO_SORT; i++)
          if  (ContentReg(i) > 0) {
	   sprintf(newname, "%2d.%d %s",
		   Register[i].stacknumber,
		   Register[i].classnumber,
		   Register[i].stackname);
	   MacroTagReg(i, newname);
	   if (PRINT_REGISTER_NAMES)
	      fprintf(stderr, "  %2d: %2d.%d %s\n", i,
		      Register[i].stacknumber,
		      Register[i].classnumber,
		      Register[i].stackname);
	   }
	}
/* ******************************************************************** */

/* FUNCTION Find_StackClass */
	 /* Return index of specified stack.class OR of register 0	*/
static int  Find_StackClass(int stack, int class) {
    int i;

    if (stack==0)	/* If not specified, use register 0's value	*/
        stack = Register[0].stacknumber;
    if (class==0)
        class = Register[0].classnumber;

    for (i=1; i<TO_SORT; i++) {
       if (Register[i].trial_count <= 0)		/* Empty?	*/
	  return(i);					/*  Use it	*/
        else						/* Else: match?	*/
        if (   (stack == Register[i].stacknumber)
            && (class == Register[i].classnumber))
	  return(i); 
       }
    return(FAIL);
    }
/* ********************************************************************	*/
