/* FILE cuesort.c	*/
     /* Sort trials in current file for cue experiments */

#include "../defs.h"
#include "../array.h"       		/* Access registers directly	*/
#include "../_imports/deffs.h"
#include "../_imports/event.h"       	/* Stack instruction definitions*/


#define FILTER			0	/* Heavy (9 Hz) or light (46 Hz)*/
#define PRINT_REGISTER_NAMES	0

#define ALIGNMENT_TIME		1000
#define ALIGN_ON_TARGET		1
#define ALIGN_ON_SACCADE	0

#define WRITE			0

static void Initialize_Stuff(void);
static void Write_to_Disk(void);
static void Tag_Registers(void);
static void Sort_Registers(void);
static int  Find_TrialClass(int stack, int class);

/* ******************************************************************** */

/* FUNCTION cuesort_macro() */
	 /* Sort shifted trials */
void cuesort_macro(void) {
   extern int DiffChannel;			/* diff.c		*/

Initialize_Stuff();

do {						/* Next trial or header	*/
   int TargetTime = StackExtract(TARGET_RAMP_INTENSITY, 1, TIME);

   switch (Register[0].stacknumber) {
	case 4: case 6: case 8:
	   Register[0].stacknumber = 4;
	   break;
	case 5: case 7: case 9:
	   Register[0].stacknumber = 5;
	   break;
	case 14:
	   break;
	case 15:
	   break;

	default:				/* Skip 20, 30:32, etc	*/
	   continue;
	}

   Set_CurrentChannel(OD_H);
   Filter(0);
   DiffChannel = H_VEL;
   Differentiate(0);

   Set_CurrentChannel(OD_V);
   Filter(0);
   DiffChannel = V_VEL;
   Differentiate(0);

   if (FILTER) {
      Set_CurrentChannel(UNIT);		/* Filter indis: SE is smooth	*/
      Filter(0);
      }


     if (ALIGN_ON_SACCADE) {	/* Saccade or arm movement	*/
#	define IGNORE_IT	320000
#	include "../sac.h"
	int Move;
	extern int NoSacsBeforeThis;
	/*extern int NoSacsAfterThis; */
	int HorizMove=IGNORE_IT, VertMove=IGNORE_IT;
	float HorizSize=0., VertSize=0.;

	NoSacsBeforeThis = TargetTime;

   	 Set_CurrentChannel(OD_H);		/* Look in both chans	*/
	if(FindSaccade(0) != FAIL) {
	    HorizMove = SaccadeData.begin;
 	      HorizSize = fabs(
	    	   AvgSomeData(0, SaccadeData.end, SaccadeData.end+30)-
 		   AvgSomeData(0, SaccadeData.begin-30, SaccadeData.begin));
	    }
   	 Set_CurrentChannel(OD_V);
	if(FindSaccade(0) != FAIL) {
	    VertMove = SaccadeData.begin;
 	      VertSize = fabs(
	        AvgSomeData(0, SaccadeData.end, SaccadeData.end+30)-
 		  AvgSomeData(0, SaccadeData.begin-30, SaccadeData.begin));
	    }

	if((VertMove != FAIL && HorizMove != FAIL) &&
	     abs(HorizMove - VertMove) > 100) {  /* Two diff sacs?	*/
	    if (HorizSize > 3 * VertSize)	   /* Vert too small	*/
	        VertMove = IGNORE_IT;		   /* Disregard it	*/
	    if (VertSize > 3 * HorizSize) 	   /* Horiz too small	*/
	        HorizMove = IGNORE_IT;
	    }				/* Now take the earlier:	*/
	Move= (HorizMove < VertMove) ? HorizMove : VertMove;
	if(Move == IGNORE_IT)	/* Didn't find any?		*/
	     Move = FAIL;

	if(Move == FAIL) {
	  fprintf(stderr, "Could not find saccade; skipping trial!\n");
	  continue;
	  }
	ShiftReg(0,ALIGNMENT_TIME-Move);
    } else {			/* Put target at ALIGNMENT_TIME ms	*/
       ShiftReg(0, ALIGNMENT_TIME-TargetTime);
       }
							
   AvgReg(0, Find_TrialClass(0,0));		/* Determine type	*/

} while (Read_trial() != FAIL);			/* Next header		*/

Sort_Registers();
Tag_Registers();

if (WRITE)
   Write_to_Disk();
}
/* ******************************************************************** */

/* FUNCTION Initialize_Stuff */
         /* Init */
static void Initialize_Stuff(void) {
   extern  int StepMs;				/* Differentiation stuff*/
   extern  int UseFilter;

   StepMs = 1;					/* Set up differentiator*/
   UseFilter = (FILTER) ? 2 : 12;		/* Heavy or light?	*/
   }
/* ******************************************************************** */
/* ******************************************************************** */
/* ******************************************************************** */

/* FUNCTION Write_to_Disk */
	 /* Write to disk */
static void Write_to_Disk(void) {
   int i = 0;

   while (ContentReg(++i) > 0)
         RawFile(i);				/* Disk copies	*/
   }
/* ******************************************************************** */

/* FUNCTION Sort_Registers */
static void Sort_Registers(void) {
   int i = 1;
   int c,s;

   for (c=1; c<17; c++)
      for (s=1; s<50; s++) {
         int it = Find_TrialClass(s,c);
	 if (it < 0) 
	    continue;;
         if (Register[it].trial_count > 0) {		/* Found it?	*/
	    /* RemoveReg(0); */
            CopyReg(i, 0);
	    /* RemoveReg(i); */
	    CopyReg(it, i++);
	    /* RemoveReg(it); */
	    CopyReg(0, it);
            }
	 }
   }     
/* ******************************************************************** */

/* FUNCTION Tag_Registers */
static void Tag_Registers(void) {
   	char newname[80];
        int i = 0;

        while (ContentReg(++i) > 0) {
	   sprintf(newname, "%2d.%d %s",
		   Register[i].stacknumber,
		   Register[i].classnumber,
		   Register[i].stackname);
	   MacroTagReg(i, newname);
	   if (PRINT_REGISTER_NAMES)
	      fprintf(stderr, "  %2d: %2d.%d %s\n", i,
		      Register[i].stacknumber,
		      Register[i].classnumber,
		      Register[i].stackname);
	   }
	}
/* ******************************************************************** */

/* FUNCTION Find_TrialClass */
	 /* Return index of specified stack.class OR of register 0	*/
static int  Find_TrialClass(int stack, int class) {
    int i;

    if (stack==0)	/* If not specified, use register 0's value	*/
        stack = Register[0].stacknumber;
    if (class==0)
        class = Register[0].classnumber;

    for (i=1; i<MAX_REGISTERS; i++) {
       if (Register[i].trial_count <= 0)		/* Empty?	*/
	  return(i);					/*  Use it	*/
        else						/* Else: match?	*/
        if (   (stack == Register[i].stacknumber)
            && (class == Register[i].classnumber))
	  return(i); 
       }
    return(FAIL);
    }
/* ********************************************************************	*/
