/* FILE Vestibmac.c	*/
     /* Read a string of units in; normalize each to a single trial and
        then add to a main register */
    /* WARNING: Not keeping the 10 deg horizontal trials */
 
#include "../defs.h"
#include "../array.h"       		/* Access registers directly	*/
#include "../sac.h"
#include "../_imports/deffs.h"
#include "../_imports/event.h"       	/* Stack instruction definitions*/
#include <stdlib.h>

#define ALIGN_ON_TARGET_ON	0	/* Cue onset			*/
#define ALIGN_ON_FIX_OFF	0	/* Fixation point offset	*/
#define ALIGN_ON_BEGIN_MOVEMENT 0	/* Beginning of purs/rotate     */
#define ALIGN_ON_MID_MOVEMENT	0	/* Mid pursuit, rotate or sac	*/
#define ALIGN_ON_END_MOVEMENT	0	/* End of movement(smpurs,rotate)*/
#define ALIGN_ON_SACCADE	1	/* Final saccade		*/

#define NORMALIZE_TRIAL_COUNT	0	/* Each unit gets equal weight	*/
#define NORMALIZE_RATE		0	/* Each unit gets equal weight	*/
#define OFFSET			0	/* Each unit starts at 0	*/

#define PRINT_REGISTER_NAMES	0	/* Print it on screen		*/
#define WRITE_TO_DISK   	0

#define PLOT_INDIVIDUALS	0	/* Plots of indi cell data	*/
#define PLOT_SINGLES		0	/* Plots of indi trial data	*/

#define HEAVIEST_FILTER		1	/* Overrides 'heavy'		*/
#define HEAVY_FILTER		1	/* Heavy (2-4 Hz) or light (46)	*/
#define DOUBLE_FILTER_UNITS	1	/* Makes SE much cleaner	*/
#define DO_EYE_TRACES		1	/* Filter, etc:  very slow	*/

#define SKIP_FIRST_CLASS	0	/* Did early on (not collected?)*/

#define TO_SORT			50
	/* vest/sac/purs * 4 classes * 2 directions * Eye/World	*/

static void Initialize_Stuff(void);
static void Write_to_Disk(void);
static void Tag_Registers(void);
static void Normalize_Registers(int Target_At);
static void Offset_Registers(void);
static void Avg_Registers(void);
static void Subtract_Registers(void);
static void Clean_Registers(void);
static int  Find_TrialType(void);
static int  Find_Register(int stack, int class);
static int Find_ClassOffset(void);


#define NOT_FOUND	INVALID_REG		/* 999			*/
/* ******************************************************************** */

/* FUNCTION Vestib_sort_macro() */
	 /* Sort trials */
void Vestib_sort_macro() {
   extern int DiffChannel;			/* diff.c		*/
   static int ToldUs = 0;
   int Target_At = FAIL;			/*Time target appears at*/
   extern int UseFilter;
   int FilterSetting;
   int SkipCount = 0;
			/* Odd: fails if use "extern int DiffChannel"	*/

if (ALIGN_ON_TARGET_ON + ALIGN_ON_FIX_OFF + ALIGN_ON_BEGIN_MOVEMENT +
    ALIGN_ON_MID_MOVEMENT + ALIGN_ON_END_MOVEMENT + ALIGN_ON_SACCADE > 1)
   fatal("Choose just one alignment method");
if (ALIGN_ON_TARGET_ON + ALIGN_ON_FIX_OFF + ALIGN_ON_BEGIN_MOVEMENT +
    ALIGN_ON_MID_MOVEMENT + ALIGN_ON_END_MOVEMENT + ALIGN_ON_SACCADE == 0)
   fatal("Choose an alignment method");
if (ToldUs++ == 0)
 fprintf(stderr, "Align on %s\n",			/* Tell us	*/
  (ALIGN_ON_TARGET_ON)    ? "target on" : (
  (ALIGN_ON_FIX_OFF)      ? "fixation off": (
  (ALIGN_ON_BEGIN_MOVEMENT) ? "begin movement": (
  (ALIGN_ON_MID_MOVEMENT) ? "mid movement": (
  (ALIGN_ON_SACCADE) ? "final saccade" : (
  (ALIGN_ON_END_MOVEMENT) ? "end movement": "??"))))));

if (MAX_REGISTERS <= 2*TO_SORT + 2) {
   fprintf(stderr, "MAX_REG is only %d; need %d\n", MAX_REGISTERS, 2*TO_SORT+3);
   fatal("Increase MAX_REGISTERS or decrease TO_SORT");
   }

Initialize_Stuff();

if (HEAVIEST_FILTER)
    FilterSetting = 1;
else if (HEAVY_FILTER)
    FilterSetting = 2;
else
    FilterSetting = 12;

if (PLOT_SINGLES) {
  ChangeParameter('o', "20");
  ChangeParameter('h', "140");
  ChangeParameter('w', "2350");
  ChangeParameter('s', "650");
  ChangeParameter('m', "0");
  ChangeParameter('i', "0");
  }


do {						/* Next trial or header	*/
#    if SKIP_FIRST_CLASS
     if (Register[0].classnumber == 5 || Register[0].classnumber == 1)
	continue;	/* Early on didn't collect these, but later, did*/
#    endif

     Register[0].stacknumber = (Register[0].stacknumber % 100);

     if ((Register[0].stacknumber % 10) < 2)
        continue;			/* Why are we skipping 100-119?	*/
     if ((Register[0].stacknumber < 21))
        continue;			/* Skip stacks 1-20	*/
     if (((Register[0].stacknumber % 10) == 6 ||
	  (Register[0].stacknumber % 10) == 7)  &&
           Register[0].classnumber < 5)
        continue;	/* These are horizontal 10 degree stacks	*/
     if ((Register[0].classnumber > 8))
        continue;			/* Skip classes > #8		*/


     Set_CurrentChannel(UNIT);		/* Filter indis: SE is smooth	*/
     UseFilter = FilterSetting;
     Filter(0);
     if (DOUBLE_FILTER_UNITS)
        Filter(0);			/* Filter twice: cleaner SE's	*/

     {
     int occur = 0;

     while (StackExtract(TARGET_RE_1, ++occur, ONE) != 3) /* Target 3?	*/
        if (occur > 100)
           fatal("Can't find target 3 RE_1");
     Target_At = StackExtract(TARGET_RE_1,occur,TIME);

     occur = 0;

#    if ALIGN_ON_TARGET_ON
      ShiftReg(0, 1000 - Target_At);
#    elif ALIGN_ON_FIX_OFF
     {
      int time_off, time_blank;
      while (StackExtract(TARGET_OFF, ++occur, ONE) != 1) /* Target 1?	*/
         if (occur > 100)
	    break;
      time_off = StackExtract(TARGET_OFF, occur, TIME);
      occur = 0;
      while (StackExtract(TARGET_BLANK, ++occur, ONE) != 1) /* Targ 1	*/
         if (occur > 100)
	    break;
      time_blank = StackExtract(TARGET_BLANK, occur, TIME);
	
      if (time_off == FAIL && time_blank == FAIL)
         fatal("Can't find target blank/off");

      if ((time_off==FAIL) ||		/* Only a 'blank' exists	*/
          (time_blank != FAIL &&	/* Both exist, and		*/
	      time_blank<time_off))	/* blank occurs BEFORE off:	*/
	time_off = time_blank;		/* Then use blank time		*/
					/* Else use off time		*/
      ShiftReg(0, 2500 - time_off);
     }
#    elif ALIGN_ON_END_MOVEMENT
      {
      int end_movement;

      end_movement = StackExtract(TARGET_SAC, 1, TIME);	/* Check for sac*/
      if (end_movement != FAIL) {
	 end_movement = StackExtract(ACQUIRE, 2, TIME);	/* Acq time	*/
	 goto SACCADE_TRIALS_END;
	 }

      while (StackExtract(CHAIR_AT, ++occur, TIME) != FAIL) ;
      if (occur == 1 || occur > 100) {
         occur = 0;			/* Try looking for pursuit	*/
         while (StackExtract(TARGET_PURSUIT, ++occur, TIME) != FAIL) ;
         if (occur == 1 || occur > 100)
	    fatal("Can't find rotation or pursuit (or too many)");
         end_movement = StackExtract(TARGET_PURSUIT,occur-1,TIME);
      } else {
         end_movement = StackExtract(CHAIR_AT,occur-1,TIME);
	 }

      SACCADE_TRIALS_END:
      ShiftReg(0, 2500 - end_movement);
      }
#    elif ALIGN_ON_MID_MOVEMENT
      {
      int mid_movement;
      int end, begin;

      mid_movement = StackExtract(TARGET_SAC, 1, TIME);	/* Check for sac*/
      if (mid_movement != FAIL) {
	 goto SACCADE_TRIALS;
	 }

      while (StackExtract(CHAIR_AT, ++occur, TIME) != FAIL) ;
      if (occur == 1 || occur > 100) {
         occur = 0;			/* Try looking for pursuit	*/
         while (StackExtract(TARGET_PURSUIT, ++occur, TIME) != FAIL);
         if (occur==1 || occur > 100)
	    fatal("Can't find rotation or pursuit (or too many)");
         while (StackExtract(TARGET_PURSUIT, --occur, ONE) != 1) ;
	 						/* Last target 1 */
	 end = StackExtract(TARGET_PURSUIT,occur,TIME);
         while (StackExtract(TARGET_PURSUIT, --occur, ONE) != 1) ;
	 						/* 2nd to last#1 */
         begin = StackExtract(TARGET_PURSUIT,occur,TIME);
         if (occur < 1)
	    fatal("Can't find start (and end?) of pursuit");
      } else {
	 end = StackExtract(CHAIR_AT,occur-1,TIME);
         begin = StackExtract(CHAIR_AT,occur-2,TIME);
	 }
      mid_movement = begin + (end - begin) / 2;
      SACCADE_TRIALS:
      ShiftReg(0, 2500 - mid_movement);
      }
#    elif ALIGN_ON_BEGIN_MOVEMENT
      {
      int begin_movement;
      while (StackExtract(CHAIR_AT, ++occur, TIME) != FAIL) ;
      if (occur == 1 || occur > 100) {
         occur = 0;                     /* Try looking for pursuit      */
         while (StackExtract(TARGET_PURSUIT, ++occur, TIME) != FAIL) ;
	 						/* Last pursuit	*/
         if (occur == 1 || occur > 100)
            fatal("Can't find rotation or pursuit (or too many)");
         while (StackExtract(TARGET_PURSUIT, --occur, ONE) != 1) ;
	 						/* Last target 1*/
         while (StackExtract(TARGET_PURSUIT, --occur, ONE) != 1) ;
	 						/* 2nd to last#1*/
         begin_movement = StackExtract(TARGET_PURSUIT,occur,TIME);
         if (occur < 1)
	    fatal("Can't find start (and end?) of pursuit");
      } else {
         begin_movement = StackExtract(CHAIR_AT,occur-2,TIME);
         }
      ShiftReg(0, 2500 - begin_movement);
      }
#    elif ALIGN_ON_SACCADE
      {
      int at, at_h, at_v;
      float size_h = 0., size_v = 0.;
      int occur = 0;
      extern int NoSacsBeforeThis;
      extern int NoSacsAfterThis;
      extern int SuppressNoSaccadeMessage;
      
      while (StackExtract(TARGET_PURSUIT, ++occur, TIME) != FAIL) ;
      NoSacsBeforeThis = StackExtract(TARGET_PURSUIT, occur-1, TIME);

      occur = 0;
      while (StackExtract(TARGET_DIM, ++occur, TIME) != FAIL) ;
      NoSacsAfterThis = StackExtract(TARGET_DIM, occur-1, TIME);

      if (NoSacsAfterThis == FAIL) {
         occur = 0;
         while (StackExtract(TARGET_BLANK, ++occur, TIME) != FAIL) ;
         NoSacsAfterThis = StackExtract(TARGET_BLANK, occur-1, TIME);
	 }

      if (NoSacsAfterThis == FAIL)
          NoSacsAfterThis = 0;

      if ((Register[0].stacknumber > 40 &&	/* Sac trials don't work!*/
           Register[0].stacknumber < 60))	/* Heroic/quick fix:	*/
         NoSacsBeforeThis = NoSacsAfterThis - 800;

      ChangeParameter('t', "h");	/* Horizontal eye position	*/
      UseFilter = 2;
      Filter(0);
      SuppressNoSaccadeMessage = 1;
      FindSaccade(0);
      at_h = SaccadeData.peak;
      if (SaccadeData.peak > Register[0].frame_count-200 ||
          SaccadeData.peak < 100)
	 at_h = FAIL;
      if (at_h != FAIL)
         size_h = AvgSomeData(0, SaccadeData.end+50, SaccadeData.end+250) -
                  AvgSomeData(0, SaccadeData.begin-250, SaccadeData.begin-50);

      ChangeParameter('t', "v");	/* Vertical eye position	*/
      Filter(0);
      FindSaccade(0);
      at_v = SaccadeData.peak;
      if (SaccadeData.peak > Register[0].frame_count-200 ||
	  SaccadeData.peak < 100)
	 at_v = FAIL;
      if (at_v != FAIL)
         size_v = AvgSomeData(0, SaccadeData.end+50, SaccadeData.end+250) -
                  AvgSomeData(0, SaccadeData.begin-250, SaccadeData.begin-50);
      SuppressNoSaccadeMessage = 0;

      if ((at_h == FAIL && at_v == FAIL)) {
         SkipCount++;
	 continue;
	 }

      if (at_h == FAIL)
          at = at_v;
      else if (at_v == FAIL)
          at = at_h;
      else if (size_h > size_v)
         at = at_h;
      else
         at = at_v;

      ShiftReg(0, 2500 - at);
      }
#    endif
     }

#   if DO_EYE_TRACES
     UseFilter = 12;			/* Don't over-filter position */
     Set_CurrentChannel(OD_H);
     Filter(0);
     DiffChannel = H_VEL;
     Differentiate(0);
     UseFilter = FilterSetting;		/* Do over-filter velocity */
     Filter(0);

     UseFilter = 12;			/* Don't over-filter position */
     Set_CurrentChannel(OD_V);
     Filter(0);
     DiffChannel = V_VEL;
     Differentiate(0);
     UseFilter = FilterSetting;
     Filter(0);
#   endif

     if (PLOT_SINGLES) {
        if (Register[0].classnumber == 3) {
   	 ChangeParameter('t', "h");
	 if (Register[0].stacknumber == 82) {
            ChangeParameter('c', "R");
	    GraphData(0);
 	  } else
	 if (Register[0].stacknumber == 83) {
            ChangeParameter('c', "B");
            ChangeParameter('c', "r6");
	    GraphData(0);
	    }
	 }
	}

     AvgReg(0, Find_TrialType());		/* Determine type	*/
} while (Read_trial() != FAIL);			/* Next header		*/

if (SkipCount)
   fprintf(stderr, "Vestib macro: skipped %d trials (couldn't find saccade)\n",
	SkipCount);

if (Target_At == FAIL)
   fprintf(stderr, "No 'Target_At' (Vestibmac))\n");

Tag_Registers();
if (NORMALIZE_TRIAL_COUNT || NORMALIZE_RATE)
   Normalize_Registers(Target_At);
if (OFFSET)
   Offset_Registers();
Avg_Registers();
Subtract_Registers();				/* Do differences	*/

/* FOR GETTING OUTPUT DURING RUNNING OF MACRO: */
if (PLOT_INDIVIDUALS) {
 char Text[80];
 int ClassOffset = Find_ClassOffset();
 /* system("sleep 2");	*/
 GraphErase();
 ChangeParameter('o', "0");
 ChangeParameter('h', "300");
 ChangeParameter('w', "5000");
 ChangeParameter('s', "0");
 ChangeParameter('t', "u");

 ChangeParameter('c', "G");
 GraphData(Find_Register(52,ClassOffset+3));
 GraphData(Find_Register(56,ClassOffset+3));
 ChangeParameter('c', "B");
 GraphData(Find_Register(53,ClassOffset+3));
 GraphData(Find_Register(57,ClassOffset+3));
 ChangeParameter('c', "R");
 GraphData(Find_Register(42,ClassOffset+3));
 GraphData(Find_Register(46,ClassOffset+3));
 ChangeParameter('c', "R");
 ChangeParameter('c', "g6");
 GraphData(Find_Register(43,ClassOffset+3));
 GraphData(Find_Register(47,ClassOffset+3));

 ChangeParameter('o', "46");
 ChangeParameter('c', "G");
 GraphData(Find_Register(82,ClassOffset+3));
 GraphData(Find_Register(86,ClassOffset+3));
 ChangeParameter('c', "B");
 GraphData(Find_Register(83,ClassOffset+3));
 GraphData(Find_Register(87,ClassOffset+3));
 ChangeParameter('c', "R");
 GraphData(Find_Register(72,ClassOffset+3));
 GraphData(Find_Register(76,ClassOffset+3));
 ChangeParameter('c', "R");
 ChangeParameter('c', "g6");
 GraphData(Find_Register(73,ClassOffset+3));
 GraphData(Find_Register(77,ClassOffset+3));

 ChangeParameter('t', "h");
 ChangeParameter('o', "95");
 ChangeParameter('c', "G");
 GraphData(Find_Register(52,ClassOffset+3));
 GraphData(Find_Register(56,ClassOffset+3));
 ChangeParameter('c', "B");
 GraphData(Find_Register(53,ClassOffset+3));
 GraphData(Find_Register(57,ClassOffset+3));
 ChangeParameter('c', "R");
 GraphData(Find_Register(42,ClassOffset+3));
 GraphData(Find_Register(46,ClassOffset+3));
 ChangeParameter('c', "R");
 ChangeParameter('c', "g6");
 GraphData(Find_Register(43,ClassOffset+3));
 GraphData(Find_Register(47,ClassOffset+3));

 sprintf(Text, "@t 400 0 %d.%d",
	Register[0].classnumber,
	Register[0].stacknumber);
 Paint(Text);
 }

Clean_Registers();

if (WRITE_TO_DISK)
    Write_to_Disk();
}
/* ******************************************************************** */

/* FUNCTION Initialize_Stuff */
         /* Init */
static void Initialize_Stuff(void) {
   extern  int StepMs;				/* Differentiation stuff*/

   StepMs = 30;					/* Set up differentiator*/
   }					/* 2:9 Hz; 4:~25    12:46Hz	*/
/* ******************************************************************** */
/* ******************************************************************** */
/* ******************************************************************** */

/* FUNCTION Write_to_Disk */
	 /* Write to disk */
static void Write_to_Disk(void) {
   int i;

   for (i=TO_SORT+1; i<=TO_SORT*2; i++)
      if (ContentReg(i) > 0)
         RawFile(i);				/* Disk copies	*/
   }
/* ******************************************************************** */

/* FUNCTION Normalize_Registers */
	 /* Make'm look like 1 trial, and/or set max height = 100 Hz */
static void Normalize_Registers(int Target_At) {
	int i;

	if (NORMALIZE_TRIAL_COUNT)
           for (i=1; i<=TO_SORT; i++)
	      NormalizeReg(i);

	if (NORMALIZE_RATE) {
	   float max_peak = -9999.;
	   int peak_at;

 	   ChangeParameter('t', "u");		/* Change to units	*/

           for (i=1; i<=TO_SORT; i++) {
	      peak_at = FindPeakOfData(i,
	        Target_At + Register[i].shift,	/* Target presentation	*/
		Target_At + Register[i].shift + 500,	/* 500 ms later	*/
		1);					/* Positive peak*/
	      if (AvgSomeData(i,peak_at-10, peak_at+10) > max_peak)
	         max_peak = AvgSomeData(i,peak_at-10, peak_at+10);
	      }
	   if (max_peak < 0.)
	      fatal("vestib macro: couldn't find a peak value");
	   {
	   extern float multiplier;		/* From data.c		*/
 	   multiplier = 100/max_peak;		/* Scale peak to 100	*/
	   }

           for (i=1; i<=TO_SORT; i++)
	      MultiplyData(i);
	   }
	}
/* ******************************************************************** */

/* FUNCTION Offset_Registers */
	 /* Offset so activity at 400-600 ms is at zero */
static void Offset_Registers(void) {
	int i;
        for (i=1; i<=TO_SORT; i++)
          if (Register[i].trial_count)			/* Not empty?	*/
	    OffsetData(i, AvgSomeData(i, 700, 1000));
	}
/* ******************************************************************** */

/* FUNCTION Avg_Registers */
static void Avg_Registers(void) {
   int ClassOffset = Find_ClassOffset();

   if ((((Find_Register(72,3) != NOT_FOUND) + 
         (Find_Register(72,7) != NOT_FOUND) + 
         (Find_Register(76,7) != NOT_FOUND)) > 1) ||
       (((Find_Register(73,3) != NOT_FOUND) + 
         (Find_Register(73,7) != NOT_FOUND) + 
         (Find_Register(77,7) != NOT_FOUND)) > 1) ||
       (((Find_Register(82,3) != NOT_FOUND) + 
         (Find_Register(82,7) != NOT_FOUND) + 
         (Find_Register(86,7) != NOT_FOUND)) > 1) ||
       (((Find_Register(83,3) != NOT_FOUND) + 
         (Find_Register(83,7) != NOT_FOUND) + 
         (Find_Register(87,7) != NOT_FOUND)) > 1))
      fprintf(stderr,
       "Warning: cell %d contributes multiple vestib observations (cells).\n",
	Header_Unit());

   if ((((Find_Register(22,3) != NOT_FOUND) +
         (Find_Register(22,7) != NOT_FOUND) +
         (Find_Register(26,7) != NOT_FOUND)) > 1) ||
       (((Find_Register(23,3) != NOT_FOUND) +
         (Find_Register(23,7) != NOT_FOUND) +
         (Find_Register(27,7) != NOT_FOUND)) > 1) ||
       (((Find_Register(32,3) != NOT_FOUND) + 
         (Find_Register(32,7) != NOT_FOUND) + 
         (Find_Register(36,7) != NOT_FOUND)) > 1) ||
       (((Find_Register(33,3) != NOT_FOUND) + 
         (Find_Register(33,7) != NOT_FOUND) + 
         (Find_Register(37,7) != NOT_FOUND)) > 1))
      fprintf(stderr,
       "Warning: cell %d contributes multiple pursue observations (cells).\n",
	Header_Unit());

   if ((((Find_Register(42,3) != NOT_FOUND) +
         (Find_Register(42,7) != NOT_FOUND) +
         (Find_Register(46,7) != NOT_FOUND)) > 1) ||
       (((Find_Register(43,3) != NOT_FOUND) +
         (Find_Register(43,7) != NOT_FOUND) +
         (Find_Register(47,7) != NOT_FOUND)) > 1) ||
       (((Find_Register(52,3) != NOT_FOUND) + 
         (Find_Register(52,7) != NOT_FOUND) + 
         (Find_Register(56,7) != NOT_FOUND)) > 1) ||
       (((Find_Register(53,3) != NOT_FOUND) + 
         (Find_Register(53,7) != NOT_FOUND) + 
         (Find_Register(57,7) != NOT_FOUND)) > 1))
      fprintf(stderr,
       "Warning: cell %d contributes multiple saccade observations (cells).\n",
	Header_Unit());

						/* Class 3		*/
						/*  FIRST DO VESTIBS    */
   AvgReg(Find_Register(72,ClassOffset+3), TO_SORT + 1); /* U-R or D-R	*/
   AvgReg(Find_Register(73,ClassOffset+3), TO_SORT + 2);
   AvgReg(Find_Register(82,ClassOffset+3), TO_SORT + 3);
   AvgReg(Find_Register(83,ClassOffset+3), TO_SORT + 4);

   AvgReg(Find_Register(76,7), TO_SORT + 1);	/* Get horizontals	*/
   AvgReg(Find_Register(77,7), TO_SORT + 2);	/* Combine w/ diagonals	*/
   AvgReg(Find_Register(86,7), TO_SORT + 3);
   AvgReg(Find_Register(87,7), TO_SORT + 4);

						/* NOW DO PURSUITS */
   AvgReg(Find_Register(22,ClassOffset+3), TO_SORT + 5);
   AvgReg(Find_Register(23,ClassOffset+3), TO_SORT + 6);
   AvgReg(Find_Register(32,ClassOffset+3), TO_SORT + 7);
   AvgReg(Find_Register(33,ClassOffset+3), TO_SORT + 8);

   AvgReg(Find_Register(26,7), TO_SORT + 5);	/* Get horizontals	*/
   AvgReg(Find_Register(27,7), TO_SORT + 6);	/* Combine w/ diagonals	*/
   AvgReg(Find_Register(36,7), TO_SORT + 7);
   AvgReg(Find_Register(37,7), TO_SORT + 8);

						/* NOW DO SACCADES */
   AvgReg(Find_Register(42,ClassOffset+3), TO_SORT + 33);
   AvgReg(Find_Register(43,ClassOffset+3), TO_SORT + 34);
   AvgReg(Find_Register(52,ClassOffset+3), TO_SORT + 35);
   AvgReg(Find_Register(53,ClassOffset+3), TO_SORT + 36);

   AvgReg(Find_Register(46,7), TO_SORT + 33);	/* Get horizontals	*/
   AvgReg(Find_Register(47,7), TO_SORT + 34);	/* Combine w/ diagonals	*/
   AvgReg(Find_Register(56,7), TO_SORT + 35);
   AvgReg(Find_Register(57,7), TO_SORT + 36);

						/*      CLASS 2         */
						/*    VESTIBULARS       */
   AvgReg(Find_Register(72,ClassOffset+2), TO_SORT + 9);
   AvgReg(Find_Register(73,ClassOffset+2), TO_SORT + 10);
   AvgReg(Find_Register(82,ClassOffset+2), TO_SORT + 11);
   AvgReg(Find_Register(83,ClassOffset+2), TO_SORT + 12);

   AvgReg(Find_Register(76,6), TO_SORT + 9);	/* Get horizontals	*/
   AvgReg(Find_Register(77,6), TO_SORT + 10);	/* Combine w/ diagonals	*/
   AvgReg(Find_Register(86,6), TO_SORT + 11);
   AvgReg(Find_Register(87,6), TO_SORT + 12);
						/*      PURSUITS       */
   AvgReg(Find_Register(22,ClassOffset+2), TO_SORT + 13);
   AvgReg(Find_Register(23,ClassOffset+2), TO_SORT + 14);
   AvgReg(Find_Register(32,ClassOffset+2), TO_SORT + 15);
   AvgReg(Find_Register(33,ClassOffset+2), TO_SORT + 16);

   AvgReg(Find_Register(26,6), TO_SORT + 13);	/* Get horizontals	*/
   AvgReg(Find_Register(27,6), TO_SORT + 14);	/* Combine w/ diagonals	*/
   AvgReg(Find_Register(36,6), TO_SORT + 15);
   AvgReg(Find_Register(37,6), TO_SORT + 16);
						/* NOW DO SACCADES */
   AvgReg(Find_Register(42,ClassOffset+2), TO_SORT + 37);
   AvgReg(Find_Register(43,ClassOffset+2), TO_SORT + 38);
   AvgReg(Find_Register(52,ClassOffset+2), TO_SORT + 39);
   AvgReg(Find_Register(53,ClassOffset+2), TO_SORT + 40);

   AvgReg(Find_Register(46,6), TO_SORT + 37);	/* Get horizontals	*/
   AvgReg(Find_Register(47,6), TO_SORT + 38);	/* Combine w/ diagonals	*/
   AvgReg(Find_Register(56,6), TO_SORT + 39);
   AvgReg(Find_Register(57,6), TO_SORT + 40);

                                                /*      CLASS 4         */
                                                /*     VESTIBULARS      */
   AvgReg(Find_Register(72,ClassOffset+4), TO_SORT + 17);
   AvgReg(Find_Register(73,ClassOffset+4), TO_SORT + 18);
   AvgReg(Find_Register(82,ClassOffset+4), TO_SORT + 19);
   AvgReg(Find_Register(83,ClassOffset+4), TO_SORT + 20);

   AvgReg(Find_Register(76,8), TO_SORT + 17);    /* Get horizontals      */
   AvgReg(Find_Register(77,8), TO_SORT + 18);   /* Combine w/ diagonals */
   AvgReg(Find_Register(86,8), TO_SORT + 19);
   AvgReg(Find_Register(87,8), TO_SORT + 20);
                                                /*      PURSUITS       */
   AvgReg(Find_Register(22,ClassOffset+4), TO_SORT + 21);
   AvgReg(Find_Register(23,ClassOffset+4), TO_SORT + 22);
   AvgReg(Find_Register(32,ClassOffset+4), TO_SORT + 23);
   AvgReg(Find_Register(33,ClassOffset+4), TO_SORT + 24);

   AvgReg(Find_Register(26,8), TO_SORT + 21);   /* Get horizontals      */
   AvgReg(Find_Register(27,8), TO_SORT + 22);   /* Combine w/ diagonals */
   AvgReg(Find_Register(36,8), TO_SORT + 23);
   AvgReg(Find_Register(37,8), TO_SORT + 24);
						/* NOW DO SACCADES */
   AvgReg(Find_Register(42,ClassOffset+4), TO_SORT + 41);
   AvgReg(Find_Register(43,ClassOffset+4), TO_SORT + 42);
   AvgReg(Find_Register(52,ClassOffset+4), TO_SORT + 43);
   AvgReg(Find_Register(53,ClassOffset+4), TO_SORT + 44);

   AvgReg(Find_Register(46,8), TO_SORT + 41);	/* Get horizontals	*/
   AvgReg(Find_Register(47,8), TO_SORT + 42);	/* Combine w/ diagonals	*/
   AvgReg(Find_Register(56,8), TO_SORT + 43);
   AvgReg(Find_Register(57,8), TO_SORT + 44);

                                                /*      CLASS 1         */
                                                /*     VESTIBULARS      */
   AvgReg(Find_Register(72,ClassOffset+1), TO_SORT + 25);
   AvgReg(Find_Register(73,ClassOffset+1), TO_SORT + 26);
   AvgReg(Find_Register(82,ClassOffset+1), TO_SORT + 27);
   AvgReg(Find_Register(83,ClassOffset+1), TO_SORT + 28);

   AvgReg(Find_Register(76,5), TO_SORT + 25);    /* Get horizontals      */
   AvgReg(Find_Register(77,5), TO_SORT + 26);   /* Combine w/ diagonals */
   AvgReg(Find_Register(86,5), TO_SORT + 27);
   AvgReg(Find_Register(87,5), TO_SORT + 28);
                                                /*      PURSUITS       */
   AvgReg(Find_Register(22,ClassOffset+1), TO_SORT + 29);
   AvgReg(Find_Register(23,ClassOffset+1), TO_SORT + 30);
   AvgReg(Find_Register(32,ClassOffset+1), TO_SORT + 31);
   AvgReg(Find_Register(33,ClassOffset+1), TO_SORT + 32);

   AvgReg(Find_Register(26,5), TO_SORT + 29);   /* Get horizontals      */
   AvgReg(Find_Register(27,5), TO_SORT + 30);   /* Combine w/ diagonals */
   AvgReg(Find_Register(36,5), TO_SORT + 31);
   AvgReg(Find_Register(37,5), TO_SORT + 32);
						/* NOW DO SACCADES */
   AvgReg(Find_Register(42,ClassOffset+1), TO_SORT + 45);
   AvgReg(Find_Register(43,ClassOffset+1), TO_SORT + 46);
   AvgReg(Find_Register(52,ClassOffset+1), TO_SORT + 47);
   AvgReg(Find_Register(53,ClassOffset+1), TO_SORT + 48);

   AvgReg(Find_Register(46,5), TO_SORT + 45);	/* Get horizontals	*/
   AvgReg(Find_Register(47,5), TO_SORT + 46);	/* Combine w/ diagonals	*/
   AvgReg(Find_Register(56,5), TO_SORT + 47);
   AvgReg(Find_Register(57,5), TO_SORT + 48);
   }
/* ******************************************************************** */

/* FUNCTION Subtract_Registers */
static void Subtract_Registers() {
   int Stack=0, Class=0;		/* Standards for this cell	*/
   
   if (Find_Register(72,3) <= TO_SORT) {	/* Find out which we did*/
      Stack = 72;
      Class = 3;
   } else if (Find_Register(72,7) <= TO_SORT) {
      Stack = 72;
      Class = 7;
   } else if (Find_Register(76,7) <= TO_SORT) {
      Stack = 76;
      Class = 7;
   }

   CopyReg(Find_Register(Stack,Class), 0);	   /* 72.3 into reg 0	*/
   SubtractReg(0, Find_Register(Stack+1,Class));   /* 0 = 72.3 - 73.3	*/
   AvgReg(0, TO_SORT + 49);
   MacroTagReg(TO_SORT + 49, "Diff 72.3 - 73.3");

      
   CopyReg(Find_Register(Stack+10,Class), 0);	   /* 82.3 into reg 0	*/
   SubtractReg(0, Find_Register(Stack+11,Class));  /* 0 = 82.3 - 83.3	*/
   AvgReg(0, TO_SORT + 50);
   MacroTagReg(TO_SORT + 50, "Diff 82.3 - 83.3");

   Stack -= 50;					/* Go from 70's to 20's	*/
   if (Find_Register(Stack, Class) <= TO_SORT) {
    CopyReg(Find_Register(Stack,Class), 0);	   /* 22.3 into reg 0	*/
    SubtractReg(0, Find_Register(Stack+1,Class));  /* 0 = 72.3 - 73.3	*/
    AvgReg(0, TO_SORT + 51);
    MacroTagReg(TO_SORT + 51, "Diff 22.3 - 23.3");
      
    CopyReg(Find_Register(Stack+10,Class), 0);     /* 32.3 into reg 0	*/
    SubtractReg(0, Find_Register(Stack+11,Class));  /* 0 = 32.3 - 33.3	*/
    AvgReg(0, TO_SORT + 52);
    MacroTagReg(TO_SORT + 52, "Diff 32.3 - 33.3");
    }

   Stack += 20;					/* Go from 20's to 40's	*/
   if (Find_Register(Stack, Class) <= TO_SORT) {
    CopyReg(Find_Register(Stack,Class), 0);	   /* 42.3 into reg 0	*/
    SubtractReg(0, Find_Register(Stack+1,Class));  /* 0 = 42.3 - 43.3	*/
    AvgReg(0, TO_SORT + 53);
    MacroTagReg(TO_SORT + 53, "Diff 42.3 - 43.3");
      
    CopyReg(Find_Register(Stack+10,Class), 0);     /* 52.3 into reg 0	*/
    SubtractReg(0, Find_Register(Stack+11,Class));  /* 0 = 52.3 - 53.3	*/
    AvgReg(0, TO_SORT + 54);
    MacroTagReg(TO_SORT + 54, "Diff 52.3 - 53.3");
    }
   }
/* ******************************************************************** */
/* FUNCTION Clean_Registers */
static void Clean_Registers() {
	int i;

	for (i=0; i<=TO_SORT; i++)
	    RemoveReg(i);
	}
/* ******************************************************************** */

/* FUNCTION Tag_Registers */
static void Tag_Registers(void) {
   	char newname[80];
	int i;

	for (i=0; i<MAX_REGISTERS; i++)
	     if (Register[i].trial_count > 0) {
	        sprintf(newname, "%d.%d %s",
		   Register[i].stacknumber,
		   Register[i].classnumber,
		   Register[i].stackname);
		
	        MacroTagReg(i, newname);
	        }
	if (PRINT_REGISTER_NAMES)
	   ListReg();
	}
/* ******************************************************************** */

/* FUNCTION Find_Register */
	 /* Find register with given stack, class */
static int Find_Register(int stack, int class) {
	int i;

	for (i=1; i<=TO_SORT; i++)
	   if (Register[i].trial_count)
            if (stack == Register[i].stacknumber
	    				&& class==Register[i].classnumber)
	       return(i);
	return(NOT_FOUND);		/* Not found or out of room	*/
	}
/* ******************************************************************** */

/* FUNCTION Find_TrialType */
	 /* Return index of this trial in Class[]	*/
static int  Find_TrialType(void) {
    int i;
    int stack = Register[0].stacknumber;
    int class = Register[0].classnumber;

    for (i=1; i<=TO_SORT; i++) {
       if (Register[i].trial_count <= 0)		/* Empty?	*/
	  return(i);					/*  Use it	*/
        else						/* Else: match?	*/
        if (stack == Register[i].stacknumber && class==Register[i].classnumber)
	  return(i); 
       }
    return(NOT_FOUND);
    }
/* ********************************************************************	*/

/* FUNCTION Find_ClassOffset */
	 /* Return 0 or 4 */
static int Find_ClassOffset(void) {
    while (Register[1].classnumber > 8)
       return((Register[1].classnumber > 10) ? 4 : 0);
    return( (Register[1].classnumber < 5) ? 0 : 4);
    }
/* ********************************************************************	*/
