/* FILE RewardSort.c */
     
/* Read a string of units in; normalize each to a single trial and
   then add to a main register */

#include "../defs.h"
#include "../array.h"       		/* Access registers directly	*/
#include "../_imports/deffs.h"
#include "../_imports/event.h"       	/* Stack instruction definitions*/
#include <stdlib.h>


static int  ALIGN_ON_TARGET = 1;	/* PICK JUST ONE OF THESE!	*/
static int  ALIGN_ON_MOVE = 0;
static int  ALIGN_ON_GO = 0;
#define	ALIGNMENT_TIME		3000	/* No need to change this	*/

static int  FILTER = 12;   	/* (2) 0:no 2:9 4:25 12:46 Hz	*/
static int  DIFF_FILTER = 12;    /* (4) Extra for diff traces    */
static int  DO_EYE_TRACES = 0;  /* Filter, etc:  very slow      */
static int  RECTIFY_ANALOG = 0; /* Show up systematic changes   */

static int  NORMALIZE = 1;	/* Each unit gets equal weight	*/
static int  OFFSET = 0;		/* Each unit starts at 0	*/

#define  PRINT_REGISTER_NAMES	0	/* Print it on screen	*/
#define  WRITE_TO_DISK   	0
#define  PLOT_AVERAGED_CELLS	0	/* As you go...		*/
#define  PLOT_INDIVIDUALS	0

static int  STACKS_TO_SORT  = 8;	/* [12]50-4, [12]64, 300*/
#define     TO_SORT			STACKS_TO_SORT

void reward_sort_macro(void);
static void Write_to_Disk(void);
static void Tag_Registers(void);
static void Normalize_Registers(void);
static void Offset_Registers(void);
static void Avg_Registers(void);
static void Clean_Registers();
static int  Find_TrialType(void);
static int  Find_Register(int stack, int class);

/* ******************************************************************** */

/* FUNCTION reward_sort_macro() */
	 /* Sort shifted trials */
void reward_sort_macro(void) {
	extern int StepMs;
	extern int UseFilter;
	extern int DiffChannel;

if (MAX_REGISTERS <= 2*TO_SORT + 2) {
   fprintf(stderr, "MAX_REG is only %d; need %d\n", MAX_REGISTERS, 2*TO_SORT+3);
   fatal("Increase MAX_REGISTERS or decrease STACKS/CLASSES_TO_SORT");
   }

StepMs = 30;					/* Set up differentiator*/
UseFilter = FILTER;

do {						/* Next trial or header	*/
     int TargetTime = StackExtract(TARGET_RE_2_POLAR, 1, TIME); /*first	*/
     int GoTime = StackExtract(ACQUIRE, 3, TIME);	/* 3rd acq	*/

     if (StackExtract(ACQUIRE, 3, ONE) != 3 &&
         StackExtract(ACQUIRE, 3, ONE) != 2)	/* Aq move (3 or 4)	*/
	 fprintf(stderr, "Alignment is incorrect (%d)!\n",
			 			StackExtract(ACQUIRE,3,ONE));
	     	
     if (DO_EYE_TRACES) {
	extern int UseFilter;
	int SaveFilter = UseFilter;

	UseFilter = 12;			/* Less than units (faster)	*/

        Set_CurrentChannel(OD_H);
        if (FILTER)
           Filter(0);
        DiffChannel = H_VEL;
        Differentiate(0);

        Set_CurrentChannel(OD_V);
        if (FILTER)
           Filter(0);
        DiffChannel = V_VEL;
        Differentiate(0);

	UseFilter = SaveFilter;

        if (RECTIFY_ANALOG) {
           Set_CurrentChannel(OD_H);
           ChannelDataTransfer(0, X3);	/* Copy to extra channel X3	*/
           Set_CurrentChannel(X3);
           OffsetData(0, 
               AvgSomeData(0, TargetTime-400, TargetTime));
           RectifyData(0);

           Set_CurrentChannel(OD_V);
           ChannelDataTransfer(0, X4);	/* Copy to extra channel X4	*/
           Set_CurrentChannel(X4);
           OffsetData(0, 
               AvgSomeData(0, TargetTime-400, TargetTime));
           RectifyData(0);

           Set_CurrentChannel(ARM_H);
           ChannelDataTransfer(0, X5);/* Copy to extra channel X5	*/
           Set_CurrentChannel(X5);
           OffsetData(0, 
               AvgSomeData(0, TargetTime-400, TargetTime));
           RectifyData(0);

           Set_CurrentChannel(ARM_V);
           ChannelDataTransfer(0, X6);/* Copy to extra channel X6	*/
           Set_CurrentChannel(X6);
           OffsetData(0, 
               AvgSomeData(0, TargetTime-400, TargetTime));
           RectifyData(0);
	   }
     }


     Set_CurrentChannel(UNIT);		/* Filter indis: SE is smooth	*/
     if (FILTER)
        Filter(0);

     if (ALIGN_ON_GO) {					/* Go cue	*/
        ShiftReg(0, ALIGNMENT_TIME-GoTime);
      } else if (ALIGN_ON_MOVE) {			/* Movement	*/
	int Move;
	extern int NoArmMovesBeforeThis;
	NoArmMovesBeforeThis = GoTime;
	Move = FindArmMove(0);

	if (Move == FAIL) {
	   fprintf(stderr, "Could not find movemment; skipping trial!\n");
	   continue;
	   }
	ShiftReg(0, ALIGNMENT_TIME - Move);
     } else if (ALIGN_ON_TARGET)
        ShiftReg(0, ALIGNMENT_TIME-TargetTime);

     AvgReg(0, Find_TrialType());		/* Determine type	*/
} while (Read_trial() != FAIL);			/* Next header		*/

if (DIFF_FILTER) {
   extern  int UseFilter;
   UseFilter = DIFF_FILTER;	/* Heavy filtering of difference traces	*/
   }

Tag_Registers();
ListReg();
if (NORMALIZE)
   Normalize_Registers();
if (OFFSET)
   Offset_Registers();

Avg_Registers();
Clean_Registers();

if (WRITE_TO_DISK)
    Write_to_Disk();
}
/* ******************************************************************** */
/* ******************************************************************** */
/* ******************************************************************** */

/* FUNCTION Write_to_Disk */
	 /* Write to disk */
static void Write_to_Disk(void) {
   int i;

   for (i=TO_SORT+1; i<=TO_SORT*2; i++)
      if (ContentReg(i) > 0)
         RawFile(i);				/* Disk copies	*/
   }
/* ******************************************************************** */

/* FUNCTION Normalize_Registers */
	 /* Make'm look like 1 trial */
static void Normalize_Registers(void) {
	int i;
        for (i=1; i<=TO_SORT; i++)
	    NormalizeReg(i);
	}
/* ******************************************************************** */

/* FUNCTION Offset_Registers */
	 /* Offset so activity at 0 to 200 ms before align is at zero */
static void Offset_Registers(void) {
	int i;
        for (i=1; i<=TO_SORT; i++)
          if (Register[i].trial_count)			/* Not empty?	*/
	    OffsetData(i, AvgSomeData(i, ALIGNMENT_TIME-200, ALIGNMENT_TIME));
	}
/* ******************************************************************** */

/* FUNCTION mAx */ static int mAx(int *a, int *b) { return(*a>*b); }
/* ******************************************************************** */

/* FUNCTION Avg_Registers */
static void Avg_Registers(void) {
   int stack[STACKS_TO_SORT];
   int MaxStacks = 0;
   int i,j;

   for (i=1; i<=TO_SORT; i++) {			/* For each trial type	*/
      if (Register[i].frame_count==0)		/* Unused register?	*/
         continue;				/* Skip it		*/

      for (j=0; j<MaxStacks; j++)		/* Look thru stacks	*/
         if (stack[j] == Register[i].stacknumber)  /* Found this one?	*/
	    break;
      if (j==MaxStacks && Register[i].stacknumber!=0)	/* Found new one*/
         stack[MaxStacks++] = Register[i].stacknumber;	/* Store as next*/
      }

   if (MaxStacks > STACKS_TO_SORT)
      fatal("STACKS_TO_SORT is too small!");

   qsort(stack, MaxStacks, sizeof(int), (void *) mAx);

   for (i=0; i<MaxStacks; i++)
      AvgReg(Find_Register(stack[i], 1), 1 + TO_SORT + i);
   }
/* ******************************************************************** */

/* FUNCTION Clean_Registers */
static void Clean_Registers() {
	int i;

	for (i=0; i<=TO_SORT; i++)
	    RemoveReg(i);
	}
/* ******************************************************************** */

/* FUNCTION Tag_Registers */
static void Tag_Registers(void) {
   	char newname[80];
	int i;

	for (i=0; i<MAX_REGISTERS; i++)
	     if (Register[i].trial_count > 0) {
	        sprintf(newname, "%d %s",
		   Register[i].stacknumber,
		   Register[i].stackname);
	        MacroTagReg(i, newname);
	        if (PRINT_REGISTER_NAMES)
	           fprintf(stderr, "  %d: %d %s\n", i,
		      Register[i].stacknumber,
		      Register[i].stackname);
	        }
	}
/* ******************************************************************** */

/* FUNCTION Find_Register */
	 /* Find register with given stack, class */
static int Find_Register(int stack, int class) {
	int i;

	for (i=1; i<=TO_SORT; i++)
            if (stack == Register[i].stacknumber
	    				&& class==Register[i].classnumber)
	       return(i);
	return(99);			/* Not found or out of room	*/
	}
/* ******************************************************************** */

/* FUNCTION Find_TrialType */
	 /* Return index of this trial in Class[]	*/
static int  Find_TrialType(void) {
    int i;
    int stack = Register[0].stacknumber;
    int class = Register[0].classnumber;

    for (i=1; i<=TO_SORT; i++) {
       if (Register[i].trial_count <= 0)		/* Empty?	*/
	  return(i);					/*  Use it	*/
        else						/* Else: match?	*/
        if (stack == Register[i].stacknumber && class==Register[i].classnumber)
	  return(i); 
       }
    return(99);
    }
/* ********************************************************************	*/
