/* FILE ReferenceSort.c (used to be TwoArmsmac.c, which used to be stevemac.c */
     
     /* R, L arm stacks are separately considered. */
     
     /* Read a string of units in; normalize each to a single trial and
        then add to a main register */

#include "../defs.h"
#include "../array.h"       		/* Access registers directly	*/
#include "../_imports/deffs.h"
#include "../_imports/event.h"       	/* Stack instruction definitions*/
#include <stdlib.h>


static int  ALIGN_ON_TARGET = 1;	/* PICK JUST ONE OF THESE!	*/
static int  ALIGN_ON_MOVE = 0;
static int  ALIGN_ON_GO = 0;
#define	ALIGNMENT_TIME		3000	/* No need to change this	*/

static int  FILTER = 4;   	/* (2) 0:no 2:9 4:25 12:46 Hz	*/
static int  DIFF_FILTER = 4;	/* (4) Extra for diff traces	*/
static int  DO_EYE_TRACES = 0;	/* Filter, etc:  very slow	*/
static int  RECTIFY_ANALOG = 1;	/* Show up systematic changes	*/
			/* i.e., drift that occurs before the 'go' cue	*/

static int  NORMALIZE = 1;	/* Each unit gets equal weight	*/
#define REALLY_NORMALIZE 1	/* & make each = scale; but works poorly */
static int  OFFSET = 0;		/* Each unit starts at 0	*/

#define  PRINT_REGISTER_NAMES	0	/* Print it on screen	*/
#define  WRITE_TO_DISK   	0
#define  PLOT_AVERAGED_CELLS	0	/* As you go...		*/
#define  PLOT_INDIVIDUALS	0

static int  COLLAPSE_ACROSS_STACKS = 0;	/* 150-4 -> 154, 250-4 -> 254	*/
#define     NARROW  0			/* Use only T3 vs T2-T4		*/
static int  STACKS_TO_SORT  = 8;	/* [12]50-4, [12]64, 300*/
static int  CLASSES_TO_SORT = 1;
#define     TO_SORT			(STACKS_TO_SORT * CLASSES_TO_SORT)
	/* 100 is contra, 200 is ipsi, 300 is diff		*/
	/* 300 is pref minus null ([12]0.3 - [12]64.1)		*/
	/* ?54 is aligned; class 3 is center (?50 thru ?54)	*/
	/* ?64 is null direction (class 1 or 3: opposite)	*/
	/*   if just 1, then 1 is opp; if 1:3, 3 is opp		*/
	/*    (in that case, 1 and 2 are orthogonal)		*/
	/* So stacks ?64 and 300 will have only one class	*/

void steve_reference_sort_macro(int direction);
void steve_reference_initialize_macro(int value);
static void Initialize_Stuff(void);
static void Write_to_Disk(void);
static void Tag_Registers(void);
static void Normalize_Registers(void);
static void Offset_Registers(void);
static void Avg_Registers(void);
static void Clean_Registers();
static int  Find_TrialType(void);
static int  Find_Register(int stack, int class);

/* ******************************************************************** */


/* FUNCTION steve_reference_initialize_macro() */
	 /* Initialize the macro - currently unused 	*/
void steve_reference_initialize_macro(int value) {
	if (value == -352237) fatal("Avoid 'unused param' warning");
	;
  }
/* ******************************************************************** */

/* FUNCTION steve_reference_sort_macro() */
	 /* Sort shifted trials */
void steve_reference_sort_macro(int diverge) {
   extern int DiffChannel;			/* diff.c		*/
   int i;
   int WhichArm = (Register[0].stacknumber / 100) * 100;
   int NullClass = 1;		/* For stack ?64: could be 1 or 3	*/

/* if (REALLY_NORMALIZE) fprintf(stderr, "'Really normalize' is on!\n");*DIAG*/

if (MAX_REGISTERS <= 2*TO_SORT + 2) {
   fprintf(stderr, "MAX_REG is only %d; need %d\n", MAX_REGISTERS, 2*TO_SORT+3);
   fatal("Increase MAX_REGISTERS or decrease STACKS/CLASSES_TO_SORT");
   }

Initialize_Stuff();

do {						/* Next trial or header	*/
  if ((Register[0].stacknumber%100 == 64) && (Register[0].classnumber>1)) {
     NullClass = 3;
     break;
     }
  } while (Read_trial() != FAIL);		/* Next header		*/
ReRead_file();					/* Rewind to start	*/

do {						/* Next trial or header	*/
     int TargetTime, GoTime;

     if ((Register[0].stacknumber / 100) * 100 != WhichArm)
        continue;
	/* fatal("Appears to be a mixing of arms in this file!\n"); */

     if (Register[0].stacknumber % 100 == 64) {	/* Skip ?64.1 and ?64.2	*/
        if (Register[0].classnumber != NullClass)
	   continue;
        Register[0].classnumber = 3;		/* Makes sorting simpler*/
      } else if (Register[0].stacknumber % 100 >= 50 ||
                 Register[0].stacknumber % 100 <= 54) {
	 if (NARROW) {
	    if (Register[0].classnumber != 3)		/* Just class 3	*/
	       continue;
	  } else {
            if (Register[0].classnumber == 1  ||
                Register[0].classnumber == 5)		/* classes 2-4	*/ 
	       continue;
            Register[0].classnumber = 3;		/* classes 2-4	*/ 
	    }
      } else					/* ?50-54 and ?64 only	*/
	 fatal("Appears to be an unknown stack in this file!\n");
      	 /* continue; */
	
     if (COLLAPSE_ACROSS_STACKS && Register[0].stacknumber % 100 != 64)
	Register[0].stacknumber = 
	    (Register[0].stacknumber % 100) * 100 + 54; /* 154, 254 */
        
	
     {					/* Find timing (targ & go)	*/
     int occur = 0;

     while (++occur < 10)		/* First non '-1' polar target	*/
        if (StackExtract(TARGET_ON_POLAR, occur, TIME) > 0)
	   break;
     if (occur >= 10)
        fatal("Can't find target");
     TargetTime = StackExtract(TARGET_ON_POLAR,occur, TIME);/* 2nd to last*/

     occur = 0;
     while (++occur < 10)		/* First non '-1' polar target	*/
        if (StackExtract(TARGET_SIZE, occur, TIME) > 0)
	   break;
     if (occur >= 10)
        fatal("Can't find 'go'");
     GoTime = StackExtract(TARGET_SIZE, occur, TIME);
     }

     if (DO_EYE_TRACES) {
	extern int UseFilter;
	int SaveFilter = UseFilter;

	UseFilter = 12;			/* Less than units (faster)	*/

        Set_CurrentChannel(OD_H);
        if (FILTER)
           Filter(0);
        DiffChannel = H_VEL;
        Differentiate(0);

        Set_CurrentChannel(OD_V);
        if (FILTER)
           Filter(0);
        DiffChannel = V_VEL;
        Differentiate(0);

	UseFilter = SaveFilter;

        if (RECTIFY_ANALOG) {
           Set_CurrentChannel(OD_H);
           ChannelDataTransfer(0, X3);	/* Copy to extra channel X3	*/
           Set_CurrentChannel(X3);
           OffsetData(0, 
               AvgSomeData(0, TargetTime-400, TargetTime));
           RectifyData(0);

           Set_CurrentChannel(OD_V);
           ChannelDataTransfer(0, X4);	/* Copy to extra channel X4	*/
           Set_CurrentChannel(X4);
           OffsetData(0, 
               AvgSomeData(0, TargetTime-400, TargetTime));
           RectifyData(0);

           Set_CurrentChannel(ARM_H);
           ChannelDataTransfer(0, X5);/* Copy to extra channel X5	*/
           Set_CurrentChannel(X5);
           OffsetData(0, 
               AvgSomeData(0, TargetTime-400, TargetTime));
           RectifyData(0);

           Set_CurrentChannel(ARM_V);
           ChannelDataTransfer(0, X6);/* Copy to extra channel X6	*/
           Set_CurrentChannel(X6);
           OffsetData(0, 
               AvgSomeData(0, TargetTime-400, TargetTime));
           RectifyData(0);
	   }
     }


     Set_CurrentChannel(UNIT);		/* Filter indis: SE is smooth	*/
     if (FILTER)
        Filter(0);

     if (ALIGN_ON_GO) {					/* Go cue	*/
        ShiftReg(0, ALIGNMENT_TIME-GoTime);
      } else if (ALIGN_ON_MOVE) {			/* Movement	*/
	int Move;
	extern int NoArmMovesBeforeThis;
	NoArmMovesBeforeThis = GoTime;
	Move = FindArmMove(0);

	if (Move == FAIL) {
	   fprintf(stderr, "Could not find movemment; skipping trial!\n");
	   continue;
	   }
	ShiftReg(0, ALIGNMENT_TIME - Move);
     } else if (ALIGN_ON_TARGET)
        ShiftReg(0, ALIGNMENT_TIME-TargetTime);

     /* FOR GETTING OUTPUT DURING RUNNING OF MACRO: */
     if (PLOT_INDIVIDUALS) {
        static int count = 0;
        ChangeParameter('h', "140");
        ChangeParameter('w', "3000");
        ChangeParameter('s', "0");	/* ALIGNMENT_TIME	*/
        ChangeParameter('o', "67");
	ChangeParameter('b', "2");
	if (Register[0].stacknumber==232 && Register[0].classnumber==10) {
  	    extern void GraphLine(int i, int j);
   	    extern  int UseFilter;
	    UseFilter = 2;
	  if (count++ > 10) break;
          GraphLine(2600, 0);
          ChangeParameter('c', "R");
          ChangeParameter('t', "h");
	  Filter(0);
	  Filter(0);
	  GraphData(0);
          ChangeParameter('o', "33");
          ChangeParameter('c', "G");
          ChangeParameter('t', "v");
	  Filter(0);
	  Filter(0);
	  GraphData(0);
	  }
        }

     AvgReg(0, Find_TrialType());		/* Determine type	*/
} while (Read_trial() != FAIL);			/* Next header		*/

if (DIFF_FILTER) {
   extern  int UseFilter;
   UseFilter = DIFF_FILTER;	/* Heavy filtering of difference traces	*/
   }

if (1) {				/* Always do 'in minus out'	*/
   for (i=1; i<=TO_SORT; i++)				/* Find empty	*/
      if (ContentReg(i) <= 0)
         break;
   if (i > TO_SORT)			/* Need an empty slot	*/
      fatal("Need an extra register for differences");
   CopyReg(Find_Register(WhichArm+54,3), i);	/* aligned,center target*/
   SubtractReg(i, Find_Register(WhichArm+64,3));/* minus opp direction	*/
   Register[i].stacknumber = 300;		/* Mark as a diff	*/
   Register[i].classnumber = 3;
   if (DIFF_FILTER)
      Filter(i);
   }

if (diverge > 0) {			/* Latency (pref & diff)	*/
   int PrefReg = MAX_REGISTERS-2;
   int DiffReg = MAX_REGISTERS-3;
#  define ALIGN_TIME ALIGNMENT_TIME	/* Short-hand			*/
   int a,b;

   extern int Diverge_Points;		/* Can adjust parameters	*/
   extern float Diverge_StdErrs;
   extern float Diverge_MaxStdErr;
   Diverge_Points = 10;
   Diverge_StdErrs = 2.5;
   Diverge_MaxStdErr = 4;

   CopyReg(Find_Register(WhichArm+54,3), PrefReg);	/* Pref */
   CopyReg(Find_Register(300,3), DiffReg);		/* Diff */

   OffsetData(PrefReg,AvgSomeData(PrefReg,ALIGN_TIME-200,ALIGN_TIME-50));
   OffsetData(DiffReg,AvgSomeData(DiffReg,ALIGN_TIME-200,ALIGN_TIME-50));

   DeleteAllData(PrefReg, 0, ALIGN_TIME);
   DeleteAllData(DiffReg, 0, ALIGN_TIME);

   a = DivergeFromZeroData(PrefReg) - ALIGN_TIME; /* Print warnings now */
   b = DivergeFromZeroData(DiffReg) - ALIGN_TIME;

   fprintf(stderr, "Latency: %d %d\n", a,b);	  /* Print results now */
   }

Tag_Registers();
if (NORMALIZE)
   Normalize_Registers();
if (OFFSET)
   Offset_Registers();
Avg_Registers();

/* FOR GETTING OUTPUT DURING RUNNING OF MACRO: */
if (PLOT_AVERAGED_CELLS) {
  extern void GraphLine(int i, int j);
   system("sleep 4");		/* Pause, then clear screen?	*/
   GraphErase();
   ChangeParameter('b', "0");
   ChangeParameter('o', "0");
   ChangeParameter('h', "80");
   ChangeParameter('w', "2000");
   ChangeParameter('s', "2100");
   ChangeParameter('t', "u");
   ChangeParameter('c', "G");
   GraphData(Find_Register(230,10));
   ChangeParameter('c', "R");
   GraphData(Find_Register(232,10));
   GraphLine(2600, 0);
   }

Clean_Registers();

if (WRITE_TO_DISK)
    Write_to_Disk();
}
/* ******************************************************************** */

/* FUNCTION Initialize_Stuff */
         /* Init */
static void Initialize_Stuff(void) {
   extern  int StepMs;				/* Differentiation stuff*/
   extern  int UseFilter;

   StepMs = 30;					/* Set up differentiator*/
   UseFilter = FILTER;
   }
/* ******************************************************************** */
/* ******************************************************************** */
/* ******************************************************************** */

/* FUNCTION Write_to_Disk */
	 /* Write to disk */
static void Write_to_Disk(void) {
   int i;

   for (i=TO_SORT+1; i<=TO_SORT*2; i++)
      if (ContentReg(i) > 0)
         RawFile(i);				/* Disk copies	*/
   }
/* ******************************************************************** */

/* FUNCTION Normalize_Registers */
	 /* Make'm look like 1 trial */
static void Normalize_Registers(void) {
	int i;
        for (i=1; i<=TO_SORT; i++)
	    NormalizeReg(i);
	if (REALLY_NORMALIZE) {
	 extern int UseFilter;
	 int Save = UseFilter;
	 UseFilter = 2;
	 float offset, max;
	 extern float multiplier;
	 /* fprintf(stderr, "DIAG: Check normalization code!\n"); */

         for (i=1; i<=TO_SORT; i++) {
            if (Register[i].trial_count <= 0)
	       continue;
	    if (Register[i].stacknumber % 100 == 64) {
	       fprintf(stderr, "DIAG %d.%d: %3.0f %3.0f\n", Register[i].stacknumber, Register[i].classnumber, AvgSomeData(0, ALIGNMENT_TIME, ALIGNMENT_TIME+120), AvgSomeData(0, ALIGNMENT_TIME+300, ALIGNMENT_TIME+800));
	       continue;		/* Skip null; do pref and diff	*/
	       }
	    CopyReg(i, 0);
	    Filter(0);
	    fprintf(stderr, "DIAG %d.%d: %3.0f %3.0f  ", Register[i].stacknumber, Register[i].classnumber, AvgSomeData(0, ALIGNMENT_TIME, ALIGNMENT_TIME+120), AvgSomeData(0, ALIGNMENT_TIME+300, ALIGNMENT_TIME+800));
	    OffsetData(0, offset =
	       AvgSomeData(0, ALIGNMENT_TIME, ALIGNMENT_TIME+120));
	    fprintf(stderr, "%3.0f %3.0f\n", AvgSomeData(0, ALIGNMENT_TIME, ALIGNMENT_TIME+120), AvgSomeData(0, ALIGNMENT_TIME+300, ALIGNMENT_TIME+800)); /* DIAG */
#define DIAG
#ifndef DIAG
	    int time;
	    /* Two diff norms: max from 50 to 300, or fixed at 200 to 300 */
	    time = FindPeakOfData(0, ALIGNMENT_TIME+ 50, ALIGNMENT_TIME+300, 1);
	    max = AvgSomeData(0, time-25, time+25);
#else
	    max = AvgSomeData(0, ALIGNMENT_TIME+ 300, ALIGNMENT_TIME+800);
#endif
	    /* fprintf(stderr, "DIAG: max is %.0f\n", max); */
	    multiplier = 10/max;
	    MultiplyData(0);
	    OffsetData(0, -offset);
	    CopyReg(0, i);		/* No, do math on reg i; don't use smoothed! */
	    }
	 UseFilter = Save;
	 /* We normalize + only, and the DIFFERENCE, which is crazy!  */
	 }
	}
/* ******************************************************************** */

/* FUNCTION Offset_Registers */
	 /* Offset so activity at 0 to 200 ms before align is at zero */
static void Offset_Registers(void) {
	int i;
        for (i=1; i<=TO_SORT; i++)
          if (Register[i].trial_count)			/* Not empty?	*/
	    OffsetData(i, AvgSomeData(i, ALIGNMENT_TIME-200, ALIGNMENT_TIME));
	}
/* ******************************************************************** */

/* FUNCTION mAx */ static int mAx(int *a, int *b) { return(*a>*b); }
/* ******************************************************************** */

/* FUNCTION Avg_Registers */
static void Avg_Registers(void) {
   int class[CLASSES_TO_SORT];
   int stack[STACKS_TO_SORT];
   int MaxClasses = 0;
   int MaxStacks = 0;
   int i,j;

   for (i=1; i<=TO_SORT; i++) {			/* For each trial type	*/
      if (Register[i].frame_count==0)		/* Unused register?	*/
         continue;				/* Skip it		*/

      for (j=0; j<MaxClasses; j++)		/* Look thru classes	*/
         if (class[j] == Register[i].classnumber)  /* Found this one?	*/
	    break;
      if (j==MaxClasses && Register[i].classnumber!=0)	/* Found new one*/
         class[MaxClasses++] = Register[i].classnumber;	/* Store as next*/

      for (j=0; j<MaxStacks; j++)		/* Look thru stacks	*/
         if (stack[j] == Register[i].stacknumber)  /* Found this one?	*/
	    break;
      if (j==MaxStacks && Register[i].stacknumber!=0)	/* Found new one*/
         stack[MaxStacks++] = Register[i].stacknumber;	/* Store as next*/
      }

   if (MaxClasses > CLASSES_TO_SORT)
      fatal("CLASSES_TO_SORT is too small!");
   if (MaxStacks > STACKS_TO_SORT)
      fatal("STACKS_TO_SORT is too small!");

   qsort(class, MaxClasses, sizeof(int), (void *) mAx);
   qsort(stack, MaxStacks, sizeof(int), (void *) mAx);

   for (i=0; i<MaxStacks; i++)
      for (j=0; j<MaxClasses; j++) {
         AvgReg(Find_Register(stack[i], class[j]),
	 	TO_SORT + i*MaxClasses + j+1);
	 }
   }
/* ******************************************************************** */

/* FUNCTION Clean_Registers */
static void Clean_Registers() {
	int i;

	for (i=0; i<=TO_SORT; i++)
	    RemoveReg(i);
	}
/* ******************************************************************** */

/* FUNCTION Tag_Registers */
static void Tag_Registers(void) {
   	char newname[80];
	int i;

	for (i=0; i<MAX_REGISTERS; i++)
	     if (Register[i].trial_count > 0) {
	        sprintf(newname, "%d.%d %s",
		   Register[i].stacknumber,
		   Register[i].classnumber,
		   Register[i].stackname);
	        MacroTagReg(i, newname);
	        if (PRINT_REGISTER_NAMES)
	           fprintf(stderr, "  %d: %d.%d %s\n", i,
		      Register[i].stacknumber,
		      Register[i].classnumber,
		      Register[i].stackname);
	        }
	}
/* ******************************************************************** */

/* FUNCTION Find_Register */
	 /* Find register with given stack, class */
static int Find_Register(int stack, int class) {
	int i;

	for (i=1; i<=TO_SORT; i++)
            if (stack == Register[i].stacknumber
	    				&& class==Register[i].classnumber)
	       return(i);
	return(99);			/* Not found or out of room	*/
	}
/* ******************************************************************** */

/* FUNCTION Find_TrialType */
	 /* Return index of this trial in Class[]	*/
static int  Find_TrialType(void) {
    int i;
    int stack = Register[0].stacknumber;
    int class = Register[0].classnumber;

    for (i=1; i<=TO_SORT; i++) {
       if (Register[i].trial_count <= 0)		/* Empty?	*/
	  return(i);					/*  Use it	*/
        else						/* Else: match?	*/
        if (stack == Register[i].stacknumber && class==Register[i].classnumber)
	  return(i); 
       }
    return(99);
    }
/* ********************************************************************	*/
