/* FILE Memorymac.c	*/
     /* Read a string of units in; normalize each to a single trial and
        then add to a main register */
 
#include "../defs.h"
#include "../array.h"       		/* Access registers directly	*/
#include "../sac.h"
#include "../_imports/deffs.h"
#include "../_imports/event.h"       	/* Stack instruction definitions*/
#include <stdlib.h>


#define ROTATE_TO_PREFDIR	1	/* Make class 1 = PD; 5=ND	*/

#define ALIGN_ON_TARGET_ON	1	/* Cue onset			*/
#define ALIGN_ON_FIX_OFF	0	/* Fixation point offset	*/
#define ALIGN_ON_SACCADE	0	/* Final saccade		*/

#define NORMALIZE_TRIAL_COUNT	1	/* Each unit gets equal weight	*/
#define NORMALIZE_RATE		1	/* Each unit gets equal weight	*/
#define OFFSET			1	/* Each unit starts at 0	*/

#define PRINT_REGISTER_NAMES	0	/* Print it on screen		*/
#define WRITE_TO_DISK   	0

#define HEAVIEST_FILTER		1	/* Overrides 'heavy'		*/
#define HEAVY_FILTER		1	/* Heavy (2-4 Hz) or light (46)	*/
#define DOUBLE_FILTER_UNITS	1	/* Makes SE much cleaner	*/
#define DIFFERENTIATE_RATE	0	/* Calc rate of change of firing*/
#define DO_EYE_TRACES		1	/* Filter, etc:  very slow	*/

#define TO_SORT			50
	/* sht/med/long * 16 classes  */

static void Write_to_Disk(void);
static void Tag_Registers(void);
static void Normalize_Registers(int Target_At);
static void Offset_Registers(void);
static void Avg_Registers(void);
static void Subtract_Registers(void);
static void Clean_Registers(void);
static int  Find_TrialType(void);
static int  Find_Register(int stack, int class);

#define NOT_FOUND	INVALID_REG		/* 999			*/
/* ******************************************************************** */

/* FUNCTION Memory_sort_macro(pref) */
	 /* Sort trials and average together */
void Memory_sort_macro(int pref) {
   extern  int StepMs;			/* Differentiation stuff	*/
   int Eye_StepMs =  30;		/* Diff for eye channels	*/
# if DIFFERENTIATE_RATE			/* Differentiate units		*/
   int Unit_StepMs= 150;		/* Diff for units channel	*/
# endif

   extern int DiffChannel;			/* diff.c		*/
   static int ToldUs = 0;
   int Target_At = FAIL;			/*Time target appears at*/
   extern int UseFilter;
   int FilterSetting;
   int SkipCount = 0;
			/* Odd: fails if use "extern int DiffChannel"	*/

if (ALIGN_ON_TARGET_ON + ALIGN_ON_FIX_OFF + ALIGN_ON_SACCADE > 1)
   fatal("Choose just one alignment method");
if (ALIGN_ON_TARGET_ON + ALIGN_ON_FIX_OFF + ALIGN_ON_SACCADE == 0)
   fatal("Choose an alignment method");
if (ToldUs++ == 0)
 fprintf(stderr, "Align on %s\n",			/* Tell us	*/
  (ALIGN_ON_TARGET_ON)    ? "target on" : (
  (ALIGN_ON_FIX_OFF)      ? "fixation off": (
  (ALIGN_ON_SACCADE) ? "final saccade": "??")));

if (MAX_REGISTERS <= 2*TO_SORT + 2) {
   fprintf(stderr, "MAX_REG is only %d; need %d\n", MAX_REGISTERS, 2*TO_SORT+3);
   fatal("Increase MAX_REGISTERS or decrease TO_SORT");
   }

if (HEAVIEST_FILTER)
    FilterSetting = 1;
else if (HEAVY_FILTER)
    FilterSetting = 2;
else
    FilterSetting = 12;

do {						/* Next trial or header	*/

     if ((Register[0].stacknumber < 24) ||
	  (Register[0].stacknumber > 26))
        continue;	/* only memory stacks				*/

# if ROTATE_TO_PREFDIR			/* Align on best direction	*/
     if (pref == 0)		       	/* Didn't tell us which		*/
	fatal("Direction not specified: Memory_sort_macro");

     Register[0].classnumber = Register[0].classnumber - (pref -1);	
     if (Register[0].classnumber < 1)
	Register[0].classnumber = Register[0].classnumber + 16;
#endif     

    Set_CurrentChannel(UNIT);		/* Filter indis: SE is smooth	*/
    UseFilter = FilterSetting;
    Filter(0);
     if (DOUBLE_FILTER_UNITS)
        Filter(0);			/* Filter twice: cleaner SE's	*/

# if DIFFERENTIATE_RATE			/* Differentiate units		*/
    Set_CurrentChannel(UNIT);
    StepMs = Unit_StepMs;
    DiffChannel = X3;
    Differentiate(0);
# endif

     {
     int occur = 0;

     while (StackExtract(TARGET_RE_1_POLAR, ++occur, ONE) != 3) /* Targ 3? */
        if (occur > 100)
           fatal("Can't find target 3 RE_1_POLAR");
     Target_At = StackExtract(TARGET_RE_1_POLAR,occur,TIME);

     occur = 0;

#    if ALIGN_ON_TARGET_ON
      ShiftReg(0, 1000 - Target_At);
#    elif ALIGN_ON_FIX_OFF
     {
      int time_off, time_blank;
      while (StackExtract(TARGET_OFF, ++occur, ONE) != 1) /* Target 1?	*/
         if (occur > 100)
	    break;
      time_off = StackExtract(TARGET_OFF, occur, TIME);
      occur = 0;
      while (StackExtract(TARGET_BLANK, ++occur, ONE) != 1) /* Targ 1	*/
         if (occur > 100)
	    break;
      time_blank = StackExtract(TARGET_BLANK, occur, TIME);
	
      if (time_off == -9999 && time_blank == -9999)
         fatal("Can't find target blank/off");

      if ((time_off==FAIL) ||		/* Only a 'blank' exists	*/
          (time_blank != -9999 &&	/* Both exist, and		*/
	      time_blank<time_off))	/* blank occurs BEFORE off:	*/
	time_off = time_blank;		/* Then use blank time		*/
					/* Else use off time		*/
      ShiftReg(0, 7000 - time_off);
     }
#    elif ALIGN_ON_SACCADE
      {
      int at, at_h, at_v;
      float size_h, size_v;
      int occur = 0;
      extern NoSacsBeforeThis;
      extern NoSacsAfterThis;
      extern SuppressNoSaccadeMessage;
      
      occur = 0;
      while (StackExtract(TARGET_BLANK, ++occur, TIME) != FAIL) ;
      NoSacsAfterThis = StackExtract(TARGET_BLANK, occur-1, TIME);
			    /* R: not sure what's going on here...*/

      if (NoSacsAfterThis == FAIL)
          NoSacsAfterThis = 0;

      ChangeParameter('t', "h");	/* Horizontal eye position	*/
      UseFilter = 2;
      Filter(0);
      SuppressNoSaccadeMessage = 1;
      FindSaccade(0);
      at_h = SaccadeData.peak;
      if (at_h != FAIL)
         size_h = AvgSomeData(0, SaccadeData.end+50, SaccadeData.end+250) -
                  AvgSomeData(0, SaccadeData.begin-250, SaccadeData.begin-50);

      ChangeParameter('t', "v");	/* Vertical eye position	*/
      Filter(0);
      FindSaccade(0);
      at_v = SaccadeData.peak;
      if (at_v != FAIL)
         size_v = AvgSomeData(0, SaccadeData.end+50, SaccadeData.end+250) -
                  AvgSomeData(0, SaccadeData.begin-250, SaccadeData.begin-50);
      SuppressNoSaccadeMessage = 0;

      if (at_h == FAIL && at_v == FAIL) {
         SkipCount++;
	 continue;
	 }

      if (at_h == FAIL)
          at = at_v;
      else if (at_v == FAIL)
          at = at_h;
      else if (size_h > size_v)
         at = at_h;
      else
         at = at_v;

      ShiftReg(0, 7000 - at);
      }
#    endif
     }

#   if DO_EYE_TRACES
     StepMs = Eye_StepMs;
     UseFilter = 12;			/* Don't over-filter position */
     Set_CurrentChannel(OD_H);
     Filter(0);
     DiffChannel = H_VEL;
     Differentiate(0);
     UseFilter = FilterSetting;		/* Do over-filter velocity */
     Filter(0);

     UseFilter = 12;			/* Don't over-filter position */
     Set_CurrentChannel(OD_V);
     Filter(0);
     DiffChannel = V_VEL;
     Differentiate(0);
     UseFilter = FilterSetting;
     Filter(0);
#   endif

  AvgReg(0, Find_TrialType());			/* Determine type	*/
} while (Read_trial() != FAIL);			/* Next header		*/

if (SkipCount)
   fprintf(stderr, "Memory macro: skipped %d trials (couldn't find saccade)\n",
	SkipCount);

Tag_Registers();

if (NORMALIZE_TRIAL_COUNT || NORMALIZE_RATE)
   Normalize_Registers(Target_At);

if (OFFSET)
   Offset_Registers();

Avg_Registers();
Subtract_Registers();				/* Do differences	*/

Clean_Registers();

if (WRITE_TO_DISK)
    Write_to_Disk();
}
/* ******************************************************************** */
/* ******************************************************************** */
/* ******************************************************************** */

/* FUNCTION Write_to_Disk */
	 /* Write to disk */
static void Write_to_Disk(void) {
   int i;

   for (i=TO_SORT+1; i<=TO_SORT*2; i++)
      if (ContentReg(i) > 0)
         RawFile(i);				/* Disk copies	*/
   }
/* ******************************************************************** */

/* FUNCTION Normalize_Registers */
	 /* Make'm look like 1 trial, and/or set max height = 100 Hz */
static void Normalize_Registers(int Target_At) {
	int i;

	if (NORMALIZE_TRIAL_COUNT)
           for (i=1; i<=TO_SORT; i++)
	      NormalizeReg(i);

	if (NORMALIZE_RATE) {
	   float max_peak = -9999.;
	   int peak_at;

 	   ChangeParameter('t', "u");		/* Change to units	*/

           for (i=1; i<=TO_SORT; i++) {
	      peak_at = FindPeakOfData(i,
	        Target_At + Register[i].shift,	/* Target presentation	*/
		Target_At + Register[i].shift + 500,	/* 500 ms later	*/
		1);					/* Positive peak*/
	      if (AvgSomeData(i,peak_at-10, peak_at+10) > max_peak)
	         max_peak = AvgSomeData(i,peak_at-10, peak_at+10);
	      }
	   if (max_peak < 0.)
	      fatal("Memory mac: couldn't find peak value! CORRECT STACKS?");
	   {
	   extern float multiplier;		/* From data.c		*/
 	   multiplier = 100/max_peak;		/* Scale peak to 100	*/
	   }

           for (i=1; i<=TO_SORT; i++)
	      MultiplyData(i);
	   }
	}
/* ******************************************************************** */

/* FUNCTION Offset_Registers */
	 /* Offset so pre-target activity (-300 to 0) is at zero */
static void Offset_Registers(void) {
	int i;
        for (i=1; i<=TO_SORT; i++)
          if (Register[i].trial_count)			/* Not empty?	*/
	    OffsetData(i, AvgSomeData(i, 700, 1000));
	}
/* ******************************************************************** */

/* FUNCTION Avg_Registers */
static void Avg_Registers(void) {
						/* Stack 24		*/
						/*  FIRST DO SHORT MEM    */
   AvgReg(Find_Register(24,1), TO_SORT + 1);
   AvgReg(Find_Register(24,2), TO_SORT + 2);
   AvgReg(Find_Register(24,3), TO_SORT + 3);
   AvgReg(Find_Register(24,4), TO_SORT + 4);
   AvgReg(Find_Register(24,5), TO_SORT + 5);
   AvgReg(Find_Register(24,6), TO_SORT + 6);
   AvgReg(Find_Register(24,7), TO_SORT + 7);
   AvgReg(Find_Register(24,8), TO_SORT + 8);
   AvgReg(Find_Register(24,9), TO_SORT + 9);
   AvgReg(Find_Register(24,10), TO_SORT + 10);
   AvgReg(Find_Register(24,11), TO_SORT + 11);
   AvgReg(Find_Register(24,12), TO_SORT + 12);
   AvgReg(Find_Register(24,13), TO_SORT + 13);
   AvgReg(Find_Register(24,14), TO_SORT + 14);
   AvgReg(Find_Register(24,15), TO_SORT + 15);
   AvgReg(Find_Register(24,16), TO_SORT + 16);
						/* Stack 25		*/
						/*  NEXT DO MED MEM    */
   AvgReg(Find_Register(25,1), TO_SORT + 17);
   AvgReg(Find_Register(25,2), TO_SORT + 18);
   AvgReg(Find_Register(25,3), TO_SORT + 19);
   AvgReg(Find_Register(25,4), TO_SORT + 20);
   AvgReg(Find_Register(25,5), TO_SORT + 21);
   AvgReg(Find_Register(25,6), TO_SORT + 22);
   AvgReg(Find_Register(25,7), TO_SORT + 23);
   AvgReg(Find_Register(25,8), TO_SORT + 24);
   AvgReg(Find_Register(25,9), TO_SORT + 25);
   AvgReg(Find_Register(25,10), TO_SORT + 26);
   AvgReg(Find_Register(25,11), TO_SORT + 27);
   AvgReg(Find_Register(25,12), TO_SORT + 28);
   AvgReg(Find_Register(25,13), TO_SORT + 29);
   AvgReg(Find_Register(25,14), TO_SORT + 30);
   AvgReg(Find_Register(25,15), TO_SORT + 31);
   AvgReg(Find_Register(25,16), TO_SORT + 32);
						/* Stack 26		*/
						/* LAST DO LONG MEM	*/
   AvgReg(Find_Register(26,1), TO_SORT + 33);
   AvgReg(Find_Register(26,2), TO_SORT + 34);
   AvgReg(Find_Register(26,3), TO_SORT + 35);
   AvgReg(Find_Register(26,4), TO_SORT + 36);
   AvgReg(Find_Register(26,5), TO_SORT + 37);
   AvgReg(Find_Register(26,6), TO_SORT + 38);
   AvgReg(Find_Register(26,7), TO_SORT + 39);
   AvgReg(Find_Register(26,8), TO_SORT + 40);
   AvgReg(Find_Register(26,9), TO_SORT + 41);
   AvgReg(Find_Register(26,10), TO_SORT + 42);
   AvgReg(Find_Register(26,11), TO_SORT + 43);
   AvgReg(Find_Register(26,12), TO_SORT + 44);
   AvgReg(Find_Register(26,13), TO_SORT + 45);
   AvgReg(Find_Register(26,14), TO_SORT + 46);
   AvgReg(Find_Register(26,15), TO_SORT + 47);
   AvgReg(Find_Register(26,16), TO_SORT + 48);

   }
/* ******************************************************************** */

/* FUNCTION Subtract_Registers */
static void Subtract_Registers() {
  if (Find_Register(26,1)!= NOT_FOUND) {
   CopyReg(Find_Register(26,1), 0);	   /* 26.1 into reg 0	*/
   /*SubtractReg(0, Find_Register(26,9));    0 = 26.1 - 26.9	*/
   /* Don't do subtraction -- not all cells have nonpref at 9   */
   AvgReg(0, TO_SORT + 49);
   MacroTagReg(TO_SORT + 49, "Copy 26.1");
   /*MacroTagReg(TO_SORT + 49, "Diff 26.1 - 26.9");		*/
   if (Find_Register(26,2)!= NOT_FOUND) {
       /* Fine spacing (22.5 deg) not always tested		*/
       CopyReg(Find_Register(26,2), 0);	   /* 26.2  into reg 0	*/
       AvgReg(Find_Register(26,16), 0);	   /* 26.16 into reg 0	*/
       AvgReg(0, TO_SORT + 50);
       MacroTagReg(TO_SORT + 50, "Avg  26.2&16");
       }
   CopyReg(Find_Register(26,3), 0);	   /* 26.3  into reg 0	*/
   AvgReg(Find_Register(26,15), 0);	   /* 26.15 into reg 0	*/
   AvgReg(0, TO_SORT + 51);
   MacroTagReg(TO_SORT + 51, "Avg   26.3&15");
   }
}
/* ******************************************************************** */
/* FUNCTION Clean_Registers */
static void Clean_Registers() {
	int i;

	for (i=0; i<=TO_SORT; i++)
	    RemoveReg(i);
	}
/* ******************************************************************** */

/* FUNCTION Tag_Registers */
static void Tag_Registers(void) {
   	char newname[80];
	int i;

	for (i=0; i<MAX_REGISTERS; i++)
	     if (Register[i].trial_count > 0) {
	        sprintf(newname, "%d.%d %s",
		   Register[i].stacknumber,
		   Register[i].classnumber,
		   Register[i].stackname);
		
	        MacroTagReg(i, newname);
	        }
	if (PRINT_REGISTER_NAMES)
	   ListReg();
	}
/* ******************************************************************** */

/* FUNCTION Find_Register */
	 /* Find register with given stack, class */
static int Find_Register(int stack, int class) {
	int i;

	for (i=1; i<=TO_SORT; i++)
	   if (Register[i].trial_count)
            if (stack == Register[i].stacknumber
	    				&& class==Register[i].classnumber)
	       return(i);
	return(NOT_FOUND);		/* Not found or out of room	*/
	}
/* ******************************************************************** */

/* FUNCTION Find_TrialType */
	 /* Return index of this trial in Class[]	*/
static int  Find_TrialType(void) {
    int i;
    int stack = Register[0].stacknumber;
    int class = Register[0].classnumber;

    for (i=1; i<=TO_SORT; i++) {
       if (Register[i].trial_count <= 0)		/* Empty?	*/
	  return(i);					/*  Use it	*/
        else						/* Else: match?	*/
        if (stack == Register[i].stacknumber && class==Register[i].classnumber)
	  return(i); 
       }
    return(NOT_FOUND);
    }
/* ********************************************************************	*/
