/* FILE Framemac.c	*/
     /* Sort and align reference frames data, then write it out	*/
 
#include "../defs.h"
#include "../array.h"       		/* Access registers directly	*/
#include "../sac.h"
#include "../_imports/deffs.h"
#include "../_imports/event.h"       	/* Stack instruction definitions*/
#include "../_imports/head.h"       	/* Monk name, unit & run numbers*/
#include <stdlib.h>

#define TO_SORT			80	/* Max number of stack/class combos*/
	/* vest/sac/purs * 6 classes * 2 directions * Eye/World	*/

static int  Find_TrialType(void);

#define NOT_FOUND	INVALID_REG		/* 999			*/
/* ******************************************************************** */

/* FUNCTION Frames_sort_macro() */
	 /* Reference frame data */
void Frames_sort_macro() {
   int Target_At;
   int occur;
   int i;



do {						/* Next trial or header	*/
     /* Register[0].stacknumber = (Register[0].stacknumber % 100); */

     /* ALIGN DATA ON TARGET ONSET */
     occur = 0;
     while (StackExtract(TARGET_RE_1, ++occur, ONE) != 3) /* Target 3?	*/
        if (occur > 100)
           fatal("Can't find target 3 RE_1");
     Target_At = StackExtract(TARGET_RE_1,occur,TIME);

     ShiftReg(0, 1000 - Target_At);

     /* DISCARD ALL DATA AFTER FIXATION OFFSET */
     { int time_off, time_blank;

      i = 0;
      while (StackExtract(TARGET_OFF, ++i, ONE) != 1) /* Target 1?	*/
         if (i > 100)
	    break;
      time_off = StackExtract(TARGET_OFF, i, TIME);
      i = 0;
      while (StackExtract(TARGET_BLANK, ++i, ONE) != 1) /* Targ 1	*/
         if (i > 100)
	    break;
      time_blank = StackExtract(TARGET_BLANK, i, TIME);
	
      if (time_off == FAIL && time_blank == FAIL)
         fatal("Can't find target blank/off");

      if ((time_off==FAIL) ||		/* Only a 'blank' exists	*/
          (time_blank != FAIL &&	/* Both exist, and		*/
	      time_blank<time_off))	/* blank occurs BEFORE off:	*/
	time_off = time_blank;		/* Then use blank time		*/
					/* Else use off time		*/
      DeleteAllData(0, time_off, time_off+100000);
      }

     AvgReg(0, Find_TrialType());		/* Determine type	*/
} while (Read_trial() != FAIL);			/* Next header		*/

ListReg();

for (i=1; i<TO_SORT; i++) {
   if (ContentReg(i) > 0) {
      char OutputName[80];
      FILE *File;
      /* Open up an output file */
      sprintf(OutputName, "t_%c_%d.%d_%d.%d",
		       h.id.monk[0], h.id.unit, h.id.run,
		       Register[i].stacknumber, Register[i].classnumber);
      File = fopen(OutputName, "w");

      UseStack(i);

      fprintf(File,
	     "stack %d class %d reg %d   %s target at %.1f %.1f\n",
	Register[i].stacknumber, Register[i].classnumber,
	i, 
	(StackExtract(TARGET_PURSUIT, 6, TIME) == FAIL) ? "world" : "gaze",
        StackExtract(TARGET_RE_1,occur,TWO)/10.,
        StackExtract(TARGET_RE_1,occur,THREE)/10.
	);
      TextFile(i, File, 1);	/* Might want format 2 -- unsure LHS 2018*/
      fclose(File);
      }
   }
}
/* ******************************************************************** */

/* FUNCTION Find_TrialType */
	 /* Return index of this trial in Class[]	*/
static int  Find_TrialType(void) {
    int i;
    int stack = Register[0].stacknumber;
    int class = Register[0].classnumber;

    for (i=1; i<=TO_SORT; i++) {
       if (Register[i].trial_count <= 0)		/* Empty?	*/
	  return(i);					/*  Use it	*/
        else						/* Else: match?	*/
        if (stack == Register[i].stacknumber && class==Register[i].classnumber)
	  return(i); 
       }
    return(NOT_FOUND);
    }
/* ********************************************************************	*/
