/* FILE xyplot */
    /* Eye position and targets in X-Y space (instead of vs time plots)	*/

    /* First eye target is red; subsequent eye targets are purple.
     * Cues are cyan; arm targets are green.
     * Pursuit trajectory is white/black.
     * Eye locations are red, arm locations are slightly dark cyan
     */

#include <stdlib.h>					/* abs()	*/
#include "deffs.h"

#define SHOW_EVENTS		1

#include "ad.h"
#include "config.h"
#include "event.h"			/* So can call EventExtract()	*/

/* ********************************************************************	*/
/* #define MAX_H_RANGE		 ((ZOOM_AD_RANGE_BEHAV) ? 28 : 50)
 * #define MAX_V_RANGE	       ((((ZOOM_AD_RANGE_BEHAV) ? 28 : 50) * 2) / 3)
 */

#define MAX_H_RANGE  (40 / ((ZOOM_AD_RANGE_BEHAV==0)? .5:ZOOM_AD_RANGE_BEHAV))
#define MAX_V_RANGE  (MAX_H_RANGE * 2 / 3)


#define CHAIR_OFFSET		(-MAX_V_RANGE)

static int Counts[MAX_TYPES];
static int FirstTargRed;	/* Pun on read: seen 1st targ yet?	*/

static void XY_Plot_Analog_Eye();
static void XY_Plot_Analog_Arm();
static void XY_Plot_Analog_Chair();
static int ADtoPix_H(int h);
static int ADtoPix_V(int v);
static void Do_XY_Tics();
static void Arrow(int H1, int V1, int H2, int V2, int width);
static int scale = 0;
/* ********************************************************************	*/

/* FUNCTION Init_XY_Plot */
	 /* Initialize */
void Init_XY_Plot() {
	extern void Set_Config_Parameter();
	int i;

	for (i=0; i<MAX_TYPES; i++)
	    Counts[i] = 0;

	Set_Config_Parameter("HEIGHT", (2 * DurationTime())/3);
	/* Set height close to duration so plot is close to square	*/
	}
/* ********************************************************************	*/

/* FUNCTION Do_Individual_XY_Plot */
	 /* Plot stuff in X-Y space */
void Do_Individual_XY_Plot() {
	int trialtype = Get_TrialType();

	if (Setup_Coords_For_TrialType(trialtype) == -1)  /* No draw	*/
	   return;

	scale = abs(Get_Histo_Scale_From_CmdLine());

	Counts[trialtype]++;
	if (FAST_FIGURE) {
	   if (Counts[trialtype] != 1)
	      return;
	} else if (SEMI_FAST_FIGURE) {
	   if (Counts[trialtype] > SEMI_FAST_FIGURE)
	      return;
	   }

	SetColorByTrialType(trialtype);
	if (Counts[trialtype] == 1)
	   Do_XY_Tics();
	   
	if (SHOW_ANALOG & SHOW_EVENTS) {
	   FirstTargRed = 0; 
	   Show_Events_For_XY_Plot();
	   }

	if (SHOW_ANALOG) {
	   extern int if_overlay_stacks();
	   SetColorByTrialType(trialtype);
	   if (! if_overlay_stacks())
	       Color(8,0,0);
	   XY_Plot_Analog_Eye();
	   if (TouchCount_Header(1) != FAIL) {	/* Optical touch panel	*/
	         if (! if_overlay_stacks())
	            Color(0,8,0);
	         XY_Plot_Analog_Arm();
	         }
	   if (ChairAt_Header() != REACH_FAIL)	/* Chair stuff		*/
		 XY_Plot_Analog_Chair();
	   }
        }
/* ********************************************************************	*/

/* FUNCTION XY_Plot_Target */
	 /* Plot eye or arm target OR CUE (values in ADunits)	*/
void XY_Plot_Target(int H, int V, int which) {

	SetLineWidth(2);
	if (which == EYE)
	   Color(8,0,(FirstTargRed)? 8:0);		/* red/purple	*/
	else if (which == ARM)
	   Color(0,8,0);				/* green	*/
	else
	   Color(0,4,4);				/* cyan		*/
	circle(ADtoPix_H(H),ADtoPix_V(V), 50 + (which>EYE)*25);
	fill(0);			/* Can be empty or filled!	*/

	if (which <= EYE)
	   FirstTargRed = 1;
	}
/* ********************************************************************	*/

/* FUNCTION XY_Plot_Vector */
	 /* Plot vector (current eye/arm to target) (values in ADunits)	*/
void XY_Plot_Vector(int targ_H, int targ_V, int time, int which) {
	float eye_H, eye_V;

	SetLineWidth(0);                    		/* Very thin	*/
	if (which == EYE)
	   Color(8,5,0);				/* orange	*/
	else if (which == ARM)
	   Color(0,8,0);				/* green	*/
	else
	   Color(0,8,8);				/* cyan		*/

	if (! TimeNotRecorded(time, time+50)) {
	  static int Save_V_offset = 0;		/* Offset vector 	*/
	  static int Save_H_offset = 0;		/* Offset vector 	*/
	  static int first = 1;
	  int H_offset = 0, V_offset = 0;
	  
	  if (which == EYE) {	/* Vector shows final sac: messy	*/
	     if (first==1) {	/* Calculate just once (save everywhere)*/

	        /* If the chair moves, then offset to chair vector */
		if (EventExtract(CHAIR_AT, TIME, 1) != FAIL)
		   Save_V_offset = ADtoPix_V(CHAIR_OFFSET);
	        else if (abs( targ_V - (int)DEGtoAD(eye_V)) < 40)
	           Save_V_offset = 2*ADtoPix_V(MAX_V_RANGE)/3;
	        else if (abs( targ_H - (int)DEGtoAD(eye_H)) < 40)
	           Save_H_offset = 2*ADtoPix_H(MAX_H_RANGE)/3;
		first = 0;
		}
	     H_offset = Save_H_offset;
	     V_offset = Save_V_offset;
	     }

	  Get_EyePosition(time, time+50, &eye_H, &eye_V);
	  move(ADtoPix_H(targ_H) - H_offset, ADtoPix_V(targ_V) - V_offset);
	  cont(ADtoPix_H((int)DEGtoAD(eye_H)) - H_offset,
	       ADtoPix_V((int)DEGtoAD(eye_V)) - V_offset);
	  }
	}
/* ********************************************************************	*/

/* FUNCTION XY_Plot_Pursuit */
	 /* Plot a pursuit course (values in ADs)	*/
void XY_Plot_Pursuit(int H1, int V1, int H2, int V2) {
	Color(0,0,0);					/* White/black	*/
	Arrow(ADtoPix_H(H1), ADtoPix_V(V1), ADtoPix_H(H2), ADtoPix_V(V2), 3);
	}
/* ********************************************************************	*/

/* FUNCTION XY_Plot_Analog_Eye */
	 /* Plot eye position (X-Y) */
static void XY_Plot_Analog_Eye() {
	extern short Data[MAX_FRAMES*MAX_CHANNELS];	/* Analog data	*/
	int channels = ChannelCount_Header();
	int AVG = ANALOG_GRAPH_DENSITY;			/* Just 1 lookup*/
	int from = (Get_Interval_Begin(1)+Get_ZeroTime()) / MsPerFrame_Header();
	int to   = (Get_Interval_End  (1)+Get_ZeroTime()) / MsPerFrame_Header();
	int OneBigPoint = (AVG == 0);
	int from2= (Get_Interval_Begin(2)+Get_ZeroTime()) / MsPerFrame_Header();
	int to2  = (Get_Interval_End  (2)+Get_ZeroTime()) / MsPerFrame_Header();

	if (GRAPH_EYES == 0)
	   return;

	SetLineWidth(0);

	if (from == to) {		/* No limits - open all the way	*/
	   from = 1;
	   to = FrameCount_Header();
	   }

	if (OneBigPoint)
	   AVG = to - from;		/* Else skips inner loop, below	*/
        else if (from2 != to2)
	   fprintf(stderr, "Use -B or -I only if 1 point (ANALOG_DENSITY=0)\n");

	while (from < FrameCount_Header()-AVG  &&  from<to-AVG/2) {
	   int sum_h  = 0, sum_v  = 0;
	   int sum_h2 = 0, sum_v2 = 0;
	   int j;

	   for (j=0; j<AVG; j++) {
	      sum_h += Data[(from+j)*channels + H_EYE];
	      sum_v += Data[(from+j)*channels + V_EYE];
	      }

	   sum_h /= AVG;
	   sum_v /= AVG;

	   if (OneBigPoint && (from2 != to2)) {
	     for (j=from2; j<to2; j++) {
	      sum_h2 += Data[j*channels + H_EYE];
	      sum_v2 += Data[j*channels + V_EYE];
	      }
	     sum_h -= sum_h2/AVG;
	     sum_v -= sum_v2/AVG;
	     }

	   if (OneBigPoint)
	      j = 80;
	    else if (AVG > 9)
	      j = 60;
	    else
	      j = 15;
	   if (ZOOM_AD_RANGE_BEHAV > 0)
	      j /= ZOOM_AD_RANGE_BEHAV;
	   if (ZOOM_AD_RANGE_BEHAV < 0)
	      j *= ZOOM_AD_RANGE_BEHAV;

	   circle(ADtoPix_H(sum_h), ADtoPix_V(sum_v), j);
	   if (OneBigPoint)
	      fill(1);
	   from += AVG;
	   }

#if INCLUDE
	/* Eye position at alignment time */
	{
	float H, V;
	int AlignmentTime = Get_ZeroTime()+SkipSpikeTime();
	Color(8,5,8);

	if (! TimeNotRecorded(AlignmentTime, AlignmentTime+50)) {
	   Get_EyePosition(AlignmentTime, AlignmentTime+50, &H, &V);
	   circle(ADtoPix_H((int)DEGtoAD(H)), ADtoPix_V((int)DEGtoAD(V)), 45);
	   fill(1);
	   }
	}
#endif
	}
/* ********************************************************************	*/

/* FUNCTION XY_Plot_Analog_Arm */
	 /* Plot arm position (X-Y) */
static void XY_Plot_Analog_Arm() {
	extern short Touch1[MAX_FRAMES*MAX_CHANNELS];	/* Analog data	*/
	short *Ptr = Touch1, *Ptr2 = Touch1;
	int AVG = ANALOG_GRAPH_DENSITY;			/* Just 1 lookup*/
	int from = (Get_Interval_Begin(1)+Get_ZeroTime()) / MsPerFrame_Header();
	int to   = (Get_Interval_End  (1)+Get_ZeroTime()) / MsPerFrame_Header();
	int OneBigPoint = (AVG == 0);
	int from2= (Get_Interval_Begin(2)+Get_ZeroTime()) / MsPerFrame_Header();
	int to2  = (Get_Interval_End  (2)+Get_ZeroTime()) / MsPerFrame_Header();

	if (GRAPH_ARMS == 0)
	   return;

	         /* MODIFIED ALL THIS CODE 2013-10-24 for -b, not tested*/

	SetLineWidth(0);

	if (from == to) {		/* No limits - open all the way	*/
	   from = 1;
	   to = FrameCount_Header();
	   }

	if (OneBigPoint)		/* Added 2007-8-30 and not tested */
	   AVG = to - from;		/* Else skips inner loop, below	*/
        else if (from2 != to2)
	   fprintf(stderr, "Use -B or -I only if 1 point (ANALOG_DENSITY=0)\n");

	Ptr += from * 2;
	Ptr2 += from * 2;

	while (from < FrameCount_Header()-AVG  &&  from<to-AVG/2) {
	   int sum_h2 = 0, sum_v2 = 0;
	   int sum_h  = 0, sum_v  = 0;
	   int N_h = 0, N_v = 0;
	   int N_h2 = 0, N_v2 = 0;
	   int j;

	   for (j=0; j<AVG; j++) {
	      if (*Ptr != NO_TOUCH) {
	         sum_h += *Ptr;
		 N_h++;
	         }
	      Ptr++;
	      if (*Ptr != NO_TOUCH) {
	         sum_v += *Ptr;
		 N_v++;
	         }
	      Ptr++;
	      }
	   if (N_h && N_v) {
	      sum_h /= N_h;
	      sum_v /= N_v;
	      }
		 

	   if (OneBigPoint && (from2 != to2)) {
	    for (j=0; j<AVG; j++) {
	      if (*Ptr2 != NO_TOUCH) {
	         sum_h2 += *Ptr2;
		 N_h2++;
	         }
	      Ptr2++;
	      if (*Ptr2 != NO_TOUCH) {
	         sum_v2 += *Ptr2;
		 N_v2++;
	         }
	      Ptr2++;
	      }
	     if (N_h2 && N_v2) {
	        sum_h -= sum_h2/N_h2;
	        sum_v -= sum_v2/N_v2;
	        }
	     }
	   from += AVG;
	   from2 += AVG;

	   if (N_h && N_v) {
	      if (OneBigPoint)
	         j = 80;
	       else if (AVG > 9)
	         j = 60;
	       else
	         j = 15;
	      if (ZOOM_AD_RANGE_BEHAV > 0)
	         j /= ZOOM_AD_RANGE_BEHAV;
	      if (ZOOM_AD_RANGE_BEHAV < 0)
	         j *= ZOOM_AD_RANGE_BEHAV;

	      circle(ADtoPix_H(sum_h), ADtoPix_V(sum_v), j);
	      if (OneBigPoint)
	         fill(1);
	      }
	   }
	}
/* ********************************************************************	*/

/* FUNCTION XY_Plot_Analog_Chair */
	 /* Plot chair vector (begin -> end), NOT interval-constrained	*/
static void XY_Plot_Analog_Chair() {
	extern short Data[MAX_FRAMES*MAX_CHANNELS];	/* Analog data	*/
	int channels = ChannelCount_Header();
	int begin=0;
	int end = FrameCount_Header();
	int j;

	for (j=0; j<20; j++) {
	    begin += Data[(j    )*channels + CHAIR_POSITION];
	    end   += Data[(end-j)*channels + CHAIR_POSITION];
	    }

	if (abs(begin - end) > 30) {	/* Don't draw tiny vectors	*/
	   Color(8,8,0);
	   SetLineWidth(1);
	   Arrow(ADtoPix_H(begin/20), CHAIR_OFFSET,
	         ADtoPix_H(end/20),   CHAIR_OFFSET, 3);
	   }
	}
/* ********************************************************************	*/

/* FUNCTION ADtoPix_H */
	 /* Scale DurationTime() to MAX_RANGE	*/
static int ADtoPix_H(int h) {
   if (scale)
      return((int) (DurationTime()/2. + (h * DurationTime()) /
      	DEGtoAD(2*MAX_H_RANGE) * scale / 100.));
   else 
      return(DurationTime()/2 + (h * DurationTime()) / DEGtoAD(2*MAX_H_RANGE));
   }
/* ********************************************************************	*/

/* FUNCTION ADtoPix_V */
	 /* Scale HEIGHT to two-thirds of MAX_RANGE	*/
static int ADtoPix_V(int v) {
   if (scale)
      return((int) (HEIGHT/2. + (v * HEIGHT) / (DEGtoAD(2*MAX_V_RANGE))
      	* scale / 100.));
   else 
      return(HEIGHT/2 + (v * HEIGHT) / (DEGtoAD(2*MAX_V_RANGE)));
      }		/* Offset by half height; Divide by range in deg*/
/* ********************************************************************	*/

/* FUNCTION Do_XY_Tics */
static void Do_XY_Tics() {
	int TenDeg_H = ADtoPix_H(DEGtoAD(10)) - ADtoPix_H(0);
	int TenDeg_V = ADtoPix_V(DEGtoAD(10)) - ADtoPix_V(0);
	int Mid_H = DurationTime()/2;
	int Mid_V = HEIGHT/2;
	int TicSize = TenDeg_H/10;
	int i = 0;

	if (DRAW_BOX) {
	   SetLineWidth(2);                    	/* Double thick	*/
	   move(0,0);                          	/* Draw box	*/
	   cont(0,HEIGHT);
	   cont(DurationTime(), HEIGHT);
	   cont(DurationTime(), 0);
	   cont(0, 0);
	   }

	Color(0,0,0);
	SetLineWidth(0);

	move(DurationTime(), Mid_V);		/* Cross-hairs	*/
	cont(0, HEIGHT/2);
	move(Mid_H, HEIGHT);
	cont(Mid_H, 0);

	while (++i*10 < MAX_H_RANGE) {
	   move(Mid_H + i*TenDeg_H, Mid_V - TicSize);
	   cont(Mid_H + i*TenDeg_H, Mid_V + TicSize);	/* 10 deg marks	*/

	   move(Mid_H - i*TenDeg_H, Mid_V + TicSize);
	   cont(Mid_H - i*TenDeg_H, Mid_V - TicSize);
	   }

	i = 0;
	while (++i*10 < MAX_V_RANGE) {
	   move(Mid_H - TicSize, Mid_V + i*TenDeg_V);
	   cont(Mid_H + TicSize, Mid_V + i*TenDeg_V);

	   move(Mid_H + TicSize, Mid_V - i*TenDeg_V);
	   cont(Mid_H - TicSize, Mid_V - i*TenDeg_V);
	   }
	}
/* ********************************************************************	*/

/* FUNCTION Arrow */
	 /* Draw a line with an arrowhead */
static void Arrow(int H1, int V1, int H2, int V2, int width) {
	/* Begin coords, end coords, width */
	int Size = DurationTime()/30;
	int Arrow_H1=0, Arrow_H2=0, Arrow_V1=0, Arrow_V2=0;

	SetLineWidth(width);                   		/* Thick	*/

	move(H1, V1);
	cont(H2, V2);

	if (H2 > H1) {					/* to right?	*/
	   if (V2 > V1) {
	      ;
	   } else if (V2 < V1) {
	      ;
	   } else {
	      Arrow_V1 = -Size;
	      Arrow_V2 =  Size;
	      Arrow_H1 = Arrow_H2 = -Size;
	      }
	} else if (H2 < H1) {				/* to left?	*/
	   if (V2 > V1) {
	      ;
	   } else if (V2 < V1) {
	      ;
	   } else {
	      Arrow_V1 = -Size;
	      Arrow_V2 =  Size;
	      Arrow_H1 = Arrow_H2 = Size;
	      }
	} else { 					/* Vertical?	*/
	   Arrow_H1 = -Size;
	   Arrow_H2 =  Size;
	   Arrow_V1 = Arrow_V2 = (V2>V1) ? -Size : Size;
	   }

	move(H2, V2);
	cont(H2 + Arrow_H1, V2 + Arrow_V1);
	move(H2, V2);
	cont(H2 + Arrow_H2, V2 + Arrow_V2);
	}
/* ********************************************************************	*/
