/* FILE util */
     /* Miscellaneous graphing functions, used by histo and/or graph	*/

#include <unistd.h>		/* For lseek() */
#include "deffs.h"		/* Uses only function.h and STACK	*/

/*
 PUBLIC:
   SetColorByStackNumber	Basic method: lookup stack#, map to color
   SetColorByTrialType		Get stack# given trialtype, call ByStack#
   SetColorByStackIndex		Get stack# given stack index, call ByStack#
   Color			Set color (interface to library SetColor())
   TargetLocation		Given target line #, return horiz location (deg)
   Coord_To_TargetCode		Given coords, return code of target (0x0->55)
   SayWhere			Report where you are in the file (for diag)
 */

/* ********************************************************************	*/
			/* WASHU (new) */

#if larry || afreen || ben || michael
# define BIMANUAL			1
# define PROPRIO2			0
# define PROPRIO3			1
#endif

#if kaplan
# define PROPRIO			0
# define PROPRIO2			0
#endif
#if larry || tim || jason || jim || kaplan
/* # define REFERENCE_FRAME		1    Conflicts with proprio */
#elif calton || tony || liz || kristina || steve  
# define CHANG_REACH			1
#elif justin
# define REFERENCE_FRAME_JB		1
#elif rob
# define REFERENCE_FRAME_RW		1
#elif stoet
#elif yuqing || eric
# define MUSCIMOL			1
#elif cunguo || ericm || sreyas || kang
#define BIMANUAL			1
#endif

#ifndef REFERENCE_FRAME
# define REFERENCE_FRAME		0
#endif
#ifndef REFERENCE_FRAME_JB
# define REFERENCE_FRAME_JB		0
#endif
#ifndef REFERENCE_FRAME_RW
# define REFERENCE_FRAME_RW		0
#endif
#ifndef MEMORY_RW
# define MEMORY_RW			0
#endif
#ifndef CHANG_REACH
# define CHANG_REACH			0
#endif
#ifndef CALTON_REACH
# define CALTON_REACH			0
#endif
#ifndef MUSCIMOL
# define MUSCIMOL			0
#endif
#ifndef BONNIE
# define BONNIE				0
#endif
#ifndef STOET
# define STOET				0
#endif
#ifndef BIMANUAL
# define BIMANUAL			0
#endif
#ifndef PROPRIO
# define PROPRIO			0
#endif
#ifndef PROPRIO2
# define PROPRIO2			0
#endif
/* ********************************************************************	*/
/* PRIMARY METHOD OF CHOOSING COLOR IS BY STACK NUMBER.  IF THE STACK
   NUMBER DOES NOT APPEAR IN THE SWITCH, THEN COLOR IS CHOSEN BASED ON
   THE ORDER OF THAT STACK NUMBER IN THE STACK NUMBER LIST.		*/
/* ********************************************************************	*/
/* FUNCTION SetColorByStackIndex */
	 /* Use stack index to get stack #, call set by stack number	*/
void SetColorByStackIndex(int stackindex) {
	SetColorByStackNumber(List_Element(stackindex, STACK));
	}
/* ********************************************************************	*/
/* FUNCTION SetColorByTrialType */
	 /* Use trial type to get stack #, call set by stack number	*/
void SetColorByTrialType(int type) {
        extern int if_overlay_classes();
        if (if_overlay_classes())       /* Make diff CLASSES diff colors*/
            /* SetColorByStackNumber(Get_TrialType_Info(type, CLASS)); */
            SetColorByStackNumber(	/* Ordinal # of class in list	*/
		List_Index(Get_TrialType_Info(type, CLASS), CLASS));
        else
	    SetColorByStackNumber(Get_TrialType_Info(type, STACK));
	}
/* ********************************************************************	*/
/* FUNCTION SetColorByStackNumber */
	 /* Basic method: switch based on stack number */
	 /* If that fails, fall-back is to use index into stack	*/
void SetColorByStackNumber(int stacknumber) {
	switch(stacknumber) {

				/* These are also used for class colors	*/
		case 1: Color(8,0,0);   break;		/* red		*/
		case 2: Color(0,7,0);   break;		/* green	*/
		case 3: Color(0,0,8);   break;		/* blue		*/
		case 4: Color(0,0,0);   break;		/* black	*/
		case 5: Color(8,0,8);   break;		/* purple	*/
		case 6: Color(0,8,8); 	break;		/* Cyan		 */
		case 7: Color(8,5,0); 	break;		/* 4: orange	*/
    		case 8: Color(8,3,3); 	break;		/* 7: Pink	*/
		case 9: Color(4,4,0);  break;		/* brown?	*/
		case 10: Color(0,4,4);  break;	
		case 11:Color(6,0,0);	break;		/* Dark red	*/
		case 12: Color(8,4,8);	break;
		case 13: Color(0,4,0);	break;		/* Lite blue	*/
		case 14: Color(2,5,7);  break;		/* Medium blue	*/
		case 15: Color(5,6,5);  break;		/* Medium blue	*/

#if  BIMANUAL
	case 53: case 93:
	case 31: case 63: case 83: Color(0,6,0); break;	/* green	*/
	case 54: case 94:
	case 32: case 64: case 84: Color(8,2,2); break;	/* red		*/
	case 55: case 95:
	case 40: case 65: case 85: Color(0,0,7); break;	/* blue		*/
	case 41: case 43: 	   Color(0,3,0); break;	/* dark-green	*/
	case 42: case 44: 	   Color(4,1,1); break;	/* dark-red	*/
	case 47: case 48: 	   Color(8,5,0); break;	/* orange	*/
	case 56: case 46: case 96:
	case 78: case 66: case 86: Color(8,5,0); break;	/* orange	*/
	case 52: case 92:
	case 50: case 62: case 82: Color(2,2,2); break;	/* black	*/
#endif

#if PROPRIO2
		case 90: Color(0,0,0);  break;		/* Black	*/
		case 91: Color(0,0,8);	break;		/* Blue		*/
		case 92: Color(0,8,8);	break;		/* cyan		*/
		case 93: Color(0,7,0);	break;		/* green	*/
		case 94: Color(8,5,0);  break;		/* orange	*/
		case 95: Color(7,0,0);  break;		/* red		*/
		case 96: Color(8,2,8);  break;		/* magenta	*/
		case 97: Color(4,1,8);  break;		/* purple	*/
#endif

#if PROPRIO3
		/* NO SHIFT (no gain field rotation, rotate CCW, CW)	*/
		case 124: case 134: case 144:		/* -1.5		*/
			 Color(8,0,0);  break;		/*   red	*/
		case 122: case 132: case 142:		/* -0.5		*/
			 Color(0,7,0);  break;		/*   green	*/
		case 123: case 133: case 143:		/* +0.5		*/
			 Color(0,0,8);  break;		/*   blue	*/
		case 125: case 135: case 145:		/* +1.5		*/
			 Color(2,2,2);	break;		/*   gray	*/

		/* - SHIFT */
		case 220: case 230: case 240:		/* 0		*/
			 Color(5,0,0);  break;		/*   dark red	*/
		case 222: case 232: case 242:		/* -1.0		*/
			 Color(0,5,5);	break;		/*   dark cyan	*/
		case 224: case 234: case 244:		/* +1.0		*/
			 Color(0,0,5);  break;		/*   dark blue	*/

		/* + SHIFT */
		case 221: case 231: case 241:
			 Color(8,3,3);  break;		/*   light red	*/
		case 223: case 233: case 243:
			 Color(4,8,8);	break;		/*   light cyan	*/
		case 225: case 235: case 245:
			 Color(5,6,8);  break;		/*   light blue	*/

#endif

#if PROPRIO
		case 65:  Color(0,8,0); break;  /* green        */
		case 66:  Color(8,0,0); break;  /* red	        */

		case 120: Color(0,6,0); break;  /* *EYE- green	*/
		case 121: Color(0,0,8); break;  /* *EYE+ gray green 	*/

		case 129: 			/* *ARM--	*/
		case 229: Color(8,6,3); break;	/* brown	*/
		case 222:
		case 122: Color(7,0,7); break; 	/* *ARM- orange	*/
	 	case 123:			/* *ARM+	*/
		case 223: Color(8,4,0); break;	/* (dk) purple	*/
		case 130:			/* *ARM ++	*/
		case 230: Color(5,0,0); break;  /* dk red       */

		case 124: Color(0,0,4); break;  /* dark blue    */
		case 125: Color(5,6,8); break;	/* light blue	*/
		case 126: Color(2,4,6); break;  /* blue       */
		case 127: Color(0,0,0); break;	/* black	*/
		case 131: Color(0,0,0); break;  /* Align, cardinal*/
		case 132: Color(5,6,5); break;  /* gray green   */
		case 133: Color(5,6,5); break;  /* gray green   */
		
		case 202: 
		case 302: Color(0,0,0); break;  /* black 	*/
		case 203: 
		case 303: Color(0,0,6); break;  /* med gray	*/
	        case 200: 
		case 300: Color(0,4,8); break;  /* gray green   */
		case 201:
		case 301: Color(0,8,8); break;  /* med gray     */
		case 204: 
		case 304: Color(1,2,2); break;  /* Black        */
		case 205: 
		case 305: Color(3,3,3); break;  /* Purple       */
#endif
	  
#if CHANG_REACH
	 /* L limb CUE-TARGET && L TARGET-CUE && LEFT CUE-MEM */
		case 100: case 120: case 110:
		  Color(5,6,5); break;     /* GREY GREEN */
		case 102: case 122: case 112:
		  Color(8,6,6); break;     /* Pale RED-PINK */
		case 104: case 124: case 114: case 89:
		  Color(0,5,8); break;     /* CYAN */
	 /* R limb CUE-TARGET && R TARGET-CUE && RIGHT CUE-MEM */
		case 200: case 220: case 210: case 87:
		  Color(0,4,0); break;     /* GREEN */
		case 202: case 222: case 212: case 88:
		  Color(8,0,0); break;     /* RED */
		case 204: case 224: case 214: case 86:
		  Color(0,0,8); break;     /* BLUE */
	/* L Spatial MEM */
		case 130:
		  Color(2,4,0); break; 	   /* GREEN */
		case 132:
		  Color(8,0,0); break; 	   /* RED */
	 	case 134:
		  Color(6,0,8); break;     /* BLUE */
	/* R Spatial MEM */
		case 230:
		  Color(5,6,6); break;     /* GREY GREEN */
		case 232:
		  Color(8,6,6); break;     /* Pale RED-PINK */
		case 234:
		  Color(0,5,8); break;     /* LIGHT BLUE */
        /*Reference Frames */
		case 150: case 250:  
			Color(0,5,8); break;	/* blue	*/
		case 151: case 251: 
			Color(0,0,4); break;	/* dark blue	*/
		case 152: case 252: 
			Color(8,4,0); break;	/* orange	*/
		case 153: case 253:
			Color(6,0,0); break;	/* red	*/
		case 154: case 254:
			Color(2,4,0); break;	/* GREEN	*/
		case 164: case 264:
			Color(0,8,0); break;	/* green	*/
		case 140:
		  Color(2,4,0); break; 	   /* GREEN */
		case 142:
		  Color(8,0,0); break; 	   /* RED */

        /* Search & MF mapping */
		case 116:
		 Color(0,5,8); break;
		case 117:
		 Color(0,5,8); break;
		case 217:
		 Color(3,0,8); break;
		case 118:
		 Color(0,4,0); break;
		case 119:
		 Color(8,0,0); break;
#endif 
		  
#if CALTON_REACH
		case 100: case 120: case 130:
		case 200: case 220: case 230: case 260:
			Color(4,8,4); break;	/* Pale Green	*/

		case 110: case 210: case 270: case 280:
			Color(0,8,0); break;	/* Green	*/

		case 102: case 122: case 132:
		case 202: case 222: case 232: case 262:
			Color(8,3,3); break;	/* Pale red	*/

		case 112: case 212: case 272: case 282:
			Color(8,0,0); break;	/* Red		*/

		case 104: case 124: case 134:
		case 204: case 224: case 234: case 264: case 284:
			Color(3,3,8); break;	/* Pale blue	*/

		case 214: case 274:
			Color(0,0,8); break;	/* Blue		*/
#endif

#if BONNIE
		case 200:
		case 220:
		case 230:
			Color(4,8,4); break;	/* Pale Green	*/

		case 210:
			Color(0,8,0); break;	/* Green	*/

		case 202:
		case 222:
		case 232:
			Color(8,3,3); break;	/* Pale red	*/
		case 212:
			Color(8,0,0); break;	/* Red		*/

		case 204:
		case 224:
		case 234:
			Color(3,3,8); break;	/* Pale blue	*/
		case 214:
			Color(0,0,8); break;	/* Blue		*/
#endif

#if STOET
		case 160:			/* Triangle, A	*/
		case 230:
			Color(8,0,0); break;	/*    Red	*/

		case 161:			/* Triangle, B	*/
		case 232:
			Color(8,5,0); break;	/*    Orange	*/

		case 140:			/* Color, A	*/
		case 210:
		case 260:
			Color(0,0,8); break;	/*    Blue	*/

		case 141:			/* Color, B	*/
		case 212:
		case 262:
			Color(0,8,8); break;	/*    Cyan	*/

#endif

#if REFERENCE_FRAME
		case 20: case 21: case 22: case 23: case 24:
		case 25: case 26: case 27: case 28: case 29:
			Color(8,0,0); break;		/* Red */

		case 30: case 31: case 32: case 33: case 34:
		case 35: case 36: case 37: case 38: case 39:
			Color(0,8,0); break;		/* Green */
	
	
		case 170: case 270: case 176: 	/* World stacks */
		case 140: case 240: case 146:
			Color(8,3,5);  break;	/* Pink 	*/
		case 172: case 272: case 122: case 222: case 142: case 242:
			Color(6,0,0);  break;	/* Red		*/

		case 171: case 271: case 177:
		case 121: case 221: case 127:
		case 141: case 1411: case 241: case 147:
			Color(8,6,0);  break;	/* yellow	*/
		case 173: case 273: case 123: case 223: case 143: case 243:
			Color(8,4,0);  break;	/* orange	*/

		case 180: case 280: case 186:	/* Eye stacks	*/
		
		case 182: case 282: case 132: case 232: case 152: case 252:
			Color(0,4,0); break;	/* Dark green	*/
		case 183: case 283: case 133: case 233: case 153: case 253:
			Color(0,0,4); break;   /* Blue */   
#endif



#if REFERENCE_FRAME_JB

		case 20: case 21: case 22: case 23: case 24:
                case 25: case 26: case 27: case 28: case 29:
                        Color(8,0,0); break;            /* Red */

                case 30: case 31: case 32: case 33: case 34:
                case 35: case 36: case 37: case 38: case 39:
                        Color(0,8,0); break;            /* Green */


                case 170: case 270: case 176: case 126:  
                case 172: case 272: case 122: case 222:
                        Color(6,0,0);  break;   /* Red          */

                case 171: case 271: case 177: case 121: case 221:
                case 173: case 273: case 123: case 223: case 127:
                        Color(8,4,0);  break;   /* orange       */

                case 180: case 280: case 186: case 136: case 130: 
                case 182: case 282: case 132: case 232:
                        Color(0,4,0); break;    /* Dark green   */

		case 187: case 137: case 287: case 237:
                case 183: case 283: case 133: case 233:
                        Color(0,0,4); break;   /* Dark Blue */
#endif

#if REFERENCE_FRAME_RW
		case 24:			/* short mem	*/
		  Color(8,0,0); break; 		/* Red		*/
		case 25:			/* interm mem	*/
		  Color(8,0,8); break;		/* Purple	*/
		case 26:			/* long mem	*/
		  Color(2,5,7); break;		/* Blue		*/

		case 40: case 41: case 42: case 43: case 44: case 45:
		case 46: case 47: case 48: case 49: /* for layout */
		  Color(0,0,0); break;		/* Black	*/

		case 170: case 270: case 176: 	/* World stacks */
		case 140: case 240: case 146:
			Color(8,3,5);  break;	/* Pink 	*/
		case 172: case 272: case 122: case 222: case 142: case 242:
			Color(6,0,0);  break;	/* Red		*/

		case 171: case 271: case 177:
		case 121: case 221: case 127:
		case 141: case 241: case 147:
			Color(8,6,0);  break;	/* yellow	*/
		case 173: case 273: case 123: case 223: case 143: case 243:
			Color(8,4,0);  break;	/* orange	*/

		case 180: case 280: case 186:	/* Eye stacks	*/
		case 150: case 250: case 156:
			Color(4,8,4); break;	/* Pale green	*/
		case 182: case 282: case 132: case 232: case 152: case 252:
			Color(0,4,0); break;	/* Dark green	*/

		case 183: case 283: case 133: case 233: case 153: case 253:
			Color(0,0,4); break;   /* Blue */   

#endif
	

#	if MUSCIMOL	
		case 241: Color(8,6,0); break;	/* Yellow	*/
		case 61:  Color(0,8,0); break;	/* Green	*/
		case 62:  Color(8,0,0); break;	/* Red		*/
#	endif

	        default:	/* Not listed? Color by order of stack#	*/
		   switch (	/*  If overlay_stacks, returns 0 - use  *
		                 *  stack#, which is really class #	*/
		     (List_Index(stacknumber, STACK) == 0) ?
		       stacknumber : List_Index(stacknumber,STACK)) {
		case 1: Color(8,0,0);   break;		/* red		*/
		case 2: Color(0,8,0);   break;		/* green	*/
		case 3: Color(0,0,8);   break;		/* blue		*/
		case 4: Color(0,0,0);   break;		/* black	*/
		case 5: Color(8,5,0); 	break;		/* 4: orange	*/
		case 6: Color(0,8,8);   break;		/* purple	*/
		case 7: Color(8,0,8); 	break;		/* cyan		*/
		case 8: Color(8,8,0);   break;		/* yellow	*/
    	case 9: Color(8,3,3); 	break;		/* 7: Pink	*/
		case 10: Color(4,4,0);   break;		/* brown?	*/
		case 11: Color(0,4,4);   break;	
		case 12:Color(6,0,0);	break;		/* Dark red	*/
		case 13: Color(8,4,8);	break;
		case 14: Color(0,4,0);	break;		/* Lite blue	*/
		case 15: Color(2,5,7);  break;		/* Medium blue	*/
    		      default: Color(5,6,5); break;	/* 8: Grey-green*/
		      }
		}
	}
/* ********************************************************************	*/
/* ********************************************************************	*/

/* FUNCTION Color */
	 /* ScaleMap int 8 to max_int & preceed color() call w/ 'move'	*/
void Color(int a,int b,int c) {
#ifdef PS_PLOT_LIBRARY
	move(0,0);	/* Force previous line to be drawn in prev color*/
#endif
	SetColor(a*0x1FFF, b*0x1FFF, c*0x1FFF);
	}
/* ********************************************************************	*/

/* FUNCTION TargetLocation */
	 /* Given target (line) #, return horiz location in degrees	*/
int TargetLocation(int targ) {
	if (targ > 27) 	/* Encoding: 55 is center, H:one's, V:ten's	*/
	   return(((targ % 10) - 5) * 12);
	switch (targ) {
	   case 25: case 26: case 27:	return(-36);
	   case 22: case 23: case 24:	return(-24);
	   case 13: case 14: case 15:	return( 24);
	   case 10: case 11: case 12:	return( 36);
	   case  9: case  2: case  3:	return( 12);
	   case  8: case  1: case  4:	return(  0);
	   case  7: case  6: case  5:	return(-12);
	   default:			return(-99999);
           }
	}
/* ********************************************************************	*/

int Coord_To_TargetCode(int x, int y) {
	return(10*(y+5) + x+5);
	}
/* ********************************************************************	*/

void SayWhere(char *msg) {
	int File = Get_InputFile();
	long long now;

	now = lseek(File, 0L, SEEK_CUR);
	fprintf(stderr, "%s: At %lld bytes\n",
		msg,
		now - (long long) lseek(File, 0L, SEEK_SET));
	now = lseek(File, now, SEEK_SET);
	}
/* ********************************************************************	*/
