/* FILE trial */
     /* Keep track of trial types */

#include "deffs.h"
#include "event.h"
#include "trial.h"
#include <string.h>

#define  DEBUG 		0		/* Levels 0 thru 2		*/

/* ********************************************************************	*/
/* ********************************************************************	*/
/*
PUBLIC:
  Get_TrialType_Info	Return bit of info about one trial type
  Set_TrialType_Info 	Set bit of info about one trial type
  Set_TrialTypes    	Build array of trial types (struct TrialTypes)
  Set_TrialTypes_For_Single_Trial	When using 'e' flag
  Get_TrialType		Return index of trial type of current header
  Get_StackClass_TrialType	Return index of given stack,class
  Count_TrialTypes	Return number of trial types (with n > 1?)

  Get_TrialType_StackName	Used by title functions

  Get_TrialType_TargetData	Return structure giving target times

PRIVATE:
  Set_TrialType		Guts of Set_TrialTypes (called once per header)
  Get_Info_From_Stack	Calls multiple EventExtract to obtain trial profile
 */
/* ********************************************************************	*/

/* extern void  Sort_Lists(); */
/* extern int   EventExtract(); */
static void  Get_Info_From_Stack(int *Info);
static void  Set_TrialType();

struct TRIAL_TYPE ClearType = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,{(char) 0}};

static int   MonteCarlo = 0;
/* ********************************************************************	*/
/* *************  PUBLIC FUNCTIONS ************************************	*/
/* ********************************************************************	*/

/* FUNCTION Set_MonteCarlo_TrialType */
         /* Make trial assignment random */
void Set_MonteCarlo_TrialType() { MonteCarlo = 1; }
/* ********************************************************************	*/

/* FUNCTION Get_TrialType_Info */
	 /* Return some element of a particular trial */
	 /* See also Get_TrialType_StackName */
int Get_TrialType_Info(int type, int what) {
	struct TRIAL_TYPE  *T = TrialType + type;

	switch (what) {
		case BODY: return(T->where);
		case ACCEL: return(T->accel);
		case TARG1: return(T->targ1);
		case TARG2: return(T->targ2);
		case TARG3: return(T->targ3);
		case CLASS: return(T->table);
		case STACK: return(T->stack);
		case CELL:  return(T->cell);
		case VELOC: return(T->veloc);
		case COL:   return(T->col);
		case ROW:   return(T->row);
		case NUMBER:return(T->n);
		case ORDER: return(T->order);
		default:    Exit("Illegal 'what'", "Get_TrialType_Info");
		}

	return(0);				/* Keep lint happy	*/
	}
/* ********************************************************************	*/

/* FUNCTION Set_TrialType_Info */
	 /* Set an element of a particular trial */
void Set_TrialType_Info(int type, int what, int to) {
	struct TRIAL_TYPE  *T = TrialType + type;

	switch (what) {
		case BODY:  T->where  = to; break;
		case ACCEL: T->accel  = to; break;
		case TARG1: T->targ1  = to; break;
		case TARG2: T->targ2  = to; break;
		case TARG3: T->targ3  = to; break;
		case CLASS: T->table  = to; break;
		case STACK: T->stack  = to; break;
		case CELL:  T->cell   = to; break;
		case VELOC: T->veloc  = to; break;
		case COL:   T->col    = to; break;
		case ROW:   T->row    = to; break;
		case NUMBER:T->n      = to; break;
		case ORDER: T->order  = to; break;

		default:    Exit("Illegal 'what'", "Set_TrialType_Info");
		}
	}
/* ********************************************************************	*/

/* FUNCTION Set_TrialTypes */
	 /* Read thru file, tally each trial type */
	 /* Build list of 'where', 'accel', 'trial'	*/
void Set_TrialTypes() {
        int i = -1;

	CountTypes = 0;					/* INITIALIZE	*/
	for (i=0; i<MAX_TYPES; i++)
	   TrialType[i] = ClearType;
	Init_Lists();
	Init_Times();
	i = 0;

	while (Read_Next_Trial(SKIP_DATA)) {
	   Set_TrialType();				/* Get index #	*/
	   Set_TrialTiming();		/* Set Start-,EndTime,Duration	*/
	   }

	Sort_Lists();
	Rewind_InputFile();				/* Back to start*/
	}
/* ********************************************************************	*/

/* FUNCTION Set_TrialTypes_For_Single_Trial */
	 /* Used with 'e' flag; assumes header already read & loaded	*/
void Set_TrialTypes_For_Single_Trial() {
	CountTypes = 0;				/* RE-INITIALIZE	*/
	TrialType[0] = ClearType;		/* Clear 1st trial type	*/
	Init_Lists();
	Init_Times();				/* Init timing variables*/
	Set_TrialType();			/* Set up as 1st type	*/
	Set_TrialTiming();			/* Start,End,Duration	*/
	Sort_Lists();
	}
/* ********************************************************************	*/

/* FUNCTION Get_TrialType_StackName	*/
char *Get_TrialType_StackName(int i) { return(TrialType[i].stackname); }
/* ********************************************************************	*/

/* FUNCTION Count_TrialTypes */
	 /* Return number of trial types */
int Count_TrialTypes() { return(CountTypes); }
/* ********************************************************************	*/

/* FUNCTION Get_StackClass_TrialType */
	 /* Return index into structure, based on given stack, class	*/
int Get_StackClass_TrialType(int stack, int table) {
	int index = -1;
	int j;

	stack = MergeStack(stack);	/* Change # if to be merged	*/
	table = MergeTable(table);	/* Ditto above			*/

	while (++index < CountTypes)
	   if (table==TrialType[index].table && stack==TrialType[index].stack)
	      break;
	if (index == CountTypes)
	   return(FAIL);		/* Not found	*/

	j = index;
	while (++j < CountTypes)		/* Check for double hits*/
	   if (table == TrialType[j].table && stack == TrialType[j].stack)
	       fprintf(stderr,
		 "WARNING: *Two* matches in Get_StackClass_TrialType\n");
	return(index);		/* No other partial matches: this is it	*/
	}
/* ********************************************************************	*/

/* FUNCTION Get_TrialType */
	 /* Return index into structure, based on current header */
	 /* Should find index based only on table & stack, but occasional
	    errors early on (<1-20-94?) caused double hits.	*/
int  Get_TrialType() {
	int table = TableNumber_Header();
	int stack = StackNumber_Header();
	int i;

	/* Not necessary; is already merged	*/
	/* stack = MergeStack(stack);	* Change # if to be merged	*/
	/* table = MergeTable(table);	* Ditto above			*/

	if (MonteCarlo == 1)
	   return(rand() % CountTypes);	/* 0:(n-1); srand() in main.c	*/
	if (MonteCarlo == 2)

	i = -1;
	while (++i < CountTypes)
	   if (table == TrialType[i].table && stack == TrialType[i].stack)
	      break;
	if (i == CountTypes)				/* Didn't find	*/
	   Exit("Non-existent type", "Get_TrialType");

	return(i);		/* No other partial matches: this is it	*/
	}
/* ********************************************************************	*/

/* ********************************************************************	*/
/* *****    PRIVATE FUNCTIONS    **************************************	*/
/* ********************************************************************	*/

/* FUNCTION Set_TrialType */
	 /* Called only once per header to build structure	*/
static void  Set_TrialType() {
	int this_trial[MAX_INFO];
	int i = -1;
	int j;

	/* FIRST, GET TRIAL ID */
	this_trial[CLASS] = TableNumber_Header();
	this_trial[STACK] = StackNumber_Header();
	Get_Info_From_Stack(this_trial);

	while (++i < CountTypes)
	   if (this_trial[CLASS] == TrialType[i].table &&
	       this_trial[STACK] == TrialType[i].stack)
	      break;

	if (i == CountTypes) {				/* Didn't find	*/
	   if (++CountTypes == MAX_TYPES)		/* Overflow?	*/
	      Exit("Too many trial types", "Set_TrialType");

	   TrialType[i].where = this_trial[BODY];
	   TrialType[i].accel = this_trial[ACCEL];
	   TrialType[i].targ1 = this_trial[TARG1];
	   TrialType[i].targ2 = this_trial[TARG2];
	   TrialType[i].targ3 = this_trial[TARG3];
	   TrialType[i].table = this_trial[CLASS];
	   TrialType[i].stack = this_trial[STACK];
	   TrialType[i].cell  = this_trial[CELL ];
	   TrialType[i].veloc = this_trial[VELOC];
	   TrialType[i].order = this_trial[ORDER];
	   TrialType[i].n     = 0;		/* This trial tallied below*/
	   strcpy(TrialType[i].stackname, StackName_Header());

	   List_Append(this_trial);		/* Send ptr to each element*/

	   if (DEBUG) {
	    fprintf(stderr, "DEBUG new type (%3d):", i);
	    for (j=0; j<MAX_INFO; j++)
	       fprintf(stderr, " %5d", this_trial[j]);
	    fprintf(stderr, "\n");
            }
	   }
	(TrialType[i].n)++;			/* Count for label	*/
	}
/* ********************************************************************	*/

/* FUNCTION Get_Info_From_Stack */
static void Get_Info_From_Stack(int *info) {
	int ChairType;
	static int ChairTypes[] = 
		{ CHAIR_TO, CHAIR_TO_RUNTIME, 0 };

	ChairType  = MultiEventExtract(ChairTypes, TYPE, LAST_OCCURRENCE);

	if (ChairType == FAIL)
	   info[BODY] = info[ACCEL] = info[VELOC] = 0;
	else {
	   info[BODY] = 10 * MultiEventExtract(ChairTypes,ONE,LAST_OCCURRENCE);
	   info[VELOC] = EventExtract(CHAIR_AT, ONE, 1);
	   if (info[VELOC] == FAIL)
	       info[VELOC] = 0;
	   info[ACCEL] = 0;				/* Not coded	*/
	   }

	info[CELL]   = EventExtract(DISPLAY, ONE, 1);
	if (info[CELL] == FAIL) {
	   if (EventExtract(TARGET_SAC, TIME, 1) == FAIL) {
	      info[CELL] = EventExtract(SUMMARY, ONE, 1);
	      if (info[CELL] == FAIL)
	          info[CELL] = 1;
	   } else {
	      int h=EventExtract(TARGET_SAC,TWO,1);
	      int v=EventExtract(TARGET_SAC,THREE,1);

	      if (h==0)
		 info[CELL] = 7;
	      else if (h<0)
		 info[CELL] = 4;
	      else
		 info[CELL] = 10;

	      if (v==0)
		 info[CELL] += 1;
 	      else if (v<0)
		 info[CELL] += 2;
	      }
	   }
	if (DEBUG && (info[CELL] == FAIL)) {
	   fprintf(stderr, "%d.%d.%d (%d)not originally displayed\n",
	      RawStackNumber_Header(), RawTableNumber_Header(),
	      TrialNumber_Header(), TrialNumber_Input());
	   }


	info[TARG1] = WindowAcquireEventExtract(ONE,1);	/* First targ	*/
	info[TARG2] = WindowAcquireEventExtract(ONE,2);	/* 2nd targ	*/
	info[TARG3] = WindowAcquireEventExtract(ONE,3);	/* 3rd targ	*/
	info[ORDER] = TrialNumber_Input();
	}
/* ********************************************************************	*/
