/* FILE title */
     /* Title things */

#include "deffs.h"
#include "config.h"
#include <time.h>			/* For time calls		*/
#include <string.h>			/* For time calls		*/

#define  DEBUG 		0		/* Levels 0 thru 2		*/

	/* If title from command line, use these as class titles:	*/
#define COLUMN_TITLE(i)	  sprintf(Title, "%d.%d", \
		Get_TrialType_Info(i,STACK), Get_TrialType_Info(i,CLASS));
#define TITLE_ROW		1	/* Numbered top down		*/
/* ********************************************************************	*/
/* ********************************************************************	*/
/*
PUBLIC:
  Do_Class_Titles	Title a plot (class titles, stack names, alignment)
  Set_Title_From_CmdLine
  Get_Title_From_CmdLine
  Do_Single_Trial_Title
  Do_Header_Title

PRIVATE:
  Do_TitleFromCmdLine	If set from cmd line, do sparser title
 */
/* ********************************************************************	*/

char TitleFromCmdLine[80]  = "";		/* Exported to head.c	*/
/* extern char *Get_CallCommand(); */ 
/* extern char *Date_From_Header(); */
/* ********************************************************************	*/

/* FUNCTION Set_Title_From_CmdLine */
void Set_Title_From_CmdLine(char *title) {
	strcpy(TitleFromCmdLine, title);
	}
/* FUNCTION Get_Title_From_CmdLine */
char *Get_Title_From_CmdLine() {
	return(TitleFromCmdLine);
	}
/* ********************************************************************	*/

/* FUNCTION Do_TitleFromCmdLine */
	 /* Write specified title (-T command) & label one row of figs	*/
	 /*  If '-T+', will label ALL figs, elsewhere */
static void Do_TitleFromCmdLine() {
	int i;
	char Title[80];
	int add = (*TitleFromCmdLine == ADD_TITLE_CHAR);	/* Bool	*/

	Setup_Coords_For_TrialType(TITLE_SPACE);
        if (add)
	   Color(8,0,8);			/* Violent purple	*/
	move(LEFT_TEXT_MARGIN, TopCoord(40 + ((add)? 60:0)));
	fontsize(32-((int)(strlen(TitleFromCmdLine)))/5);/* Scaled(was28)*/
	for (i=0; TitleFromCmdLine[i]; i++)
	      if (TitleFromCmdLine[i] == '_')
		 TitleFromCmdLine[i] = ' ';
	alabel('l', 'b', TitleFromCmdLine+add);	/* Align bottom of text	*/
        Color(0,0,0);

	if (!add)
	  for (i=0; i<Count_TrialTypes(); i++)	/* Survey all types	*/
	     if (Get_TrialType_Info(i,ROW)==TITLE_ROW &&  /*Label only 1 row*/
                  Setup_Coords_For_TrialType(i) != -1) {
	       COLUMN_TITLE(i);
               move(DurationTime()/2, HEIGHT + HEIGHT/25);
               fontsize(20);
               alabel('c', 'b', Title);		/* Align at bottom left	*/
	       }
	}
/* ********************************************************************	*/

/* FUNCTION MoveForTitle */
	 /* 1 or 2 columns */
static void MoveForTitle(int i, int stacks) {
	if (stacks <= 8)
	   move(CENTER_TEXT_MARGIN, TopCoord(5+(stacks-i)*100/stacks));
	   /* move(CENTER_TEXT_MARGIN*.8, TopCoord(i*100/stacks - 5)); */
	else {						/* Two columns	*/
	   int column_spacing = DurationTime();
	   if (DurationTime() > RightEdgeCoord()/5)
	       column_spacing = RightEdgeCoord()/5;
	   /* move(CENTER_TEXT_MARGIN + ((i%2) ? -.8 : .8) * column_spacing,
	     	   		TopCoord(5+((stacks-i-1)/2)*12)); */
	   stacks = (stacks+1) / 2;			/* Round up	*/
	   int column2 = i > stacks;
	   if (column2)
	      i -= stacks;
	   move(CENTER_TEXT_MARGIN + ((column2) ? .8 : -.8) * column_spacing,
	   			TopCoord(5+(stacks-i)*100/stacks));
	   }
	}
/* ********************************************************************	*/

/* FUNCTION Do_Class_Titles */
	/* Title individual cells AND write alignment info	*/
void Do_Class_Titles(int Output) {
	int i;
	char Title[80];
   	char Targets[80];

	    /* Titles by row if 1 stack per row; else by numerical order*/
	int   StacksByRows = 1;		/* Innocent til proven guilty	*/
	int   Stacks_By_Row[1+MAX_STACKS_IN_FIG];
	char *StackNames_By_Row[1+MAX_STACKS_IN_FIG];
        extern char *Get_TrialType_StackName();

	if (*TitleFromCmdLine) {		/* COMMAND LINE TITLE	*/
	   Do_TitleFromCmdLine();
	   if (*TitleFromCmdLine != ADD_TITLE_CHAR)
	      return;
	   }

						/* DETERMINE STACK NAMES*/
	for (i=0; i<MAX_STACKS_IN_FIG+1; i++)	/* Init to all 0's	*/
	   Stacks_By_Row[i] = 0;

	if (!(Output & INDIVIDUAL_PLOTS)) {	/* No individuals	*/
	   int row;
	   for (row=0; row<List_Length(STACK); row++) {	/* Fake rows:	*/
               int stack = List_Element(row,STACK);
	       int j;		/* Fill Stacks_By_Row directly from list*/
	       for (j=0; j<Count_TrialTypes(); j++)
		  if (Get_TrialType_Info(j,STACK) == stack) {
		     Stacks_By_Row[1+row] = stack;
		     StackNames_By_Row[1+row] = Get_TrialType_StackName(j);
		     break;
		     }
	       }
	   goto END;
	   }

	for (i=0; i<Count_TrialTypes(); i++)	/* Survey all types	*/
           if (Test_Coords_For_TrialType(i) != -1) {
	       int row = Get_TrialType_Info(i,ROW);
	       int stack = Get_TrialType_Info(i,STACK);
	       if (Stacks_By_Row[row]) {
		   if (Stacks_By_Row[row] == stack)
		      continue;
		   StacksByRows = 0;		/* 2 stacks in 1 row	*/
		   break;
	        } else {
		   Stacks_By_Row[row] = stack;
		   StackNames_By_Row[row] = Get_TrialType_StackName(i);
		   }
	       }
	if (StacksByRows) {		/* If only 1 stack per row	*/
   	   i = -1;			/* Check for >1 row per stack	*/
	   while (++i < MAX_STACKS_IN_FIG)		/* For each row	*/
	      if (Stacks_By_Row[i]) {			/* Stack on row?*/
		 int j = i;
	         while (++j < MAX_STACKS_IN_FIG+1)
		    if (Stacks_By_Row[i] == Stacks_By_Row[j]) {
		       StacksByRows = 0;		/* Stack on 2 rows! */
		       goto END;
		       }
		 } 
	   }
	END:


	{
	int stacks = List_Length(STACK);		/* Shorthand	*/

	Setup_Coords_For_TrialType(TITLE_SPACE);
	if (stacks > 7)
	   fontsize(6);
	else if (stacks > 4)
	   fontsize(17 - (int)(0.5+stacks*1.5));
	else
	   fontsize(27 - 3 * stacks);	/* Scale by # names */

	if (! StacksByRows) {
           extern char *Get_TrialType_StackName();
	   int j;
	   for (i=0; i<stacks; i++) {
	      for (j=0; j<Count_TrialTypes(); j++)
	         if (Get_TrialType_Info(j,STACK) == List_Element(i,STACK))
		    break;
	      sprintf(Title, "%2d: %s",
		Get_TrialType_Info(j,STACK), Get_TrialType_StackName(j));
	      SetColorByStackIndex(i);            /* Must precede 'move()'*/
	      MoveForTitle(i+1, stacks);
	      alabel('l', 'b', Title);
	      }
	} else {
	   int actual = -1;
	   for (i=0; i<MAX_STACKS_IN_FIG; i++)
	      if (Stacks_By_Row[i+1]) {
	         ++actual;			/* Skip dummy stacks	*/
	         SetColorByStackNumber(Stacks_By_Row[i+1]);
	         /* SetColorByStackIndex(actual); * Previous, wrong version*/
		 MoveForTitle(actual+1, stacks);
	         sprintf(Title, "%2d: %s", 
			Stacks_By_Row[i+1], StackNames_By_Row[i+1]);
	         alabel('l', 'b', Title);
		 }
	   }
	Color(0,0,0);
	}

	/* Setup_Coords_For_TrialType(TITLE_SPACE);	 * already set	*/
	move(RIGHT_TEXT_MARGIN, TopCoord(45));
	fontsize(10);
	alabel('l', 'c', AlignTime_String());

	if (!(Output & INDIVIDUAL_PLOTS)) /* If no individuals, go away	*/
	   return;
	
	for (i=0; i<Count_TrialTypes(); i++)	      /* For each type:	*/
           if (Setup_Coords_For_TrialType(i) != -1) {
	       int where = Get_TrialType_Info(i,BODY) / 10;
	       int targ2 = Get_TrialType_Info(i,TARG2);
	       int j;

               for (j=0; j<sizeof(Title); j++)	/* Write trial title	*/
                  Title[j] = 0;
	       
	       sprintf(Title, "%d.%d: ",
		     Get_TrialType_Info(i,STACK), Get_TrialType_Info(i,TABLE));
               sprintf(Title, "%sn=%d", Title, Get_TrialType_Info(i,NUMBER));

               move(5, HEIGHT);
               fontsize(10);
               alabel('l', 'b', Title);	/* Align title's bottom left	*/

#	       define ADDITIONAL_TITLE 0
#	       if   ADDITIONAL_TITLE
               if (List_Length(TARG2)>1 && targ2!=FAIL) {
	          sprintf(Title, "\nTarg %2d ", targ2);
                  move(5, HEIGHT-220);
                  fontsize(7);
                  alabel('l', 'b', Title);	/* Align bottom left	*/
	          }

               if (List_Length(BODY) > 1) {
		  int accel = Get_TrialType_Info(i,ACCEL);
	          sprintf(Title, "%3d deg ", (where==FAIL)?999:where/10);
	          if (List_Length(ACCEL) > 1) {
	             if (accel%100 == 0)
	                sprintf(Title, "%s(%d/s2) ", Title, accel/100);
	             else if (accel%10 == 0)
	                sprintf(Title, "%s(%.1f/s2) ", Title, accel/100.);
	             else
	                sprintf(Title, "%s(%.2f/s2) ", Title, accel/100.);
	             }
                  move(5, HEIGHT+220);
                  fontsize(7);
                  alabel('l', 'b', Title);	/* Align bottom left	*/
	          }
#	       endif

			/* Glean target info common to all trials	*/
			/* If all at 1 place, or this one at center, or
			   none are at center, then:			*/
      	       if ((List_Length(BODY) == 1 && i==0) || (where==0)
       		     || (List_Length(BODY) > 1 && List_Index(0,BODY)==0)) {
	          int targ1 = Get_TrialType_Info(i,TARG1);
	          if (List_Length(TARG2) == 1)
                     sprintf(Targets, "Targets %d to %d", targ1, targ2);
                  else
                     sprintf(Targets, "From target %d", targ1);
	          }
	       }

	Setup_Coords_For_TrialType(TITLE_SPACE); /* Common target info	*/
	move(RIGHT_TEXT_MARGIN, TopCoord(20));
	fontsize(11);
	alabel('l', 'c', Targets);		/* Align top of text	*/
	}
/* ********************************************************************	*/

/* FUNCTION Do_Single_Trial_Title */
	 /* Title a single trial ('e' flag)	*/
void Do_Single_Trial_Title() {
	char Title[80];
	char *Get_TrialType_StackName();
        time_t Time;

	if (*TitleFromCmdLine) {		/* COMMAND LINE TITLE	*/
	   Do_TitleFromCmdLine();
	   if (*TitleFromCmdLine != ADD_TITLE_CHAR)
	      return;
	   }

	Setup_Coords_For_TrialType(TITLE_SPACE); /* Common target info	*/


	fontsize(40);			/* Note: no date!	*/
	move(LEFT_TEXT_MARGIN, TopCoord(110));
        sprintf(Title, "%d:  %s %d.%d.%d",
	     TrialNumber_Input(), MonkName_Header(),
	     UnitNumber_Header(), RunNumber_Header(),
	     TrialNumber_Header());
        alabel('l', 'c', Title);

	fontsize(45);			/* Note: no date!	*/
	SetColorByStackIndex(0);            /* Must precede 'move()'*/
        move(CENTER_TEXT_MARGIN, TopCoord(65));
	sprintf(Title, "%2d.%d: %s",
		Get_TrialType_Info(0,STACK),
		Get_TrialType_Info(0,CLASS),
		Get_TrialType_StackName(0));
	alabel('l', 'c', Title);
	Color(0,0,0);

	fontsize(15);
        move(LEFT_TEXT_MARGIN, TopCoord(0));
        time(&Time);
        strcpy(Title, ctime(&Time));
        *(strchr(Title, '\n')) = 0;			/* Rm line feed	*/
        alabel('l', 'c', Title+4);


        move(LEFT_TEXT_MARGIN, TopCoord(40));
        alabel('l', 'c', Date_From_Header());
        move(LEFT_TEXT_MARGIN, TopCoord(20));
        alabel('l', 'c', Get_CallCommand());

	fontsize(22);
        move(LEFT_TEXT_MARGIN, TopCoord(80));
	sprintf(Title, "Targets %d %d %d",
		Get_TrialType_Info(0,TARG1),
		Get_TrialType_Info(0,TARG2),
		Get_TrialType_Info(0,TARG3));
        alabel('l', 'c', Title);
   }
/* ********************************************************************	*/

/* FUNCTION Do_Header_Title */
	 /* Print out header info and current time; invis if '-T'	*/
void Do_Header_Title() {
   time_t Time;
   char TitleText[80];
   char TimeText[80];
   int  Invisible = 0;		/* Called with -T: hide ID,cmd-call,etc	*/

   if (TitleFromCmdLine[0] && TitleFromCmdLine[0] != ADD_TITLE_CHAR)
      Invisible = 1;

   Setup_Coords_For_TrialType(TITLE_SPACE);		/* Print title	*/

   if (List_Length(STACK) > 3)
      fontsize(9);
   else
      fontsize(11);

   if (Invisible)
      Color(8,8,8);					/* White	*/
   else
      Color(0,0,0);					/* Black	*/

   time(&Time);
   strcpy(TimeText, ctime(&Time));
   move(RIGHT_TEXT_MARGIN, TopCoord(70));
   *(strchr(TimeText, '\n')) = 0;			/* Rm line feed	*/
   alabel('l', 'c', TimeText+4);

			/* Break call-command up into several lines	*/
#  define ONE_LINE	35			/* Characters per line	*/
   if (((int)strlen(Get_CallCommand())) > ONE_LINE) {
#ifdef DIAG
      char OneLine[ONE_LINE+1];
      int length = strlen(Get_CallCommand());	/* Length remaining	*/
      int done = 0;				/* Lines that are done	*/
      int line = TopCoord(93) + (100) * (length/ONE_LINE);

      while (length > 0) {
          strncpy(OneLine, Get_CallCommand() + done*ONE_LINE, ONE_LINE);
	  OneLine[ONE_LINE] = 0;
	  if (TopCoord(95+20*(length/ONE_LINE)) )
          move(RIGHT_TEXT_MARGIN, line -= 100);
	  	/* TopCoord(95 + 20*(length/ONE_LINE)));	OLD y	*/
	  alabel('l', 'c', OneLine);		/* Above: integer div!	*/
	  length -= ONE_LINE;
	  done++;
	  }
#endif
      move(RightEdgeCoord(), TopCoord(95));
      alabel('r', 'c', Get_CallCommand());	/* Tell how generated	*/
   } else {
      move(RIGHT_TEXT_MARGIN, TopCoord(95));
      alabel('l', 'c', Get_CallCommand());	/* Tell how generated	*/
      }

   if (!Invisible)
      fontsize(30);		/* Write date, unit#, monkey name LARGE	*/
   sprintf(TitleText, "%s %d.%d",
	MonkName_Header(), UnitNumber_Header(), RunNumber_Header());
   move(LEFT_TEXT_MARGIN, TopCoord(60));
   alabel('l', 'b', TitleText);

   move(LEFT_TEXT_MARGIN, TopCoord(10));
   alabel('l', 'b', Date_From_Header());
   }
/* ********************************************************************	*/
