/* FILE skip.c */
     /* Exclude individual trials, stacks or table columns		*/
     /*  Or exclude based on event presence/absence or param range	*/
     /* Complete exclusion, as if not in the file; don't just not print	*/
     /* NOTE: does merge first or skip first, depending on WHICH IS FIRST*/
     /* Can also skip based on an event type and param/time range	*/

#define DEBUG	0

#include <stdio.h>
#include "deffs.h"					/* START_ERR	*/
/* ********************************************************************	*/

#define MAX_SKIP 2500	/* Max ~ ranges EACH of trials,stacks,cols	*/

static struct {
	int begin[MAX_SKIP];
	int end[MAX_SKIP];
	int n;
	} SkipTrials,SkipStack,SkipColumn,SkipBoth,SkipUnit,
	  SkipRun,SkipUnitRun,*SkipPtr;

static struct {
	int event[MAX_SKIP];
	int begin[MAX_SKIP];
	int end[MAX_SKIP];
	int which[MAX_SKIP];
	int occur[MAX_SKIP];
	int stack[MAX_SKIP];
	char x[MAX_SKIP];
	int n;
	} SkipEvent;

static int SkipFlag;
static int StartErrs;			/* Skip or exclusively include?	*/

/* Merge before skip, or vice versa?  If sees a skip before a merge, does
 * ALL skips first; if sees merge before a skip, does ALL merges first	*/
static int MergeFirst;			/* Merge before skipping?	*/
static int SeenMergeOrSkip;
/* ********************************************************************	*/

/* FUNCTION Init_Skip */
	 /* Prepare to store trial numbers, stacks or columns to skip	*/
void Init_Skip() {
     SkipTrials.n = 0;
     SkipStack.n = 0;
     SkipColumn.n = 0;
     SkipBoth.n = 0;
     SkipUnit.n = 0;
     SkipRun.n = 0;
     SkipUnitRun.n = 0;
     SkipFlag = 0;
     StartErrs = 0;
     MergeFirst = 1;		/* Merge BEFORE calling exclude/include	*/
     	/* Note: default irrelevant if you don't have both; will be set
	 * if you have one or the other (& of course if you have both),
	 * so the default is irrelevant - never actually matters	*/
     SeenMergeOrSkip = 0;	/* 0: haven't seen either  1: seen one	*/

     SkipEvent.n = 0;
     }
/* ********************************************************************	*/

/* FUNCTION Seen_Merge */
/* FUNCTION Seen_Skip */
         /* main.c reports seeing a 'merge' or 'skip' command	*/
void Seen_Merge() {
     if (SeenMergeOrSkip)	/* Is this the first merge or skip?	*/
	return;			/* If not, go away (no more changes)	*/
     MergeFirst = 1;		/* Saw a merge first			*/
     SeenMergeOrSkip = 1;	/* Now you've seen one			*/
     }
void Seen_Skip() {
     if (SeenMergeOrSkip)	/* Is this the first merge or skip?	*/
	return;			/* If not, go away (no more changes)	*/
     MergeFirst = 0;		/* Saw a skip first			*/
     SeenMergeOrSkip = 1;	/* Now you've seen one			*/
     }
/* ********************************************************************	*/

/* FUNCTION Store_Skip */
	 /* Store trial numbers, stacks or columns (units,runs)to skip	*/
void Store_Skip(char type, int from, int to) {
	switch (type) {
	   case 't':  SkipPtr = &SkipTrials;	 break;
	   case 'c':  SkipPtr = &SkipColumn; 	 break;
	   case 's':  SkipPtr = &SkipStack;	 break;
	   case 'b':  SkipPtr = &SkipBoth; 	 break;
	   case 'u':  SkipPtr = &SkipUnit; 	 break;
	   case 'r':  SkipPtr = &SkipRun; 	 break;
	   case 'U':  SkipPtr = &SkipUnitRun; 	 break;
	   case 'n':  StartErrs = -1; SkipFlag = 1; return;
	   default:   fprintf(stderr, "Unknown skip type %c\n", type);
		      Exit("Store_Skip", "skip.c");
	   }

	if (SkipPtr->n >= MAX_SKIP-1) {
	   fprintf(stderr, "ARGH! Increase MAX_SKIP!\n");
	   return;
	   }
	SkipPtr->begin[SkipPtr->n] = from;
	SkipPtr->end[(SkipPtr->n)++] = to;
	SkipFlag = 1;
	if (DEBUG) fprintf(stderr, "Skip %c %d to %d (%d-th entry)",
			type, from, to, SkipPtr->n);
     }
/* ********************************************************************	*/

/* FUNCTION UnStore_NoSkip */
	 /* Remove -Xt entries (to loop thru, re-reading, 1 trial per)	*/
void UnStore_NoSkip(char type) {
     switch (type) {
	  case 't': SkipTrials.n = 0; 	break;
          default:   fprintf(stderr, "Unimplemented skip type %c\n", type);
	  }
     }
/* ********************************************************************	*/

/* FUNCTION Store_No_Skip */
	 /* Skip all BUT these trials/stacks/columns	*/
void Store_No_Skip(char type, int from, int to) {
	switch (type) {
	   case 't':  SkipPtr = &SkipTrials;	 break;
	   case 'c':  SkipPtr = &SkipColumn; 	 break;
	   case 's':  SkipPtr = &SkipStack;	 break;
	   case 'b':  SkipPtr = &SkipBoth; 	 break;
	   case 'u':  SkipPtr = &SkipUnit; 	 break;
	   case 'r':  SkipPtr = &SkipRun; 	 break;
	   case 'U':  SkipPtr = &SkipUnitRun; 	 break;
	   case 'n':  StartErrs = 1; SkipFlag = 1; return;
	   default:   fprintf(stderr, "Unknown skip type %c\n", type);
	   }

	if (SkipPtr->n >= MAX_SKIP-1) {
	   fprintf(stderr, "ARGH! Increase MAX_SKIP!\n");
	   return;
	   }
        if (type=='b') {		/* not to:from but stack.class	*/
	   SkipPtr->begin[SkipPtr->n] = -from;			/* FLAG!*/
	   SkipPtr->end[SkipPtr->n++] = to;
         } else if (type=='U') {	/* not to:from but unit.run	*/
	   SkipPtr->begin[SkipPtr->n] = -from;			/* FLAG!*/
	   SkipPtr->end[SkipPtr->n++] = to;
	 } else {			/* Exclude all but specified range */
	   SkipPtr->begin[SkipPtr->n] = 1;
	   SkipPtr->end[(SkipPtr->n)++] = from-1;
	   SkipPtr->begin[SkipPtr->n] = to+1;
	   SkipPtr->end[(SkipPtr->n)++] = 100000;
	   }

	SkipFlag = 1;
	if (DEBUG) fprintf(stderr, "Skip %c %d to %d (%d-th entry)",
			type, from, to, SkipPtr->n);
     }
/* ********************************************************************	*/
/* FUNCTION Store_EventSkip */
void Store_EventSkip(char x, int event, int from, int to,
					int which, int occur, int stack) {
	if (SkipEvent.n >= MAX_SKIP-1) {
	   fprintf(stderr, "ARGH! Increase MAX_SKIP!\n");
	   return;
	   }
	SkipEvent.x[SkipEvent.n] = x;
	SkipEvent.event[SkipEvent.n] = event;
	SkipEvent.begin[SkipEvent.n] = from;
	SkipEvent.end[SkipEvent.n] = to;
	SkipEvent.which[SkipEvent.n] = which;
	SkipEvent.occur[SkipEvent.n] = occur;
	SkipEvent.stack[(SkipEvent.n)++] = stack;
	}
/* ********************************************************************	*/

/* FUNCTION SkipTrial */
	 /* Skip this trial?  return 0 (no;ok) or 1 (yes;skip)	*/
int  SkipTrial(int trial) {
	   int column, stack, i;
	   int run, unit;
	   int SkipAllElseFlag = 0;		/* Used -Xb... ?	*/


	   /* Nothing to do ? */
	   if (SkipFlag == 0)
	      return(0);			/* No skips (fast!)	*/

	   /* Skips based on event present/values	*/
	   i = -1;
           while (++i < SkipEvent.n) {
	       int value = EventExtract(SkipEvent.event[i],
			                SkipEvent.which[i],
			                SkipEvent.occur[i]);

	       if (SkipEvent.stack[i] &&
		  (SkipEvent.stack[i] != StackNumber_Header()))
		  continue;		/* Not the stack you r looking 4*/
	       
	       if ((value == FAIL)	/* Could not find the event	*/
		  && (SkipEvent.x[i] == 'X'))	/* Failed, so skip it	*/
		     return(1);

	       if ((value != FAIL)	/* Found the event		*/
		  && (SkipEvent.x[i] == 'x'))	/* Exclude if not there	*/
		     return(1);

	       if ((SkipEvent.begin[i] != FAIL) & (SkipEvent.end[i] != FAIL)) {
	        if ((SkipEvent.x[i] == 'x')	/* Skip if in range	*/
	          && (value >= SkipEvent.begin[i])
		  && (value <= SkipEvent.end[i]))
		     return(1);
	        if ((SkipEvent.x[i] == 'X')
		  && ((value < SkipEvent.begin[i])
		  || (value > SkipEvent.end[i])))
		     return(1);
		 }
	       }


	   /* skips based on start errors */
	   if (StartErrs) {			/* 1:include -1:exclude	*/
	      if ((StartErrs == 1) && (RunStatus_Header() != START_ERR))
	         return(1);				/* Leave it out	*/
	      else if ((StartErrs == -1) && (RunStatus_Header()==START_ERR))
	         return(1);				/* Leave it out	*/
	      }					/* Else keep checking	*/


	   /* Skips based on trial */
	   i = -1;
	   while (++i < SkipTrials.n)		/* Excluded trial?	*/
	      if (trial >= SkipTrials.begin[i] && trial <= SkipTrials.end[i]) {
		 if (DEBUG)
		     fprintf(stderr, "Trial out [%d] (%d vs (%d:%d)!\n",
			i, trial, SkipTrials.begin[i], SkipTrials.end[i]);
		 return(1);			/* Yes, skip this trial	*/
		 }


	   /* Skips based on stack/class/both	*/
	   i = -1;
	   stack = RawStackNumber_Header();
	   if (MergeFirst)
	      stack = MergeStack(stack);
	   while (++i < SkipStack.n)
	      if (stack >= SkipStack.begin[i] && stack <= SkipStack.end[i]) {
		 if (DEBUG)
		     fprintf(stderr, "Stack out [%d] (%d vs (%d:%d)!\n",
			i, stack, SkipStack.begin[i], SkipStack.end[i]);
		 return(1);			/* Skip this stack	*/
		 }

	   i = -1;
	   column = RawTableNumber_Header();
	   if (MergeFirst)
	      column = MergeTable(column);
	   while (++i < SkipColumn.n)
	      if (column>=SkipColumn.begin[i] && column <= SkipColumn.end[i]) {
		 if (DEBUG)
		     fprintf(stderr, "Table out [%d] (%d vs (%d:%d)!\n",
			i, column, SkipColumn.begin[i], SkipColumn.end[i]);
		 return(1);			/* Skip column/table	*/
		 }

	   i = -1;
	   while (++i < SkipBoth.n) {
	      int sta = SkipBoth.begin[i];
	      int col = SkipBoth.end[i];	/* SkipBoth stack.class	*/
	      if (sta > 0) {			/* Exclude this sta.cla	*/
	         if (stack==sta && column==col) {  	/* A match?	*/
		    if (DEBUG || 1)
		       fprintf(stderr, "Skip %d.%d\n", sta, col);
		    return(1);			/* Skip column/table	*/
		    }
	       } else {				/* Keep this sta.cla	*/
	         if (stack==-sta && column==col) {  	/* A match?	*/
		    if (DEBUG)
		       fprintf(stderr, "Keep only %d.%d\n", -sta, col);
		    return(0);			/* Don't skip		*/
		    }
		 if (DEBUG)
		    fprintf(stderr, "Skip all that aren't %d.%d\n", -sta, col);
		 SkipAllElseFlag = 1;		/* Else skip!		*/
		 }
	      }


	   /* Skips based on unit/run/both	*/
	   i = -1;
	   unit = UnitNumber_Header();
	   while (++i < SkipUnit.n)
	      if (unit >= SkipUnit.begin[i] && unit <= SkipUnit.end[i]) {
		 if (DEBUG)
		     fprintf(stderr, "Unit out [%d] (%d vs (%d:%d)!\n",
			i, unit, SkipUnit.begin[i], SkipUnit.end[i]);
		 return(1);			/* Skip this unit	*/
		 }

	   i = -1;
	   run = RunNumber_Header();
	   while (++i < SkipRun.n)
	      if (run>=SkipRun.begin[i] && run <= SkipRun.end[i]) {
		 if (DEBUG)
		     fprintf(stderr, "Table out [%d] (%d vs (%d:%d)!\n",
			i, run, SkipRun.begin[i], SkipRun.end[i]);
		 return(1);			/* Skip run		*/
		 }

	   i = -1;
	   while (++i < SkipUnitRun.n) {
	      int un = SkipUnitRun.begin[i];
	      int ru  = SkipUnitRun.end[i];
	      if (un > 0) {			/* Exclude this sta.cla	*/
	         if (unit==un && run==ru) {  	/* A match?	*/
		    if (DEBUG || 1)
		       fprintf(stderr, "Skip %d.%d\n", un, ru);
		    return(1);			/* Skip column/table	*/
		    }
	       } else {				/* Keep this sta.cla	*/
	         if (unit==-un && run==ru) {  	/* A match?	*/
		    if (DEBUG)
		       fprintf(stderr, "Keep only %d.%d\n", -un, ru);
		    return(0);			/* Don't skip		*/
		    }
		 if (DEBUG)
		    fprintf(stderr, "Skip all that aren't %d.%d\n", -un, ru);
		 SkipAllElseFlag = 1;		/* Else skip!		*/
		 }
	      }

	  return(SkipAllElseFlag);		/* Usually 0: don't skip*/
	}
/* ********************************************************************	*/
